/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.process.conditions;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.config.AppMapPackage;
import com.appland.appmap.process.conditions.Condition;
import com.appland.appmap.transform.annotations.AnnotationUtil;
import com.appland.appmap.transform.annotations.AppMapAppMethod;
import com.appland.appmap.util.AppMapBehavior;
import com.appland.appmap.util.FullyQualifiedName;
import com.appland.appmap.util.Logger;
import com.appland.shade.javassist.CtBehavior;
import com.appland.shade.javassist.CtClass;
import com.appland.shade.javassist.CtMethod;
import com.appland.shade.javassist.Modifier;
import com.appland.shade.javassist.NotFoundException;
import com.appland.shade.javassist.bytecode.Descriptor;
import java.util.Map;
import java.util.regex.Pattern;

public class ConfigCondition
implements Condition {
    private static final Pattern SETTER_PATTERN;
    private static final Pattern GETTER_PATTERN;
    private static final Pattern IS_HAS_PATTERN;

    @Override
    public Boolean match(CtBehavior behavior, Map<String, Object> matchResult) {
        boolean matched = this.doMatch(behavior, matchResult);
        if (matched) {
            AnnotationUtil.setAnnotation(new AnnotationUtil.AnnotatedBehavior(behavior), AppMapAppMethod.class);
        }
        return matched;
    }

    private boolean doMatch(CtBehavior behavior, Map<String, Object> matchResult) {
        CtClass declaringClass = behavior.getDeclaringClass();
        if (declaringClass.getName().startsWith("java.lang")) {
            return false;
        }
        if (!AppMapBehavior.isRecordable(behavior).booleanValue() || ConfigCondition.ignoreMethod(behavior)) {
            return false;
        }
        if (!declaringClass.isInterface() && behavior.getMethodInfo().getLineNumber(0) < 0) {
            return false;
        }
        AppMapPackage.LabelConfig ls = AppMapConfig.get().includes(new FullyQualifiedName(behavior));
        if (ls != null) {
            matchResult.put("labels", ls.getLabels());
            return true;
        }
        return false;
    }

    static boolean isSetter(CtMethod method) throws NotFoundException {
        String descriptor = method.getMethodInfo().getDescriptor();
        return AppMapBehavior.isRecordable(method) != false && Descriptor.numOfParameters(descriptor) == 1 && descriptor.endsWith(")V") && SETTER_PATTERN.matcher(method.getName()).matches();
    }

    static boolean isGetter(CtMethod method) throws NotFoundException {
        String descriptor = method.getMethodInfo().getDescriptor();
        String methodName = method.getName();
        if (AppMapBehavior.isRecordable(method).booleanValue() && Descriptor.numOfParameters(descriptor) == 0) {
            if (!descriptor.endsWith(")V") && GETTER_PATTERN.matcher(methodName).matches()) {
                return true;
            }
            return descriptor.endsWith(")Z") && IS_HAS_PATTERN.matcher(methodName).matches();
        }
        return false;
    }

    private static boolean ignoreMethod(CtBehavior behavior) {
        if (!(behavior instanceof CtMethod)) {
            return false;
        }
        CtMethod method = (CtMethod)behavior;
        try {
            return behavior.getMethodInfo2().isConstructor() || behavior.getMethodInfo2().isStaticInitializer() || ConfigCondition.isGetter(method) || ConfigCondition.isSetter(method) || ConfigCondition.isIgnoredInstanceMethod(method);
        }
        catch (NotFoundException e) {
            Logger.println(e);
            return true;
        }
    }

    public static boolean isIgnoredInstanceMethod(CtMethod method) {
        int mods = method.getModifiers();
        if (Modifier.isStatic(mods)) {
            return false;
        }
        String methodName = method.getName();
        return methodName.equals("equals") || methodName.equals("hashCode") || methodName.equals("iterator") || methodName.equals("toString");
    }

    static {
        AppMapConfig.get();
        SETTER_PATTERN = Pattern.compile("^set[A-Z].*");
        GETTER_PATTERN = Pattern.compile("^get[A-Z].*");
        IS_HAS_PATTERN = Pattern.compile("^(i|ha)s[A-Z].*");
    }
}

