/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.transform;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.config.Properties;
import com.appland.appmap.output.v1.NoSourceAvailableException;
import com.appland.appmap.transform.annotations.AnnotationUtil;
import com.appland.appmap.transform.annotations.AppMapInstrumented;
import com.appland.appmap.transform.annotations.Hook;
import com.appland.appmap.transform.annotations.HookFactory;
import com.appland.appmap.transform.annotations.HookSite;
import com.appland.appmap.transform.annotations.HookValidationException;
import com.appland.appmap.util.AppMapClassPool;
import com.appland.appmap.util.Logger;
import com.appland.shade.javassist.ClassPool;
import com.appland.shade.javassist.CtBehavior;
import com.appland.shade.javassist.CtClass;
import com.appland.shade.javassist.CtMember;
import com.appland.shade.javassist.NotFoundException;
import com.appland.shade.javassist.bytecode.AnnotationsAttribute;
import com.appland.shade.javassist.bytecode.ClassFile;
import com.appland.shade.javassist.bytecode.ConstPool;
import com.appland.shade.javassist.bytecode.annotation.Annotation;
import com.appland.shade.org.reflections.Reflections;
import com.appland.shade.org.reflections.scanners.SubTypesScanner;
import com.appland.shade.org.reflections.util.ClasspathHelper;
import com.appland.shade.org.reflections.util.ConfigurationBuilder;
import com.appland.shade.org.reflections.util.FilterBuilder;
import com.appland.shade.org.tinylog.Supplier;
import com.appland.shade.org.tinylog.TaggedLogger;
import java.io.ByteArrayInputStream;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ClassFileTransformer
implements java.lang.instrument.ClassFileTransformer {
    private static final TaggedLogger logger = AppMapConfig.getLogger(null);
    private static String tracePrefix = Properties.DebugClassPrefix;
    private static final String PROCESS_PACKAGE = "com.appland.appmap.process";
    private final String name;
    private final List<Hook> unkeyedHooks = new ArrayList<Hook>();
    private final Map<String, List<Hook>> keyedHooks = new HashMap<String, List<Hook>>();
    private HookFactory hookFactory;
    private Hook[] sortedUnkeyedHooks = null;
    private Map<String, Hook[]> allKeyedHooks = null;
    private static final List<ClassFileTransformer> instances = new ArrayList<ClassFileTransformer>();
    private long classesExamined = 0L;
    private long methodsHooked = 0L;
    private long methodsExamined = 0L;
    private Map<String, Integer> packagesHooked = new HashMap<String, Integer>();
    private Map<String, Integer> packagesIgnored = new HashMap<String, Integer>();
    private long classesIgnored = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassFileTransformer(String name, HookFactory hookFactory) {
        this.name = name;
        this.hookFactory = hookFactory;
        Reflections reflections = new Reflections(new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage(PROCESS_PACKAGE, new ClassLoader[0])).setScanners(new SubTypesScanner(false)).filterInputsBy(new FilterBuilder().includePackage(PROCESS_PACKAGE)));
        ClassPool classPool = AppMapClassPool.acquire(Thread.currentThread().getContextClassLoader());
        try {
            for (Class<Object> classType : reflections.getSubTypesOf(Object.class)) {
                try {
                    CtClass ctClass = classPool.get(classType.getName());
                    this.processClass(ctClass);
                    ctClass.detach();
                }
                catch (NotFoundException e) {
                    logger.debug(e);
                }
            }
            this.resolveHooks();
        }
        finally {
            AppMapClassPool.release();
            instances.add(this);
        }
    }

    private void resolveHooks() {
        Function<Stream, Hook[]> sorter = s -> (Hook[])s.sorted(Comparator.comparingInt(Hook::getPosition)).toArray(Hook[]::new);
        this.sortedUnkeyedHooks = sorter.apply(this.unkeyedHooks.stream());
        this.allKeyedHooks = this.keyedHooks.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Hook[])sorter.apply(Stream.of((List)e.getValue(), this.unkeyedHooks).flatMap(Collection::stream))));
    }

    private void addHook(Hook hook) {
        if (hook == null) {
            return;
        }
        String key = hook.getKey();
        logger.trace("{}: {}", key, hook);
        if (key == null) {
            this.unkeyedHooks.add(hook);
        } else {
            List matchingKeyedHooks = this.keyedHooks.computeIfAbsent(key, k -> new ArrayList());
            matchingKeyedHooks.add(hook);
        }
    }

    private Hook[] getHooks(String methodId) {
        Hook[] methodHooks = this.allKeyedHooks.get(methodId);
        return methodHooks != null ? methodHooks : this.sortedUnkeyedHooks;
    }

    private void processClass(CtClass ctClass) {
        boolean traceClass;
        boolean bl = traceClass = tracePrefix == null || ctClass.getName().startsWith(tracePrefix);
        if (traceClass) {
            logger.trace(() -> ctClass.getName());
        }
        for (CtBehavior behavior : ctClass.getDeclaredBehaviors()) {
            Hook hook;
            if (traceClass) {
                logger.trace(() -> behavior.getLongName());
            }
            if ((hook = this.hookFactory.from(behavior)) == null) {
                if (!traceClass) continue;
                logger.trace("{}, no hooks", () -> behavior.getLongName());
                continue;
            }
            ctClass.defrost();
            try {
                hook.validate();
            }
            catch (HookValidationException e) {
                logger.debug((Throwable)e, "failed to validate hook");
                continue;
            }
            this.addHook(hook);
            if (!traceClass) continue;
            logger.trace("registered hook {}", hook);
        }
    }

    private boolean applyHooks(CtBehavior behavior) {
        boolean traceClass = tracePrefix == null || behavior.getDeclaringClass().getName().startsWith(tracePrefix);
        try {
            List<HookSite> hookSites = this.getHookSites(behavior);
            if (hookSites == null) {
                if (traceClass) {
                    logger.trace("no hook sites");
                }
                return false;
            }
            Hook.apply(behavior, hookSites);
            if (logger.isDebugEnabled()) {
                for (HookSite hookSite : hookSites) {
                    Hook hook = hookSite.getHook();
                    String className = behavior.getDeclaringClass().getName();
                    if (tracePrefix != null && !className.startsWith(tracePrefix) || !traceClass) continue;
                    logger.trace("hooked {}.{}{} on ({},{}) with {}", className, behavior.getName(), behavior.getMethodInfo().getDescriptor(), hook.getMethodEvent().getEventString(), hook.getPosition(), hook);
                }
            }
            return true;
        }
        catch (NoSourceAvailableException e) {
            Logger.println(e);
            return false;
        }
    }

    public List<HookSite> getHookSites(CtBehavior behavior) {
        ArrayList<HookSite> hookSites = null;
        HashMap<String, Object> hookContext = new HashMap<String, Object>();
        AnnotationUtil.AnnotatedBehavior ab = new AnnotationUtil.AnnotatedBehavior(behavior);
        AnnotationsAttribute attr = ab.get();
        HashSet<String> behaviorAnnotations = null;
        if (attr != null) {
            Annotation[] annotations;
            behaviorAnnotations = new HashSet<String>();
            Annotation[] annotationArray = annotations = attr.getAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation a = annotationArray[i];
                behaviorAnnotations.add(a.getTypeName());
            }
        }
        hookContext.put("annotations", behaviorAnnotations);
        for (Hook hook : this.getHooks(behavior.getName())) {
            HookSite hookSite = hook.prepare(behavior, hookContext);
            if (hookSite == null) continue;
            if (hookSites == null) {
                hookSites = new ArrayList<HookSite>();
            }
            hookSites.add(hookSite);
        }
        return hookSites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> redefiningClass, ProtectionDomain domain, byte[] bytes) throws IllegalClassFormatException {
        ++this.classesExamined;
        AppMapClassPool.acquire(loader);
        try {
            CtClass ctClass;
            if (className == null) {
                byte[] byArray = null;
                return byArray;
            }
            if ((className = className.replace('/', '.')).startsWith("com.appland.shade")) {
                byte[] byArray = null;
                return byArray;
            }
            boolean traceClass = tracePrefix == null || className.startsWith(tracePrefix);
            try {
                ClassPool classPool = AppMapClassPool.get();
                if (traceClass) {
                    logger.debug("className: {}", className);
                }
                ctClass = classPool.makeClass(new ByteArrayInputStream(bytes));
            }
            catch (RuntimeException e) {
                logger.warn((Throwable)e, "makeClass failed");
                byte[] byArray = null;
                AppMapClassPool.release();
                return byArray;
            }
            if (ctClass.isInterface()) {
                if (traceClass) {
                    logger.trace("{} is an interface", className);
                }
                byte[] e = null;
                return e;
            }
            boolean hookApplied = false;
            for (CtBehavior behavior : ctClass.getDeclaredBehaviors()) {
                if (traceClass) {
                    logger.trace("behavior: {}", behavior.getLongName());
                }
                if ((behavior.getModifiers() & 0x400) != 0) {
                    if (!traceClass) continue;
                    logger.trace("abstract method");
                    continue;
                }
                ++this.methodsExamined;
                if (!this.applyHooks(behavior)) continue;
                hookApplied = true;
                ++this.methodsHooked;
            }
            if (hookApplied) {
                ClassFile classFile = ctClass.getClassFile();
                ConstPool constPool = classFile.getConstPool();
                Annotation annot = new Annotation(AppMapInstrumented.class.getName(), constPool);
                AnnotationUtil.setAnnotation(new AnnotationUtil.AnnotatedClass(ctClass), annot);
                if (traceClass) {
                    logger.trace("hooks applied to {}", className);
                    this.packagesHooked.compute(ctClass.getPackageName(), (k, v) -> v == null ? 1 : v + 1);
                }
                byte[] byArray = ctClass.toBytecode();
                return byArray;
            }
            ++this.classesIgnored;
            this.packagesIgnored.compute(ctClass.getPackageName(), (k, v) -> v == null ? 1 : v + 1);
            if (traceClass) {
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = ctClass::getName;
                supplierArray[1] = () -> Arrays.stream(ctClass.getDeclaredBehaviors()).map(CtMember::getName).collect(Collectors.joining(","));
                logger.trace("no hooks applied to {}, methods: {}", supplierArray);
            }
        }
        catch (Throwable t) {
            logger.warn(t);
        }
        finally {
            AppMapClassPool.release();
        }
        return null;
    }

    public static void logStatistics() {
        instances.forEach(cft -> {
            logger.info("+++ {} +++", cft.name);
            logger.info("classes examined: {}", cft.classesExamined);
            logger.info("classes ignored: {}", cft.classesIgnored);
            logger.info("methods examined: {}", cft.methodsExamined);
            logger.info("methods instrumented: {}", cft.methodsHooked);
            Function<Map, String> collectPkgs = pkgs -> pkgs.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).map(entry -> (String)entry.getKey() + ": " + entry.getValue()).collect(Collectors.joining("\n"));
            logger.debug("{} packages hooked:\n{}", () -> cft.packagesHooked.size(), () -> (String)collectPkgs.apply(cft.packagesHooked));
            logger.debug("{} packages ignored:\n{}", () -> cft.packagesIgnored.size(), () -> (String)collectPkgs.apply(cft.packagesIgnored));
            logger.info("=== {} ===", cft.name);
        });
    }
}

