/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.transform.instrumentation;

import com.appland.appmap.process.ThreadLock;
import com.appland.appmap.process.hooks.MethodCall;
import com.appland.appmap.process.hooks.MethodException;
import com.appland.appmap.process.hooks.MethodReturn;
import com.appland.appmap.record.EventTemplateRegistry;
import com.appland.appmap.transform.annotations.AppMapAppMethod;
import com.appland.appmap.transform.annotations.MethodEvent;
import com.appland.shade.net.bytebuddy.asm.Advice;
import com.appland.shade.net.bytebuddy.implementation.bytecode.assign.Assigner;
import java.lang.reflect.Method;

public class BBAdvice {
    @Advice.OnMethodEnter
    public static void onEnter(@Advice.This(optional=true) Object self, @Advice.Origin Method method, @Advice.AllArguments Object[] args) throws Throwable {
        AppMapAppMethod annot = method.getAnnotation(AppMapAppMethod.class);
        int[] values = annot.value();
        EventTemplateRegistry etr = EventTemplateRegistry.get();
        int callTemplateOrdinal = values[MethodEvent.METHOD_INVOCATION.getIndex()];
        ThreadLock.current().enter();
        if (ThreadLock.current().lock()) {
            MethodCall.handle(etr.buildCallEvent(callTemplateOrdinal), self, args);
            ThreadLock.current().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Advice.OnMethodExit(onThrowable=Throwable.class)
    public static void onExit(@Advice.This(optional=true) Object self, @Advice.Origin Method method, @Advice.AllArguments Object[] args, @Advice.Return(typing=Assigner.Typing.DYNAMIC) Object ret, @Advice.Thrown Throwable exc) throws Throwable {
        try {
            if (exc == null) {
                BBAdvice.handleReturn(self, method, args, ret);
            } else {
                BBAdvice.handleExc(self, method, args, exc);
            }
        }
        finally {
            ThreadLock.current().exit();
        }
    }

    public static void handleReturn(Object self, Method method, Object[] args, Object ret) throws Throwable {
        EventTemplateRegistry etr = EventTemplateRegistry.get();
        AppMapAppMethod annot = method.getAnnotation(AppMapAppMethod.class);
        int[] values = annot.value();
        int returnTemplateOrdinal = values[MethodEvent.METHOD_RETURN.getIndex()];
        if (ThreadLock.current().lock()) {
            MethodReturn.handle(etr.buildReturnEvent(returnTemplateOrdinal), self, ret, args);
            ThreadLock.current().unlock();
        }
    }

    public static void handleExc(Object self, Method method, Object[] args, Throwable exc) throws Throwable {
        AppMapAppMethod annot = method.getAnnotation(AppMapAppMethod.class);
        int[] values = annot.value();
        EventTemplateRegistry etr = EventTemplateRegistry.get();
        int excTemplateOrdinal = values[MethodEvent.METHOD_EXCEPTION.getIndex()];
        if (ThreadLock.current().lock()) {
            MethodException.handle(etr.buildReturnEvent(excTemplateOrdinal), self, exc, args);
            ThreadLock.current().unlock();
        }
        throw exc;
    }
}

