/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.util;

import com.appland.appmap.config.AppMapConfig;
import com.appland.shade.org.eclipse.jgit.api.Git;
import com.appland.shade.org.eclipse.jgit.api.errors.GitAPIException;
import com.appland.shade.org.eclipse.jgit.errors.RevisionSyntaxException;
import com.appland.shade.org.eclipse.jgit.lib.ObjectId;
import com.appland.shade.org.eclipse.jgit.lib.Repository;
import com.appland.shade.org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import com.appland.shade.org.eclipse.jgit.transport.RemoteConfig;
import com.appland.shade.org.eclipse.jgit.transport.URIish;
import com.appland.shade.org.eclipse.jgit.treewalk.TreeWalk;
import com.appland.shade.org.eclipse.jgit.treewalk.filter.PathFilter;
import com.appland.shade.org.eclipse.jgit.util.FileUtils;
import com.appland.shade.org.tinylog.TaggedLogger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class GitUtil
implements AutoCloseable {
    private static final TaggedLogger logger = AppMapConfig.getLogger(null);
    private Git git;
    private Path fsBase;
    private ObjectId tree;
    private static Map<String, Path> sourceRoots = new HashMap<String, Path>();
    private static Map<String, Optional<String>> sourcePaths = new HashMap<String, Optional<String>>();
    private static final byte[] GIT_MAIN_JAVA = "src/main/java".getBytes();
    private static int GIT_MAIN_JAVA_LEN = GIT_MAIN_JAVA.length;
    private static final byte[] GIT_TEST_JAVA = "src/test/java".getBytes();
    private static int GIT_TEST_JAVA_LEN = GIT_TEST_JAVA.length;

    private GitUtil(Git git, ObjectId tree, Path fsBase) {
        this.git = git;
        this.tree = tree;
        this.fsBase = fsBase;
    }

    public static GitUtil open() throws IOException {
        try {
            FileRepositoryBuilder builder = (FileRepositoryBuilder)new FileRepositoryBuilder().readEnvironment();
            builder.findGitDir();
            if (builder.getGitDir() == null) {
                logger.debug("Working directory {}, not in a git repo", () -> Paths.get("", new String[0]).toAbsolutePath());
                return null;
            }
            Repository repository = builder.build();
            if (repository.isBare()) {
                logger.warn("Current git repository is an unsupported configuration. No git metadata will be collected, and source paths may be incorrect.");
                return null;
            }
            Path fsBase = AppMapConfig.get().configFile.toAbsolutePath().getParent();
            ObjectId tree = repository.resolve("HEAD^{tree}");
            if (tree == null) {
                logger.warn("Couldn't resolve HEAD to a tree in {}, source paths may be incorrect", fsBase);
                return null;
            }
            return new GitUtil(new Git(repository), tree, fsBase);
        }
        catch (IOException e) {
            logger.warn(e);
            return null;
        }
    }

    @Override
    public void close() {
        this.git.close();
    }

    public Repository getRepository() {
        return this.git.getRepository();
    }

    public String getRepositoryURL() {
        try {
            Object remotes = this.git.remoteList().call();
            Optional<RemoteConfig> originConfig = remotes.stream().filter(r -> r.getName().equals("origin")).findFirst();
            List<URIish> uris = originConfig.isPresent() ? originConfig.get().getURIs() : ((RemoteConfig)remotes.get(0)).getURIs();
            return uris.get(0).toASCIIString();
        }
        catch (GitAPIException e) {
            logger.warn(e);
            return "";
        }
    }

    public String getBranch() {
        try {
            return this.getRepository().getBranch();
        }
        catch (IOException e) {
            logger.warn(e);
            return "";
        }
    }

    public String getCommit() {
        try {
            return this.getRepository().resolve("HEAD").name();
        }
        catch (RevisionSyntaxException | IOException e) {
            logger.warn(e);
            return "";
        }
    }

    public static void findSourceRoots() throws IOException {
        try (GitUtil git = GitUtil.open();){
            if (git == null) {
                return;
            }
            Repository repository = git.getRepository();
            Path fsRoot = repository.getWorkTree().toPath();
            String gitBase = fsRoot.relativize(git.fsBase).toString().replace(File.separator, "/");
            logger.debug("repoRoot: {}, gitCwd: {}", fsRoot, gitBase);
            try (TreeWalk treeWalk = new TreeWalk(repository);){
                treeWalk.addTree(git.tree);
                if (gitBase.length() > 0) {
                    treeWalk.setFilter(PathFilter.create(gitBase));
                }
                treeWalk.setRecursive(false);
                while (treeWalk.next()) {
                    if (treeWalk.isPathSuffix(GIT_MAIN_JAVA, GIT_MAIN_JAVA_LEN) || treeWalk.isPathSuffix(GIT_TEST_JAVA, GIT_TEST_JAVA_LEN)) {
                        String gitSourceRoot = treeWalk.getPathString();
                        Path fsSourceRoot = fsRoot.resolve(Paths.get(gitSourceRoot, new String[0]));
                        if (gitBase.length() > 0) {
                            gitSourceRoot = FileUtils.relativizeGitPath(gitBase, gitSourceRoot);
                        }
                        logger.debug("found {} => {}", gitSourceRoot, fsSourceRoot);
                        sourceRoots.put(gitSourceRoot, fsSourceRoot);
                        continue;
                    }
                    if (!treeWalk.isSubtree()) continue;
                    treeWalk.enterSubtree();
                }
            }
        }
    }

    public static String resolveSourcePath(String gitPartialPath) {
        Optional<String> cached = sourcePaths.get(gitPartialPath);
        if (cached != null) {
            logger.trace("cache hit, {} => {}", gitPartialPath, cached);
            return cached.orElse(gitPartialPath);
        }
        logger.trace("cache miss, {}", gitPartialPath);
        String gitFullPath = null;
        for (Map.Entry<String, Path> sourceRoot : sourceRoots.entrySet()) {
            String gitRoot = sourceRoot.getKey();
            Path fsRoot = sourceRoot.getValue();
            Path fsFullPath = fsRoot.resolve(gitPartialPath);
            boolean exists = Files.exists(fsFullPath, new LinkOption[0]);
            logger.trace("{} exists under project root {}? {}", gitPartialPath, fsRoot, exists);
            if (!exists) continue;
            gitFullPath = gitRoot + "/" + gitPartialPath;
            logger.debug("found: {}", gitFullPath);
            break;
        }
        logger.trace("found: {}", gitFullPath);
        sourcePaths.put(gitPartialPath, Optional.ofNullable(gitFullPath));
        return gitFullPath != null ? gitFullPath : gitPartialPath;
    }
}

