/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.eclipse.jgit.api;

import com.appland.shade.org.eclipse.jgit.api.GitCommand;
import com.appland.shade.org.eclipse.jgit.api.errors.GitAPIException;
import com.appland.shade.org.eclipse.jgit.api.errors.JGitInternalException;
import com.appland.shade.org.eclipse.jgit.lib.Ref;
import com.appland.shade.org.eclipse.jgit.lib.Repository;
import com.appland.shade.org.eclipse.jgit.revwalk.RevWalk;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListTagCommand
extends GitCommand<List<Ref>> {
    protected ListTagCommand(Repository repo) {
        super(repo);
    }

    @Override
    public List<Ref> call() throws GitAPIException {
        this.checkCallable();
        ArrayList<Ref> tags = new ArrayList<Ref>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (RevWalk revWalk = new RevWalk(this.repo);){
                List<Ref> refList = this.repo.getRefDatabase().getRefsByPrefix("refs/tags/");
                for (Ref ref : refList) {
                    tags.add(ref);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        Collections.sort(tags, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        this.setCallable(false);
        return tags;
    }
}

