/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.eclipse.jgit.internal.storage.pack;

import com.appland.shade.org.eclipse.jgit.annotations.NonNull;
import com.appland.shade.org.eclipse.jgit.annotations.Nullable;
import com.appland.shade.org.eclipse.jgit.errors.CorruptObjectException;
import com.appland.shade.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import com.appland.shade.org.eclipse.jgit.errors.LargeObjectException;
import com.appland.shade.org.eclipse.jgit.errors.MissingObjectException;
import com.appland.shade.org.eclipse.jgit.errors.SearchForReuseTimeout;
import com.appland.shade.org.eclipse.jgit.errors.StoredObjectRepresentationNotAvailableException;
import com.appland.shade.org.eclipse.jgit.internal.JGitText;
import com.appland.shade.org.eclipse.jgit.internal.storage.file.PackBitmapIndexBuilder;
import com.appland.shade.org.eclipse.jgit.internal.storage.file.PackBitmapIndexWriterV1;
import com.appland.shade.org.eclipse.jgit.internal.storage.file.PackIndexWriter;
import com.appland.shade.org.eclipse.jgit.internal.storage.pack.BaseSearch;
import com.appland.shade.org.eclipse.jgit.internal.storage.pack.BitmapCommit;
import com.appland.shade.org.eclipse.jgit.internal.storage.pack.CachedPack;
import com.appland.shade.org.eclipse.jgit.internal.storage.pack.CachedPackUriProvider;
import com.appland.shade.org.eclipse.jgit.internal.storage.pack.DeltaCache;
import com.appland.shade.org.eclipse.jgit.internal.storage.pack.DeltaIndex;
import com.appland.shade.org.eclipse.jgit.internal.storage.pack.DeltaTask;
import com.appland.shade.org.eclipse.jgit.internal.storage.pack.DeltaWindow;
import com.appland.shade.org.eclipse.jgit.internal.storage.pack.ObjectReuseAsIs;
import com.appland.shade.org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import com.appland.shade.org.eclipse.jgit.internal.storage.pack.PackOutputStream;
import com.appland.shade.org.eclipse.jgit.internal.storage.pack.PackWriterBitmapPreparer;
import com.appland.shade.org.eclipse.jgit.internal.storage.pack.StoredObjectRepresentation;
import com.appland.shade.org.eclipse.jgit.internal.storage.pack.ThreadSafeDeltaCache;
import com.appland.shade.org.eclipse.jgit.lib.AnyObjectId;
import com.appland.shade.org.eclipse.jgit.lib.AsyncObjectSizeQueue;
import com.appland.shade.org.eclipse.jgit.lib.BatchingProgressMonitor;
import com.appland.shade.org.eclipse.jgit.lib.BitmapIndex;
import com.appland.shade.org.eclipse.jgit.lib.BitmapObject;
import com.appland.shade.org.eclipse.jgit.lib.Constants;
import com.appland.shade.org.eclipse.jgit.lib.NullProgressMonitor;
import com.appland.shade.org.eclipse.jgit.lib.ObjectId;
import com.appland.shade.org.eclipse.jgit.lib.ObjectIdOwnerMap;
import com.appland.shade.org.eclipse.jgit.lib.ObjectIdSet;
import com.appland.shade.org.eclipse.jgit.lib.ObjectLoader;
import com.appland.shade.org.eclipse.jgit.lib.ObjectReader;
import com.appland.shade.org.eclipse.jgit.lib.ProgressMonitor;
import com.appland.shade.org.eclipse.jgit.lib.Repository;
import com.appland.shade.org.eclipse.jgit.lib.ThreadSafeProgressMonitor;
import com.appland.shade.org.eclipse.jgit.revwalk.BitmapWalker;
import com.appland.shade.org.eclipse.jgit.revwalk.DepthWalk;
import com.appland.shade.org.eclipse.jgit.revwalk.ObjectWalk;
import com.appland.shade.org.eclipse.jgit.revwalk.RevCommit;
import com.appland.shade.org.eclipse.jgit.revwalk.RevFlag;
import com.appland.shade.org.eclipse.jgit.revwalk.RevObject;
import com.appland.shade.org.eclipse.jgit.revwalk.RevSort;
import com.appland.shade.org.eclipse.jgit.revwalk.RevTag;
import com.appland.shade.org.eclipse.jgit.revwalk.RevTree;
import com.appland.shade.org.eclipse.jgit.storage.pack.PackConfig;
import com.appland.shade.org.eclipse.jgit.storage.pack.PackStatistics;
import com.appland.shade.org.eclipse.jgit.transport.FilterSpec;
import com.appland.shade.org.eclipse.jgit.transport.ObjectCountCallback;
import com.appland.shade.org.eclipse.jgit.transport.PacketLineOut;
import com.appland.shade.org.eclipse.jgit.util.BlockList;
import com.appland.shade.org.eclipse.jgit.util.TemporaryBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PackWriter
implements AutoCloseable {
    private static final int PACK_VERSION_GENERATED = 2;
    public static final Set<ObjectId> NONE = Collections.emptySet();
    private static final Map<WeakReference<PackWriter>, Boolean> instances = new ConcurrentHashMap<WeakReference<PackWriter>, Boolean>();
    private static final Iterable<PackWriter> instancesIterable = () -> new Iterator<PackWriter>(){
        private final Iterator<WeakReference<PackWriter>> it = PackWriter.access$0().keySet().iterator();
        private PackWriter next;

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean hasNext() {
            if (this.next == null) ** GOTO lbl8
            return true;
lbl-1000:
            // 1 sources

            {
                ref = this.it.next();
                this.next = (PackWriter)ref.get();
                if (this.next != null) {
                    return true;
                }
                this.it.remove();
lbl8:
                // 2 sources

                ** while (this.it.hasNext())
            }
lbl9:
            // 1 sources

            return false;
        }

        @Override
        public PackWriter next() {
            if (this.hasNext()) {
                PackWriter result = this.next;
                this.next = null;
                return result;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };
    BlockList<ObjectToPack>[] objectsLists = new BlockList[5];
    private ObjectIdOwnerMap<ObjectToPack> objectsMap;
    private List<ObjectToPack> edgeObjects;
    private BitmapIndex.BitmapBuilder haveObjects;
    private List<CachedPack> cachedPacks;
    private Set<ObjectId> tagTargets;
    private Set<? extends ObjectId> excludeFromBitmapSelection;
    private ObjectIdSet[] excludeInPacks;
    private ObjectIdSet excludeInPackLast;
    private Deflater myDeflater;
    private final ObjectReader reader;
    private final ObjectReuseAsIs reuseSupport;
    final PackConfig config;
    private final PackStatistics.Accumulator stats;
    private final MutableState state;
    private final WeakReference<PackWriter> selfRef;
    private PackStatistics.ObjectType.Accumulator typeStats;
    private List<ObjectToPack> sortedByName;
    private byte[] packcsum;
    private boolean deltaBaseAsOffset;
    private boolean reuseDeltas;
    private boolean reuseDeltaCommits;
    private boolean reuseValidate;
    private boolean thin;
    private boolean useCachedPacks;
    private boolean useBitmaps;
    private boolean ignoreMissingUninteresting;
    private boolean pruneCurrentObjectList;
    private boolean shallowPack;
    private boolean canBuildBitmaps;
    private boolean indexDisabled;
    private boolean checkSearchForReuseTimeout;
    private final Duration searchForReuseTimeout;
    private long searchForReuseStartTimeEpoc;
    private int depth;
    private Collection<? extends ObjectId> unshallowObjects;
    private PackBitmapIndexBuilder writeBitmaps;
    private CRC32 crc32;
    private ObjectCountCallback callback;
    private FilterSpec filterSpec;
    private PackfileUriConfig packfileUriConfig;

    public static Iterable<PackWriter> getInstances() {
        return instancesIterable;
    }

    public PackWriter(Repository repo) {
        this(repo, repo.newObjectReader());
    }

    public PackWriter(ObjectReader reader) {
        this(new PackConfig(), reader);
    }

    public PackWriter(Repository repo, ObjectReader reader) {
        this(new PackConfig(repo), reader);
    }

    public PackWriter(PackConfig config, ObjectReader reader) {
        this(config, reader, null);
    }

    public PackWriter(PackConfig config, ObjectReader reader, @Nullable PackStatistics.Accumulator statsAccumulator) {
        this.objectsLists[1] = new BlockList();
        this.objectsLists[2] = new BlockList();
        this.objectsLists[3] = new BlockList();
        this.objectsLists[4] = new BlockList();
        this.objectsMap = new ObjectIdOwnerMap();
        this.edgeObjects = new BlockList<ObjectToPack>();
        this.cachedPacks = new ArrayList<CachedPack>(2);
        this.tagTargets = NONE;
        this.excludeFromBitmapSelection = NONE;
        this.ignoreMissingUninteresting = true;
        this.checkSearchForReuseTimeout = false;
        this.filterSpec = FilterSpec.NO_FILTER;
        this.config = config;
        this.reader = reader;
        this.reuseSupport = reader instanceof ObjectReuseAsIs ? (ObjectReuseAsIs)((Object)reader) : null;
        this.deltaBaseAsOffset = config.isDeltaBaseAsOffset();
        this.reuseDeltas = config.isReuseDeltas();
        this.searchForReuseTimeout = config.getSearchForReuseTimeout();
        this.reuseValidate = true;
        this.stats = statsAccumulator != null ? statsAccumulator : new PackStatistics.Accumulator();
        this.state = new MutableState();
        this.selfRef = new WeakReference<PackWriter>(this);
        instances.put(this.selfRef, Boolean.TRUE);
    }

    public PackWriter setObjectCountCallback(ObjectCountCallback callback) {
        this.callback = callback;
        return this;
    }

    public void setClientShallowCommits(Set<ObjectId> clientShallowCommits) {
        this.stats.clientShallowCommits = Collections.unmodifiableSet(new HashSet<ObjectId>(clientShallowCommits));
    }

    public boolean isDeltaBaseAsOffset() {
        return this.deltaBaseAsOffset;
    }

    public void checkSearchForReuseTimeout() throws SearchForReuseTimeout {
        if (this.checkSearchForReuseTimeout && Duration.ofMillis(System.currentTimeMillis() - this.searchForReuseStartTimeEpoc).compareTo(this.searchForReuseTimeout) > 0) {
            throw new SearchForReuseTimeout(this.searchForReuseTimeout);
        }
    }

    public void setDeltaBaseAsOffset(boolean deltaBaseAsOffset) {
        this.deltaBaseAsOffset = deltaBaseAsOffset;
    }

    public void enableSearchForReuseTimeout() {
        this.checkSearchForReuseTimeout = true;
    }

    public boolean isReuseDeltaCommits() {
        return this.reuseDeltaCommits;
    }

    public void setReuseDeltaCommits(boolean reuse) {
        this.reuseDeltaCommits = reuse;
    }

    public boolean isReuseValidatingObjects() {
        return this.reuseValidate;
    }

    public void setReuseValidatingObjects(boolean validate) {
        this.reuseValidate = validate;
    }

    public boolean isThin() {
        return this.thin;
    }

    public void setThin(boolean packthin) {
        this.thin = packthin;
    }

    public boolean isUseCachedPacks() {
        return this.useCachedPacks;
    }

    public void setUseCachedPacks(boolean useCached) {
        this.useCachedPacks = useCached;
    }

    public boolean isUseBitmaps() {
        return this.useBitmaps;
    }

    public void setUseBitmaps(boolean useBitmaps) {
        this.useBitmaps = useBitmaps;
    }

    public boolean isIndexDisabled() {
        return this.indexDisabled || !this.cachedPacks.isEmpty();
    }

    public void setIndexDisabled(boolean noIndex) {
        this.indexDisabled = noIndex;
    }

    public boolean isIgnoreMissingUninteresting() {
        return this.ignoreMissingUninteresting;
    }

    public void setIgnoreMissingUninteresting(boolean ignore) {
        this.ignoreMissingUninteresting = ignore;
    }

    public void setTagTargets(Set<ObjectId> objects) {
        this.tagTargets = objects;
    }

    public void setShallowPack(int depth, Collection<? extends ObjectId> unshallow) {
        this.shallowPack = true;
        this.depth = depth;
        this.unshallowObjects = unshallow;
    }

    public void setFilterSpec(@NonNull FilterSpec filter) {
        this.filterSpec = Objects.requireNonNull(filter);
    }

    public void setPackfileUriConfig(PackfileUriConfig config) {
        this.packfileUriConfig = config;
    }

    public long getObjectCount() throws IOException {
        if (this.stats.totalObjects == 0L) {
            long objCnt = 0L;
            objCnt += (long)this.objectsLists[1].size();
            objCnt += (long)this.objectsLists[2].size();
            objCnt += (long)this.objectsLists[3].size();
            objCnt += (long)this.objectsLists[4].size();
            for (CachedPack pack : this.cachedPacks) {
                objCnt += pack.getObjectCount();
            }
            return objCnt;
        }
        return this.stats.totalObjects;
    }

    private long getUnoffloadedObjectCount() throws IOException {
        long objCnt = 0L;
        objCnt += (long)this.objectsLists[1].size();
        objCnt += (long)this.objectsLists[2].size();
        objCnt += (long)this.objectsLists[3].size();
        objCnt += (long)this.objectsLists[4].size();
        for (CachedPack pack : this.cachedPacks) {
            CachedPackUriProvider.PackInfo packInfo = this.packfileUriConfig.cachedPackUriProvider.getInfo(pack, this.packfileUriConfig.protocolsSupported);
            if (packInfo != null) continue;
            objCnt += pack.getObjectCount();
        }
        return objCnt;
    }

    public ObjectIdOwnerMap<ObjectIdOwnerMap.Entry> getObjectSet() throws IOException {
        if (!this.cachedPacks.isEmpty()) {
            throw new IOException(JGitText.get().cachedPacksPreventsListingObjects);
        }
        if (this.writeBitmaps != null) {
            return this.writeBitmaps.getObjectSet();
        }
        ObjectIdOwnerMap<ObjectIdOwnerMap.Entry> r = new ObjectIdOwnerMap<ObjectIdOwnerMap.Entry>();
        BlockList<ObjectToPack>[] blockListArray = this.objectsLists;
        int n = this.objectsLists.length;
        int n2 = 0;
        while (n2 < n) {
            BlockList<ObjectToPack> objList = blockListArray[n2];
            if (objList != null) {
                for (ObjectToPack otp : objList) {
                    r.add(new ObjectIdOwnerMap.Entry(otp){});
                }
            }
            ++n2;
        }
        return r;
    }

    public void excludeObjects(ObjectIdSet idx) {
        if (this.excludeInPacks == null) {
            this.excludeInPacks = new ObjectIdSet[]{idx};
            this.excludeInPackLast = idx;
        } else {
            int cnt = this.excludeInPacks.length;
            ObjectIdSet[] newList = new ObjectIdSet[cnt + 1];
            System.arraycopy(this.excludeInPacks, 0, newList, 0, cnt);
            newList[cnt] = idx;
            this.excludeInPacks = newList;
        }
    }

    public void preparePack(@NonNull Iterator<RevObject> objectsSource) throws IOException {
        while (objectsSource.hasNext()) {
            this.addObject(objectsSource.next());
        }
    }

    public void preparePack(Collection<? extends CachedPack> c) {
        this.cachedPacks.addAll(c);
    }

    public void preparePack(ProgressMonitor countingMonitor, @NonNull Set<? extends ObjectId> want, @NonNull Set<? extends ObjectId> have) throws IOException {
        this.preparePack(countingMonitor, want, have, NONE, NONE);
    }

    public void preparePack(ProgressMonitor countingMonitor, @NonNull Set<? extends ObjectId> want, @NonNull Set<? extends ObjectId> have, @NonNull Set<? extends ObjectId> shallow) throws IOException {
        this.preparePack(countingMonitor, want, have, shallow, NONE);
    }

    public void preparePack(ProgressMonitor countingMonitor, @NonNull Set<? extends ObjectId> want, @NonNull Set<? extends ObjectId> have, @NonNull Set<? extends ObjectId> shallow, @NonNull Set<? extends ObjectId> noBitmaps) throws IOException {
        Throwable throwable = null;
        Object var7_8 = null;
        try (ObjectWalk ow = this.getObjectWalk();){
            ow.assumeShallow(shallow);
            this.preparePack(countingMonitor, ow, want, have, noBitmaps);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private ObjectWalk getObjectWalk() {
        return this.shallowPack ? new DepthWalk.ObjectWalk(this.reader, this.depth - 1) : new ObjectWalk(this.reader);
    }

    public void preparePack(ProgressMonitor countingMonitor, @NonNull ObjectWalk walk, @NonNull Set<? extends ObjectId> interestingObjects, @NonNull Set<? extends ObjectId> uninterestingObjects, @NonNull Set<? extends ObjectId> noBitmaps) throws IOException {
        if (countingMonitor == null) {
            countingMonitor = NullProgressMonitor.INSTANCE;
        }
        if (this.shallowPack && !(walk instanceof DepthWalk.ObjectWalk)) {
            throw new IllegalArgumentException(JGitText.get().shallowPacksRequireDepthWalk);
        }
        if (this.filterSpec.getTreeDepthLimit() >= 0L) {
            walk.setVisitationPolicy(new DepthAwareVisitationPolicy(walk));
        }
        this.findObjectsToPack(countingMonitor, walk, interestingObjects, uninterestingObjects, noBitmaps);
    }

    public boolean willInclude(AnyObjectId id) throws IOException {
        ObjectToPack obj = this.objectsMap.get(id);
        return obj != null && !obj.isEdge();
    }

    public ObjectToPack get(AnyObjectId id) {
        ObjectToPack obj = this.objectsMap.get(id);
        return obj != null && !obj.isEdge() ? obj : null;
    }

    public ObjectId computeName() {
        byte[] buf = new byte[20];
        MessageDigest md = Constants.newMessageDigest();
        for (ObjectToPack otp : this.sortByName()) {
            otp.copyRawTo(buf, 0);
            md.update(buf, 0, 20);
        }
        return ObjectId.fromRaw(md.digest());
    }

    public int getIndexVersion() {
        int indexVersion = this.config.getIndexVersion();
        if (indexVersion <= 0) {
            BlockList<ObjectToPack>[] blockListArray = this.objectsLists;
            int n = this.objectsLists.length;
            int n2 = 0;
            while (n2 < n) {
                BlockList<ObjectToPack> objs = blockListArray[n2];
                indexVersion = Math.max(indexVersion, PackIndexWriter.oldestPossibleFormat(objs));
                ++n2;
            }
        }
        return indexVersion;
    }

    public void writeIndex(OutputStream indexStream) throws IOException {
        if (this.isIndexDisabled()) {
            throw new IOException(JGitText.get().cachedPacksPreventsIndexCreation);
        }
        long writeStart = System.currentTimeMillis();
        PackIndexWriter iw = PackIndexWriter.createVersion(indexStream, this.getIndexVersion());
        iw.write(this.sortByName(), this.packcsum);
        this.stats.timeWriting += System.currentTimeMillis() - writeStart;
    }

    public void writeBitmapIndex(OutputStream bitmapIndexStream) throws IOException {
        if (this.writeBitmaps == null) {
            throw new IOException(JGitText.get().bitmapsMustBePrepared);
        }
        long writeStart = System.currentTimeMillis();
        PackBitmapIndexWriterV1 iw = new PackBitmapIndexWriterV1(bitmapIndexStream);
        iw.write(this.writeBitmaps, this.packcsum);
        this.stats.timeWriting += System.currentTimeMillis() - writeStart;
    }

    private List<ObjectToPack> sortByName() {
        if (this.sortedByName == null) {
            int cnt = 0;
            cnt += this.objectsLists[1].size();
            cnt += this.objectsLists[2].size();
            cnt += this.objectsLists[3].size();
            this.sortedByName = new BlockList<ObjectToPack>(cnt += this.objectsLists[4].size());
            this.sortedByName.addAll(this.objectsLists[1]);
            this.sortedByName.addAll(this.objectsLists[2]);
            this.sortedByName.addAll(this.objectsLists[3]);
            this.sortedByName.addAll(this.objectsLists[4]);
            Collections.sort(this.sortedByName);
        }
        return this.sortedByName;
    }

    private void beginPhase(PackingPhase phase, ProgressMonitor monitor, long cnt) {
        String task;
        this.state.phase = phase;
        switch (phase) {
            case COUNTING: {
                task = JGitText.get().countingObjects;
                break;
            }
            case GETTING_SIZES: {
                task = JGitText.get().searchForSizes;
                break;
            }
            case FINDING_SOURCES: {
                task = JGitText.get().searchForReuse;
                break;
            }
            case COMPRESSING: {
                task = JGitText.get().compressingObjects;
                break;
            }
            case WRITING: {
                task = JGitText.get().writingObjects;
                break;
            }
            case BUILDING_BITMAPS: {
                task = JGitText.get().buildingBitmaps;
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().illegalPackingPhase, new Object[]{phase}));
            }
        }
        monitor.beginTask(task, (int)cnt);
    }

    private void endPhase(ProgressMonitor monitor) {
        monitor.endTask();
    }

    /*
     * Unable to fully structure code
     */
    public void writePack(ProgressMonitor compressMonitor, ProgressMonitor writeMonitor, OutputStream packStream) throws IOException {
        if (compressMonitor == null) {
            compressMonitor = NullProgressMonitor.INSTANCE;
        }
        if (writeMonitor == null) {
            writeMonitor = NullProgressMonitor.INSTANCE;
        }
        this.excludeInPacks = null;
        this.excludeInPackLast = null;
        v0 = needSearchForReuse = this.reuseSupport != null && (this.reuseDeltas != false || this.config.isReuseObjects() != false || this.cachedPacks.isEmpty() == false);
        if (compressMonitor instanceof BatchingProgressMonitor) {
            delay = 1000L;
            if (needSearchForReuse && this.config.isDeltaCompress()) {
                delay = 500L;
            }
            ((BatchingProgressMonitor)compressMonitor).setDelayStart(delay, TimeUnit.MILLISECONDS);
        }
        if (needSearchForReuse) {
            this.searchForReuse(compressMonitor);
        }
        if (this.config.isDeltaCompress()) {
            this.searchForDeltas(compressMonitor);
        }
        this.crc32 = new CRC32();
        out = new PackOutputStream(writeMonitor, this.isIndexDisabled() != false ? packStream : new CheckedOutputStream(packStream, this.crc32), this);
        this.stats.totalObjects = objCnt = this.packfileUriConfig == null ? this.getObjectCount() : this.getUnoffloadedObjectCount();
        if (this.callback != null) {
            this.callback.setObjectCount(objCnt);
        }
        this.beginPhase(PackingPhase.WRITING, writeMonitor, objCnt);
        writeStart = System.currentTimeMillis();
        try {
            if (this.packfileUriConfig != null) {
                unwrittenCachedPacks = new ArrayList<CachedPack>();
                p = PackfileUriConfig.access$0(this.packfileUriConfig);
                o = PackfileUriConfig.access$2(this.packfileUriConfig);
                o.writeString("packfile-uris\n");
                for (CachedPack pack : this.cachedPacks) {
                    packInfo = p.getInfo(pack, PackfileUriConfig.access$1(this.packfileUriConfig));
                    if (packInfo != null) {
                        o.writeString(String.valueOf(packInfo.getHash()) + ' ' + packInfo.getUri() + '\n');
                        ++this.stats.offloadedPackfiles;
                        this.stats.offloadedPackfileSize += packInfo.getSize();
                        continue;
                    }
                    unwrittenCachedPacks.add(pack);
                }
                PackfileUriConfig.access$2(this.packfileUriConfig).writeDelim();
                PackfileUriConfig.access$2(this.packfileUriConfig).writeString("packfile\n");
            } else {
                unwrittenCachedPacks = this.cachedPacks;
            }
            out.writeFileHeader(2, objCnt);
            out.flush();
            this.writeObjects(out);
            if (!this.edgeObjects.isEmpty() || !this.cachedPacks.isEmpty()) {
                var14_13 = this.stats.objectTypes;
                pack = this.stats.objectTypes.length;
                var12_12 = 0;
                while (var12_12 < pack) {
                    typeStat = var14_13[var12_12];
                    if (typeStat != null) {
                        this.stats.thinPackBytes += typeStat.bytes;
                    }
                    ++var12_12;
                }
            }
            this.stats.reusedPacks = Collections.unmodifiableList(this.cachedPacks);
            for (CachedPack pack : unwrittenCachedPacks) {
                deltaCnt = pack.getDeltaCount();
                this.stats.reusedObjects += pack.getObjectCount();
                this.stats.reusedDeltas += deltaCnt;
                this.stats.totalDeltas += deltaCnt;
                this.reuseSupport.copyPackAsIs(out, pack);
            }
            this.writeChecksum(out);
            out.flush();
        }
        finally {
            this.stats.timeWriting = System.currentTimeMillis() - writeStart;
            this.stats.depth = this.depth;
            var20_20 = this.stats.objectTypes;
            var19_22 = this.stats.objectTypes.length;
            var18_24 = 0;
            ** while (var18_24 < var19_22)
        }
lbl-1000:
        // 1 sources

        {
            typeStat = var20_20[var18_24];
            if (typeStat != null) {
                typeStat.cntDeltas += typeStat.reusedDeltas;
                this.stats.reusedObjects += typeStat.reusedObjects;
                this.stats.reusedDeltas += typeStat.reusedDeltas;
                this.stats.totalDeltas += typeStat.cntDeltas;
            }
            ++var18_24;
            continue;
        }
lbl83:
        // 1 sources

        this.stats.totalBytes = out.length();
        this.reader.close();
        this.endPhase(writeMonitor);
    }

    public PackStatistics getStatistics() {
        return new PackStatistics(this.stats);
    }

    public State getState() {
        return this.state.snapshot();
    }

    @Override
    public void close() {
        this.reader.close();
        if (this.myDeflater != null) {
            this.myDeflater.end();
            this.myDeflater = null;
        }
        instances.remove(this.selfRef);
    }

    private void searchForReuse(ProgressMonitor monitor) throws IOException {
        long start;
        long cnt = 0L;
        cnt += (long)this.objectsLists[1].size();
        cnt += (long)this.objectsLists[2].size();
        cnt += (long)this.objectsLists[3].size();
        this.searchForReuseStartTimeEpoc = start = System.currentTimeMillis();
        this.beginPhase(PackingPhase.FINDING_SOURCES, monitor, cnt += (long)this.objectsLists[4].size());
        if (cnt <= 4096L) {
            BlockList<ObjectToPack> tmp = new BlockList<ObjectToPack>((int)cnt);
            tmp.addAll(this.objectsLists[4]);
            tmp.addAll(this.objectsLists[1]);
            tmp.addAll(this.objectsLists[2]);
            tmp.addAll(this.objectsLists[3]);
            this.searchForReuse(monitor, tmp);
            if (this.pruneCurrentObjectList) {
                PackWriter.pruneEdgesFromObjectList(this.objectsLists[1]);
                PackWriter.pruneEdgesFromObjectList(this.objectsLists[2]);
                PackWriter.pruneEdgesFromObjectList(this.objectsLists[3]);
                PackWriter.pruneEdgesFromObjectList(this.objectsLists[4]);
            }
        } else {
            this.searchForReuse(monitor, this.objectsLists[4]);
            this.searchForReuse(monitor, this.objectsLists[1]);
            this.searchForReuse(monitor, this.objectsLists[2]);
            this.searchForReuse(monitor, this.objectsLists[3]);
        }
        this.endPhase(monitor);
        this.stats.timeSearchingForReuse = System.currentTimeMillis() - start;
        if (this.config.isReuseDeltas() && this.config.getCutDeltaChains()) {
            this.cutDeltaChains(this.objectsLists[2]);
            this.cutDeltaChains(this.objectsLists[3]);
        }
    }

    private void searchForReuse(ProgressMonitor monitor, List<ObjectToPack> list) throws IOException, MissingObjectException {
        this.pruneCurrentObjectList = false;
        this.reuseSupport.selectObjectRepresentation(this, monitor, list);
        if (this.pruneCurrentObjectList) {
            PackWriter.pruneEdgesFromObjectList(list);
        }
    }

    private void cutDeltaChains(BlockList<ObjectToPack> list) throws IOException {
        int max = this.config.getMaxDeltaDepth();
        int idx = list.size() - 1;
        while (idx >= 0) {
            int d = 0;
            ObjectToPack b = list.get(idx).getDeltaBase();
            while (b != null) {
                if (d < b.getChainLength()) break;
                b.setChainLength(++d);
                if (d >= max && b.isDeltaRepresentation()) {
                    this.reselectNonDelta(b);
                    break;
                }
                b = b.getDeltaBase();
            }
            --idx;
        }
        if (this.config.isDeltaCompress()) {
            for (ObjectToPack otp : list) {
                otp.clearChainLength();
            }
        }
    }

    private void searchForDeltas(ProgressMonitor monitor) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectToPack[] list = new ObjectToPack[this.objectsLists[2].size() + this.objectsLists[3].size() + this.edgeObjects.size()];
        int cnt = 0;
        cnt = this.findObjectsNeedingDelta(list, cnt, 2);
        if ((cnt = this.findObjectsNeedingDelta(list, cnt, 3)) == 0) {
            return;
        }
        int nonEdgeCnt = cnt;
        for (ObjectToPack eo : this.edgeObjects) {
            eo.setWeight(0);
            list[cnt++] = eo;
        }
        long sizingStart = System.currentTimeMillis();
        this.beginPhase(PackingPhase.GETTING_SIZES, monitor, cnt);
        AsyncObjectSizeQueue<ObjectToPack> sizeQueue = this.reader.getObjectSize(Arrays.asList(list).subList(0, cnt), false);
        try {
            long limit = Math.min(this.config.getBigFileThreshold(), Integer.MAX_VALUE);
            while (true) {
                long sz;
                block19: {
                    try {
                        if (sizeQueue.next()) break block19;
                        break;
                    }
                    catch (MissingObjectException notFound) {
                        monitor.update(1);
                        if (this.ignoreMissingUninteresting) {
                            ObjectToPack otp = sizeQueue.getCurrent();
                            if (otp != null && otp.isEdge()) {
                                otp.setDoNotDelta();
                                continue;
                            }
                            otp = this.objectsMap.get(notFound.getObjectId());
                            if (otp != null && otp.isEdge()) {
                                otp.setDoNotDelta();
                                continue;
                            }
                        }
                        throw notFound;
                    }
                }
                ObjectToPack otp = sizeQueue.getCurrent();
                if (otp == null) {
                    otp = this.objectsMap.get(sizeQueue.getObjectId());
                }
                if (16L < (sz = sizeQueue.getSize()) && sz < limit) {
                    otp.setWeight((int)sz);
                } else {
                    otp.setDoNotDelta();
                }
                monitor.update(1);
            }
        }
        finally {
            sizeQueue.release();
        }
        this.endPhase(monitor);
        this.stats.timeSearchingForSizes = System.currentTimeMillis() - sizingStart;
        Arrays.sort(list, 0, cnt, (a, b) -> {
            int cmp = (a.isDoNotDelta() ? 1 : 0) - (b.isDoNotDelta() ? 1 : 0);
            if (cmp != 0) {
                return cmp;
            }
            cmp = a.getType() - b.getType();
            if (cmp != 0) {
                return cmp;
            }
            cmp = (a.getPathHash() >>> 1) - (b.getPathHash() >>> 1);
            if (cmp != 0) {
                return cmp;
            }
            cmp = (a.getPathHash() & 1) - (b.getPathHash() & 1);
            if (cmp != 0) {
                return cmp;
            }
            cmp = (a.isEdge() ? 0 : 1) - (b.isEdge() ? 0 : 1);
            if (cmp != 0) {
                return cmp;
            }
            return b.getWeight() - a.getWeight();
        });
        while (cnt > 0 && list[cnt - 1].isDoNotDelta()) {
            if (!list[cnt - 1].isEdge()) {
                --nonEdgeCnt;
            }
            --cnt;
        }
        if (cnt == 0) {
            return;
        }
        long searchStart = System.currentTimeMillis();
        this.searchForDeltas(monitor, list, cnt);
        this.stats.deltaSearchNonEdgeObjects = nonEdgeCnt;
        this.stats.timeCompressing = System.currentTimeMillis() - searchStart;
        int i = 0;
        while (i < cnt) {
            if (!list[i].isEdge() && list[i].isDeltaRepresentation()) {
                ++this.stats.deltasFound;
            }
            ++i;
        }
    }

    private int findObjectsNeedingDelta(ObjectToPack[] list, int cnt, int type) {
        for (ObjectToPack otp : this.objectsLists[type]) {
            if (otp.isDoNotDelta() || otp.isDeltaRepresentation()) continue;
            otp.setWeight(0);
            list[cnt++] = otp;
        }
        return cnt;
    }

    private void reselectNonDelta(ObjectToPack otp) throws IOException {
        otp.clearDeltaBase();
        otp.clearReuseAsIs();
        boolean old = this.reuseDeltas;
        this.reuseDeltas = false;
        this.reuseSupport.selectObjectRepresentation(this, NullProgressMonitor.INSTANCE, Collections.singleton(otp));
        this.reuseDeltas = old;
    }

    private void searchForDeltas(ProgressMonitor monitor, ObjectToPack[] list, int cnt) throws MissingObjectException, IncorrectObjectTypeException, LargeObjectException, IOException {
        int threads = this.config.getThreads();
        if (threads == 0) {
            threads = Runtime.getRuntime().availableProcessors();
        }
        if (threads <= 1 || cnt <= this.config.getDeltaSearchWindowSize()) {
            this.singleThreadDeltaSearch(monitor, list, cnt);
        } else {
            this.parallelDeltaSearch(monitor, list, cnt, threads);
        }
    }

    private void singleThreadDeltaSearch(ProgressMonitor monitor, ObjectToPack[] list, int cnt) throws IOException {
        long totalWeight = 0L;
        int i = 0;
        while (i < cnt) {
            ObjectToPack o = list[i];
            totalWeight += (long)DeltaTask.getAdjustedWeight(o);
            ++i;
        }
        long bytesPerUnit = 1L;
        while (0x900000L <= totalWeight / bytesPerUnit) {
            bytesPerUnit <<= 10;
        }
        int cost = (int)(totalWeight / bytesPerUnit);
        if (totalWeight % bytesPerUnit != 0L) {
            ++cost;
        }
        this.beginPhase(PackingPhase.COMPRESSING, monitor, cost);
        new DeltaWindow(this.config, new DeltaCache(this.config), this.reader, monitor, bytesPerUnit, list, 0, cnt).search();
        this.endPhase(monitor);
    }

    private void parallelDeltaSearch(ProgressMonitor monitor, ObjectToPack[] list, int cnt, int threads) throws IOException {
        List<Throwable> errors;
        block27: {
            ThreadSafeDeltaCache dc = new ThreadSafeDeltaCache(this.config);
            ThreadSafeProgressMonitor pm = new ThreadSafeProgressMonitor(monitor);
            DeltaTask.Block taskBlock = new DeltaTask.Block(threads, this.config, this.reader, dc, pm, list, 0, cnt);
            taskBlock.partitionTasks();
            this.beginPhase(PackingPhase.COMPRESSING, monitor, taskBlock.cost());
            pm.startWorkers(taskBlock.tasks.size());
            Executor executor = this.config.getExecutor();
            errors = Collections.synchronizedList(new ArrayList(threads));
            if (executor instanceof ExecutorService) {
                PackWriter.runTasks((ExecutorService)executor, pm, taskBlock, errors);
            } else {
                if (executor == null) {
                    Exception e1;
                    ExecutorService pool;
                    block26: {
                        pool = Executors.newFixedThreadPool(threads);
                        e1 = null;
                        try {
                            try {
                                PackWriter.runTasks(pool, pm, taskBlock, errors);
                                break block26;
                            }
                            catch (Exception e) {
                                e1 = e;
                                pool.shutdown();
                                try {
                                    while (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                                    }
                                    break block27;
                                }
                                catch (InterruptedException e2) {
                                    if (e1 != null) {
                                        e2.addSuppressed(e1);
                                    }
                                    throw new IOException(JGitText.get().packingCancelledDuringObjectsWriting, e2);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            pool.shutdown();
                            try {
                                while (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                                }
                            }
                            catch (InterruptedException e) {
                                if (e1 != null) {
                                    e.addSuppressed(e1);
                                }
                                throw new IOException(JGitText.get().packingCancelledDuringObjectsWriting, e);
                            }
                        }
                        throw throwable;
                    }
                    pool.shutdown();
                    try {
                        while (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                        }
                    }
                    catch (InterruptedException e) {
                        if (e1 != null) {
                            e.addSuppressed(e1);
                        }
                        throw new IOException(JGitText.get().packingCancelledDuringObjectsWriting, e);
                    }
                }
                for (DeltaTask task : taskBlock.tasks) {
                    executor.execute(() -> {
                        try {
                            task.call();
                        }
                        catch (Throwable failure) {
                            errors.add(failure);
                        }
                    });
                }
                try {
                    pm.waitForCompletion();
                }
                catch (InterruptedException ie) {
                    throw new IOException(JGitText.get().packingCancelledDuringObjectsWriting, ie);
                }
            }
        }
        if (!errors.isEmpty()) {
            Throwable err = errors.get(0);
            if (err instanceof Error) {
                throw (Error)err;
            }
            if (err instanceof RuntimeException) {
                throw (RuntimeException)err;
            }
            if (err instanceof IOException) {
                throw (IOException)err;
            }
            throw new IOException(err.getMessage(), err);
        }
        this.endPhase(monitor);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static void runTasks(ExecutorService pool, ThreadSafeProgressMonitor pm, DeltaTask.Block tb, List<Throwable> errors) throws IOException {
        block7: {
            futures = new ArrayList<Future<Object>>(tb.tasks.size());
            for (DeltaTask task : tb.tasks) {
                futures.add(pool.submit(task));
            }
            try {
                pm.waitForCompletion();
                for (Future f : futures) {
                    try {
                        f.get();
                    }
                    catch (ExecutionException failed) {
                        errors.add(failed.getCause());
                    }
                }
                break block7;
            }
            catch (InterruptedException ie) {
                ** for (f : futures)
            }
lbl-1000:
            // 1 sources

            {
                f.cancel(true);
                continue;
            }
lbl23:
            // 1 sources

            throw new IOException(JGitText.get().packingCancelledDuringObjectsWriting, ie);
        }
    }

    private void writeObjects(PackOutputStream out) throws IOException {
        this.writeObjects(out, this.objectsLists[1]);
        this.writeObjects(out, this.objectsLists[4]);
        this.writeObjects(out, this.objectsLists[2]);
        this.writeObjects(out, this.objectsLists[3]);
    }

    private void writeObjects(PackOutputStream out, List<ObjectToPack> list) throws IOException {
        if (list.isEmpty()) {
            return;
        }
        this.typeStats = this.stats.objectTypes[list.get(0).getType()];
        long beginOffset = out.length();
        if (this.reuseSupport != null) {
            this.reuseSupport.writeObjects(out, list);
        } else {
            for (ObjectToPack otp : list) {
                out.writeObject(otp);
            }
        }
        this.typeStats.bytes += out.length() - beginOffset;
        this.typeStats.cntObjects = list.size();
    }

    void writeObject(PackOutputStream out, ObjectToPack otp) throws IOException {
        if (!otp.isWritten()) {
            this.writeObjectImpl(out, otp);
        }
    }

    private void writeObjectImpl(PackOutputStream out, ObjectToPack otp) throws IOException {
        if (otp.wantWrite()) {
            this.reselectNonDelta(otp);
        }
        otp.markWantWrite();
        while (otp.isReuseAsIs()) {
            this.writeBase(out, otp.getDeltaBase());
            if (otp.isWritten()) {
                return;
            }
            this.crc32.reset();
            otp.setOffset(out.length());
            try {
                this.reuseSupport.copyObjectAsIs(out, otp, this.reuseValidate);
                out.endObject();
                otp.setCRC((int)this.crc32.getValue());
                ++this.typeStats.reusedObjects;
                if (otp.isDeltaRepresentation()) {
                    ++this.typeStats.reusedDeltas;
                    this.typeStats.deltaBytes += out.length() - otp.getOffset();
                }
                return;
            }
            catch (StoredObjectRepresentationNotAvailableException gone) {
                if (otp.getOffset() == out.length()) {
                    otp.setOffset(0L);
                    otp.clearDeltaBase();
                    otp.clearReuseAsIs();
                    this.reuseSupport.selectObjectRepresentation(this, NullProgressMonitor.INSTANCE, Collections.singleton(otp));
                    continue;
                }
                CorruptObjectException coe = new CorruptObjectException(otp, "");
                coe.initCause(gone);
                throw coe;
            }
        }
        if (otp.isDeltaRepresentation()) {
            this.writeDeltaObjectDeflate(out, otp);
        } else {
            this.writeWholeObjectDeflate(out, otp);
        }
        out.endObject();
        otp.setCRC((int)this.crc32.getValue());
    }

    private void writeBase(PackOutputStream out, ObjectToPack base) throws IOException {
        if (base != null && !base.isWritten() && !base.isEdge()) {
            this.writeObjectImpl(out, base);
        }
    }

    private void writeWholeObjectDeflate(PackOutputStream out, ObjectToPack otp) throws IOException {
        Deflater deflater = this.deflater();
        ObjectLoader ldr = this.reader.open(otp, otp.getType());
        this.crc32.reset();
        otp.setOffset(out.length());
        out.writeHeader(otp, ldr.getSize());
        deflater.reset();
        DeflaterOutputStream dst = new DeflaterOutputStream((OutputStream)out, deflater);
        ldr.copyTo(dst);
        dst.finish();
    }

    private void writeDeltaObjectDeflate(PackOutputStream out, ObjectToPack otp) throws IOException {
        byte[] zbuf;
        this.writeBase(out, otp.getDeltaBase());
        this.crc32.reset();
        otp.setOffset(out.length());
        DeltaCache.Ref ref = otp.popCachedDelta();
        if (ref != null && (zbuf = (byte[])ref.get()) != null) {
            out.writeHeader(otp, otp.getCachedSize());
            out.write(zbuf);
            ++this.typeStats.cntDeltas;
            this.typeStats.deltaBytes += out.length() - otp.getOffset();
            return;
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (TemporaryBuffer.Heap delta = this.delta(otp);){
            out.writeHeader(otp, delta.length());
            Deflater deflater = this.deflater();
            deflater.reset();
            DeflaterOutputStream dst = new DeflaterOutputStream((OutputStream)out, deflater);
            delta.writeTo(dst, null);
            dst.finish();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ++this.typeStats.cntDeltas;
        this.typeStats.deltaBytes += out.length() - otp.getOffset();
    }

    private TemporaryBuffer.Heap delta(ObjectToPack otp) throws IOException {
        DeltaIndex index = new DeltaIndex(this.buffer(otp.getDeltaBaseId()));
        byte[] res = this.buffer(otp);
        TemporaryBuffer.Heap delta = new TemporaryBuffer.Heap(res.length);
        index.encode(delta, res);
        return delta;
    }

    private byte[] buffer(AnyObjectId objId) throws IOException {
        return PackWriter.buffer(this.config, this.reader, objId);
    }

    static byte[] buffer(PackConfig config, ObjectReader or, AnyObjectId objId) throws IOException {
        return or.open(objId).getCachedBytes(config.getBigFileThreshold());
    }

    private Deflater deflater() {
        if (this.myDeflater == null) {
            this.myDeflater = new Deflater(this.config.getCompressionLevel());
        }
        return this.myDeflater;
    }

    private void writeChecksum(PackOutputStream out) throws IOException {
        this.packcsum = out.getDigest();
        out.write(this.packcsum);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void findObjectsToPack(@NonNull ProgressMonitor countingMonitor, @NonNull ObjectWalk walker, @NonNull Set<? extends ObjectId> want, @NonNull Set<? extends ObjectId> have, @NonNull Set<? extends ObjectId> noBitmaps) throws IOException {
        block45: {
            block43: {
                countingStart = System.currentTimeMillis();
                this.beginPhase(PackingPhase.COUNTING, countingMonitor, 0L);
                this.stats.interestingObjects = Collections.unmodifiableSet(new HashSet<ObjectId>(want));
                this.stats.uninterestingObjects = Collections.unmodifiableSet(new HashSet<ObjectId>(have));
                this.excludeFromBitmapSelection = noBitmaps;
                v0 = this.canBuildBitmaps = this.config.isBuildBitmaps() != false && this.shallowPack == false && have.isEmpty() != false && (this.excludeInPacks == null || this.excludeInPacks.length == 0);
                if (!this.shallowPack && this.useBitmaps && (bitmapIndex = this.reader.getBitmapIndex()) != null) {
                    bitmapWalker = new BitmapWalker(walker, bitmapIndex, countingMonitor);
                    this.findObjectsToPackUsingBitmaps(bitmapWalker, want, have);
                    this.endPhase(countingMonitor);
                    this.stats.timeCounting = System.currentTimeMillis() - countingStart;
                    this.stats.bitmapIndexMisses = bitmapWalker.getCountOfBitmapIndexMisses();
                    return;
                }
                all = new ArrayList<ObjectId>(want.size() + have.size());
                all.addAll(want);
                all.addAll(have);
                include = walker.newFlag("include");
                added = walker.newFlag("added");
                walker.carry(include);
                haveEst = have.size();
                if (have.isEmpty()) {
                    walker.sort(RevSort.COMMIT_TIME_DESC);
                } else {
                    walker.sort(RevSort.TOPO);
                    if (this.thin) {
                        walker.sort(RevSort.BOUNDARY, true);
                    }
                }
                wantObjs = new ArrayList<RevObject>(want.size());
                haveObjs = new ArrayList<RevObject>(haveEst);
                wantTags = new ArrayList<RevTag>(want.size());
                q = walker.parseAny(all, true);
                try {
                    while (true) {
                        try {
                            while (true) {
                                if ((o = q.next()) == null) {
                                    break block43;
                                }
                                if (have.contains(o)) {
                                    haveObjs.add(o);
                                }
                                if (!want.contains(o)) continue;
                                o.add(include);
                                wantObjs.add(o);
                                if (!(o instanceof RevTag)) continue;
                                wantTags.add((RevTag)o);
                            }
                        }
                        catch (MissingObjectException e) {
                            if (this.ignoreMissingUninteresting && have.contains(e.getObjectId())) continue;
                            throw e;
                        }
                        break;
                    }
                }
                finally {
                    q.release();
                }
            }
            if (!wantTags.isEmpty()) {
                all = new ArrayList<E>(wantTags.size());
                for (RevTag tag : wantTags) {
                    all.add(tag.getObject());
                }
                q = walker.parseAny(all, true);
                try {
                    while (q.next() != null) {
                    }
                }
                finally {
                    q.release();
                }
            }
            if (walker instanceof DepthWalk.ObjectWalk) {
                depthWalk = (DepthWalk.ObjectWalk)walker;
                for (RevObject obj : wantObjs) {
                    depthWalk.markRoot(obj);
                }
                for (RevObject obj : haveObjs) {
                    if (!(obj instanceof RevCommit)) continue;
                    t = ((RevCommit)obj).getTree();
                    depthWalk.markUninteresting(t);
                }
                if (this.unshallowObjects != null) {
                    for (Object id : this.unshallowObjects) {
                        depthWalk.markUnshallow(walker.parseAny((AnyObjectId)id));
                    }
                }
            } else {
                for (RevObject obj : wantObjs) {
                    walker.markStart(obj);
                }
            }
            for (RevObject obj : haveObjs) {
                walker.markUninteresting(obj);
            }
            maxBases = this.config.getDeltaSearchWindowSize();
            baseTrees = new HashSet<RevTree>();
            commits = new BlockList<RevCommit>();
            roots = new HashSet<ObjectId>();
            while ((c = walker.next()) != null) {
                if (this.exclude(c)) continue;
                if (c.has(RevFlag.UNINTERESTING)) {
                    if (baseTrees.size() > maxBases) continue;
                    baseTrees.add(c.getTree());
                    continue;
                }
                commits.add(c);
                if (c.getParentCount() == 0) {
                    roots.add(c.copy());
                }
                countingMonitor.update(1);
            }
            this.stats.rootCommits = Collections.unmodifiableSet(roots);
            if (this.shallowPack) {
                for (RevCommit cmit : commits) {
                    this.addObject(cmit, 0);
                }
            } else {
                commitCnt = 0;
                putTagTargets = false;
                for (RevCommit cmit : commits) {
                    if (!cmit.has(added)) {
                        cmit.add(added);
                        this.addObject(cmit, 0);
                        ++commitCnt;
                    }
                    i = 0;
                    while (i < cmit.getParentCount()) {
                        p = cmit.getParent(i);
                        if (!(p.has(added) || p.has(RevFlag.UNINTERESTING) || this.exclude(p))) {
                            p.add(added);
                            this.addObject(p, 0);
                            ++commitCnt;
                        }
                        ++i;
                    }
                    if (putTagTargets || 4096 >= commitCnt) continue;
                    for (ObjectId id : this.tagTargets) {
                        obj = walker.lookupOrNull(id);
                        if (!(obj instanceof RevCommit) || !obj.has(include) || obj.has(RevFlag.UNINTERESTING) || obj.has(added)) continue;
                        obj.add(added);
                        this.addObject(obj, 0);
                    }
                    putTagTargets = true;
                }
            }
            commits = null;
            if (!this.thin || baseTrees.isEmpty()) ** GOTO lbl161
            bases = new BaseSearch(countingMonitor, baseTrees, this.objectsMap, this.edgeObjects, this.reader);
            while ((o = walker.nextObject()) != null) {
                if (o.has(RevFlag.UNINTERESTING) || this.exclude(o)) continue;
                pathHash = walker.getPathHashCode();
                pathBuf = walker.getPathBuffer();
                pathLen = walker.getPathLength();
                bases.addBase(o.getType(), pathBuf, pathLen, pathHash);
                if (!this.depthSkip(o, walker)) {
                    this.filterAndAddObject(o, o.getType(), pathHash, want);
                }
                countingMonitor.update(1);
            }
            break block45;
lbl-1000:
            // 1 sources

            {
                if (o.has(RevFlag.UNINTERESTING) || this.exclude(o)) continue;
                if (!this.depthSkip(o, walker)) {
                    this.filterAndAddObject(o, o.getType(), walker.getPathHashCode(), want);
                }
                countingMonitor.update(1);
lbl161:
                // 3 sources

                ** while ((o = walker.nextObject()) != null)
            }
        }
        for (CachedPack pack : this.cachedPacks) {
            countingMonitor.update((int)pack.getObjectCount());
        }
        this.endPhase(countingMonitor);
        this.stats.timeCounting = System.currentTimeMillis() - countingStart;
        this.stats.bitmapIndexMisses = -1L;
    }

    private void findObjectsToPackUsingBitmaps(BitmapWalker bitmapWalker, Set<? extends ObjectId> want, Set<? extends ObjectId> have) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        BitmapIndex.BitmapBuilder haveBitmap = bitmapWalker.findObjects(have, null, true);
        BitmapIndex.BitmapBuilder wantBitmap = bitmapWalker.findObjects(want, haveBitmap, false);
        BitmapIndex.BitmapBuilder needBitmap = wantBitmap.andNot(haveBitmap);
        if (this.useCachedPacks && this.reuseSupport != null && !this.reuseValidate && (this.excludeInPacks == null || this.excludeInPacks.length == 0)) {
            this.cachedPacks.addAll(this.reuseSupport.getCachedPacksAndUpdate(needBitmap));
        }
        for (BitmapObject obj : needBitmap) {
            ObjectId objectId = obj.getObjectId();
            if (this.exclude(objectId)) {
                needBitmap.remove(objectId);
                continue;
            }
            this.filterAndAddObject(objectId, obj.getType(), 0, want);
        }
        if (this.thin) {
            this.haveObjects = haveBitmap;
        }
    }

    private static void pruneEdgesFromObjectList(List<ObjectToPack> list) {
        int size = list.size();
        int src = 0;
        int dst = 0;
        while (src < size) {
            ObjectToPack obj = list.get(src);
            if (!obj.isEdge()) {
                if (dst != src) {
                    list.set(dst, obj);
                }
                ++dst;
            }
            ++src;
        }
        while (dst < list.size()) {
            list.remove(list.size() - 1);
        }
    }

    public void addObject(RevObject object) throws IncorrectObjectTypeException {
        if (!this.exclude(object)) {
            this.addObject(object, 0);
        }
    }

    private void addObject(RevObject object, int pathHashCode) {
        this.addObject(object, object.getType(), pathHashCode);
    }

    private void addObject(AnyObjectId src, int type, int pathHashCode) {
        ObjectToPack otp = this.reuseSupport != null ? this.reuseSupport.newObjectToPack(src, type) : new ObjectToPack(src, type);
        otp.setPathHash(pathHashCode);
        this.objectsLists[type].add(otp);
        this.objectsMap.add(otp);
    }

    private boolean depthSkip(@NonNull RevObject obj, ObjectWalk walker) {
        long treeDepth = walker.getTreeDepth();
        if (obj.getType() == 3) {
            ++treeDepth;
        } else {
            ++this.stats.treesTraversed;
        }
        if (this.filterSpec.getTreeDepthLimit() < 0L || treeDepth <= this.filterSpec.getTreeDepthLimit()) {
            return false;
        }
        walker.skipTree();
        return true;
    }

    private void filterAndAddObject(@NonNull AnyObjectId src, int type, int pathHashCode, @NonNull Set<? extends AnyObjectId> want) throws IOException {
        boolean reject;
        boolean bl = reject = !this.filterSpec.allowsType(type) && !want.contains(src) || this.filterSpec.getBlobLimit() >= 0L && type == 3 && !want.contains(src) && this.reader.getObjectSize(src, 3) > this.filterSpec.getBlobLimit();
        if (!reject) {
            this.addObject(src, type, pathHashCode);
        }
    }

    private boolean exclude(AnyObjectId objectId) {
        if (this.excludeInPacks == null) {
            return false;
        }
        if (this.excludeInPackLast.contains(objectId)) {
            return true;
        }
        ObjectIdSet[] objectIdSetArray = this.excludeInPacks;
        int n = this.excludeInPacks.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectIdSet idx = objectIdSetArray[n2];
            if (idx.contains(objectId)) {
                this.excludeInPackLast = idx;
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void select(ObjectToPack otp, StoredObjectRepresentation next) {
        int nFmt = next.getFormat();
        if (!this.cachedPacks.isEmpty()) {
            if (otp.isEdge()) {
                return;
            }
            if (nFmt == 1 || nFmt == 0) {
                for (CachedPack pack : this.cachedPacks) {
                    if (!pack.hasObject(otp, next)) continue;
                    otp.setEdge();
                    otp.clearDeltaBase();
                    otp.clearReuseAsIs();
                    this.pruneCurrentObjectList = true;
                    return;
                }
            }
        }
        if (nFmt == 0 && this.reuseDeltas && this.reuseDeltaFor(otp)) {
            ObjectId baseId = next.getDeltaBase();
            ObjectToPack ptr = this.objectsMap.get(baseId);
            if (ptr != null && !ptr.isEdge()) {
                otp.setDeltaBase(ptr);
                otp.setReuseAsIs();
            } else if (this.thin && this.have(ptr, baseId)) {
                otp.setDeltaBase(baseId);
                otp.setReuseAsIs();
            } else {
                otp.clearDeltaBase();
                otp.clearReuseAsIs();
            }
        } else if (nFmt == 1 && this.config.isReuseObjects()) {
            int nWeight = next.getWeight();
            if (otp.isReuseAsIs() && !otp.isDeltaRepresentation() && otp.getWeight() <= nWeight) {
                return;
            }
            otp.clearDeltaBase();
            otp.setReuseAsIs();
            otp.setWeight(nWeight);
        } else {
            otp.clearDeltaBase();
            otp.clearReuseAsIs();
        }
        otp.setDeltaAttempted(this.reuseDeltas && next.wasDeltaAttempted());
        otp.select(next);
    }

    private final boolean have(ObjectToPack ptr, AnyObjectId objectId) {
        return ptr != null && ptr.isEdge() || this.haveObjects != null && this.haveObjects.contains(objectId);
    }

    public boolean prepareBitmapIndex(ProgressMonitor pm) throws IOException {
        if (!this.canBuildBitmaps || this.getObjectCount() > Integer.MAX_VALUE || !this.cachedPacks.isEmpty()) {
            return false;
        }
        if (pm == null) {
            pm = NullProgressMonitor.INSTANCE;
        }
        int numCommits = this.objectsLists[1].size();
        List<ObjectToPack> byName = this.sortByName();
        this.sortedByName = null;
        this.objectsLists = null;
        this.objectsMap = null;
        this.writeBitmaps = new PackBitmapIndexBuilder(byName);
        byName = null;
        PackWriterBitmapPreparer bitmapPreparer = new PackWriterBitmapPreparer(this.reader, this.writeBitmaps, pm, this.stats.interestingObjects, this.config);
        Collection<BitmapCommit> selectedCommits = bitmapPreparer.selectCommits(numCommits, this.excludeFromBitmapSelection);
        this.beginPhase(PackingPhase.BUILDING_BITMAPS, pm, selectedCommits.size());
        BitmapWalker walker = bitmapPreparer.newBitmapWalker();
        BitmapCommit last = null;
        for (BitmapCommit cmit : selectedCommits) {
            if (!cmit.isReuseWalker()) {
                walker = bitmapPreparer.newBitmapWalker();
            }
            BitmapIndex.BitmapBuilder bitmap = walker.findObjects(Collections.singleton(cmit), null, false);
            if (last != null && cmit.isReuseWalker() && !bitmap.contains(last)) {
                throw new IllegalStateException(MessageFormat.format(JGitText.get().bitmapMissingObject, cmit.name(), last.name()));
            }
            last = BitmapCommit.copyFrom(cmit).build();
            this.writeBitmaps.processBitmapForWrite(cmit, bitmap.build(), cmit.getFlags());
            walker.setPrevCommit(last);
            walker.setPrevBitmap(bitmap);
            pm.update(1);
        }
        this.endPhase(pm);
        return true;
    }

    private boolean reuseDeltaFor(ObjectToPack otp) {
        int type = otp.getType();
        if ((type & 2) != 0) {
            return true;
        }
        if (type == 1) {
            return this.reuseDeltaCommits;
        }
        return type != 4;
    }

    static /* synthetic */ Map access$0() {
        return instances;
    }

    private static class DepthAwareVisitationPolicy
    implements ObjectWalk.VisitationPolicy {
        private final Map<ObjectId, Integer> lowestDepthVisited = new HashMap<ObjectId, Integer>();
        private final ObjectWalk walk;

        DepthAwareVisitationPolicy(ObjectWalk walk) {
            this.walk = Objects.requireNonNull(walk);
        }

        @Override
        public boolean shouldVisit(RevObject o) {
            Integer lastDepth = this.lowestDepthVisited.get(o);
            if (lastDepth == null) {
                return true;
            }
            return this.walk.getTreeDepth() < lastDepth;
        }

        @Override
        public void visited(RevObject o) {
            this.lowestDepthVisited.put(o, this.walk.getTreeDepth());
        }
    }

    private class MutableState {
        private static final long OBJECT_TO_PACK_SIZE = 120L;
        private final long totalDeltaSearchBytes;
        private volatile PackingPhase phase = PackingPhase.COUNTING;

        MutableState() {
            if (PackWriter.this.config.isDeltaCompress()) {
                int threads = PackWriter.this.config.getThreads();
                if (threads <= 0) {
                    threads = Runtime.getRuntime().availableProcessors();
                }
                this.totalDeltaSearchBytes = (long)threads * PackWriter.this.config.getDeltaSearchMemoryLimit() + (long)PackWriter.this.config.getBigFileThreshold();
            } else {
                this.totalDeltaSearchBytes = 0L;
            }
        }

        State snapshot() {
            long objCnt = 0L;
            BlockList<ObjectToPack>[] lists = PackWriter.this.objectsLists;
            if (lists != null) {
                objCnt += (long)lists[1].size();
                objCnt += (long)lists[2].size();
                objCnt += (long)lists[3].size();
                objCnt += (long)lists[4].size();
            }
            long bytesUsed = 120L * objCnt;
            PackingPhase curr = this.phase;
            if (curr == PackingPhase.COMPRESSING) {
                bytesUsed += this.totalDeltaSearchBytes;
            }
            return new State(curr, bytesUsed);
        }
    }

    public static class PackfileUriConfig {
        @NonNull
        private final PacketLineOut pckOut;
        @NonNull
        private final Collection<String> protocolsSupported;
        @NonNull
        private final CachedPackUriProvider cachedPackUriProvider;

        public PackfileUriConfig(@NonNull PacketLineOut pckOut, @NonNull Collection<String> protocolsSupported, @NonNull CachedPackUriProvider cachedPackUriProvider) {
            this.pckOut = pckOut;
            this.protocolsSupported = protocolsSupported;
            this.cachedPackUriProvider = cachedPackUriProvider;
        }

        static /* synthetic */ PacketLineOut access$2(PackfileUriConfig packfileUriConfig) {
            return packfileUriConfig.pckOut;
        }
    }

    public static enum PackingPhase {
        COUNTING,
        GETTING_SIZES,
        FINDING_SOURCES,
        COMPRESSING,
        WRITING,
        BUILDING_BITMAPS;

    }

    public class State {
        private final PackingPhase phase;
        private final long bytesUsed;

        State(PackingPhase phase, long bytesUsed) {
            this.phase = phase;
            this.bytesUsed = bytesUsed;
        }

        public PackConfig getConfig() {
            return PackWriter.this.config;
        }

        public PackingPhase getPhase() {
            return this.phase;
        }

        public long estimateBytesUsed() {
            return this.bytesUsed;
        }

        public String toString() {
            return "PackWriter.State[" + (Object)((Object)this.phase) + ", memory=" + this.bytesUsed + "]";
        }
    }
}

