/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.eclipse.jgit.lib;

import com.appland.shade.org.eclipse.jgit.annotations.NonNull;
import com.appland.shade.org.eclipse.jgit.annotations.Nullable;
import com.appland.shade.org.eclipse.jgit.internal.JGitText;
import com.appland.shade.org.eclipse.jgit.lib.Constants;
import com.appland.shade.org.eclipse.jgit.lib.GpgSignature;
import com.appland.shade.org.eclipse.jgit.lib.PersonIdent;
import com.appland.shade.org.eclipse.jgit.util.References;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Objects;

public abstract class ObjectBuilder {
    private static final byte[] hencoding = Constants.encodeASCII("encoding");
    private PersonIdent author;
    private GpgSignature gpgSignature;
    private String message;
    private Charset encoding = StandardCharsets.UTF_8;

    protected PersonIdent getAuthor() {
        return this.author;
    }

    protected void setAuthor(PersonIdent newAuthor) {
        this.author = Objects.requireNonNull(newAuthor);
    }

    public void setGpgSignature(@Nullable GpgSignature gpgSignature) {
        this.gpgSignature = gpgSignature;
    }

    @Nullable
    public GpgSignature getGpgSignature() {
        return this.gpgSignature;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    public void setMessage(@Nullable String message) {
        this.message = message;
    }

    @NonNull
    public Charset getEncoding() {
        return this.encoding;
    }

    public void setEncoding(@NonNull Charset encoding) {
        this.encoding = encoding;
    }

    @NonNull
    public abstract byte[] build() throws UnsupportedEncodingException;

    static void writeMultiLineHeader(@NonNull String in, @NonNull OutputStream out, boolean enforceAscii) throws IOException, IllegalArgumentException {
        int length = in.length();
        int i = 0;
        while (i < length) {
            char ch = in.charAt(i);
            switch (ch) {
                case '\r': {
                    if (i + 1 < length && in.charAt(i + 1) == '\n') {
                        ++i;
                    }
                    if (i + 1 >= length) break;
                    out.write(10);
                    out.write(32);
                    break;
                }
                case '\n': {
                    if (i + 1 >= length) break;
                    out.write(10);
                    out.write(32);
                    break;
                }
                default: {
                    if (ch > '\u007f' && enforceAscii) {
                        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().notASCIIString, in));
                    }
                    out.write(ch);
                }
            }
            ++i;
        }
    }

    static void writeEncoding(@NonNull Charset encoding, @NonNull OutputStream out) throws IOException {
        if (!References.isSameObject(encoding, StandardCharsets.UTF_8)) {
            out.write(hencoding);
            out.write(32);
            out.write(Constants.encodeASCII(encoding.name()));
            out.write(10);
        }
    }
}

