/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.transform.annotations;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.output.v1.Parameters;
import com.appland.appmap.record.EventTemplateRegistry;
import com.appland.appmap.transform.annotations.AnnotationUtil;
import com.appland.appmap.transform.annotations.AppMapAgentMethod;
import com.appland.appmap.transform.annotations.AppMapAppMethod;
import com.appland.appmap.transform.annotations.HookBinding;
import com.appland.appmap.transform.annotations.HookSite;
import com.appland.appmap.transform.annotations.HookValidationException;
import com.appland.appmap.transform.annotations.ISystem;
import com.appland.appmap.transform.annotations.MethodEvent;
import com.appland.appmap.transform.annotations.SourceMethodSystem;
import com.appland.appmap.transform.annotations.Unique;
import com.appland.appmap.util.AppMapClassPool;
import com.appland.shade.javassist.CannotCompileException;
import com.appland.shade.javassist.ClassPool;
import com.appland.shade.javassist.CtBehavior;
import com.appland.shade.javassist.CtClass;
import com.appland.shade.javassist.CtConstructor;
import com.appland.shade.javassist.CtMethod;
import com.appland.shade.javassist.NotFoundException;
import com.appland.shade.javassist.bytecode.AnnotationsAttribute;
import com.appland.shade.javassist.bytecode.ClassFile;
import com.appland.shade.javassist.bytecode.ConstPool;
import com.appland.shade.javassist.bytecode.MethodInfo;
import com.appland.shade.javassist.bytecode.annotation.Annotation;
import com.appland.shade.javassist.bytecode.annotation.ArrayMemberValue;
import com.appland.shade.javassist.bytecode.annotation.IntegerMemberValue;
import com.appland.shade.javassist.bytecode.annotation.MemberValue;
import com.appland.shade.org.tinylog.Supplier;
import com.appland.shade.org.tinylog.TaggedLogger;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Hook {
    private static final TaggedLogger logger = AppMapConfig.getLogger(null);
    private static final EventTemplateRegistry eventTemplateRegistry = EventTemplateRegistry.get();
    private final SourceMethodSystem sourceSystem;
    private final List<ISystem> optionalSystems;
    private final Parameters staticParameters = new Parameters();
    private final Parameters hookParameters;
    private final CtBehavior hookBehavior;
    private String uniqueKey = "";
    public static final String ANNOTATIONS = "annotations";

    Hook(SourceMethodSystem sourceSystem, List<ISystem> optionalSystems, CtBehavior hookBehavior) {
        this.sourceSystem = sourceSystem;
        this.optionalSystems = optionalSystems;
        this.hookBehavior = hookBehavior;
        this.hookParameters = new Parameters(hookBehavior);
        this.uniqueKey = (String)AnnotationUtil.getValue(hookBehavior, Unique.class, "");
        this.buildParameters();
    }

    public void buildParameters() {
        this.sourceSystem.mutateStaticParameters(this.hookBehavior, this.staticParameters);
        this.optionalSystems.stream().sorted(Comparator.comparingInt(ISystem::getParameterPriority)).forEach(system -> system.mutateStaticParameters(this.hookBehavior, this.staticParameters));
    }

    public Parameters getRuntimeParameters(HookBinding binding) {
        Parameters runtimeParameters = this.staticParameters.clone();
        Stream.concat(Stream.of(this.sourceSystem), this.optionalSystems.stream()).sorted(Comparator.comparingInt(ISystem::getParameterPriority)).forEach(system -> system.mutateRuntimeParameters(binding, runtimeParameters));
        return runtimeParameters;
    }

    public HookSite prepare(CtBehavior targetBehavior, Map<String, Object> hookContext) {
        if (targetBehavior instanceof CtConstructor) {
            return null;
        }
        if (!this.sourceSystem.match(targetBehavior, hookContext).booleanValue()) {
            return null;
        }
        String[] labels = (String[])hookContext.getOrDefault("labels", new String[0]);
        Integer behaviorOrdinal = eventTemplateRegistry.register(targetBehavior, labels);
        if (behaviorOrdinal < 0) {
            return null;
        }
        HookBinding binding = new HookBinding(this, targetBehavior, behaviorOrdinal);
        for (ISystem system : this.optionalSystems) {
            if (system.validate(binding).booleanValue()) continue;
            return null;
        }
        return new HookSite(this, behaviorOrdinal, binding);
    }

    public static void apply(CtBehavior targetBehavior, List<HookSite> hookSites) {
        MethodInfo methodInfo = targetBehavior.getMethodInfo();
        AnnotationsAttribute attr = (AnnotationsAttribute)methodInfo.getAttribute("RuntimeVisibleAnnotations");
        if (attr.getAnnotation(AppMapAppMethod.class.getName()) != null) {
            Hook.setBehaviorOrdinals(targetBehavior, hookSites);
        }
        if (attr.getAnnotation(AppMapAgentMethod.class.getName()) != null) {
            Hook.instrument(targetBehavior, hookSites);
        }
    }

    public static void instrument(CtBehavior targetBehavior, List<HookSite> hookSites) {
        CtClass returnType = Hook.getReturnType(targetBehavior);
        Boolean returnsVoid = returnType == CtClass.voidType;
        StringBuilder uniqueLocks = new StringBuilder();
        HashSet<String> uniqueKeys = new HashSet<String>();
        String[] invocations = new String[3];
        for (HookSite hookSite : hookSites) {
            String uniqueKey;
            Integer index = hookSite.getMethodEvent().getIndex();
            if (invocations[index] == null) {
                invocations[index.intValue()] = hookSite.getHookInvocation();
            } else {
                int n = index;
                invocations[n] = invocations[n] + hookSite.getHookInvocation();
            }
            if ((uniqueKey = hookSite.getUniqueKey()).isEmpty() || uniqueKeys.contains(uniqueKey)) continue;
            uniqueLocks.append("com.appland.appmap.process.ThreadLock.current().lockUnique(\"").append(uniqueKey).append("\");");
            uniqueKeys.add(uniqueKey);
        }
        try {
            String beforeSrcBlock = Hook.beforeSrcBlock(uniqueLocks.toString(), invocations[MethodEvent.METHOD_INVOCATION.getIndex()]);
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = targetBehavior::getName;
            supplierArray[1] = beforeSrcBlock::toString;
            logger.trace("{}: beforeSrcBlock:\n{}", supplierArray);
            targetBehavior.insertBefore(beforeSrcBlock);
            String afterSrcBlock = Hook.afterSrcBlock(invocations[MethodEvent.METHOD_RETURN.getIndex()]);
            Supplier[] supplierArray2 = new Supplier[2];
            supplierArray2[0] = targetBehavior::getName;
            supplierArray2[1] = afterSrcBlock::toString;
            logger.trace("{}: afterSrcBlock:\n{}", supplierArray2);
            targetBehavior.insertAfter(afterSrcBlock);
            ClassPool cp = AppMapClassPool.get();
            String exitEarlyCatchSrc = "{com.appland.appmap.process.ThreadLock.current().exit();return;}";
            if (returnsVoid.booleanValue()) {
                targetBehavior.addCatch(exitEarlyCatchSrc, cp.get("com.appland.appmap.process.ExitEarly"));
            } else if (!returnType.isPrimitive()) {
                exitEarlyCatchSrc = "{com.appland.appmap.process.ThreadLock.current().exit();return(" + returnType.getName() + ")$e.getReturnValue();}";
                targetBehavior.addCatch(exitEarlyCatchSrc, cp.get("com.appland.appmap.process.ExitEarly"));
            }
            Supplier[] supplierArray3 = new Supplier[2];
            supplierArray3[0] = targetBehavior::getName;
            supplierArray3[1] = exitEarlyCatchSrc::toString;
            logger.trace("{}: catch1Src:\n{}", supplierArray3);
            String catchSrcBlock = Hook.catchSrcBlock(invocations[MethodEvent.METHOD_EXCEPTION.getIndex()]);
            targetBehavior.addCatch(catchSrcBlock, cp.get("java.lang.Throwable"));
            Supplier[] supplierArray4 = new Supplier[2];
            supplierArray4[0] = targetBehavior::getName;
            supplierArray4[1] = catchSrcBlock::toString;
            logger.trace("{}: catchSrcBlock:\n{}", supplierArray4);
        }
        catch (CannotCompileException e) {
            logger.debug((Throwable)e, "failed to compile {}.{}", targetBehavior.getDeclaringClass().getName(), targetBehavior.getName());
        }
        catch (NotFoundException e) {
            logger.debug(e);
        }
    }

    private static void setBehaviorOrdinals(CtBehavior behavior, List<HookSite> hookSites) {
        CtClass ctClass = behavior.getDeclaringClass();
        ClassFile classFile = ctClass.getClassFile();
        ConstPool constPool = classFile.getConstPool();
        Annotation annotation = new Annotation(AppMapAppMethod.class.getName(), constPool);
        MethodEvent[] eventTypes = MethodEvent.values();
        MemberValue[] values = new MemberValue[eventTypes.length];
        for (MethodEvent eventType : eventTypes) {
            IntegerMemberValue v = new IntegerMemberValue(constPool);
            v.setValue(hookSites.get(eventType.getIndex()).getBehaviorOrdinal());
            values[eventType.getIndex().intValue()] = v;
        }
        ArrayMemberValue arrayVal = new ArrayMemberValue(constPool);
        arrayVal.setValue(values);
        annotation.addMemberValue("value", (MemberValue)arrayVal);
        AnnotationUtil.setAnnotation((AnnotationUtil.Annotated)new AnnotationUtil.AnnotatedBehavior(behavior), annotation);
    }

    private static String safeConcatStrings(String ... strs) {
        return Arrays.stream(strs).filter(Objects::nonNull).collect(Collectors.joining());
    }

    private static String beforeSrcBlock(String ... invocations) {
        String allInvocations = Hook.safeConcatStrings(invocations);
        return "{com.appland.appmap.process.ThreadLock.current().enter();" + allInvocations + "}";
    }

    private static String afterSrcBlock(String ... invocations) {
        String allInvocations = Hook.safeConcatStrings(invocations);
        return "{" + allInvocations + "com.appland.appmap.process.ThreadLock.current().exit();}";
    }

    private static String catchSrcBlock(String ... invocations) {
        String allInvocations = Hook.safeConcatStrings(invocations);
        return "{" + allInvocations + "com.appland.appmap.process.ThreadLock.current().exit();throw $e;}";
    }

    public String getKey() {
        return this.sourceSystem.getKey();
    }

    public String toString() {
        return String.format("%s(%s)", this.sourceSystem.toString(), this.hookParameters.toString());
    }

    public String getUniqueKey() {
        return this.uniqueKey;
    }

    public Parameters getParameters() {
        return this.hookParameters;
    }

    public CtBehavior getBehavior() {
        return this.hookBehavior;
    }

    public void validate() throws HookValidationException {
    }

    public void validate(CtBehavior behavior) throws HookValidationException {
    }

    public MethodEvent getMethodEvent() {
        return this.sourceSystem.getMethodEvent();
    }

    public SourceMethodSystem getSourceSystem() {
        return this.sourceSystem;
    }

    private static CtClass getReturnType(CtBehavior behavior) {
        CtClass returnType = CtClass.voidType;
        if (behavior instanceof CtMethod) {
            try {
                returnType = ((CtMethod)behavior).getReturnType();
            }
            catch (NotFoundException e) {
                logger.debug((Throwable)e, "unknown return type");
            }
        }
        return returnType;
    }

    public ISystem getSystem(Class<? extends ISystem> systemClass) {
        for (ISystem system : this.optionalSystems) {
            if (!systemClass.isInstance(system)) continue;
            return system;
        }
        return null;
    }

    public Integer getPosition() {
        return this.sourceSystem.getHookPosition();
    }
}

