/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.util;

import com.appland.shade.javassist.ClassPool;
import com.appland.shade.javassist.LoaderClassPath;
import java.util.ArrayDeque;
import java.util.Deque;

public class AppMapClassPool {
    private static final ThreadLocal<Deque<ClassPool>> threadPoolQueue = ThreadLocal.withInitial(() -> new ArrayDeque());

    public static ClassPool acquire(ClassLoader classLoader) {
        ClassPool ret = new ClassPool();
        ret.appendClassPath(new LoaderClassPath(classLoader));
        threadPoolQueue.get().push(ret);
        return ret;
    }

    public static ClassPool get() {
        ClassPool ret = threadPoolQueue.get().peek();
        if (ret == null) {
            throw new InternalError("not acquired");
        }
        return ret;
    }

    public static void release() {
        threadPoolQueue.get().pop();
    }
}

