/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.util.tinylog;

import com.appland.shade.org.tinylog.Level;
import com.appland.shade.org.tinylog.configuration.ConfigurationLoader;
import com.appland.shade.org.tinylog.provider.InternalLogger;
import com.appland.shade.org.tinylog.runtime.RuntimeProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class AppMapConfigurationLoader
implements ConfigurationLoader {
    @Override
    public Properties load() throws IOException {
        Properties properties = new Properties();
        File localConfigFile = new File("appmap-log.local.properties");
        String[] configFiles = new String[]{"appmap-log.properties", localConfigFile.getName()};
        for (String configFile : configFiles) {
            List<ClassLoader> classLoaders = RuntimeProvider.getClassLoaders();
            for (ClassLoader cl : classLoaders) {
                InputStream stream = cl.getResourceAsStream(configFile);
                Throwable throwable = null;
                try {
                    if (stream == null) continue;
                    properties.load(stream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
        }
        if (com.appland.appmap.config.Properties.DisableLogFile == Boolean.TRUE) {
            properties.put("level", "WARN");
            properties.put("writer", "console");
        }
        try {
            if (localConfigFile.exists()) {
                properties.load(new FileInputStream(localConfigFile));
            }
        }
        catch (IOException e) {
            InternalLogger.log(Level.ERROR, e, "Failed to load " + localConfigFile.getAbsolutePath());
        }
        for (Map.Entry entry : System.getProperties().entrySet()) {
            String prefix = "appmap.log.";
            String key = (String)entry.getKey();
            if (!key.startsWith(prefix)) continue;
            properties.put(key.substring(prefix.length()), entry.getValue());
        }
        return properties;
    }
}

