/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.eclipse.jgit.revwalk.filter;

import com.appland.shade.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import com.appland.shade.org.eclipse.jgit.errors.MissingObjectException;
import com.appland.shade.org.eclipse.jgit.errors.StopWalkException;
import com.appland.shade.org.eclipse.jgit.internal.JGitText;
import com.appland.shade.org.eclipse.jgit.revwalk.RevCommit;
import com.appland.shade.org.eclipse.jgit.revwalk.RevWalk;
import com.appland.shade.org.eclipse.jgit.revwalk.filter.RevFilter;
import java.io.IOException;

public class SkipRevFilter
extends RevFilter {
    private final int skip;
    private int count;

    public static RevFilter create(int skip) {
        if (skip < 0) {
            throw new IllegalArgumentException(JGitText.get().skipMustBeNonNegative);
        }
        return new SkipRevFilter(skip);
    }

    private SkipRevFilter(int skip) {
        this.skip = skip;
    }

    @Override
    public boolean include(RevWalk walker, RevCommit cmit) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.skip <= this.count++;
    }

    @Override
    public RevFilter clone() {
        return new SkipRevFilter(this.skip);
    }
}

