/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.tinylog.pattern;

import com.appland.shade.org.tinylog.core.LogEntry;
import com.appland.shade.org.tinylog.core.LogEntryValue;
import com.appland.shade.org.tinylog.pattern.Token;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;

final class PlainTextToken
implements Token {
    private static final Pattern NEW_LINE_PATTERN = Pattern.compile("\r\n|\n|\r");
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final String text;

    PlainTextToken(String text) {
        this.text = NEW_LINE_PATTERN.matcher(text).replaceAll(NEW_LINE);
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        return Collections.emptyList();
    }

    @Override
    public void render(LogEntry logEntry, StringBuilder builder) {
        builder.append(this.text);
    }

    @Override
    public void apply(LogEntry logEntry, PreparedStatement statement, int index) throws SQLException {
        statement.setString(index, this.text);
    }
}

