/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.process.hooks.test;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.output.v1.Event;
import com.appland.appmap.process.hooks.RecordingSupport;
import com.appland.appmap.record.Recorder;
import com.appland.appmap.transform.annotations.AnnotationUtil;
import com.appland.appmap.util.ClassUtil;
import com.appland.shade.org.tinylog.TaggedLogger;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;

class TestSupport {
    private static final TaggedLogger logger = AppMapConfig.getLogger(null);
    private static final String PACKAGE_NAME = TestSupport.class.getPackage().getName();
    static final String TEST_RECORDER_TYPE = "tests";

    TestSupport() {
    }

    static void startRecording(Event event, Recorder.Metadata metadata) {
        TestSupport.startRecording(new RecordingSupport.TestDetails(event), metadata, Thread.currentThread().getStackTrace());
    }

    static void startRecording(RecordingSupport.TestDetails details, Recorder.Metadata metadata) {
        TestSupport.startRecording(details, metadata, Thread.currentThread().getStackTrace());
    }

    private static void startRecording(RecordingSupport.TestDetails details, Recorder.Metadata metadata, StackTraceElement[] stack) {
        logger.trace("stack: {}", () -> Arrays.stream(stack).map(StackTraceElement::toString).collect(Collectors.joining("\n")));
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Method testMethod = null;
        for (int idx = 0; idx < stack.length; ++idx) {
            Method stackMethod;
            String className = stack[idx].getClassName();
            if (className.startsWith("java.lang") || className.startsWith(PACKAGE_NAME) || !TestSupport.hasTestAnnotation(cl, stackMethod = TestSupport.findStackMethod(stack[idx]))) continue;
            testMethod = stackMethod;
            break;
        }
        if (testMethod == null) {
            logger.warn("Couldn't find a test method on the stack:\n {}", () -> Arrays.stream(stack).map(StackTraceElement::toString).collect(Collectors.joining("\n")));
            throw new InternalError("Couldn't find a test method on the stack");
        }
        if (!TestSupport.isRecordingEnabled(cl, testMethod)) {
            return;
        }
        RecordingSupport.startRecording(details, metadata);
    }

    static StackTraceElement findErrorFrame(Object self, Throwable exception) throws InternalError {
        String selfClass = self.getClass().getName();
        StackTraceElement errorFrame = null;
        for (StackTraceElement frame : exception.getStackTrace()) {
            if (!frame.getClassName().equals(selfClass)) continue;
            errorFrame = frame;
            break;
        }
        if (errorFrame == null) {
            throw new InternalError("no stack frame matched test class");
        }
        return errorFrame;
    }

    private static boolean hasTestAnnotation(ClassLoader cl, Method stackMethod) {
        Class[] testAnnotations;
        for (Class a : testAnnotations = new Class[]{ClassUtil.safeClassForName(cl, "org.junit.jupiter.api.Test"), ClassUtil.safeClassForName(cl, "org.junit.Test"), ClassUtil.safeClassForName(cl, "org.testng.annotations.Test")}) {
            if (a == null || !AnnotationUtil.hasAnnotation(a, (AnnotatedElement)stackMethod)) continue;
            return true;
        }
        return false;
    }

    private static boolean isRecordingEnabled(ClassLoader cl, Method testMethod) {
        Class<?> noAppMap = ClassUtil.safeClassForName(cl, "com.appland.appmap.annotation.NoAppMap");
        boolean methodAnnotated = AnnotationUtil.hasAnnotation(noAppMap, (AnnotatedElement)testMethod);
        boolean classAnnotated = AnnotationUtil.hasAnnotation(noAppMap, testMethod.getDeclaringClass());
        return !methodAnnotated && !classAnnotated;
    }

    private static Method findStackMethod(StackTraceElement ste) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            String className = ste.getClassName();
            String methodName = ste.getMethodName();
            Class<?> cls = Class.forName(className, true, cl);
            Method[] methods = (Method[])Arrays.stream(cls.getDeclaredMethods()).filter(m -> m.getName().equals(methodName)).toArray(Method[]::new);
            if (methods.length == 0) {
                throw new InternalError("No method named " + methodName + " in " + className);
            }
            Method method = methods[0];
            if (methods.length > 1) {
                logger.warn("Found {} methods named {} in {}, using {}", methods.length, methodName, className, method.getName());
            }
            return method;
        }
        catch (ClassNotFoundException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

