/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.record;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.output.v1.CodeObject;
import com.appland.appmap.output.v1.Event;
import com.appland.appmap.record.ActiveSessionException;
import com.appland.appmap.record.CodeObjectTree;
import com.appland.appmap.record.Recording;
import com.appland.appmap.record.RecordingSession;
import com.appland.appmap.record.ThreadState;
import com.appland.appmap.util.Logger;
import com.appland.shade.org.apache.commons.lang3.RandomStringUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class Recorder {
    private static final String ERROR_SESSION_PRESENT = "an active recording session already exists";
    private static final String ERROR_NO_SESSION = "there is no active recording session";
    private static final Integer FILENAME_MAX_LENGTH = 255;
    private static final Integer HASH_LENGTH = 7;
    private static final String APPMAP_SUFFIX = ".appmap.json";
    private static final Recorder instance = new Recorder();
    private final ActiveSession activeSession = new ActiveSession();
    private final CodeObjectTree globalCodeObjects = new CodeObjectTree();
    private final Map<Long, ThreadState> threadState = new ConcurrentHashMap<Long, ThreadState>();

    public static String sanitizeFilename(String filename) {
        String sanitizedFilename = filename.replaceAll("[^a-zA-Z0-9-_]", "_");
        if (sanitizedFilename.length() > FILENAME_MAX_LENGTH - APPMAP_SUFFIX.length()) {
            int part = FILENAME_MAX_LENGTH - APPMAP_SUFFIX.length() - 1 - HASH_LENGTH;
            sanitizedFilename = sanitizedFilename.substring(0, part) + "-" + Recorder.hashFilename(sanitizedFilename.substring(part));
        }
        return sanitizedFilename + APPMAP_SUFFIX;
    }

    private static String hashFilename(String filename) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            return RandomStringUtils.random(HASH_LENGTH);
        }
        byte[] hash = digest.digest(filename.getBytes(StandardCharsets.UTF_8));
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (byte b : hash) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.substring(0, HASH_LENGTH);
    }

    public static Recorder getInstance() {
        return instance;
    }

    private Recorder() {
    }

    public void start(Metadata metadata) throws ActiveSessionException {
        RecordingSession session = new RecordingSession(metadata);
        this.activeSession.set(session);
    }

    public void setThreadSession(RecordingSession session) throws ActiveSessionException {
        this.activeSession.setThread(session);
    }

    public boolean hasActiveSession() {
        return this.activeSession.exists();
    }

    public Metadata getMetadata() throws ActiveSessionException {
        return this.activeSession.get().getMetadata();
    }

    public Recording checkpoint() {
        this.flush();
        return this.activeSession.get().checkpoint();
    }

    public Recording stop() throws ActiveSessionException {
        this.flush();
        return this.activeSession.release().stop();
    }

    public Recording stopThread() {
        this.flushThread();
        return this.activeSession.releaseThread().stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Event event) {
        if (!this.activeSession.exists()) {
            return;
        }
        ThreadState ts = this.threadState();
        if (ts.isProcessing) {
            return;
        }
        ts.isProcessing = true;
        try {
            if (event.event.equals("call")) {
                Event parent;
                if (!ts.callStack.empty() && event.hasPackageName() && AppMapConfig.get().isShallow(event.fqn()) && (parent = ts.callStack.peek()).hasPackageName() && event.packageName().equals(parent.packageName())) {
                    event.ignore();
                }
                event.setStartTime();
                ts.callStack.push(event);
            } else if (event.event.equals("return")) {
                if (ts.callStack.isEmpty()) {
                    Logger.println("Discarding 'return' event because the call stack is empty for this thread");
                    return;
                }
                Event caller = ts.callStack.pop();
                event.parentId = caller.id;
                event.threadId = caller.threadId;
                event.measureElapsed(caller);
                event.definedClass = null;
                event.methodId = null;
                event.isStatic = null;
                if (caller.ignored()) {
                    event.ignore();
                }
            } else {
                throw new IllegalArgumentException("Event should be 'call' or 'return', got " + event.event);
            }
            Event previousGlobalEvent = ts.getLastGlobalEvent();
            ts.setLastGlobalEvent(event);
            this.addPreviousEvent(previousGlobalEvent, this.activeSession::addGlobalEvent);
            Event previousThreadEvent = ts.getLastThreadEvent();
            ts.setLastThreadEvent(event);
            this.addPreviousEvent(previousThreadEvent, this.activeSession::addThreadEvent);
        }
        finally {
            ts.isProcessing = false;
        }
    }

    private void addPreviousEvent(Event previousEvent, Consumer<Event> eventAdder) {
        if (previousEvent == null || previousEvent.ignored()) {
            return;
        }
        previousEvent.freeze();
        eventAdder.accept(previousEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCodeObject(CodeObject codeObject) {
        CodeObjectTree codeObjectTree = this.globalCodeObjects;
        synchronized (codeObjectTree) {
            this.globalCodeObjects.add(codeObject);
        }
    }

    public CodeObjectTree getRegisteredObjects() {
        return this.globalCodeObjects;
    }

    Event getLastEvent() {
        return this.threadState().getLastGlobalEvent();
    }

    public Recording record(Runnable fn) throws ActiveSessionException {
        this.start(new Metadata("java", "process"));
        fn.run();
        return this.stop();
    }

    public void record(String name, Runnable fn) throws ActiveSessionException, IOException {
        String fileName = Recorder.sanitizeFilename(name);
        Metadata metadata = new Metadata("java", "process");
        metadata.scenarioName = name;
        this.start(metadata);
        fn.run();
        Recording recording = this.stop();
        recording.moveTo(fileName);
    }

    Iterator<ThreadState> getThreadStateIterator() {
        return this.threadState.values().iterator();
    }

    private ThreadState threadState() {
        ThreadState ts = this.threadState.get(Thread.currentThread().getId());
        if (ts == null) {
            ts = new ThreadState();
            this.threadState.put(Thread.currentThread().getId(), ts);
        }
        return ts;
    }

    private void flush() {
        this.getThreadStateIterator().forEachRemaining(ts -> {
            if (ts.getLastGlobalEvent() == null) {
                return;
            }
            ts.isProcessing = true;
            try {
                Event event = ts.getLastGlobalEvent();
                ts.setLastGlobalEvent(null);
                event.freeze();
                this.activeSession.addGlobalEvent(event);
                event.defrost();
            }
            finally {
                ts.isProcessing = false;
            }
        });
    }

    private void flushThread() {
        ThreadState ts = this.threadState();
        if (ts.getLastThreadEvent() == null) {
            return;
        }
        ts.isProcessing = true;
        try {
            Event event = ts.getLastThreadEvent();
            ts.setLastThreadEvent(null);
            event.freeze();
            this.activeSession.addThreadEvent(event);
            event.defrost();
        }
        finally {
            ts.isProcessing = false;
        }
    }

    public void addEventUpdate(Event event) {
        if (!this.activeSession.exists()) {
            return;
        }
        this.activeSession.addEventUpdate(event);
    }

    static class ActiveSession {
        private RecordingSession globalSession = null;
        private static final ThreadLocal<RecordingSession> threadSession = new ThreadLocal();

        ActiveSession() {
        }

        synchronized RecordingSession get() throws ActiveSessionException {
            if (this.globalSession == null) {
                throw new ActiveSessionException(Recorder.ERROR_NO_SESSION);
            }
            return this.globalSession;
        }

        boolean exists() {
            return this.globalSession != null || threadSession.get() != null;
        }

        synchronized RecordingSession release() throws ActiveSessionException {
            if (this.globalSession == null) {
                throw new ActiveSessionException(Recorder.ERROR_NO_SESSION);
            }
            RecordingSession result = this.globalSession;
            this.globalSession = null;
            return result;
        }

        synchronized void set(RecordingSession session) throws ActiveSessionException {
            if (this.globalSession != null) {
                throw new ActiveSessionException(Recorder.ERROR_SESSION_PRESENT);
            }
            this.globalSession = session;
        }

        void setThread(RecordingSession session) throws ActiveSessionException {
            if (threadSession.get() != null) {
                throw new ActiveSessionException(Recorder.ERROR_SESSION_PRESENT);
            }
            threadSession.set(session);
        }

        RecordingSession getThread() throws ActiveSessionException {
            if (threadSession.get() == null) {
                throw new ActiveSessionException(Recorder.ERROR_NO_SESSION);
            }
            return threadSession.get();
        }

        RecordingSession releaseThread() throws ActiveSessionException {
            RecordingSession ret = this.getThread();
            threadSession.remove();
            return ret;
        }

        synchronized void addEvent(Event event) {
            this.addGlobalEvent(event);
            this.addThreadEvent(event);
        }

        synchronized void addEventUpdate(Event event) {
            if (this.globalSession != null) {
                this.globalSession.addEventUpdate(event);
            }
            if (threadSession.get() != null) {
                threadSession.get().addEventUpdate(event);
            }
        }

        synchronized void addGlobalEvent(Event event) {
            if (this.globalSession != null) {
                this.globalSession.add(event);
            }
        }

        synchronized void addThreadEvent(Event event) {
            RecordingSession session = threadSession.get();
            if (session != null) {
                session.add(event);
            }
        }
    }

    public static class Metadata {
        public String scenarioName;
        public String recorderName;
        public String recorderType;
        public List<Framework> frameworks = new ArrayList<Framework>();
        public String recordedClassName;
        public String recordedMethodName;
        public String sourceLocation;
        public Boolean testSucceeded;
        public String failureMessage;
        public Integer failureLine;

        public Metadata(String recorderName, String recorderType) {
            this.recorderName = recorderName;
            this.recorderType = recorderType;
        }
    }

    public static class Framework {
        public String name;
        public String version;

        public Framework(String name, String version) {
            this.name = name;
            this.version = version;
        }
    }
}

