/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.reflect;

import com.appland.appmap.config.AppMapConfig;
import com.appland.shade.org.tinylog.TaggedLogger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ReflectiveType {
    private static final TaggedLogger logger = AppMapConfig.getLogger(null);
    private Map<String, Method> methods = new HashMap<String, Method>();
    protected Object self;

    public ReflectiveType(Object self) {
        if (self == null) {
            throw new InternalError("self must not be null");
        }
        this.self = self;
        this.addMethods("hashCode", "toString");
        this.addMethod("equals", Object.class);
    }

    public int hashCode() {
        return this.invokeIntMethod("hashCode", new Object[0]);
    }

    public String toString() {
        return this.invokeStringMethod("toString", new Object[0]);
    }

    public boolean equals(Object other) {
        return this.invokeMethod("equals", Boolean.FALSE, other);
    }

    protected ClassLoader getClassLoader() {
        return this.self.getClass().getClassLoader();
    }

    protected void addMethods(String ... names) {
        for (String name : names) {
            this.methods.put(name, this.getMethod(name, new Class[0]));
        }
    }

    protected boolean addMethod(String name, Class<?> ... parameterTypes) {
        Method m = this.getMethod(name, parameterTypes);
        if (m != null) {
            this.methods.put(name, m);
            return true;
        }
        return false;
    }

    protected Method getMethod(String name, Class<?> ... parameterTypes) {
        Class<?> cls = this.self.getClass();
        try {
            return cls.getMethod(name, parameterTypes);
        }
        catch (Exception e) {
            logger.trace((Throwable)e, "failed to get public method {}.{}", cls.getName(), name);
            logger.debug("failed to get method {}.{}", cls.getName(), name);
            return null;
        }
    }

    protected boolean addMethod(String name, String ... parameterTypes) {
        Method m = this.getMethodByClassNames(name, parameterTypes);
        if (m != null) {
            this.methods.put(name, m);
            return true;
        }
        return false;
    }

    protected boolean hasMethod(String name) {
        return this.methods.get(name) != null;
    }

    protected Object invokeWrappedMethod(Method method, Object ... parameters) {
        try {
            return this.unsafeInvokeWrappedMethod(method, parameters);
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    protected Object unsafeInvokeWrappedMethod(Method method, Object ... parameters) throws Throwable {
        try {
            method.setAccessible(true);
            logger.trace("method: {} parameters: {}", method, parameters);
            return method.invoke(this.self, parameters);
        }
        catch (InvocationTargetException e) {
            logger.debug((Throwable)e, "{}.{} threw an exception", this.self.getClass().getName(), method.getName());
            throw e.getTargetException();
        }
        catch (Exception e) {
            logger.warn((Throwable)e, "failed invoking {}.{}", this.self.getClass().getName(), method.getName());
            if (e.getCause() != null) {
                logger.warn(e.getCause());
            }
            return null;
        }
    }

    protected <T> T invokeMethod(String name, T defaultValue, Object ... parameters) {
        Method m = this.methods.get(name);
        if (m == null) {
            logger.debug("method {} not found in {}, did you forget to call addMethod?", name, this.self.getClass().getName());
        }
        return (T)(m != null ? this.invokeWrappedMethod(m, parameters) : defaultValue);
    }

    protected String invokeStringMethod(String name, Object ... parameters) {
        return this.invokeMethod(name, "", parameters);
    }

    protected Integer invokeIntMethod(String name, Object ... parameters) {
        return this.invokeMethod(name, -1, parameters);
    }

    protected Object invokeObjectMethod(String name, Object ... parameters) {
        return this.invokeMethod(name, null, parameters);
    }

    protected void invokeVoidMethod(String name, Object ... parameters) {
        this.invokeMethod(name, null, parameters);
    }

    protected Method getMethodByClassNames(String name, String ... parameterTypeNames) {
        Class<?> selfClass = this.self.getClass();
        logger.trace("self.getClass(): {}", selfClass);
        try {
            ArrayList parameterTypes = new ArrayList();
            ClassLoader cl = selfClass.getClassLoader();
            for (String typeName : parameterTypeNames) {
                parameterTypes.add(Class.forName(typeName, true, cl));
            }
            return selfClass.getMethod(name, parameterTypes.toArray(new Class[0]));
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            logger.debug((Throwable)e, "No match for method {}", name);
            return null;
        }
    }
}

