/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.eclipse.jgit.transport;

import com.appland.shade.org.eclipse.jgit.errors.NotSupportedException;
import com.appland.shade.org.eclipse.jgit.errors.TransportException;
import com.appland.shade.org.eclipse.jgit.internal.JGitText;
import com.appland.shade.org.eclipse.jgit.lib.Repository;
import com.appland.shade.org.eclipse.jgit.transport.BasePackFetchConnection;
import com.appland.shade.org.eclipse.jgit.transport.BasePackPushConnection;
import com.appland.shade.org.eclipse.jgit.transport.FetchConnection;
import com.appland.shade.org.eclipse.jgit.transport.PackTransport;
import com.appland.shade.org.eclipse.jgit.transport.PacketLineOut;
import com.appland.shade.org.eclipse.jgit.transport.PushConnection;
import com.appland.shade.org.eclipse.jgit.transport.RefSpec;
import com.appland.shade.org.eclipse.jgit.transport.TcpTransport;
import com.appland.shade.org.eclipse.jgit.transport.TransferConfig;
import com.appland.shade.org.eclipse.jgit.transport.Transport;
import com.appland.shade.org.eclipse.jgit.transport.TransportProtocol;
import com.appland.shade.org.eclipse.jgit.transport.URIish;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

class TransportGitAnon
extends TcpTransport
implements PackTransport {
    static final int GIT_PORT = 9418;
    static final TransportProtocol PROTO_GIT = new TransportProtocol(){

        @Override
        public String getName() {
            return JGitText.get().transportProtoGitAnon;
        }

        @Override
        public Set<String> getSchemes() {
            return Collections.singleton("git");
        }

        @Override
        public Set<TransportProtocol.URIishField> getRequiredFields() {
            return Collections.unmodifiableSet(EnumSet.of(TransportProtocol.URIishField.HOST, TransportProtocol.URIishField.PATH));
        }

        @Override
        public Set<TransportProtocol.URIishField> getOptionalFields() {
            return Collections.unmodifiableSet(EnumSet.of(TransportProtocol.URIishField.PORT));
        }

        @Override
        public int getDefaultPort() {
            return 9418;
        }

        @Override
        public Transport open(URIish uri, Repository local, String remoteName) throws NotSupportedException {
            return new TransportGitAnon(local, uri);
        }

        @Override
        public Transport open(URIish uri) throws NotSupportedException, TransportException {
            return new TransportGitAnon(uri);
        }
    };

    TransportGitAnon(Repository local, URIish uri) {
        super(local, uri);
    }

    TransportGitAnon(URIish uri) {
        super(uri);
    }

    @Override
    public FetchConnection openFetch() throws TransportException {
        return new TcpFetchConnection();
    }

    @Override
    public FetchConnection openFetch(Collection<RefSpec> refSpecs, String ... additionalPatterns) throws NotSupportedException, TransportException {
        return new TcpFetchConnection(refSpecs, additionalPatterns);
    }

    @Override
    public PushConnection openPush() throws TransportException {
        return new TcpPushConnection();
    }

    @Override
    public void close() {
    }

    Socket openConnection() throws TransportException {
        int tms = this.getTimeout() > 0 ? this.getTimeout() * 1000 : 0;
        int port = this.uri.getPort() > 0 ? this.uri.getPort() : 9418;
        Socket s = new Socket();
        try {
            InetAddress host = InetAddress.getByName(this.uri.getHost());
            s.connect(new InetSocketAddress(host, port), tms);
        }
        catch (IOException c) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (c instanceof UnknownHostException) {
                throw new TransportException(this.uri, JGitText.get().unknownHost);
            }
            if (c instanceof ConnectException) {
                throw new TransportException(this.uri, c.getMessage());
            }
            throw new TransportException(this.uri, c.getMessage(), c);
        }
        return s;
    }

    void service(String name, PacketLineOut pckOut, TransferConfig.ProtocolVersion gitProtocol) throws IOException {
        StringBuilder cmd = new StringBuilder();
        cmd.append(name);
        cmd.append(' ');
        cmd.append(this.uri.getPath());
        cmd.append('\u0000');
        cmd.append("host=");
        cmd.append(this.uri.getHost());
        if (this.uri.getPort() > 0 && this.uri.getPort() != 9418) {
            cmd.append(":");
            cmd.append(this.uri.getPort());
        }
        cmd.append('\u0000');
        if (TransferConfig.ProtocolVersion.V2.equals((Object)gitProtocol)) {
            cmd.append('\u0000');
            cmd.append("version=2");
            cmd.append('\u0000');
        }
        pckOut.writeString(cmd.toString());
        pckOut.flush();
    }

    class TcpFetchConnection
    extends BasePackFetchConnection {
        private Socket sock;

        TcpFetchConnection() throws TransportException {
            this(Collections.emptyList(), new String[0]);
        }

        TcpFetchConnection(Collection<RefSpec> refSpecs, String ... additionalPatterns) throws TransportException {
            super(TransportGitAnon.this);
            this.sock = TransportGitAnon.this.openConnection();
            try {
                InputStream sIn = this.sock.getInputStream();
                OutputStream sOut = this.sock.getOutputStream();
                sIn = new BufferedInputStream(sIn);
                sOut = new BufferedOutputStream(sOut);
                this.init(sIn, sOut);
                TransferConfig.ProtocolVersion gitProtocol = TransportGitAnon.this.protocol;
                if (gitProtocol == null) {
                    gitProtocol = TransferConfig.ProtocolVersion.V2;
                }
                TransportGitAnon.this.service("git-upload-pack", this.pckOut, gitProtocol);
            }
            catch (IOException err) {
                this.close();
                throw new TransportException(this.uri, JGitText.get().remoteHungUpUnexpectedly, err);
            }
            if (!this.readAdvertisedRefs()) {
                this.lsRefs(refSpecs, additionalPatterns);
            }
        }

        @Override
        public void close() {
            super.close();
            if (this.sock != null) {
                try {
                    try {
                        this.sock.close();
                    }
                    catch (IOException iOException) {
                        this.sock = null;
                    }
                }
                finally {
                    this.sock = null;
                }
            }
        }
    }

    class TcpPushConnection
    extends BasePackPushConnection {
        private Socket sock;

        TcpPushConnection() throws TransportException {
            super(TransportGitAnon.this);
            this.sock = TransportGitAnon.this.openConnection();
            try {
                InputStream sIn = this.sock.getInputStream();
                OutputStream sOut = this.sock.getOutputStream();
                sIn = new BufferedInputStream(sIn);
                sOut = new BufferedOutputStream(sOut);
                this.init(sIn, sOut);
                TransportGitAnon.this.service("git-receive-pack", this.pckOut, null);
            }
            catch (IOException err) {
                this.close();
                throw new TransportException(this.uri, JGitText.get().remoteHungUpUnexpectedly, err);
            }
            this.readAdvertisedRefs();
        }

        @Override
        public void close() {
            super.close();
            if (this.sock != null) {
                try {
                    try {
                        this.sock.close();
                    }
                    catch (IOException iOException) {
                        this.sock = null;
                    }
                }
                finally {
                    this.sock = null;
                }
            }
        }
    }
}

