/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.cli;

import com.appland.appmap.cli.CLI;
import com.appland.shade.com.alibaba.fastjson.JSON;
import com.appland.shade.com.alibaba.fastjson.serializer.SerializerFeature;
import com.appland.shade.org.apache.commons.lang3.SystemUtils;
import com.appland.shade.org.yaml.snakeyaml.Yaml;
import com.appland.shade.picocli.CommandLine;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

@CommandLine.Command(name="status", description={"Prints AppMap status of the Java project in a specified directory."})
public class Status
implements Callable<Integer> {
    @CommandLine.ParentCommand
    private CLI parent;

    @Override
    public Integer call() {
        TestCommand tc;
        Command command;
        System.err.printf("Reporting AppMap project status in directory: %s\n", this.parent.directory);
        Path dirPath = Paths.get(this.parent.directory, new String[0]);
        Path configPath = dirPath.resolve("appmap.yml");
        Result result = new Result();
        result.properties.config.app = CLI.projectName(dirPath.toFile());
        result.properties.config.present = Files.exists(configPath, new LinkOption[0]);
        if (result.properties.config.present) {
            result.properties.config.valid = Properties.isConfigValid(configPath);
        }
        FrameworkStatus gradleStatus = new FrameworkStatus();
        gradleStatus.name = "gradle";
        gradleStatus.present = Properties.isGradlePresent(dirPath);
        if (gradleStatus.present) {
            gradleStatus.valid = Properties.isGradleValid(dirPath);
        }
        result.properties.frameworks.add(gradleStatus);
        FrameworkStatus mavenStatus = new FrameworkStatus();
        mavenStatus.name = "maven";
        mavenStatus.present = Properties.isMavenPresent(dirPath);
        if (mavenStatus.present) {
            mavenStatus.valid = Properties.isMavenValid(dirPath);
        }
        result.properties.frameworks.add(mavenStatus);
        if (gradleStatus.valid) {
            String gradleWrapper = SystemUtils.IS_OS_WINDOWS ? "gradlew.bat" : "./gradlew";
            command = new Command();
            command.program = gradleWrapper;
            command.args.add("appmap");
            command.args.add("test");
            tc = new TestCommand("gradle");
            tc.command = command;
            result.testCommands.add(tc);
        }
        if (mavenStatus.valid) {
            String mavenWrapper;
            String string = mavenWrapper = SystemUtils.IS_OS_WINDOWS ? "mvnw.cmd" : "./mvnw";
            if (!dirPath.resolve(mavenWrapper).toFile().exists()) {
                mavenWrapper = "mvn";
            }
            command = new Command();
            command.program = mavenWrapper;
            command.args.add("test");
            tc = new TestCommand("maven");
            tc.command = command;
            result.testCommands.add(tc);
        }
        this.parent.getOutputStream().println(JSON.toJSONString((Object)result, SerializerFeature.PrettyFormat));
        return 0;
    }

    static class Result {
        public List<TestCommand> testCommands = new ArrayList<TestCommand>();
        public Properties properties = new Properties();

        Result() {
        }
    }

    static class Properties {
        public ConfigStatus config = new ConfigStatus();
        public AgentStatus agent = new AgentStatus();
        public ProjectStatus project = new ProjectStatus();
        public List<FrameworkStatus> frameworks = new ArrayList<FrameworkStatus>();

        Properties() {
        }

        static boolean isConfigValid(Path path) {
            Yaml yaml = new Yaml();
            InputStream inputStream = null;
            try {
                inputStream = Files.newInputStream(path, new OpenOption[0]);
            }
            catch (IOException e) {
                return false;
            }
            try {
                yaml.load(inputStream);
            }
            catch (RuntimeException e) {
                return false;
            }
            return true;
        }

        static boolean isGradlePresent(final Path projectPath) {
            return Arrays.stream(new String[]{"build.gradle", "build.gradle.kts"}).map(new Function<String, Path>(){

                @Override
                public Path apply(String pathName) {
                    return projectPath.resolve(pathName);
                }
            }).filter(path -> Files.exists(path, new LinkOption[0])).anyMatch(path -> {
                try {
                    return Files.readAllLines(path).stream().anyMatch(line -> line.contains("com.appland.appmap"));
                }
                catch (IOException e) {
                    return false;
                }
            });
        }

        static boolean isGradleValid(Path projectPath) {
            String gradleWrapper;
            String string = gradleWrapper = SystemUtils.IS_OS_WINDOWS ? "gradlew.bat" : "./gradlew";
            if (!projectPath.resolve(gradleWrapper).toFile().exists()) {
                gradleWrapper = "gradle";
            }
            String command = gradleWrapper + " --help appmap";
            try {
                Process process = Runtime.getRuntime().exec(command);
                process.waitFor(60L, TimeUnit.SECONDS);
                return process.exitValue() == 0;
            }
            catch (IOException | InterruptedException e) {
                return false;
            }
        }

        static boolean isMavenPresent(Path projectPath) {
            Path pom = projectPath.resolve("pom.xml");
            if (!Files.exists(pom, new LinkOption[0])) {
                return false;
            }
            try {
                return Files.readAllLines(pom).stream().anyMatch(line -> line.contains("appmap-maven-plugin"));
            }
            catch (IOException e) {
                return false;
            }
        }

        static boolean isMavenValid(Path projectPath) {
            String mavenWrapper;
            String string = mavenWrapper = SystemUtils.IS_OS_WINDOWS ? "mvnw.cmd" : "./mvnw";
            if (!projectPath.resolve(mavenWrapper).toFile().exists()) {
                mavenWrapper = "mvn";
            }
            String command = mavenWrapper + " -Dplugin=com.appland:appmap-maven-plugin help:describe";
            try {
                Process process = Runtime.getRuntime().exec(command);
                process.waitFor(60L, TimeUnit.SECONDS);
                return process.exitValue() == 0;
            }
            catch (IOException | InterruptedException e) {
                return false;
            }
        }
    }

    static class ConfigStatus {
        public String app;
        public boolean present;
        public boolean valid;

        ConfigStatus() {
        }
    }

    static class FrameworkStatus {
        public String name;
        public boolean present;
        public boolean valid;

        FrameworkStatus() {
        }
    }

    static class Command {
        public String program;
        public List<String> args = new ArrayList<String>();
        public Map<String, String> environment = new HashMap<String, String>();

        Command() {
        }
    }

    static class TestCommand {
        public String framework;
        public Command command;

        TestCommand(String framework) {
            this.framework = framework;
        }
    }

    static class ProjectStatus {
        public String language = "java";

        ProjectStatus() {
        }
    }

    static class AgentStatus {
        public String version = Status.class.getPackage().getImplementationVersion();

        AgentStatus() {
        }
    }
}

