/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.output.v1;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.config.Properties;
import com.appland.appmap.output.v1.Value;
import com.appland.shade.javassist.CtBehavior;
import com.appland.shade.javassist.CtClass;
import com.appland.shade.javassist.NotFoundException;
import com.appland.shade.javassist.bytecode.CodeAttribute;
import com.appland.shade.javassist.bytecode.LocalVariableAttribute;
import com.appland.shade.javassist.bytecode.MethodInfo;
import com.appland.shade.org.tinylog.TaggedLogger;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Parameters
implements Iterable<Value> {
    private static final TaggedLogger logger = AppMapConfig.getLogger(null);
    private final ArrayList<Value> values = new ArrayList();

    public Parameters() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Parameters(CtBehavior behavior) {
        int i;
        MethodInfo methodInfo = behavior.getMethodInfo();
        String fqn = behavior.getDeclaringClass().getName() + "." + behavior.getName() + methodInfo.getDescriptor();
        CtClass[] paramTypes = null;
        try {
            paramTypes = behavior.getParameterTypes();
        }
        catch (NotFoundException e) {
            logger.debug((Throwable)e, "Failed to get parameter types for {}", fqn);
            return;
        }
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        LocalVariableAttribute locals = null;
        if (codeAttribute != null) {
            locals = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
        } else {
            logger.debug("No code attribute for {}", fqn);
        }
        int numParams = paramTypes.length;
        String[] paramNames = new String[numParams];
        if (locals != null && numParams > 0) {
            int numLocals = locals.tableLength();
            if (Properties.DebugLocals.booleanValue()) {
                logger.debug("local variables for {}", fqn);
                for (int idx = 0; idx < numLocals; ++idx) {
                    logger.debug("  {} {} {}", idx, locals.variableName(idx), locals.index(idx));
                }
            }
            int slot = Modifier.isStatic(behavior.getModifiers()) ? 0 : 1;
            for (int i2 = 0; i2 < numParams; ++i2) {
                int width;
                try {
                    paramNames[i2] = locals.variableNameByIndex(slot);
                }
                catch (Exception e) {
                    try {
                        logger.debug((Throwable)e, "Failed to get local variable name for slot {} in {}", slot, fqn);
                    }
                    catch (Throwable throwable) {
                        int width2 = paramTypes[i2] == CtClass.doubleType || paramTypes[i2] == CtClass.longType ? 2 : 1;
                        slot += width2;
                        throw throwable;
                    }
                    width = paramTypes[i2] == CtClass.doubleType || paramTypes[i2] == CtClass.longType ? 2 : 1;
                    slot += width;
                    continue;
                }
                width = paramTypes[i2] == CtClass.doubleType || paramTypes[i2] == CtClass.longType ? 2 : 1;
                slot += width;
                continue;
            }
        }
        Value[] paramValues = new Value[numParams];
        for (i = 0; i < paramTypes.length; ++i) {
            Value param;
            String paramName = paramNames[i];
            if (paramName == null) {
                paramName = "p" + i;
            }
            paramValues[i] = param = new Value().setClassType(paramTypes[i].getName()).setName(paramName).setKind("req");
        }
        for (i = 0; i < paramValues.length; ++i) {
            this.add(paramValues[i]);
        }
    }

    @Override
    public Iterator<Value> iterator() {
        return this.values.iterator();
    }

    public boolean add(Value param) {
        if (param == null) {
            return false;
        }
        return this.values.add(param);
    }

    public Stream<Value> stream() {
        return this.values.stream();
    }

    public int size() {
        return this.values.size();
    }

    public void clear() {
        this.values.clear();
    }

    public Value get(String name) throws NoSuchElementException {
        if (this.values != null) {
            for (Value param : this.values) {
                if (!param.name.equals(name)) continue;
                return param;
            }
        }
        throw new NoSuchElementException();
    }

    public Value get(Integer index) throws NoSuchElementException {
        if (this.values == null) {
            throw new NoSuchElementException();
        }
        try {
            return this.values.get(index);
        }
        catch (IndexOutOfBoundsException | NullPointerException e) {
            throw new NoSuchElementException();
        }
    }

    public Boolean validate(Integer index, String type) {
        try {
            Value param = this.get(index);
            return param.classType.equals(type);
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public Parameters clone() {
        Parameters clonedParams = new Parameters();
        for (Value param : this.values) {
            clonedParams.add(new Value(param));
        }
        return clonedParams;
    }

    public String toString() {
        return this.values.stream().map(value -> value.classType).collect(Collectors.joining(", "));
    }
}

