/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.process.hooks;

import com.appland.appmap.output.v1.Event;
import com.appland.appmap.process.ThreadLock;
import com.appland.appmap.process.conditions.ConfigCondition;
import com.appland.appmap.process.hooks.MethodException;
import com.appland.appmap.record.EventTemplateRegistry;
import com.appland.appmap.record.Recorder;
import com.appland.appmap.transform.annotations.ArgumentArray;
import com.appland.appmap.transform.annotations.HookCondition;
import com.appland.appmap.transform.annotations.MethodEvent;
import java.lang.reflect.Method;

public class MethodReturn {
    private static final Recorder recorder = Recorder.getInstance();
    private static final EventTemplateRegistry templateRegistry = EventTemplateRegistry.get();

    @ArgumentArray
    @HookCondition(value=ConfigCondition.class, methodEvent=MethodEvent.METHOD_RETURN)
    public static void handle(Event event, Object self, Object returnValue, Object[] args) {
        event.setReturnValue(returnValue);
        recorder.add(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onReturn(int returnOrdinal, int excOrdinal, Object receiver, Method method, Object[] args, Object ret, Throwable exc) throws Throwable {
        try {
            if (exc == null) {
                MethodReturn.handleReturn(returnOrdinal, receiver, method, args, ret);
            } else {
                MethodReturn.handleExc(excOrdinal, receiver, method, args, exc);
            }
        }
        finally {
            ThreadLock.current().exit();
        }
    }

    static void handleReturn(int returnOrdinal, Object self, Method method, Object[] args, Object ret) throws Throwable {
        if (ThreadLock.current().lock()) {
            MethodReturn.handle(templateRegistry.buildReturnEvent(returnOrdinal), self, ret, args);
            ThreadLock.current().unlock();
        }
    }

    static void handleExc(int excOrdinal, Object self, Method method, Object[] args, Throwable exc) throws Throwable {
        if (ThreadLock.current().lock()) {
            MethodException.handle(templateRegistry.buildReturnEvent(excOrdinal), self, exc, args);
            ThreadLock.current().unlock();
        }
        throw exc;
    }
}

