/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.transform.annotations;

import com.appland.appmap.util.ClassUtil;
import com.appland.shade.javassist.CtBehavior;
import com.appland.shade.javassist.CtClass;
import com.appland.shade.javassist.bytecode.AnnotationsAttribute;
import com.appland.shade.javassist.bytecode.ClassFile;
import com.appland.shade.javassist.bytecode.ConstPool;
import com.appland.shade.javassist.bytecode.MethodInfo;
import com.appland.shade.javassist.bytecode.annotation.Annotation;
import com.appland.shade.javassist.bytecode.annotation.MemberValue;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;

public class AnnotationUtil {
    public static Object getValue(CtBehavior behavior, Class<?> annotationClass, Object defaultValue) {
        return AnnotationUtil.getObject(behavior, annotationClass, "value", defaultValue);
    }

    public static Integer getPosition(CtBehavior behavior, Class<?> annotationClass, Object defaultValue) {
        return (Integer)AnnotationUtil.getObject(behavior, annotationClass, "position", defaultValue);
    }

    public static Object getObject(CtBehavior behavior, Class<?> annotationClass, String annotationName, Object defaultValue) {
        try {
            Object annotation = behavior.getAnnotation(annotationClass);
            if (annotation == null) {
                annotation = behavior.getDeclaringClass().getAnnotation(annotationClass);
            }
            if (annotation == null) {
                return defaultValue;
            }
            Method valueMethod = annotationClass.getMethod(annotationName, new Class[0]);
            if (valueMethod == null) {
                return defaultValue;
            }
            return valueMethod.invoke(annotation, new Object[0]);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static boolean hasAnnotation(String annotationName, AnnotatedElement elt) {
        return AnnotationUtil.hasAnnotation(ClassUtil.safeClassForName(AnnotationUtil.class.getClassLoader(), annotationName), elt);
    }

    public static boolean hasAnnotation(Class<?> annotation, AnnotatedElement elt) {
        return annotation != null && elt.isAnnotationPresent(annotation);
    }

    public static Annotation newBehaviorAnnotation(AnnotatedBehavior ab, Class<?> annotationClass) {
        CtClass ctClass = ab.behavior.getDeclaringClass();
        ClassFile classFile = ctClass.getClassFile();
        ConstPool constPool = classFile.getConstPool();
        return new Annotation(annotationClass.getName(), constPool);
    }

    public static void setAnnotation(AnnotatedBehavior behavior, Class<?> annotationClass) {
        AnnotationUtil.setAnnotation((Annotated)behavior, AnnotationUtil.newBehaviorAnnotation(behavior, annotationClass));
    }

    public static void setAnnotation(Annotated annotated, Annotation annotation) {
        ClassFile classFile = annotated.getClassFile();
        ConstPool constPool = classFile.getConstPool();
        AnnotationsAttribute attr = annotated.get();
        if (attr == null) {
            attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        }
        Annotation[] existingAnnotations = attr.getAnnotations();
        boolean foundExisting = false;
        for (Annotation a : existingAnnotations) {
            if (!a.getTypeName().equals(annotation.getTypeName())) continue;
            MemberValue memberValue = annotation.getMemberValue("value");
            if (memberValue != null) {
                a.addMemberValue("value", memberValue);
            }
            foundExisting = true;
            break;
        }
        if (!foundExisting) {
            Annotation newAnnotation = new Annotation(annotation.getTypeName(), constPool);
            MemberValue memberValue = annotation.getMemberValue("value");
            if (memberValue != null) {
                newAnnotation.addMemberValue("value", memberValue);
            }
            attr.addAnnotation(newAnnotation);
        } else {
            attr.setAnnotations(existingAnnotations);
        }
        annotated.setAnnotations(attr);
    }

    public static class AnnotatedBehavior
    implements Annotated {
        private final MethodInfo methodInfo;
        final CtBehavior behavior;

        public AnnotatedBehavior(CtBehavior behavior) {
            this.behavior = behavior;
            this.methodInfo = behavior.getMethodInfo();
        }

        @Override
        public AnnotationsAttribute get() {
            return (AnnotationsAttribute)this.methodInfo.getAttribute("RuntimeVisibleAnnotations");
        }

        @Override
        public void setAnnotations(AnnotationsAttribute attr) {
            this.methodInfo.addAttribute(attr);
        }

        @Override
        public ClassFile getClassFile() {
            return this.behavior.getDeclaringClass().getClassFile();
        }
    }

    public static interface Annotated {
        public ClassFile getClassFile();

        public AnnotationsAttribute get();

        public void setAnnotations(AnnotationsAttribute var1);
    }

    public static class AnnotatedClass
    implements Annotated {
        private final ClassFile classFile;

        public AnnotatedClass(CtClass cls) {
            this.classFile = cls.getClassFile();
        }

        @Override
        public AnnotationsAttribute get() {
            return (AnnotationsAttribute)this.classFile.getAttribute("RuntimeVisibleAnnotations");
        }

        @Override
        public void setAnnotations(AnnotationsAttribute attr) {
            this.classFile.addAttribute(attr);
        }

        @Override
        public ClassFile getClassFile() {
            return this.classFile;
        }
    }
}

