/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.transform.instrumentation;

import com.appland.appmap.ClassFileExporter;
import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.config.Properties;
import com.appland.appmap.transform.annotations.AppMapInstrumented;
import com.appland.appmap.transform.instrumentation.AnnotationRemover;
import com.appland.appmap.transform.instrumentation.BBAdvice;
import com.appland.shade.net.bytebuddy.agent.builder.AgentBuilder;
import com.appland.shade.net.bytebuddy.description.type.TypeDescription;
import com.appland.shade.net.bytebuddy.dynamic.ClassFileLocator;
import com.appland.shade.net.bytebuddy.dynamic.DynamicType;
import com.appland.shade.net.bytebuddy.matcher.ElementMatchers;
import com.appland.shade.net.bytebuddy.utility.JavaModule;
import com.appland.shade.org.tinylog.TaggedLogger;
import java.lang.instrument.Instrumentation;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.ProtectionDomain;

public class BBTransformer
implements AgentBuilder.Transformer {
    private static final TaggedLogger logger = AppMapConfig.getLogger(null);

    public static void installOn(Instrumentation inst) {
        AgentBuilder builder = new AgentBuilder.Default();
        if (Properties.SaveInstrumented.booleanValue()) {
            Path dir = Paths.get(System.getProperty("java.io.tmpdir"), "appmap", "bb");
            logger.info("Saving instrumented files to {}", dir);
            builder = builder.with(new ClassFileExporter(dir));
        }
        builder.with(ClassFileLocator.ForClassLoader.ofSystemLoader()).type(ElementMatchers.isAnnotatedWith(AppMapInstrumented.class)).transform(new BBTransformer()).installOn(inst);
    }

    private BBTransformer() {
    }

    @Override
    public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, ProtectionDomain protectionDomain) {
        logger.trace("builder: {}, typeDescription: {}", builder, typeDescription);
        return builder.visit(BBAdvice.METHOD_INSTRUMENTOR).visit(AnnotationRemover.FROM_APP_METHODS).visit(AnnotationRemover.FROM_APP_CLASSES);
    }
}

