/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.util;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.output.v1.CodeObject;
import com.appland.appmap.util.AppMapClassPool;
import com.appland.shade.javassist.ClassPool;
import com.appland.shade.javassist.CtClass;
import com.appland.shade.javassist.CtMethod;
import com.appland.shade.javassist.NotFoundException;
import com.appland.shade.javassist.bytecode.LineNumberAttribute;
import com.appland.shade.javassist.bytecode.MethodInfo;
import com.appland.shade.org.apache.commons.lang3.StringUtils;
import com.appland.shade.org.tinylog.TaggedLogger;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ClassUtil {
    private static final TaggedLogger logger = AppMapConfig.getLogger(null);
    private static Map<String, CtClass> primitiveTypeMap = new HashMap<String, CtClass>();

    public static Class<?> safeClassForName(ClassLoader cl, String name) {
        try {
            return Class.forName(name, true, cl);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static Class<?> safeClassForNames(ClassLoader cl, String ... classNames) throws InternalError {
        String c;
        Class<?> cls = null;
        String[] stringArray = classNames;
        int n = stringArray.length;
        for (int i = 0; i < n && (cls = ClassUtil.safeClassForName(cl, c = stringArray[i])) == null; ++i) {
        }
        if (cls == null) {
            throw new InternalError("No class of " + String.join((CharSequence)",", classNames));
        }
        return cls;
    }

    private static CtClass mapType(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        CtClass ret = primitiveTypeMap.get(name);
        if (ret == null) {
            try {
                logger.trace("name: {}", name);
                ClassPool cp = AppMapClassPool.get();
                ret = cp.get(name);
            }
            catch (NotFoundException e) {
                logger.warn(e);
            }
        }
        return ret;
    }

    public static MethodLocation getMethodLocation(String className, String methodName, String paramTypes) {
        logger.trace("className: {}, methodName: {}, paramTypes: {}", className, methodName, paramTypes);
        try {
            ClassPool cp = AppMapClassPool.get();
            CtClass cls = cp.get(className);
            String loc = CodeObject.getSourceFilePath(cls);
            logger.trace("loc: {}", loc);
            MethodInfo methodInfo = ClassUtil.getDeclaredMethod(cls, methodName, paramTypes).getMethodInfo();
            LineNumberAttribute lineAttr = (LineNumberAttribute)methodInfo.getCodeAttribute().getAttribute("LineNumberTable");
            if (loc != null && methodInfo != null) {
                return new MethodLocation(loc, lineAttr.toLineNumber(0));
            }
        }
        catch (NotFoundException e) {
            logger.warn(e);
        }
        return null;
    }

    private static String[] splitParams(String paramTypes) {
        return StringUtils.stripAll(paramTypes.split(","));
    }

    public static CtMethod getDeclaredMethod(String className, String methodName, String paramTypes) throws NotFoundException {
        return ClassUtil.getDeclaredMethod(className, methodName, ClassUtil.splitParams(paramTypes));
    }

    public static CtMethod getDeclaredMethod(CtClass cls, String methodName, String paramTypes) throws NotFoundException {
        return ClassUtil.getDeclaredMethod(cls, methodName, ClassUtil.splitParams(paramTypes));
    }

    public static CtMethod getDeclaredMethod(String className, String methodName, String[] paramTypes) throws NotFoundException {
        ClassPool cp = AppMapClassPool.get();
        CtClass cls = cp.get(className);
        return ClassUtil.getDeclaredMethod(cls, methodName, paramTypes);
    }

    public static CtMethod getDeclaredMethod(CtClass cls, String methodName, String[] paramTypes) throws NotFoundException {
        CtClass[] paramClasses = (CtClass[])Arrays.stream(paramTypes).map(t -> ClassUtil.mapType(t)).filter(Objects::nonNull).toArray(CtClass[]::new);
        return cls.getDeclaredMethod(methodName, paramClasses);
    }

    public static <E extends Enum<E>> E enumValueOf(Class<E> enumClass, String valueName) {
        try {
            E enumValue = Enum.valueOf(enumClass, valueName);
            return enumValue;
        }
        catch (IllegalArgumentException e) {
            throw new InternalError("failed to fetch " + enumClass.getName() + "." + valueName, e);
        }
    }

    public static Enum<?> enumValueOf(ClassLoader cl, String valueName, String ... classNames) {
        Class<?> cls = ClassUtil.safeClassForNames(cl, classNames);
        return ClassUtil.enumValueOf(cls.asSubclass(Enum.class), valueName);
    }

    public static EnumSet<?> enumSetOf(Class<?> enumClass, String valueName) {
        return EnumSet.of(ClassUtil.enumValueOf(enumClass.asSubclass(Enum.class), valueName));
    }

    static {
        primitiveTypeMap.put("boolean", CtClass.booleanType);
        primitiveTypeMap.put("char", CtClass.charType);
        primitiveTypeMap.put("byte", CtClass.byteType);
        primitiveTypeMap.put("short", CtClass.shortType);
        primitiveTypeMap.put("int", CtClass.intType);
        primitiveTypeMap.put("long", CtClass.longType);
        primitiveTypeMap.put("float", CtClass.floatType);
        primitiveTypeMap.put("double", CtClass.doubleType);
    }

    public static class MethodLocation {
        public String file;
        public int line;

        MethodLocation(String file, int line) {
            this.file = file;
            this.line = line;
        }
    }
}

