/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.eclipse.jgit.dircache;

import com.appland.shade.org.eclipse.jgit.annotations.NonNull;
import com.appland.shade.org.eclipse.jgit.dircache.DirCacheCheckout;
import com.appland.shade.org.eclipse.jgit.dircache.DirCacheEntry;
import com.appland.shade.org.eclipse.jgit.internal.JGitText;
import com.appland.shade.org.eclipse.jgit.lib.CoreConfig;
import com.appland.shade.org.eclipse.jgit.lib.FileMode;
import com.appland.shade.org.eclipse.jgit.lib.FileModeCache;
import com.appland.shade.org.eclipse.jgit.lib.ObjectLoader;
import com.appland.shade.org.eclipse.jgit.lib.ObjectReader;
import com.appland.shade.org.eclipse.jgit.lib.Repository;
import com.appland.shade.org.eclipse.jgit.treewalk.WorkingTreeOptions;
import com.appland.shade.org.eclipse.jgit.util.FS;
import com.appland.shade.org.eclipse.jgit.util.FileUtils;
import com.appland.shade.org.eclipse.jgit.util.RawParseUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;

public class Checkout {
    private final FileModeCache cache;
    private final WorkingTreeOptions options;
    private boolean recursiveDelete;

    public Checkout(@NonNull Repository repo) {
        this(repo, null);
    }

    public Checkout(@NonNull Repository repo, WorkingTreeOptions options) {
        this.cache = new FileModeCache(repo);
        this.options = options != null ? options : repo.getConfig().get(WorkingTreeOptions.KEY);
    }

    public WorkingTreeOptions getWorkingTreeOptions() {
        return this.options;
    }

    public Checkout setRecursiveDeletion(boolean recursive) {
        this.recursiveDelete = recursive;
        return this;
    }

    public void safeCreateParentDirectory(String gitPath, File parentDir, boolean makeSpace) throws IOException {
        this.cache.safeCreateParentDirectory(gitPath, parentDir, makeSpace);
    }

    public void checkoutGitlink(DirCacheEntry entry, String gitPath) throws IOException {
        FS fs = this.cache.getRepository().getFS();
        File workingTree = this.cache.getRepository().getWorkTree();
        String path = gitPath != null ? gitPath : entry.getPathString();
        File gitlinkDir = new File(workingTree, path);
        File parentDir = gitlinkDir.getParentFile();
        FileModeCache.CacheItem cachedParent = this.cache.safeCreateDirectory(path, parentDir, false);
        FileUtils.mkdirs(gitlinkDir, true);
        cachedParent.insert(path.substring(path.lastIndexOf(47) + 1), FileMode.GITLINK);
        entry.setLastModified(fs.lastModifiedInstant(gitlinkDir));
    }

    public void checkout(DirCacheEntry entry, DirCacheCheckout.CheckoutMetadata metadata, ObjectReader reader, String gitPath) throws IOException {
        if (metadata == null) {
            metadata = DirCacheCheckout.CheckoutMetadata.EMPTY;
        }
        FS fs = this.cache.getRepository().getFS();
        ObjectLoader ol = reader.open(entry.getObjectId());
        String path = gitPath != null ? gitPath : entry.getPathString();
        File f = new File(this.cache.getRepository().getWorkTree(), path);
        File parentDir = f.getParentFile();
        FileModeCache.CacheItem cachedParent = this.cache.safeCreateDirectory(path, parentDir, true);
        if (entry.getFileMode() == FileMode.SYMLINK && this.options.getSymLinks() == CoreConfig.SymLinks.TRUE) {
            byte[] bytes = ol.getBytes();
            String target = RawParseUtils.decode(bytes);
            if (this.recursiveDelete && Files.isDirectory(f.toPath(), LinkOption.NOFOLLOW_LINKS)) {
                FileUtils.delete(f, 1);
            }
            fs.createSymLink(f, target);
            cachedParent.insert(f.getName(), FileMode.SYMLINK);
            entry.setLength(bytes.length);
            entry.setLastModified(fs.lastModifiedInstant(f));
            return;
        }
        String name = f.getName();
        if (name.length() > 200) {
            name = name.substring(0, 200);
        }
        File tmpFile = File.createTempFile("._" + name, null, parentDir);
        DirCacheCheckout.getContent(this.cache.getRepository(), path, metadata, ol, this.options, new FileOutputStream(tmpFile));
        if (metadata.eolStreamType == CoreConfig.EolStreamType.DIRECT && metadata.smudgeFilterCommand == null) {
            entry.setLength(ol.getSize());
        } else {
            entry.setLength(tmpFile.length());
        }
        if (this.options.isFileMode() && fs.supportsExecute()) {
            if (FileMode.EXECUTABLE_FILE.equals(entry.getRawMode())) {
                if (!fs.canExecute(tmpFile)) {
                    fs.setExecute(tmpFile, true);
                }
            } else if (fs.canExecute(tmpFile)) {
                fs.setExecute(tmpFile, false);
            }
        }
        try {
            try {
                if (this.recursiveDelete && Files.isDirectory(f.toPath(), LinkOption.NOFOLLOW_LINKS)) {
                    FileUtils.delete(f, 1);
                }
                FileUtils.rename(tmpFile, f, StandardCopyOption.ATOMIC_MOVE);
                cachedParent.remove(f.getName());
            }
            catch (IOException e) {
                throw new IOException(MessageFormat.format(JGitText.get().renameFileFailed, tmpFile.getPath(), f.getPath()), e);
            }
        }
        finally {
            if (tmpFile.exists()) {
                FileUtils.delete(tmpFile);
            }
        }
        entry.setLastModified(fs.lastModifiedInstant(f));
    }
}

