/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.tinylog.runtime;

import com.appland.shade.org.tinylog.Level;
import com.appland.shade.org.tinylog.provider.InternalLogger;
import com.appland.shade.org.tinylog.runtime.AbstractJavaRuntime;
import com.appland.shade.org.tinylog.runtime.PreciseTimestamp;
import com.appland.shade.org.tinylog.runtime.PreciseTimestampFormatter;
import com.appland.shade.org.tinylog.runtime.Timestamp;
import com.appland.shade.org.tinylog.runtime.TimestampFormatter;
import java.lang.management.ManagementFactory;
import java.util.Iterator;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Stream;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

@IgnoreJRERequirement
final class ModernJavaRuntime
extends AbstractJavaRuntime {
    private static final ClassContextSecurityManager securityManager = new ClassContextSecurityManager();
    private static final Timestamp startTime = new PreciseTimestamp(ManagementFactory.getRuntimeMXBean().getStartTime(), 0L);
    private final ProcessHandle currentProcess = ModernJavaRuntime.getCurrentProcess();

    ModernJavaRuntime() {
    }

    @Override
    public boolean isAndroid() {
        return false;
    }

    @Override
    public long getProcessId() {
        return this.currentProcess.pid();
    }

    @Override
    public Timestamp getStartTime() {
        return startTime;
    }

    @Override
    public String getCallerClassName(int depth) {
        Class<?>[] classes = securityManager.getClassContext();
        return classes.length > depth + 1 ? classes[depth + 1].getName() : null;
    }

    @Override
    public String getCallerClassName(String loggerClassName) {
        Class<?>[] classes = securityManager.getClassContext();
        int index = 0;
        while (index < classes.length && !loggerClassName.equals(classes[index++].getName())) {
        }
        while (index < classes.length) {
            String className;
            if (loggerClassName.equals(className = classes[index++].getName())) continue;
            return className;
        }
        return null;
    }

    @Override
    public StackTraceElement getCallerStackTraceElement(int depth) {
        StackWalker.StackFrame frame = StackWalker.getInstance().walk(new FixedStackFrameExtractor(depth));
        return frame == null ? null : frame.toStackTraceElement();
    }

    @Override
    public StackTraceElement getCallerStackTraceElement(String loggerClassName) {
        StackWalker.StackFrame frame = StackWalker.getInstance().walk(new DynamicStackFrameExtractor(loggerClassName));
        return frame == null ? null : frame.toStackTraceElement();
    }

    @Override
    public Timestamp createTimestamp() {
        return new PreciseTimestamp();
    }

    @Override
    public TimestampFormatter createTimestampFormatter(String pattern, Locale locale) {
        return new PreciseTimestampFormatter(pattern, locale);
    }

    private static ProcessHandle getCurrentProcess() {
        try {
            return (ProcessHandle)ProcessHandle.class.getDeclaredMethod("current", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            InternalLogger.log(Level.ERROR, ex, "Failed to receive the handle of the current process");
            return null;
        }
    }

    @IgnoreJRERequirement
    private static final class DynamicStackFrameExtractor
    implements Function<Stream<StackWalker.StackFrame>, StackWalker.StackFrame> {
        private final String loggerClassName;

        private DynamicStackFrameExtractor(String loggerClassName) {
            this.loggerClassName = loggerClassName;
        }

        @Override
        public StackWalker.StackFrame apply(Stream<StackWalker.StackFrame> stream) {
            Iterator iterator = stream.iterator();
            while (iterator.hasNext() && !this.loggerClassName.equals(((StackWalker.StackFrame)iterator.next()).getClassName())) {
            }
            while (iterator.hasNext()) {
                StackWalker.StackFrame frame = (StackWalker.StackFrame)iterator.next();
                if (this.loggerClassName.equals(frame.getClassName())) continue;
                return frame;
            }
            return null;
        }
    }

    @IgnoreJRERequirement
    private static final class FixedStackFrameExtractor
    implements Function<Stream<StackWalker.StackFrame>, StackWalker.StackFrame> {
        private final int index;

        private FixedStackFrameExtractor(int index) {
            this.index = index;
        }

        @Override
        public StackWalker.StackFrame apply(Stream<StackWalker.StackFrame> stream) {
            return stream.skip(this.index).findFirst().orElse(null);
        }
    }

    private static final class ClassContextSecurityManager
    extends SecurityManager {
        private ClassContextSecurityManager() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

