/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.cli;

import com.appland.appmap.cli.CLI;
import com.appland.shade.com.alibaba.fastjson.JSON;
import com.appland.shade.com.alibaba.fastjson.annotation.JSONField;
import com.appland.shade.com.alibaba.fastjson.serializer.SerializerFeature;
import com.appland.shade.picocli.CommandLine;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Consumer;

@CommandLine.Command(name="init", description={"Suggests AppMap configuration settings for a new project."})
public class Init
implements Callable<Integer> {
    @CommandLine.ParentCommand
    private CLI parent;

    @Override
    public Integer call() throws Exception {
        System.err.printf("Init AppMap project configuration in directory: %s\n", this.parent.directory);
        StringWriter sw = new StringWriter();
        final PrintWriter pw = new PrintWriter(sw);
        pw.println("# This is the AppMap configuration file.");
        pw.println("# For full documentation of this file for Java programs, see:");
        pw.println("# https://appland.com/docs/reference/appmap-java.html#configuration");
        pw.format("name: %s\n", CLI.projectName(new File(this.parent.directory)));
        final File javaDir = Paths.get(this.parent.directory, new String[0]).resolve("src/main/java").toFile();
        if (javaDir.isDirectory()) {
            final HashSet packages = new HashSet();
            Files.walkFileTree(javaDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    Path packagePath;
                    if (file.getFileName().toString().endsWith(".java") && (packagePath = file.getParent().subpath(javaDir.toPath().getNameCount(), file.getParent().getNameCount())).getNameCount() > 0) {
                        packages.add(packagePath);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            pw.println("# Your project contains the directory src/main/java.");
            pw.println("# AppMap has auto-detected the following Java packages in this directory:");
            pw.println("packages:");
            List topLevelPackages = packages.stream().sorted().collect(ArrayList::new, (memo, packagePath) -> {
                for (int i = 1; i < packagePath.getNameCount(); ++i) {
                    Path ancestorPath = packagePath.subpath(0, i);
                    if (!memo.contains(ancestorPath)) continue;
                    return;
                }
                memo.add(packagePath);
            }, ArrayList::addAll);
            topLevelPackages.forEach(new Consumer<Path>(){

                @Override
                public void accept(Path packagePath) {
                    ArrayList<String> tokens = new ArrayList<String>();
                    for (int i = 0; i < packagePath.getNameCount(); ++i) {
                        tokens.add(packagePath.getName(i).toString());
                    }
                    String path = String.join((CharSequence)".", tokens);
                    pw.format("- path: %s\n", path);
                }
            });
        } else {
            pw.println("packages: []");
            pw.println("# appmap-java init looks for source packages in src/main/java.");
            pw.println("# This folder was not found in your project, so no packages were auto-detected.");
            pw.println("# You can add your source packages by replacing the line above with lines like this:");
            pw.println("# packages:");
            pw.println("# - path: com.mycorp.pkg");
            pw.println("# - path: org.otherstuff.pkg");
        }
        Configuration configuration = new Configuration();
        configuration.filename = "appmap.yml";
        configuration.contents = sw.toString();
        Result result = new Result();
        result.configuration = configuration;
        this.parent.getOutputStream().println(JSON.toJSONString((Object)result, SerializerFeature.PrettyFormat));
        return 0;
    }

    static class Result {
        @JSONField
        public Configuration configuration;

        Result() {
        }
    }

    static class Configuration {
        @JSONField
        public String filename;
        @JSONField
        public String contents;

        Configuration() {
        }
    }
}

