/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.config.Properties;
import com.appland.appmap.record.Recorder;
import com.appland.appmap.record.Recording;
import com.appland.appmap.transform.ClassFileTransformer;
import com.appland.appmap.util.Logger;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Agent {
    public static void premain(String agentArgs, Instrumentation inst) {
        File dir = Properties.getOutputDirectory();
        Logger.printf("agent loaded using config %s\n", Properties.ConfigFile);
        inst.addTransformer(new ClassFileTransformer());
        if (AppMapConfig.load(new File(Properties.ConfigFile)) == null) {
            Logger.printf("failed to load config %s\n", Properties.ConfigFile);
            return;
        }
        if (Properties.RecordingAuto.booleanValue()) {
            String appmapName = Properties.RecordingName;
            Date date = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmmss");
            String timestamp = dateFormat.format(date);
            Recorder.Metadata metadata = new Recorder.Metadata();
            Recorder recorder = Recorder.getInstance();
            if (appmapName == null || appmapName.trim().isEmpty()) {
                appmapName = timestamp;
            }
            metadata.recorderName = "remote_recording";
            metadata.scenarioName = appmapName;
            recorder.start(metadata);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                String fileName = Properties.RecordingFile;
                if (fileName == null || fileName.trim().isEmpty()) {
                    fileName = String.format("%s.appmap.json", timestamp);
                }
                Recording recording = recorder.stop();
                recording.moveTo(String.join((CharSequence)File.pathSeparator, dir.getPath(), fileName));
            }));
        }
    }
}

