/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.record;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.config.Properties;
import com.appland.appmap.output.v1.CodeObject;
import com.appland.appmap.output.v1.Event;
import com.appland.appmap.record.ActiveSessionException;
import com.appland.appmap.record.CodeObjectTree;
import com.appland.appmap.record.Recording;
import com.appland.appmap.record.RecordingSession;
import com.appland.appmap.util.Logger;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class Recorder {
    private static final String ERROR_SESSION_PRESENT = "an active recording session already exists";
    private static final String ERROR_NO_SESSION = "there is no active recording session";
    private static final Recorder instance = new Recorder();
    private final ActiveSession activeSession = new ActiveSession();
    private final CodeObjectTree globalCodeObjects = new CodeObjectTree();
    private final Map<Long, ThreadState> threadState = new HashMap<Long, ThreadState>();

    public static Recorder getInstance() {
        return instance;
    }

    private Recorder() {
    }

    public void start(Metadata metadata) throws ActiveSessionException {
        RecordingSession session = new RecordingSession(metadata);
        this.activeSession.set(session);
    }

    public boolean hasActiveSession() {
        return this.activeSession.exists();
    }

    public Metadata getMetadata() throws ActiveSessionException {
        return this.activeSession.get().getMetadata();
    }

    public Recording checkpoint() {
        this.flush();
        return this.activeSession.get().checkpoint();
    }

    public Recording stop() throws ActiveSessionException {
        this.flush();
        return this.activeSession.release().stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Event event) {
        if (!this.activeSession.exists()) {
            return;
        }
        ThreadState ts = this.threadState();
        if (ts.isProcessing) {
            return;
        }
        ts.isProcessing = true;
        try {
            if (event.event.equals("call")) {
                Event parent;
                if (!ts.callStack.empty() && event.hasPackageName() && AppMapConfig.get().isShallow(event.definedClass) && (parent = ts.callStack.peek()).hasPackageName() && event.packageName().equals(parent.packageName())) {
                    event.ignore();
                }
                ts.callStack.push(event);
            } else if (event.event.equals("return")) {
                if (ts.callStack.isEmpty()) {
                    Logger.println("Discarding 'return' event because the call stack is empty for this thread");
                    return;
                }
                Event caller = ts.callStack.pop();
                event.parentId = caller.id;
                event.threadId = caller.threadId;
                event.definedClass = null;
                event.methodId = null;
                event.isStatic = null;
                if (caller.ignored()) {
                    event.ignore();
                }
            } else {
                throw new IllegalArgumentException("Event should be 'call' or 'return', got " + event.event);
            }
            Event previousEvent = ts.lastEvent;
            ts.lastEvent = event;
            if (previousEvent != null && !previousEvent.ignored()) {
                previousEvent.freeze();
                this.activeSession.addEvent(previousEvent);
            }
        }
        finally {
            ts.isProcessing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCodeObject(CodeObject codeObject) {
        CodeObjectTree codeObjectTree = this.globalCodeObjects;
        synchronized (codeObjectTree) {
            this.globalCodeObjects.add(codeObject);
        }
    }

    public CodeObjectTree getRegisteredObjects() {
        return this.globalCodeObjects;
    }

    public Event getLastEvent() {
        return this.threadState().lastEvent;
    }

    public Recording record(Runnable fn) throws ActiveSessionException {
        this.start(new Metadata());
        fn.run();
        return this.stop();
    }

    public void record(String name, Runnable fn) throws ActiveSessionException, IOException {
        String fileName = name.replaceAll("[^a-zA-Z0-9-_]", "_");
        Metadata metadata = new Metadata();
        metadata.scenarioName = name;
        this.start(metadata);
        fn.run();
        Recording recording = this.stop();
        recording.moveTo(String.join((CharSequence)File.separator, Properties.getOutputDirectory().getPath(), fileName + ".appmap.json"));
    }

    ThreadState threadState() {
        ThreadState ts = this.threadState.get(Thread.currentThread().getId());
        if (ts == null) {
            ts = new ThreadState();
            this.threadState.put(Thread.currentThread().getId(), ts);
        }
        return ts;
    }

    void flush() {
        this.threadState.values().forEach(ts -> {
            if (ts.lastEvent == null) {
                return;
            }
            ts.isProcessing = true;
            try {
                Event event = ts.lastEvent;
                ts.lastEvent = null;
                event.freeze();
                this.activeSession.addEvent(event);
            }
            finally {
                ts.isProcessing = false;
            }
        });
    }

    static class ActiveSession {
        private RecordingSession activeSession = null;

        ActiveSession() {
        }

        synchronized RecordingSession get() throws ActiveSessionException {
            if (this.activeSession == null) {
                throw new ActiveSessionException(Recorder.ERROR_NO_SESSION);
            }
            return this.activeSession;
        }

        boolean exists() {
            return this.activeSession != null;
        }

        synchronized RecordingSession release() throws ActiveSessionException {
            if (this.activeSession == null) {
                throw new ActiveSessionException(Recorder.ERROR_NO_SESSION);
            }
            RecordingSession result = this.activeSession;
            this.activeSession = null;
            return result;
        }

        synchronized void set(RecordingSession session) throws ActiveSessionException {
            if (this.activeSession != null) {
                throw new ActiveSessionException(Recorder.ERROR_SESSION_PRESENT);
            }
            this.activeSession = session;
        }

        synchronized void addEvent(Event event) {
            if (this.activeSession != null) {
                this.activeSession.add(event);
            }
        }
    }

    static class ThreadState {
        Event lastEvent;
        boolean isProcessing;
        Stack<Event> callStack = new Stack();

        ThreadState() {
        }
    }

    public static class Metadata {
        public String scenarioName;
        public String recorderName;
        public String framework;
        public String frameworkVersion;
        public String recordedClassName;
        public String recordedMethodName;
        public String sourceLocation;
        public Boolean testSucceeded;
        public Throwable exception;
    }
}

