/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.cli;

import com.appland.appmap.cli.CLI;
import com.appland.shade.com.alibaba.fastjson.JSON;
import com.appland.shade.com.alibaba.fastjson.serializer.SerializerFeature;
import com.appland.shade.org.apache.commons.lang3.JavaVersion;
import com.appland.shade.org.apache.commons.lang3.SystemUtils;
import com.appland.shade.picocli.CommandLine;
import java.util.ArrayList;
import java.util.concurrent.Callable;

@CommandLine.Command(name="validate", description={"Validates that a Java project is ready to create AppMaps."})
public class Validate
implements Callable<Integer> {
    @CommandLine.ParentCommand
    private CLI parent;

    private Error checkVersion() {
        Error ret = null;
        if (!SystemUtils.isJavaVersionAtLeast(JavaVersion.JAVA_1_8)) {
            ret = new Error("Unsupported Java Version " + SystemUtils.JAVA_VERSION);
        }
        return ret;
    }

    @Override
    public Integer call() {
        System.err.printf("Validating AppMap project in directory: %s\n", this.parent.directory);
        ArrayList<Error> result = new ArrayList<Error>();
        Error nextError = this.checkVersion();
        if (nextError != null) {
            result.add(nextError);
        }
        this.parent.getOutputStream().println(JSON.toJSONString(result, SerializerFeature.PrettyFormat));
        return result.size() == 0 ? 0 : 1;
    }

    static class Error {
        public final String level = "error";
        public String message;
        public String detailed_message;

        Error(String message) {
            this.message = message;
        }
    }
}

