/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.maven;

import com.appland.appmap.maven.AppMapAgentMojo;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="prepare-agent", defaultPhase=LifecyclePhase.TEST_COMPILE)
public class LoadJavaAppMapAgentMojo
extends AppMapAgentMojo {
    static final String SUREFIRE_ARG_LINE = "argLine";
    static final String DEFAULT_CONFIG_FILE = "appmap.yml";
    static final List<String> DEBUG_FLAGS = Arrays.asList("debug", "hooks", "locals", "http");
    @Parameter(property="skip")
    protected boolean skip = false;
    @Parameter(property="project.outputDirectory")
    protected File outputDirectory = new File("tmp/appmap");
    @Parameter(property="project.configFile")
    protected String configFile = "appmap.yml";
    @Parameter(property="project.debug")
    protected String debug = "info";
    @Parameter(property="project.debugFile")
    protected File debugFile = new File(this.outputDirectory, "agent.log");
    @Parameter(property="project.eventValueSize")
    protected Integer eventValueSize = 1024;

    @Override
    public void execute() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping AppLand AppMap execution because property 'skip' is set.");
            return;
        }
        this.getLog().info((CharSequence)"Initializing AppLand AppMap Java Recorder.");
        this.loadAppMapJavaAgent();
    }

    protected void loadAppMapJavaAgent() {
        String newValue = this.buildArguments();
        this.setProjectArgLineProperty(newValue);
        this.getLog().info((CharSequence)("argLine set to " + StringEscapeUtils.unescapeJava((String)newValue)));
    }

    private String buildArguments() {
        ArrayList<String> args = new ArrayList<String>();
        String oldConfig = this.getCurrentArgLinePropertyValue();
        if (oldConfig != null) {
            ArrayList<String> oldArgs = new ArrayList<String>(Arrays.asList(oldConfig.split(" ")));
            this.removeOldAppMapAgentFromCommandLine(oldArgs);
            args.addAll(oldArgs);
        }
        this.addMvnAppMapCommandLineArgsFirst(args);
        StringBuilder builder = new StringBuilder();
        for (String arg : args) {
            builder.append(arg).append(" ");
        }
        return builder.toString();
    }

    private String javaAgentArgLine() {
        return String.format("\"-javaagent:%s\"", StringEscapeUtils.escapeJava((String)this.getAppMapAgentJarPath()));
    }

    private void removeOldAppMapAgentFromCommandLine(List<String> oldArgs) {
        String plainAgent = this.javaAgentArgLine();
        oldArgs.removeIf(oldCommand -> oldCommand.startsWith(plainAgent));
    }

    private void addMvnAppMapCommandLineArgsFirst(List<String> args) {
        args.add(this.javaAgentArgLine());
        if (this.debug != null && !this.debug.isEmpty()) {
            ArrayList<String> debugTokens = new ArrayList<String>(Arrays.asList(this.debug.split("[,|\\s]")));
            boolean hasDebug = false;
            for (String token : debugTokens) {
                if (!DEBUG_FLAGS.contains(token)) continue;
                hasDebug = true;
                if (token.equals("debug")) {
                    args.add("-Dappmap.debug");
                    continue;
                }
                args.add("-Dappmap.debug." + token);
            }
            if (hasDebug) {
                args.add(0, "-Dappmap.debug.file=" + StringEscapeUtils.escapeJava((String)String.format("%s", this.debugFile)));
            }
        }
        args.add(0, "-Dappmap.output.directory=" + StringEscapeUtils.escapeJava((String)String.format("%s", this.outputDirectory)));
        if (!this.configFile.equals(DEFAULT_CONFIG_FILE)) {
            args.add(0, "-Dappmap.config.file=" + StringEscapeUtils.escapeJava((String)String.format("%s", this.configFile)));
        }
        args.add(0, "-Dappmap.event.valueSize=" + this.eventValueSize);
    }

    private void setProjectArgLineProperty(String newValue) {
        this.project.getProperties().setProperty(SUREFIRE_ARG_LINE, newValue);
    }

    private String getCurrentArgLinePropertyValue() {
        return this.project.getProperties().getProperty(SUREFIRE_ARG_LINE);
    }
}

