/*
 * Decompiled with CFR 0.152.
 */
package com.applandeo.materialcalendarview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.LayoutRes;
import com.applandeo.materialcalendarview.CalendarDay;
import com.applandeo.materialcalendarview.CalendarWeekDay;
import com.applandeo.materialcalendarview.EventDay;
import com.applandeo.materialcalendarview.R;
import com.applandeo.materialcalendarview.adapters.CalendarPageAdapter;
import com.applandeo.materialcalendarview.exceptions.OutOfDateRangeException;
import com.applandeo.materialcalendarview.extensions.CalendarViewPager;
import com.applandeo.materialcalendarview.listeners.OnCalendarPageChangeListener;
import com.applandeo.materialcalendarview.listeners.OnDayClickListener;
import com.applandeo.materialcalendarview.listeners.OnDayLongClickListener;
import com.applandeo.materialcalendarview.utils.AppearanceUtilsKt;
import com.applandeo.materialcalendarview.utils.CalendarProperties;
import com.applandeo.materialcalendarview.utils.DateUtils;
import com.applandeo.materialcalendarview.utils.SelectedDay;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 g2\u00020\u0001:\u0001gB-\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0007H\u0002J\u0006\u0010#\u001a\u00020!J\b\u0010$\u001a\u00020!H\u0002J\b\u0010%\u001a\u00020!H\u0002J\u0010\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020(H\u0002J\u001e\u0010)\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\t2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020!0+H\u0002J\b\u0010,\u001a\u00020!H\u0002J\u0018\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u0007H\u0002J\u0010\u00100\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0007H\u0002J\u000e\u00101\u001a\u00020!2\u0006\u00102\u001a\u00020\u0007J\u0012\u00103\u001a\u00020!2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u00104\u001a\u00020!2\b\b\u0001\u00105\u001a\u00020\u0007J\u0014\u00106\u001a\u00020!2\f\u00107\u001a\b\u0012\u0004\u0012\u0002080\u001bJ\b\u00109\u001a\u00020!H\u0002J\u000e\u0010:\u001a\u00020!2\u0006\u0010;\u001a\u00020\u0011J\u000e\u0010:\u001a\u00020!2\u0006\u0010<\u001a\u00020=J\u0014\u0010>\u001a\u00020!2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00110\u001bJ\u0014\u0010@\u001a\u00020!2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020B0\u001bJ\u000e\u0010C\u001a\u00020!2\u0006\u0010D\u001a\u00020EJ\u000e\u0010F\u001a\u00020!2\u0006\u0010G\u001a\u00020HJ\u0010\u0010I\u001a\u00020!2\b\b\u0001\u0010J\u001a\u00020\u0007J\u0010\u0010K\u001a\u00020!2\b\b\u0001\u0010J\u001a\u00020\u0007J\u0018\u0010L\u001a\u00020!2\u0006\u0010/\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u0007H\u0002J\u000e\u0010M\u001a\u00020!2\u0006\u00102\u001a\u00020\u0007J\u0016\u0010N\u001a\u00020!2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00110\u001bH\u0007J\u000e\u0010P\u001a\u00020!2\u0006\u0010/\u001a\u00020\u0011J\u000e\u0010Q\u001a\u00020!2\u0006\u0010/\u001a\u00020\u0011J\u000e\u0010R\u001a\u00020!2\u0006\u0010S\u001a\u00020TJ\u000e\u0010U\u001a\u00020!2\u0006\u0010V\u001a\u00020WJ\u000e\u0010X\u001a\u00020!2\u0006\u0010Y\u001a\u00020ZJ$\u0010[\u001a\u00020!2\u001c\u0010Y\u001a\u0018\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u0002080\u001b0\\j\u0002`]J\u000e\u0010^\u001a\u00020!2\u0006\u0010Y\u001a\u00020ZJ\u000e\u0010_\u001a\u00020!2\u0006\u0010G\u001a\u00020HJ\u0010\u0010`\u001a\u00020!2\b\b\u0001\u0010G\u001a\u00020\u0007J\u000e\u0010a\u001a\u00020!2\u0006\u0010b\u001a\u00020.J\u000e\u0010c\u001a\u00020!2\u0006\u0010d\u001a\u00020.J\u0010\u0010e\u001a\u00020!2\u0006\u0010/\u001a\u00020\u0011H\u0002J\u0006\u0010f\u001a\u00020!R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u001a\u0010\u0016\u001a\u00020\u00118FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u0013R0\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u001b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u001b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006h"}, d2={"Lcom/applandeo/materialcalendarview/CalendarView;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "properties", "Lcom/applandeo/materialcalendarview/utils/CalendarProperties;", "(Landroid/content/Context;Landroid/util/AttributeSet;ILcom/applandeo/materialcalendarview/utils/CalendarProperties;)V", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "calendarPageAdapter", "Lcom/applandeo/materialcalendarview/adapters/CalendarPageAdapter;", "calendarProperties", "currentPage", "currentPageDate", "Ljava/util/Calendar;", "getCurrentPageDate", "()Ljava/util/Calendar;", "firstSelectedDate", "getFirstSelectedDate", "selectedDate", "getSelectedDate$annotations", "()V", "getSelectedDate", "selectedDates", "", "getSelectedDates", "()Ljava/util/List;", "setSelectedDates", "(Ljava/util/List;)V", "callOnPageChangeListeners", "", "position", "clearSelectedDays", "initAttributes", "initCalendar", "initCalendarProperties", "typedArray", "Landroid/content/res/TypedArray;", "initControl", "onUiCreate", "Lkotlin/Function0;", "initUiElements", "isScrollingLimited", "", "calendar", "renderHeader", "setAbbreviationsBarVisibility", "visibility", "setAttributes", "setCalendarDayLayout", "layout", "setCalendarDays", "calendarDayProperties", "Lcom/applandeo/materialcalendarview/CalendarDay;", "setCalendarRowLayout", "setDate", "date", "currentDate", "Ljava/util/Date;", "setDisabledDays", "disabledDays", "setEvents", "eventDays", "Lcom/applandeo/materialcalendarview/EventDay;", "setFirstDayOfWeek", "weekDay", "Lcom/applandeo/materialcalendarview/CalendarWeekDay;", "setForwardButtonImage", "drawable", "Landroid/graphics/drawable/Drawable;", "setHeaderColor", "color", "setHeaderLabelColor", "setHeaderName", "setHeaderVisibility", "setHighlightedDays", "highlightedDays", "setMaximumDate", "setMinimumDate", "setOnDayClickListener", "onDayClickListener", "Lcom/applandeo/materialcalendarview/listeners/OnDayClickListener;", "setOnDayLongClickListener", "onDayLongClickListener", "Lcom/applandeo/materialcalendarview/listeners/OnDayLongClickListener;", "setOnForwardPageChangeListener", "listener", "Lcom/applandeo/materialcalendarview/listeners/OnCalendarPageChangeListener;", "setOnPagePrepareListener", "Lkotlin/Function1;", "Lcom/applandeo/materialcalendarview/utils/OnPagePrepareListener;", "setOnPreviousPageChangeListener", "setPreviousButtonImage", "setSelectionBackground", "setSelectionBetweenMonthsEnabled", "enabled", "setSwipeEnabled", "swipeEnabled", "setUpCalendarPosition", "showCurrentMonthPage", "Companion", "library_release"})
public final class CalendarView
extends LinearLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public Map<Integer, View> _$_findViewCache;
    private CalendarPageAdapter calendarPageAdapter;
    private CalendarProperties calendarProperties;
    private int currentPage;
    public static final int CLASSIC = 0;
    public static final int ONE_DAY_PICKER = 1;
    public static final int MANY_DAYS_PICKER = 2;
    public static final int RANGE_PICKER = 3;

    @JvmOverloads
    public CalendarView(@NotNull Context context, final @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this._$_findViewCache = new LinkedHashMap();
        this.initControl(new CalendarProperties(context), (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.setAttributes(attrs);
            }
        }));
    }

    public /* synthetic */ CalendarView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public CalendarView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, @NotNull CalendarProperties properties) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this(context, attrs, defStyleAttr);
        this.initControl(properties, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((CalendarView)((Object)this.receiver)).initAttributes();
            }
        }));
    }

    public /* synthetic */ CalendarView(Context context, AttributeSet attributeSet, int n, CalendarProperties calendarProperties, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n, calendarProperties);
    }

    private final void initControl(CalendarProperties calendarProperties, Function0<Unit> onUiCreate) {
        this.calendarProperties = calendarProperties;
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.calendar_view, (ViewGroup)this);
        this.initUiElements();
        onUiCreate.invoke();
        this.initCalendar();
    }

    private final void setAttributes(AttributeSet attrs) {
        TypedArray $this$setAttributes_u24lambda_u2d0 = this.getContext().obtainStyledAttributes(attrs, R.styleable.CalendarView);
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$setAttributes_u24lambda_u2d0, (String)"this");
        this.initCalendarProperties($this$setAttributes_u24lambda_u2d0);
        this.initAttributes();
        $this$setAttributes_u24lambda_u2d0.recycle();
    }

    private final void initCalendarProperties(TypedArray typedArray) {
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        CalendarProperties $this$initCalendarProperties_u24lambda_u2d1 = calendarProperties;
        boolean bl = false;
        $this$initCalendarProperties_u24lambda_u2d1.setHeaderColor(typedArray.getColor(R.styleable.CalendarView_headerColor, 0));
        $this$initCalendarProperties_u24lambda_u2d1.setHeaderLabelColor(typedArray.getColor(R.styleable.CalendarView_headerLabelColor, 0));
        $this$initCalendarProperties_u24lambda_u2d1.setAbbreviationsBarColor(typedArray.getColor(R.styleable.CalendarView_abbreviationsBarColor, 0));
        $this$initCalendarProperties_u24lambda_u2d1.setAbbreviationsLabelsColor(typedArray.getColor(R.styleable.CalendarView_abbreviationsLabelsColor, 0));
        $this$initCalendarProperties_u24lambda_u2d1.setAbbreviationsLabelsSize(typedArray.getDimension(R.styleable.CalendarView_abbreviationsLabelsSize, 0.0f));
        $this$initCalendarProperties_u24lambda_u2d1.setPagesColor(typedArray.getColor(R.styleable.CalendarView_pagesColor, 0));
        $this$initCalendarProperties_u24lambda_u2d1.setDaysLabelsColor(typedArray.getColor(R.styleable.CalendarView_daysLabelsColor, 0));
        $this$initCalendarProperties_u24lambda_u2d1.setAnotherMonthsDaysLabelsColor(typedArray.getColor(R.styleable.CalendarView_anotherMonthsDaysLabelsColor, 0));
        $this$initCalendarProperties_u24lambda_u2d1.setTodayLabelColor(typedArray.getColor(R.styleable.CalendarView_todayLabelColor, 0));
        $this$initCalendarProperties_u24lambda_u2d1.setSelectionColor(typedArray.getColor(R.styleable.CalendarView_selectionColor, 0));
        $this$initCalendarProperties_u24lambda_u2d1.setSelectionLabelColor(typedArray.getColor(R.styleable.CalendarView_selectionLabelColor, 0));
        $this$initCalendarProperties_u24lambda_u2d1.setDisabledDaysLabelsColor(typedArray.getColor(R.styleable.CalendarView_disabledDaysLabelsColor, 0));
        $this$initCalendarProperties_u24lambda_u2d1.setHighlightedDaysLabelsColor(typedArray.getColor(R.styleable.CalendarView_highlightedDaysLabelsColor, 0));
        $this$initCalendarProperties_u24lambda_u2d1.setCalendarType(typedArray.getInt(R.styleable.CalendarView_type, 0));
        $this$initCalendarProperties_u24lambda_u2d1.setMaximumDaysRange(typedArray.getInt(R.styleable.CalendarView_maximumDaysRange, 0));
        if (typedArray.hasValue(R.styleable.CalendarView_firstDayOfWeek)) {
            $this$initCalendarProperties_u24lambda_u2d1.setFirstDayOfWeek(typedArray.getInt(R.styleable.CalendarView_firstDayOfWeek, 2));
        }
        $this$initCalendarProperties_u24lambda_u2d1.setEventsEnabled(typedArray.getBoolean(R.styleable.CalendarView_eventsEnabled, $this$initCalendarProperties_u24lambda_u2d1.getCalendarType() == 0));
        $this$initCalendarProperties_u24lambda_u2d1.setSwipeEnabled(typedArray.getBoolean(R.styleable.CalendarView_swipeEnabled, true));
        $this$initCalendarProperties_u24lambda_u2d1.setSelectionDisabled(typedArray.getBoolean(R.styleable.CalendarView_selectionDisabled, false));
        $this$initCalendarProperties_u24lambda_u2d1.setSelectionBetweenMonthsEnabled(typedArray.getBoolean(R.styleable.CalendarView_selectionBetweenMonthsEnabled, false));
        $this$initCalendarProperties_u24lambda_u2d1.setPreviousButtonSrc(typedArray.getDrawable(R.styleable.CalendarView_previousButtonSrc));
        $this$initCalendarProperties_u24lambda_u2d1.setForwardButtonSrc(typedArray.getDrawable(R.styleable.CalendarView_forwardButtonSrc));
        if (Build.VERSION.SDK_INT >= 26) {
            $this$initCalendarProperties_u24lambda_u2d1.setTypeface(typedArray.getFont(R.styleable.CalendarView_typeface));
            $this$initCalendarProperties_u24lambda_u2d1.setTodayTypeface(typedArray.getFont(R.styleable.CalendarView_todayTypeface));
        }
    }

    private final void initAttributes() {
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        CalendarProperties $this$initAttributes_u24lambda_u2d2 = calendarProperties;
        boolean bl = false;
        View view = this.getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"rootView");
        AppearanceUtilsKt.setHeaderColor(view, $this$initAttributes_u24lambda_u2d2.getHeaderColor());
        view = this.getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"rootView");
        AppearanceUtilsKt.setHeaderTypeface(view, $this$initAttributes_u24lambda_u2d2.getTypeface());
        view = this.getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"rootView");
        AppearanceUtilsKt.setHeaderVisibility(view, $this$initAttributes_u24lambda_u2d2.getHeaderVisibility());
        view = this.getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"rootView");
        AppearanceUtilsKt.setAbbreviationsBarVisibility(view, $this$initAttributes_u24lambda_u2d2.getAbbreviationsBarVisibility());
        view = this.getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"rootView");
        AppearanceUtilsKt.setNavigationVisibility(view, $this$initAttributes_u24lambda_u2d2.getNavigationVisibility());
        view = this.getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"rootView");
        AppearanceUtilsKt.setHeaderLabelColor(view, $this$initAttributes_u24lambda_u2d2.getHeaderLabelColor());
        view = this.getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"rootView");
        AppearanceUtilsKt.setAbbreviationsBarColor(view, $this$initAttributes_u24lambda_u2d2.getAbbreviationsBarColor());
        view = this.getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"rootView");
        AppearanceUtilsKt.setAbbreviationsLabels(view, $this$initAttributes_u24lambda_u2d2.getAbbreviationsLabelsColor(), $this$initAttributes_u24lambda_u2d2.getFirstDayOfWeek());
        view = this.getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"rootView");
        AppearanceUtilsKt.setAbbreviationsLabelsSize(view, $this$initAttributes_u24lambda_u2d2.getAbbreviationsLabelsSize());
        view = this.getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"rootView");
        AppearanceUtilsKt.setPagesColor(view, $this$initAttributes_u24lambda_u2d2.getPagesColor());
        view = this.getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"rootView");
        AppearanceUtilsKt.setTypeface(view, $this$initAttributes_u24lambda_u2d2.getTypeface());
        view = this.getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"rootView");
        AppearanceUtilsKt.setPreviousButtonImage(view, $this$initAttributes_u24lambda_u2d2.getPreviousButtonSrc());
        view = this.getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"rootView");
        AppearanceUtilsKt.setForwardButtonImage(view, $this$initAttributes_u24lambda_u2d2.getForwardButtonSrc());
        ((CalendarViewPager)this._$_findCachedViewById(R.id.calendarViewPager)).setSwipeEnabled($this$initAttributes_u24lambda_u2d2.getSwipeEnabled());
        this.setCalendarRowLayout();
    }

    public final void setFirstDayOfWeek(@NotNull CalendarWeekDay weekDay) {
        Intrinsics.checkNotNullParameter((Object)((Object)weekDay), (String)"weekDay");
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        CalendarProperties $this$setFirstDayOfWeek_u24lambda_u2d3 = calendarProperties;
        boolean bl = false;
        $this$setFirstDayOfWeek_u24lambda_u2d3.setFirstDayOfWeek(weekDay.getValue());
        View view = this.getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"rootView");
        AppearanceUtilsKt.setAbbreviationsLabels(view, $this$setFirstDayOfWeek_u24lambda_u2d3.getAbbreviationsLabelsColor(), $this$setFirstDayOfWeek_u24lambda_u2d3.getFirstDayOfWeek());
    }

    public final void setHeaderColor(@ColorRes int color) {
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        CalendarProperties $this$setHeaderColor_u24lambda_u2d4 = calendarProperties;
        boolean bl = false;
        $this$setHeaderColor_u24lambda_u2d4.setHeaderColor(color);
        View view = this.getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"rootView");
        AppearanceUtilsKt.setHeaderColor(view, $this$setHeaderColor_u24lambda_u2d4.getHeaderColor());
    }

    public final void setHeaderVisibility(int visibility) {
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        CalendarProperties $this$setHeaderVisibility_u24lambda_u2d5 = calendarProperties;
        boolean bl = false;
        $this$setHeaderVisibility_u24lambda_u2d5.setHeaderVisibility(visibility);
        View view = this.getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"rootView");
        AppearanceUtilsKt.setHeaderVisibility(view, $this$setHeaderVisibility_u24lambda_u2d5.getHeaderVisibility());
    }

    public final void setAbbreviationsBarVisibility(int visibility) {
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        CalendarProperties $this$setAbbreviationsBarVisibility_u24lambda_u2d6 = calendarProperties;
        boolean bl = false;
        $this$setAbbreviationsBarVisibility_u24lambda_u2d6.setAbbreviationsBarVisibility(visibility);
        View view = this.getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"rootView");
        AppearanceUtilsKt.setAbbreviationsBarVisibility(view, $this$setAbbreviationsBarVisibility_u24lambda_u2d6.getAbbreviationsBarVisibility());
    }

    public final void setHeaderLabelColor(@ColorRes int color) {
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        CalendarProperties $this$setHeaderLabelColor_u24lambda_u2d7 = calendarProperties;
        boolean bl = false;
        $this$setHeaderLabelColor_u24lambda_u2d7.setHeaderLabelColor(color);
        View view = this.getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"rootView");
        AppearanceUtilsKt.setHeaderLabelColor(view, $this$setHeaderLabelColor_u24lambda_u2d7.getHeaderLabelColor());
    }

    public final void setPreviousButtonImage(@NotNull Drawable drawable) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        CalendarProperties $this$setPreviousButtonImage_u24lambda_u2d8 = calendarProperties;
        boolean bl = false;
        $this$setPreviousButtonImage_u24lambda_u2d8.setPreviousButtonSrc(drawable);
        View view = this.getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"rootView");
        AppearanceUtilsKt.setPreviousButtonImage(view, $this$setPreviousButtonImage_u24lambda_u2d8.getPreviousButtonSrc());
    }

    public final void setForwardButtonImage(@NotNull Drawable drawable) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        CalendarProperties $this$setForwardButtonImage_u24lambda_u2d9 = calendarProperties;
        boolean bl = false;
        $this$setForwardButtonImage_u24lambda_u2d9.setForwardButtonSrc(drawable);
        View view = this.getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"rootView");
        AppearanceUtilsKt.setForwardButtonImage(view, $this$setForwardButtonImage_u24lambda_u2d9.getForwardButtonSrc());
    }

    public final void setCalendarDayLayout(@LayoutRes int layout2) {
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        calendarProperties.setItemLayoutResource(layout2);
    }

    public final void setSelectionBackground(@DrawableRes int drawable) {
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        calendarProperties.setSelectionBackground(drawable);
    }

    private final void setCalendarRowLayout() {
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        if (calendarProperties.getItemLayoutResource() != R.layout.calendar_view_day) {
            return;
        }
        CalendarProperties calendarProperties2 = this.calendarProperties;
        if (calendarProperties2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties2 = null;
        }
        CalendarProperties $this$setCalendarRowLayout_u24lambda_u2d10 = calendarProperties2;
        boolean bl = false;
        $this$setCalendarRowLayout_u24lambda_u2d10.setItemLayoutResource($this$setCalendarRowLayout_u24lambda_u2d10.getEventsEnabled() ? R.layout.calendar_view_day : R.layout.calendar_view_picker_day);
    }

    private final void initUiElements() {
        ((ImageButton)this._$_findCachedViewById(R.id.previousButton)).setOnClickListener(arg_0 -> CalendarView.initUiElements$lambda-11(this, arg_0));
        ((ImageButton)this._$_findCachedViewById(R.id.forwardButton)).setOnClickListener(arg_0 -> CalendarView.initUiElements$lambda-12(this, arg_0));
    }

    private final void initCalendar() {
        Object object = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context");
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        this.calendarPageAdapter = new CalendarPageAdapter((Context)object, calendarProperties);
        CalendarViewPager calendarViewPager = (CalendarViewPager)this._$_findCachedViewById(R.id.calendarViewPager);
        CalendarPageAdapter calendarPageAdapter = this.calendarPageAdapter;
        if (calendarPageAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarPageAdapter");
            calendarPageAdapter = null;
        }
        calendarViewPager.setAdapter(calendarPageAdapter);
        ((CalendarViewPager)this._$_findCachedViewById(R.id.calendarViewPager)).onCalendarPageChangedListener((Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>((Object)this){

            public final void invoke(int p0) {
                CalendarView.access$renderHeader((CalendarView)((Object)this.receiver), p0);
            }
        }));
        object = Calendar.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getInstance()");
        this.setUpCalendarPosition((Calendar)object);
    }

    private final void renderHeader(int position) {
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        Calendar calendar = (Calendar)calendarProperties.getFirstPageCalendarDate().clone();
        calendar.add(2, position);
        if (!this.isScrollingLimited(calendar, position)) {
            this.setHeaderName(calendar, position);
        }
    }

    private final void setUpCalendarPosition(Calendar calendar) {
        CalendarProperties calendarProperties;
        DateUtils.setMidnight(calendar);
        CalendarProperties calendarProperties2 = this.calendarProperties;
        if (calendarProperties2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties2 = null;
        }
        if (calendarProperties2.getCalendarType() == 1) {
            CalendarProperties calendarProperties3 = this.calendarProperties;
            if (calendarProperties3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
                calendarProperties3 = null;
            }
            calendarProperties3.setSelectedDay(calendar);
        }
        if ((calendarProperties = this.calendarProperties) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        Calendar $this$setUpCalendarPosition_u24lambda_u2d13 = calendarProperties.getFirstPageCalendarDate();
        boolean bl = false;
        $this$setUpCalendarPosition_u24lambda_u2d13.setTime(calendar.getTime());
        $this$setUpCalendarPosition_u24lambda_u2d13.add(2, -1200);
        ((CalendarViewPager)this._$_findCachedViewById(R.id.calendarViewPager)).setCurrentItem(1200);
    }

    public final void setOnPreviousPageChangeListener(@NotNull OnCalendarPageChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        calendarProperties.setOnPreviousPageChangeListener(listener);
    }

    public final void setOnForwardPageChangeListener(@NotNull OnCalendarPageChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        calendarProperties.setOnForwardPageChangeListener(listener);
    }

    private final boolean isScrollingLimited(Calendar calendar, int position) {
        boolean bl;
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        if (DateUtils.isMonthBefore(calendarProperties.getMinimumDate(), calendar)) {
            bl = CalendarView.isScrollingLimited$scrollTo(this, position + 1);
        } else {
            CalendarProperties calendarProperties2 = this.calendarProperties;
            if (calendarProperties2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
                calendarProperties2 = null;
            }
            bl = DateUtils.isMonthAfter(calendarProperties2.getMaximumDate(), calendar) ? CalendarView.isScrollingLimited$scrollTo(this, position - 1) : false;
        }
        return bl;
    }

    private final void setHeaderName(Calendar calendar, int position) {
        TextView textView = (TextView)this._$_findCachedViewById(R.id.currentDateLabel);
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        textView.setText((CharSequence)DateUtils.getMonthAndYearDate(calendar, context));
        this.callOnPageChangeListeners(position);
    }

    private final void callOnPageChangeListeners(int position) {
        if (position > this.currentPage) {
            CalendarProperties calendarProperties = this.calendarProperties;
            if (calendarProperties == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
                calendarProperties = null;
            }
            OnCalendarPageChangeListener onCalendarPageChangeListener = calendarProperties.getOnForwardPageChangeListener();
            if (onCalendarPageChangeListener != null) {
                onCalendarPageChangeListener.onChange();
            }
        } else if (position < this.currentPage) {
            CalendarProperties calendarProperties = this.calendarProperties;
            if (calendarProperties == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
                calendarProperties = null;
            }
            OnCalendarPageChangeListener onCalendarPageChangeListener = calendarProperties.getOnPreviousPageChangeListener();
            if (onCalendarPageChangeListener != null) {
                onCalendarPageChangeListener.onChange();
            }
        }
        this.currentPage = position;
    }

    public final void setOnDayClickListener(@NotNull OnDayClickListener onDayClickListener) {
        Intrinsics.checkNotNullParameter((Object)onDayClickListener, (String)"onDayClickListener");
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        calendarProperties.setOnDayClickListener(onDayClickListener);
    }

    public final void setOnDayLongClickListener(@NotNull OnDayLongClickListener onDayLongClickListener) {
        Intrinsics.checkNotNullParameter((Object)onDayLongClickListener, (String)"onDayLongClickListener");
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        calendarProperties.setOnDayLongClickListener(onDayLongClickListener);
    }

    public final void setDate(@NotNull Calendar date) throws OutOfDateRangeException {
        CalendarProperties calendarProperties;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        CalendarProperties calendarProperties2 = this.calendarProperties;
        if (calendarProperties2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties2 = null;
        }
        if (calendarProperties2.getMinimumDate() != null) {
            CalendarProperties calendarProperties3 = this.calendarProperties;
            if (calendarProperties3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
                calendarProperties3 = null;
            }
            if (date.before(calendarProperties3.getMinimumDate())) {
                throw new OutOfDateRangeException("SET DATE EXCEEDS THE MINIMUM DATE");
            }
        }
        if ((calendarProperties = this.calendarProperties) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        if (calendarProperties.getMaximumDate() != null) {
            CalendarProperties calendarProperties4 = this.calendarProperties;
            if (calendarProperties4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
                calendarProperties4 = null;
            }
            if (date.after(calendarProperties4.getMaximumDate())) {
                throw new OutOfDateRangeException("SET DATE EXCEEDS THE MAXIMUM DATE");
            }
        }
        this.setUpCalendarPosition(date);
        TextView textView = (TextView)this._$_findCachedViewById(R.id.currentDateLabel);
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        textView.setText((CharSequence)DateUtils.getMonthAndYearDate(date, context));
        CalendarPageAdapter calendarPageAdapter = this.calendarPageAdapter;
        if (calendarPageAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarPageAdapter");
            calendarPageAdapter = null;
        }
        calendarPageAdapter.notifyDataSetChanged();
    }

    public final void setDate(@NotNull Date currentDate) {
        Calendar calendar;
        Intrinsics.checkNotNullParameter((Object)currentDate, (String)"currentDate");
        Calendar $this$setDate_u24lambda_u2d14 = calendar = Calendar.getInstance();
        boolean bl = false;
        $this$setDate_u24lambda_u2d14.setTime(currentDate);
        Calendar calendar2 = calendar;
        Intrinsics.checkNotNullExpressionValue((Object)calendar2, (String)"calendar");
        this.setDate(calendar2);
    }

    public final void setEvents(@NotNull List<EventDay> eventDays) {
        Intrinsics.checkNotNullParameter(eventDays, (String)"eventDays");
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        if (calendarProperties.getEventsEnabled()) {
            CalendarProperties calendarProperties2 = this.calendarProperties;
            if (calendarProperties2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
                calendarProperties2 = null;
            }
            calendarProperties2.setEventDays(eventDays);
            CalendarPageAdapter calendarPageAdapter = this.calendarPageAdapter;
            if (calendarPageAdapter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"calendarPageAdapter");
                calendarPageAdapter = null;
            }
            calendarPageAdapter.notifyDataSetChanged();
        }
    }

    public final void setCalendarDays(@NotNull List<CalendarDay> calendarDayProperties) {
        Intrinsics.checkNotNullParameter(calendarDayProperties, (String)"calendarDayProperties");
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        calendarProperties.setCalendarDayProperties(CollectionsKt.toMutableList((Collection)calendarDayProperties));
        CalendarPageAdapter calendarPageAdapter = this.calendarPageAdapter;
        if (calendarPageAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarPageAdapter");
            calendarPageAdapter = null;
        }
        calendarPageAdapter.notifyDataSetChanged();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Calendar> getSelectedDates() {
        void $this$mapTo$iv$iv;
        CalendarPageAdapter calendarPageAdapter = this.calendarPageAdapter;
        if (calendarPageAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarPageAdapter");
            calendarPageAdapter = null;
        }
        Iterable $this$map$iv = calendarPageAdapter.getSelectedDays();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SelectedDay selectedDay = (SelectedDay)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCalendar());
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)));
    }

    public final void setSelectedDates(@NotNull List<? extends Calendar> selectedDates) {
        Intrinsics.checkNotNullParameter(selectedDates, (String)"selectedDates");
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        calendarProperties.setSelectDays(selectedDates);
        CalendarPageAdapter calendarPageAdapter = this.calendarPageAdapter;
        if (calendarPageAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarPageAdapter");
            calendarPageAdapter = null;
        }
        calendarPageAdapter.notifyDataSetChanged();
    }

    @NotNull
    public final Calendar getSelectedDate() {
        return this.getFirstSelectedDate();
    }

    @Deprecated(message="Use getFirstSelectedDate()", replaceWith=@ReplaceWith(expression="firstSelectedDate", imports={}))
    public static /* synthetic */ void getSelectedDate$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Calendar getFirstSelectedDate() {
        void $this$mapTo$iv$iv;
        CalendarPageAdapter calendarPageAdapter = this.calendarPageAdapter;
        if (calendarPageAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarPageAdapter");
            calendarPageAdapter = null;
        }
        Iterable $this$map$iv = calendarPageAdapter.getSelectedDays();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SelectedDay selectedDay = (SelectedDay)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCalendar());
        }
        return (Calendar)CollectionsKt.first((List)((List)destination$iv$iv));
    }

    @NotNull
    public final Calendar getCurrentPageDate() {
        Calendar calendar;
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        Calendar $this$_get_currentPageDate__u24lambda_u2d17 = calendar = (Calendar)calendarProperties.getFirstPageCalendarDate().clone();
        boolean bl = false;
        $this$_get_currentPageDate__u24lambda_u2d17.set(5, 1);
        $this$_get_currentPageDate__u24lambda_u2d17.add(2, ((CalendarViewPager)this._$_findCachedViewById(R.id.calendarViewPager)).getCurrentItem());
        return calendar;
    }

    public final void setMinimumDate(@NotNull Calendar calendar) {
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        calendarProperties.setMinimumDate(calendar);
        CalendarPageAdapter calendarPageAdapter = this.calendarPageAdapter;
        if (calendarPageAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarPageAdapter");
            calendarPageAdapter = null;
        }
        calendarPageAdapter.notifyDataSetChanged();
    }

    public final void setMaximumDate(@NotNull Calendar calendar) {
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        calendarProperties.setMaximumDate(calendar);
        CalendarPageAdapter calendarPageAdapter = this.calendarPageAdapter;
        if (calendarPageAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarPageAdapter");
            calendarPageAdapter = null;
        }
        calendarPageAdapter.notifyDataSetChanged();
    }

    public final void showCurrentMonthPage() {
        int page = ((CalendarViewPager)this._$_findCachedViewById(R.id.calendarViewPager)).getCurrentItem() - DateUtils.getMonthsToDate(DateUtils.getMidnightCalendar(), this.getCurrentPageDate());
        ((CalendarViewPager)this._$_findCachedViewById(R.id.calendarViewPager)).setCurrentItem(page, true);
    }

    public final void clearSelectedDays() {
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        calendarProperties.getSelectedDays().clear();
        CalendarPageAdapter calendarPageAdapter = this.calendarPageAdapter;
        if (calendarPageAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarPageAdapter");
            calendarPageAdapter = null;
        }
        calendarPageAdapter.notifyDataSetChanged();
    }

    public final void setDisabledDays(@NotNull List<? extends Calendar> disabledDays) {
        Intrinsics.checkNotNullParameter(disabledDays, (String)"disabledDays");
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        calendarProperties.setDisabledDays(disabledDays);
        CalendarPageAdapter calendarPageAdapter = this.calendarPageAdapter;
        if (calendarPageAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarPageAdapter");
            calendarPageAdapter = null;
        }
        calendarPageAdapter.notifyDataSetChanged();
    }

    @Deprecated(message="Use setCalendarDays(List<CalendarDay>) with specific labelColor")
    public final void setHighlightedDays(@NotNull List<? extends Calendar> highlightedDays) {
        Intrinsics.checkNotNullParameter(highlightedDays, (String)"highlightedDays");
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        calendarProperties.setHighlightedDays(highlightedDays);
        CalendarPageAdapter calendarPageAdapter = this.calendarPageAdapter;
        if (calendarPageAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarPageAdapter");
            calendarPageAdapter = null;
        }
        calendarPageAdapter.notifyDataSetChanged();
    }

    public final void setSwipeEnabled(boolean swipeEnabled) {
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        calendarProperties.setSwipeEnabled(swipeEnabled);
        CalendarViewPager calendarViewPager = (CalendarViewPager)this._$_findCachedViewById(R.id.calendarViewPager);
        CalendarProperties calendarProperties2 = this.calendarProperties;
        if (calendarProperties2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties2 = null;
        }
        calendarViewPager.setSwipeEnabled(calendarProperties2.getSwipeEnabled());
    }

    public final void setSelectionBetweenMonthsEnabled(boolean enabled) {
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        calendarProperties.setSelectionBetweenMonthsEnabled(enabled);
    }

    public final void setOnPagePrepareListener(@NotNull Function1<? super Calendar, ? extends List<CalendarDay>> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        CalendarProperties calendarProperties = this.calendarProperties;
        if (calendarProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarProperties");
            calendarProperties = null;
        }
        calendarProperties.setOnPagePrepareListener(listener);
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int id2) {
        Map<Integer, View> map = this._$_findViewCache;
        View view = map.get(id2);
        if (view == null) {
            View view2 = this.findViewById(id2);
            if (view2 == null) {
                view = null;
            } else {
                map.put(id2, view2);
                view = view2;
            }
        }
        return view;
    }

    @JvmOverloads
    public CalendarView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CalendarView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void initUiElements$lambda-11(CalendarView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        ((CalendarViewPager)this$0._$_findCachedViewById(R.id.calendarViewPager)).setCurrentItem(((CalendarViewPager)this$0._$_findCachedViewById(R.id.calendarViewPager)).getCurrentItem() - 1);
    }

    private static final void initUiElements$lambda-12(CalendarView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        ((CalendarViewPager)this$0._$_findCachedViewById(R.id.calendarViewPager)).setCurrentItem(((CalendarViewPager)this$0._$_findCachedViewById(R.id.calendarViewPager)).getCurrentItem() + 1);
    }

    private static final boolean isScrollingLimited$scrollTo(CalendarView this$0, int position) {
        ((CalendarViewPager)this$0._$_findCachedViewById(R.id.calendarViewPager)).setCurrentItem(position);
        return true;
    }

    public static final /* synthetic */ void access$renderHeader(CalendarView $this, int position) {
        $this.renderHeader(position);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/applandeo/materialcalendarview/CalendarView$Companion;", "", "()V", "CLASSIC", "", "MANY_DAYS_PICKER", "ONE_DAY_PICKER", "RANGE_PICKER", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

