/*
 * Decompiled with CFR 0.152.
 */
package com.applandeo.materialcalendarview.utils;

import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.applandeo.materialcalendarview.R;
import com.applandeo.materialcalendarview.extensions.CalendarViewPager;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u001a\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001*\u00020\u0004H\u0002\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0014\u0010\t\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\n\u001a\u00020\bH\u0000\u001a\u001c\u0010\u000b\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0000\u001a\u0014\u0010\r\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0016\u0010\u0010\u001a\u00020\u0006*\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0000\u001a\u0014\u0010\u0013\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0014\u0010\u0014\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0016\u0010\u0015\u001a\u00020\u0006*\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0000\u001a\u0014\u0010\u0018\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\n\u001a\u00020\bH\u0000\u001a\u0014\u0010\u0019\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\n\u001a\u00020\bH\u0000\u001a\u0014\u0010\u001a\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0016\u0010\u001b\u001a\u00020\u0006*\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0000\u001a\u0016\u0010\u001c\u001a\u00020\u0006*\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0000\u00a8\u0006\u001d"}, d2={"getAbbreviationsTextViews", "", "Landroid/widget/TextView;", "kotlin.jvm.PlatformType", "Landroid/view/View;", "setAbbreviationsBarColor", "", "color", "", "setAbbreviationsBarVisibility", "visibility", "setAbbreviationsLabels", "firstDayOfWeek", "setAbbreviationsLabelsSize", "size", "", "setForwardButtonImage", "drawable", "Landroid/graphics/drawable/Drawable;", "setHeaderColor", "setHeaderLabelColor", "setHeaderTypeface", "typeface", "Landroid/graphics/Typeface;", "setHeaderVisibility", "setNavigationVisibility", "setPagesColor", "setPreviousButtonImage", "setTypeface", "library_release"})
public final class AppearanceUtilsKt {
    /*
     * WARNING - void declaration
     */
    public static final void setAbbreviationsLabels(@NotNull View $this$setAbbreviationsLabels, int color2, int firstDayOfWeek) {
        Intrinsics.checkNotNullParameter((Object)$this$setAbbreviationsLabels, (String)"<this>");
        List<TextView> labels = AppearanceUtilsKt.getAbbreviationsTextViews($this$setAbbreviationsLabels);
        String[] stringArray = $this$setAbbreviationsLabels.getContext().getResources().getStringArray(R.array.material_calendar_day_abbreviations_array);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"context.resources.getStr\u2026_day_abbreviations_array)");
        String[] abbreviations = stringArray;
        Iterable $this$forEachIndexed$iv = labels;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void label;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TextView textView = (TextView)item$iv;
            int index = n;
            boolean bl = false;
            label.setText((CharSequence)abbreviations[(index + firstDayOfWeek - 1) % 7]);
            if (color2 == 0) continue;
            label.setTextColor(color2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void setAbbreviationsLabelsSize(@NotNull View $this$setAbbreviationsLabelsSize, float size) {
        Intrinsics.checkNotNullParameter((Object)$this$setAbbreviationsLabelsSize, (String)"<this>");
        List<TextView> labels = AppearanceUtilsKt.getAbbreviationsTextViews($this$setAbbreviationsLabelsSize);
        int maxTextSize = $this$setAbbreviationsLabelsSize.getResources().getDimensionPixelSize(R.dimen.abbreviation_text_size_max);
        Iterable $this$forEachIndexed$iv = labels;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void label;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TextView textView = (TextView)item$iv;
            int $noName_0 = n;
            boolean bl = false;
            if (!((double)size > 0.0) || !(size <= (float)maxTextSize)) continue;
            label.setTextSize(size);
        }
    }

    private static final List<TextView> getAbbreviationsTextViews(View $this$getAbbreviationsTextViews) {
        Object[] objectArray = new TextView[]{(TextView)$this$getAbbreviationsTextViews.findViewById(R.id.mondayLabel), (TextView)$this$getAbbreviationsTextViews.findViewById(R.id.tuesdayLabel), (TextView)$this$getAbbreviationsTextViews.findViewById(R.id.wednesdayLabel), (TextView)$this$getAbbreviationsTextViews.findViewById(R.id.thursdayLabel), (TextView)$this$getAbbreviationsTextViews.findViewById(R.id.fridayLabel), (TextView)$this$getAbbreviationsTextViews.findViewById(R.id.saturdayLabel), (TextView)$this$getAbbreviationsTextViews.findViewById(R.id.sundayLabel)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public static final void setTypeface(@NotNull View $this$setTypeface, @Nullable Typeface typeface) {
        Intrinsics.checkNotNullParameter((Object)$this$setTypeface, (String)"<this>");
        if (typeface == null) {
            return;
        }
        Iterable $this$forEach$iv = AppearanceUtilsKt.getAbbreviationsTextViews($this$setTypeface);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextView label = (TextView)element$iv;
            boolean bl = false;
            label.setTypeface(typeface);
        }
    }

    public static final void setHeaderColor(@NotNull View $this$setHeaderColor, int color2) {
        Intrinsics.checkNotNullParameter((Object)$this$setHeaderColor, (String)"<this>");
        if (color2 == 0) {
            return;
        }
        ((ConstraintLayout)$this$setHeaderColor.findViewById(R.id.calendarHeader)).setBackgroundColor(color2);
    }

    public static final void setHeaderLabelColor(@NotNull View $this$setHeaderLabelColor, int color2) {
        Intrinsics.checkNotNullParameter((Object)$this$setHeaderLabelColor, (String)"<this>");
        if (color2 == 0) {
            return;
        }
        ((TextView)$this$setHeaderLabelColor.findViewById(R.id.currentDateLabel)).setTextColor(color2);
    }

    public static final void setHeaderTypeface(@NotNull View $this$setHeaderTypeface, @Nullable Typeface typeface) {
        Intrinsics.checkNotNullParameter((Object)$this$setHeaderTypeface, (String)"<this>");
        if (typeface == null) {
            return;
        }
        ((TextView)$this$setHeaderTypeface.findViewById(R.id.currentDateLabel)).setTypeface(typeface);
    }

    public static final void setAbbreviationsBarColor(@NotNull View $this$setAbbreviationsBarColor, int color2) {
        Intrinsics.checkNotNullParameter((Object)$this$setAbbreviationsBarColor, (String)"<this>");
        if (color2 == 0) {
            return;
        }
        ((LinearLayout)$this$setAbbreviationsBarColor.findViewById(R.id.abbreviationsBar)).setBackgroundColor(color2);
    }

    public static final void setPagesColor(@NotNull View $this$setPagesColor, int color2) {
        Intrinsics.checkNotNullParameter((Object)$this$setPagesColor, (String)"<this>");
        if (color2 == 0) {
            return;
        }
        ((CalendarViewPager)$this$setPagesColor.findViewById(R.id.calendarViewPager)).setBackgroundColor(color2);
    }

    public static final void setPreviousButtonImage(@NotNull View $this$setPreviousButtonImage, @Nullable Drawable drawable) {
        Intrinsics.checkNotNullParameter((Object)$this$setPreviousButtonImage, (String)"<this>");
        if (drawable == null) {
            return;
        }
        ((ImageButton)$this$setPreviousButtonImage.findViewById(R.id.previousButton)).setImageDrawable(drawable);
    }

    public static final void setForwardButtonImage(@NotNull View $this$setForwardButtonImage, @Nullable Drawable drawable) {
        Intrinsics.checkNotNullParameter((Object)$this$setForwardButtonImage, (String)"<this>");
        if (drawable == null) {
            return;
        }
        ((ImageButton)$this$setForwardButtonImage.findViewById(R.id.forwardButton)).setImageDrawable(drawable);
    }

    public static final void setHeaderVisibility(@NotNull View $this$setHeaderVisibility, int visibility) {
        Intrinsics.checkNotNullParameter((Object)$this$setHeaderVisibility, (String)"<this>");
        ((ConstraintLayout)$this$setHeaderVisibility.findViewById(R.id.calendarHeader)).setVisibility(visibility);
    }

    public static final void setNavigationVisibility(@NotNull View $this$setNavigationVisibility, int visibility) {
        Intrinsics.checkNotNullParameter((Object)$this$setNavigationVisibility, (String)"<this>");
        ((ImageButton)$this$setNavigationVisibility.findViewById(R.id.previousButton)).setVisibility(visibility);
        ((ImageButton)$this$setNavigationVisibility.findViewById(R.id.forwardButton)).setVisibility(visibility);
    }

    public static final void setAbbreviationsBarVisibility(@NotNull View $this$setAbbreviationsBarVisibility, int visibility) {
        Intrinsics.checkNotNullParameter((Object)$this$setAbbreviationsBarVisibility, (String)"<this>");
        ((LinearLayout)$this$setAbbreviationsBarVisibility.findViewById(R.id.abbreviationsBar)).setVisibility(visibility);
    }
}

