/*
 * Decompiled with CFR 0.152.
 */
package com.applandeo.materialcalendarview.utils;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.core.content.ContextCompat;
import com.applandeo.materialcalendarview.CalendarDay;
import com.applandeo.materialcalendarview.EventDay;
import com.applandeo.materialcalendarview.R;
import com.applandeo.materialcalendarview.utils.CalendarProperties;
import com.applandeo.materialcalendarview.utils.DateUtils;
import com.applandeo.materialcalendarview.utils.EventDayUtilsKt;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\n\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001e\u0010\f\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u001b\u0010\u0011\u001a\u0004\u0018\u00010\u0010*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015\u001a\u001b\u0010\u0016\u001a\u0004\u0018\u00010\u0010*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015\u001a\u0014\u0010\u0017\u001a\u00020\u0010*\u00020\u00142\b\b\u0001\u0010\u0018\u001a\u00020\u0010\u001a(\u0010\u0019\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00102\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u0010\u00a8\u0006\u001e"}, d2={"setCurrentMonthDayColors", "", "calendar", "Ljava/util/Calendar;", "dayLabel", "Landroid/widget/TextView;", "calendarProperties", "Lcom/applandeo/materialcalendarview/utils/CalendarProperties;", "setEventDayColors", "day", "setHighlightedDayColors", "setNormalDayColors", "setSelectedDayColors", "setTodayColors", "tintBackground", "color", "", "getLabelColor", "Lcom/applandeo/materialcalendarview/CalendarDay;", "context", "Landroid/content/Context;", "(Lcom/applandeo/materialcalendarview/CalendarDay;Landroid/content/Context;)Ljava/lang/Integer;", "getSelectedLabelColor", "parseColor", "colorRes", "setDayColors", "textColor", "typeface", "Landroid/graphics/Typeface;", "backgroundRes", "library_release"})
@JvmName(name="DayColorsUtils")
public final class DayColorsUtils {
    public static final void setDayColors(@NotNull TextView $this$setDayColors, int textColor, @Nullable Typeface typeface, int backgroundRes) {
        Intrinsics.checkNotNullParameter((Object)$this$setDayColors, (String)"<this>");
        Typeface typeface2 = typeface;
        if (typeface2 != null) {
            Typeface it = typeface2;
            boolean bl = false;
            $this$setDayColors.setTypeface(typeface);
        }
        $this$setDayColors.setTextColor(textColor);
        $this$setDayColors.setBackgroundResource(backgroundRes);
    }

    public static /* synthetic */ void setDayColors$default(TextView textView, int n, Typeface typeface, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            typeface = null;
        }
        if ((n3 & 4) != 0) {
            n2 = R.drawable.background_transparent;
        }
        DayColorsUtils.setDayColors(textView, n, typeface, n2);
    }

    public static final void setSelectedDayColors(@NotNull TextView dayLabel, @NotNull Calendar calendar, @NotNull CalendarProperties calendarProperties) {
        Drawable calendarDayBackgroundDrawable;
        Integer n;
        CalendarDay calendarDay;
        Intrinsics.checkNotNullParameter((Object)dayLabel, (String)"dayLabel");
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        Intrinsics.checkNotNullParameter((Object)calendarProperties, (String)"calendarProperties");
        CalendarDay calendarDay2 = calendarDay = calendarProperties.findDayProperties(calendar);
        if (calendarDay2 == null) {
            n = null;
        } else {
            Context context = dayLabel.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"dayLabel.context");
            n = DayColorsUtils.getSelectedLabelColor(calendarDay2, context);
        }
        Integer n2 = n;
        int labelColor = n2 == null ? calendarProperties.getSelectionLabelColor() : n2.intValue();
        CalendarDay calendarDay3 = calendarDay;
        Integer calendarDayBackgroundRes = calendarDay3 == null ? null : calendarDay3.getSelectedBackgroundResource();
        CalendarDay calendarDay4 = calendarDay;
        Object object = calendarDayBackgroundDrawable = calendarDay4 == null ? null : calendarDay4.getSelectedBackgroundDrawable();
        if (calendarDayBackgroundRes != null && !calendarProperties.getSelectionDisabled()) {
            DayColorsUtils.setDayColors$default(dayLabel, labelColor, null, calendarDayBackgroundRes, 2, null);
        } else if (calendarDayBackgroundDrawable != null && !calendarProperties.getSelectionDisabled()) {
            DayColorsUtils.setDayColors$default(dayLabel, labelColor, null, 0, 6, null);
            dayLabel.setBackgroundDrawable(calendarDayBackgroundDrawable);
        } else {
            DayColorsUtils.setDayColors$default(dayLabel, labelColor, null, calendarProperties.getSelectionBackground(), 2, null);
            DayColorsUtils.tintBackground(dayLabel, calendarProperties.getSelectionColor());
        }
    }

    public static final void setCurrentMonthDayColors(@NotNull Calendar calendar, @Nullable TextView dayLabel, @NotNull CalendarProperties calendarProperties) {
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        Intrinsics.checkNotNullParameter((Object)calendarProperties, (String)"calendarProperties");
        if (dayLabel == null) {
            return;
        }
        DayColorsUtils.setNormalDayColors(calendar, dayLabel, calendarProperties);
        if (DateUtils.isToday(calendar)) {
            DayColorsUtils.setTodayColors(calendar, dayLabel, calendarProperties);
        }
        if (EventDayUtilsKt.isEventDayWithLabelColor(calendar, calendarProperties)) {
            DayColorsUtils.setEventDayColors(calendar, dayLabel, calendarProperties);
        }
        if (calendarProperties.getHighlightedDays().contains(calendar)) {
            DayColorsUtils.setHighlightedDayColors(dayLabel, calendarProperties);
        }
    }

    private static final void setTodayColors(Calendar calendar, TextView dayLabel, CalendarProperties calendarProperties) {
        Drawable calendarDayBackgroundDrawable;
        CalendarDay calendarDay;
        CalendarDay calendarDay2 = calendarDay = calendarProperties.findDayProperties(calendar);
        Integer calendarDayBackgroundRes = calendarDay2 == null ? null : calendarDay2.getBackgroundResource();
        CalendarDay calendarDay3 = calendarDay;
        Object object = calendarDayBackgroundDrawable = calendarDay3 == null ? null : calendarDay3.getBackgroundDrawable();
        if (calendarDayBackgroundRes != null) {
            DayColorsUtils.setDayColors(dayLabel, calendarProperties.getTodayLabelColor(), calendarProperties.getTodayTypeface(), calendarDayBackgroundRes);
        } else if (calendarDayBackgroundDrawable != null) {
            DayColorsUtils.setDayColors$default(dayLabel, calendarProperties.getTodayLabelColor(), calendarProperties.getTodayTypeface(), 0, 4, null);
            dayLabel.setBackgroundDrawable(calendarDayBackgroundDrawable);
        } else {
            DayColorsUtils.setDayColors(dayLabel, calendarProperties.getTodayLabelColor(), calendarProperties.getTodayTypeface(), R.drawable.background_transparent);
        }
        if (calendarProperties.getTodayColor() != 0) {
            DayColorsUtils.setDayColors$default(dayLabel, calendarProperties.getSelectionLabelColor(), null, R.drawable.background_color_circle_selector, 2, null);
            DayColorsUtils.tintBackground(dayLabel, calendarProperties.getTodayColor());
        }
    }

    private static final void setEventDayColors(Calendar day, TextView dayLabel, CalendarProperties calendarProperties) {
        EventDay eventDay = EventDayUtilsKt.getEventDayWithLabelColor(day, calendarProperties);
        if (eventDay != null) {
            EventDay eventDay2 = eventDay;
            boolean bl = false;
            DayColorsUtils.setDayColors$default(dayLabel, eventDay2.getLabelColor$library_release(), null, 0, 6, null);
        }
    }

    private static final void setHighlightedDayColors(TextView dayLabel, CalendarProperties calendarProperties) {
        DayColorsUtils.setDayColors$default(dayLabel, calendarProperties.getHighlightedDaysLabelsColor(), null, 0, 6, null);
    }

    private static final void setNormalDayColors(Calendar calendar, TextView dayLabel, CalendarProperties calendarProperties) {
        Drawable calendarDayBackgroundDrawable;
        Integer n;
        CalendarDay calendarDay;
        CalendarDay calendarDay2 = calendarDay = calendarProperties.findDayProperties(calendar);
        if (calendarDay2 == null) {
            n = null;
        } else {
            Context context = dayLabel.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"dayLabel.context");
            n = DayColorsUtils.getLabelColor(calendarDay2, context);
        }
        Integer n2 = n;
        int labelColor = n2 == null ? calendarProperties.getDaysLabelsColor() : n2.intValue();
        CalendarDay calendarDay3 = calendarDay;
        Integer calendarDayBackgroundRes = calendarDay3 == null ? null : calendarDay3.getBackgroundResource();
        CalendarDay calendarDay4 = calendarDay;
        Object object = calendarDayBackgroundDrawable = calendarDay4 == null ? null : calendarDay4.getBackgroundDrawable();
        if (calendarDayBackgroundRes != null) {
            DayColorsUtils.setDayColors$default(dayLabel, labelColor, null, calendarDayBackgroundRes, 2, null);
        } else if (calendarDayBackgroundDrawable != null) {
            DayColorsUtils.setDayColors$default(dayLabel, labelColor, null, 0, 6, null);
            dayLabel.setBackgroundDrawable(calendarDayBackgroundDrawable);
        } else {
            DayColorsUtils.setDayColors$default(dayLabel, labelColor, null, R.drawable.background_transparent, 2, null);
        }
    }

    private static final void tintBackground(TextView dayLabel, int color2) {
        dayLabel.getBackground().setColorFilter(color2, PorterDuff.Mode.MULTIPLY);
    }

    private static final Integer getLabelColor(CalendarDay $this$getLabelColor, Context context) {
        Integer n = $this$getLabelColor.getLabelColor();
        if (n == null) {
            return null;
        }
        int labelColor = n;
        return DayColorsUtils.parseColor(context, labelColor);
    }

    private static final Integer getSelectedLabelColor(CalendarDay $this$getSelectedLabelColor, Context context) {
        Integer n = $this$getSelectedLabelColor.getSelectedLabelColor();
        if (n == null) {
            return null;
        }
        int selectedLabelColor = n;
        return DayColorsUtils.parseColor(context, selectedLabelColor);
    }

    public static final int parseColor(@NotNull Context $this$parseColor, @ColorRes int colorRes) {
        Intrinsics.checkNotNullParameter((Object)$this$parseColor, (String)"<this>");
        return ContextCompat.getColor((Context)$this$parseColor, (int)colorRes);
    }
}

