/*
 * Decompiled with CFR 0.152.
 */
package com.applandeo.materialcalendarview.listeners;

import android.view.View;
import android.widget.AdapterView;
import android.widget.TextView;
import com.applandeo.materialcalendarview.CalendarDay;
import com.applandeo.materialcalendarview.CalendarUtils;
import com.applandeo.materialcalendarview.EventDay;
import com.applandeo.materialcalendarview.R;
import com.applandeo.materialcalendarview.adapters.CalendarPageAdapter;
import com.applandeo.materialcalendarview.listeners.OnCalendarDayClickListener;
import com.applandeo.materialcalendarview.listeners.OnDayClickListener;
import com.applandeo.materialcalendarview.utils.CalendarProperties;
import com.applandeo.materialcalendarview.utils.DateUtils;
import com.applandeo.materialcalendarview.utils.DayColorsUtils;
import com.applandeo.materialcalendarview.utils.SelectedDay;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0014H\u0002J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J,\u0010\u001e\u001a\u00020\n2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010'\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010(\u001a\u00020\n2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010)\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010*\u001a\u00020\n2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010+\u001a\u00020\n2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010,\u001a\u00020\u0016*\u00020\u0014H\u0002J\f\u0010-\u001a\u00020\u0016*\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/applandeo/materialcalendarview/listeners/DayRowClickListener;", "Landroid/widget/AdapterView$OnItemClickListener;", "calendarPageAdapter", "Lcom/applandeo/materialcalendarview/adapters/CalendarPageAdapter;", "calendarProperties", "Lcom/applandeo/materialcalendarview/utils/CalendarProperties;", "pageMonth", "", "(Lcom/applandeo/materialcalendarview/adapters/CalendarPageAdapter;Lcom/applandeo/materialcalendarview/utils/CalendarProperties;I)V", "callOnCalendarDayClickListener", "", "calendarDay", "Lcom/applandeo/materialcalendarview/CalendarDay;", "callOnClickListener", "eventDay", "Lcom/applandeo/materialcalendarview/EventDay;", "clearAndSelectOne", "dayLabel", "Landroid/widget/TextView;", "day", "Ljava/util/Calendar;", "isAnotherDaySelected", "", "selectedDay", "Lcom/applandeo/materialcalendarview/utils/SelectedDay;", "isOutOfMaxRange", "firstDay", "lastDay", "onCalendarDayClick", "onClick", "onItemClick", "adapterView", "Landroid/widget/AdapterView;", "view", "Landroid/view/View;", "position", "id", "", "reverseUnselectedColor", "selectDay", "selectManyDays", "selectOneAndRange", "selectOneDay", "selectRange", "isActiveDay", "isCurrentMonthDay", "library_release"})
public final class DayRowClickListener
implements AdapterView.OnItemClickListener {
    @NotNull
    private final CalendarPageAdapter calendarPageAdapter;
    @NotNull
    private final CalendarProperties calendarProperties;
    private final int pageMonth;

    public DayRowClickListener(@NotNull CalendarPageAdapter calendarPageAdapter, @NotNull CalendarProperties calendarProperties, int pageMonth) {
        Intrinsics.checkNotNullParameter((Object)((Object)calendarPageAdapter), (String)"calendarPageAdapter");
        Intrinsics.checkNotNullParameter((Object)calendarProperties, (String)"calendarProperties");
        this.calendarPageAdapter = calendarPageAdapter;
        this.calendarProperties = calendarProperties;
        this.pageMonth = pageMonth < 0 ? 11 : pageMonth;
    }

    public void onItemClick(@NotNull AdapterView<?> adapterView, @NotNull View view, int position, long id2) {
        GregorianCalendar gregorianCalendar;
        Intrinsics.checkNotNullParameter(adapterView, (String)"adapterView");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        GregorianCalendar $this$onItemClick_u24lambda_u2d0 = gregorianCalendar = new GregorianCalendar();
        boolean bl = false;
        Object object = adapterView.getItemAtPosition(position);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.util.Date");
        }
        $this$onItemClick_u24lambda_u2d0.setTime((Date)object);
        GregorianCalendar day = gregorianCalendar;
        if (this.calendarProperties.getOnDayClickListener() != null) {
            this.onClick(day);
        }
        if (this.calendarProperties.getOnCalendarDayClickListener() != null) {
            this.onCalendarDayClick(day);
        }
        if (this.calendarProperties.getSelectionDisabled()) {
            return;
        }
        switch (this.calendarProperties.getCalendarType()) {
            case 1: {
                this.selectOneDay(view, day);
                break;
            }
            case 2: {
                this.selectManyDays(view, day);
                break;
            }
            case 3: {
                this.selectRange(view, day);
                break;
            }
            case 0: {
                this.calendarPageAdapter.setSelectedDay(new SelectedDay(day, view));
            }
        }
    }

    private final void selectOneDay(View view, Calendar day) {
        SelectedDay previousSelectedDay = this.calendarPageAdapter.getSelectedDay();
        TextView dayLabel = (TextView)view.findViewById(R.id.dayLabel);
        if (this.isAnotherDaySelected(previousSelectedDay, day)) {
            Intrinsics.checkNotNullExpressionValue((Object)dayLabel, (String)"dayLabel");
            this.selectDay(dayLabel, day);
            this.reverseUnselectedColor(previousSelectedDay);
            this.calendarPageAdapter.notifyDataSetChanged();
        }
    }

    private final void selectManyDays(View view, Calendar day) {
        TextView dayLabel = (TextView)view.findViewById(R.id.dayLabel);
        if (!this.isCurrentMonthDay(day) || !this.isActiveDay(day)) {
            return;
        }
        SelectedDay selectedDay = new SelectedDay(day, (View)dayLabel);
        if (!this.calendarPageAdapter.getSelectedDays().contains(selectedDay)) {
            Intrinsics.checkNotNullExpressionValue((Object)dayLabel, (String)"dayLabel");
            DayColorsUtils.setSelectedDayColors(dayLabel, day, this.calendarProperties);
        } else {
            this.reverseUnselectedColor(selectedDay);
        }
        this.calendarPageAdapter.addSelectedDay(selectedDay);
    }

    private final void selectRange(View view, Calendar day) {
        TextView dayLabel = (TextView)view.findViewById(R.id.dayLabel);
        if (!this.isCurrentMonthDay(day) && !this.calendarProperties.getSelectionBetweenMonthsEnabled() || !this.isActiveDay(day)) {
            return;
        }
        List<SelectedDay> selectedDays = this.calendarPageAdapter.getSelectedDays();
        if (selectedDays.size() > 1) {
            Intrinsics.checkNotNullExpressionValue((Object)dayLabel, (String)"dayLabel");
            this.clearAndSelectOne(dayLabel, day);
        } else if (selectedDays.size() == 1) {
            Intrinsics.checkNotNullExpressionValue((Object)dayLabel, (String)"dayLabel");
            this.selectOneAndRange(dayLabel, day);
        } else if (selectedDays.isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)dayLabel, (String)"dayLabel");
            this.selectDay(dayLabel, day);
        }
    }

    private final void clearAndSelectOne(TextView dayLabel, Calendar day) {
        Iterable $this$forEach$iv = this.calendarPageAdapter.getSelectedDays();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SelectedDay it = (SelectedDay)element$iv;
            boolean bl = false;
            this.reverseUnselectedColor(it);
        }
        this.selectDay(dayLabel, day);
        this.calendarPageAdapter.notifyDataSetChanged();
    }

    /*
     * WARNING - void declaration
     */
    private final void selectOneAndRange(TextView dayLabel, Calendar day) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Calendar previousSelectedDayCalendar = this.calendarPageAdapter.getSelectedDay().getCalendar();
        Iterable iterable = CalendarUtils.getDatesRange(previousSelectedDayCalendar, day);
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Calendar it = (Calendar)element$iv$iv;
            boolean bl = false;
            if (!(!this.calendarProperties.getDisabledDays().contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Calendar it = (Calendar)element$iv;
            boolean bl = false;
            this.calendarPageAdapter.addSelectedDay(new SelectedDay(it, null, 2, null));
        }
        if (this.isOutOfMaxRange(previousSelectedDayCalendar, day)) {
            return;
        }
        DayColorsUtils.setSelectedDayColors(dayLabel, day, this.calendarProperties);
        this.calendarPageAdapter.addSelectedDay(new SelectedDay(day, (View)dayLabel));
        this.calendarPageAdapter.notifyDataSetChanged();
    }

    private final void selectDay(TextView dayLabel, Calendar day) {
        DayColorsUtils.setSelectedDayColors(dayLabel, day, this.calendarProperties);
        this.calendarPageAdapter.setSelectedDay(new SelectedDay(day, (View)dayLabel));
    }

    private final void reverseUnselectedColor(SelectedDay selectedDay) {
        View view;
        DayColorsUtils.setCurrentMonthDayColors(selectedDay.getCalendar(), (view = selectedDay.getView()) instanceof TextView ? (TextView)view : null, this.calendarProperties);
    }

    private final boolean isCurrentMonthDay(Calendar $this$isCurrentMonthDay) {
        return $this$isCurrentMonthDay.get(2) == this.pageMonth && DateUtils.isBetweenMinAndMax($this$isCurrentMonthDay, this.calendarProperties);
    }

    private final boolean isActiveDay(Calendar $this$isActiveDay) {
        return !this.calendarProperties.getDisabledDays().contains($this$isActiveDay);
    }

    private final boolean isOutOfMaxRange(Calendar firstDay, Calendar lastDay) {
        int numberOfSelectedDays = CalendarUtils.getDatesRange(firstDay, lastDay).size() + 1;
        int daysMaxRange = this.calendarProperties.getMaximumDaysRange();
        return daysMaxRange != 0 && numberOfSelectedDays >= daysMaxRange;
    }

    private final boolean isAnotherDaySelected(SelectedDay selectedDay, Calendar day) {
        return !Intrinsics.areEqual((Object)day, (Object)selectedDay.getCalendar()) && this.isCurrentMonthDay(day) && this.isActiveDay(day);
    }

    private final void onClick(Calendar day) {
        EventDay eventDay;
        EventDay eventDay2;
        Object v0;
        block3: {
            if (this.calendarProperties.getEventDays().isEmpty()) {
                this.callOnClickListener(new EventDay(day));
                return;
            }
            Iterable $this$firstOrNull$iv = this.calendarProperties.getEventDays();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                EventDay it = (EventDay)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getCalendar(), (Object)day)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        if ((eventDay2 = (eventDay = (EventDay)v0)) == null) {
            eventDay2 = new EventDay(day);
        }
        this.callOnClickListener(eventDay2);
    }

    private final void callOnClickListener(EventDay eventDay) {
        boolean enabledDay = this.calendarProperties.getDisabledDays().contains(eventDay.getCalendar()) || !DateUtils.isBetweenMinAndMax(eventDay.getCalendar(), this.calendarProperties);
        eventDay.setEnabled(enabledDay);
        OnDayClickListener onDayClickListener = this.calendarProperties.getOnDayClickListener();
        if (onDayClickListener != null) {
            onDayClickListener.onDayClick(eventDay);
        }
    }

    private final void onCalendarDayClick(Calendar day) {
        CalendarDay calendarDay;
        CalendarDay calendarDay2;
        Object v0;
        block3: {
            if (this.calendarProperties.getCalendarDays().isEmpty()) {
                this.callOnCalendarDayClickListener(new CalendarDay(day));
                return;
            }
            Iterable $this$firstOrNull$iv = this.calendarProperties.getCalendarDays();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                CalendarDay it = (CalendarDay)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getCalendar(), (Object)day)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        if ((calendarDay2 = (calendarDay = (CalendarDay)v0)) == null) {
            calendarDay2 = new CalendarDay(day);
        }
        this.callOnCalendarDayClickListener(calendarDay2);
    }

    private final void callOnCalendarDayClickListener(CalendarDay calendarDay) {
        OnCalendarDayClickListener onCalendarDayClickListener = this.calendarProperties.getOnCalendarDayClickListener();
        if (onCalendarDayClickListener != null) {
            onCalendarDayClickListener.onClick(calendarDay);
        }
    }
}

