/*
 * Decompiled with CFR 0.152.
 */
package com.applandeo.materialcalendarview.utils;

import android.content.Context;
import com.applandeo.materialcalendarview.R;
import com.applandeo.materialcalendarview.utils.CalendarProperties;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\u001a\u0014\u0010\u000b\u001a\u00020\f*\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u0012\u0010\u0012\u001a\u00020\u0013*\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001\u001a\u0012\u0010\u0014\u001a\u00020\t*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0012\u0010\u0017\u001a\u00020\t*\u00020\u00012\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0012\u0010\u0018\u001a\u00020\t*\b\u0012\u0004\u0012\u00020\u00010\u0019H\u0000\u001a\u0014\u0010\u001a\u001a\u00020\t*\u0004\u0018\u00010\u00012\u0006\u0010\u001b\u001a\u00020\u0001\u001a\u0016\u0010\u001c\u001a\u00020\t*\u0004\u0018\u00010\u00012\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001\u001a\n\u0010\u001d\u001a\u00020\u0001*\u00020\u0001\"\u001a\u0010\u0000\u001a\u00020\u00018FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0002\u0010\u0003\u001a\u0004\b\u0004\u0010\u0005\"\u0011\u0010\u0006\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\"\u0015\u0010\b\u001a\u00020\t*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006\u001e"}, d2={"calendar", "Ljava/util/Calendar;", "getCalendar$annotations", "()V", "getCalendar", "()Ljava/util/Calendar;", "midnightCalendar", "getMidnightCalendar", "isToday", "", "(Ljava/util/Calendar;)Z", "getDaysToDate", "", "endCalendar", "getMonthAndYearDate", "", "context", "Landroid/content/Context;", "getMonthsToDate", "", "isBetweenMinAndMax", "calendarProperties", "Lcom/applandeo/materialcalendarview/utils/CalendarProperties;", "isEqual", "isFullDatesRange", "", "isMonthAfter", "secondCalendar", "isMonthBefore", "setMidnight", "library_release"})
@JvmName(name="DateUtils")
public final class DateUtils {
    @NotNull
    public static final Calendar getMidnightCalendar() {
        Calendar calendar;
        Calendar $this$_get_midnightCalendar__u24lambda_u2d0 = calendar = Calendar.getInstance();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$_get_midnightCalendar__u24lambda_u2d0, (String)"this");
        DateUtils.setMidnight($this$_get_midnightCalendar__u24lambda_u2d0);
        Calendar calendar2 = calendar;
        Intrinsics.checkNotNullExpressionValue((Object)calendar2, (String)"getInstance().apply {\n  \u2026 this.setMidnight()\n    }");
        return calendar2;
    }

    @NotNull
    public static final Calendar getCalendar() {
        Calendar calendar;
        Calendar $this$_get_calendar__u24lambda_u2d1 = calendar = Calendar.getInstance();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$_get_calendar__u24lambda_u2d1, (String)"this");
        DateUtils.setMidnight($this$_get_calendar__u24lambda_u2d1);
        Calendar calendar2 = calendar;
        Intrinsics.checkNotNullExpressionValue((Object)calendar2, (String)"getInstance().apply {\n  \u2026 this.setMidnight()\n    }");
        return calendar2;
    }

    @Deprecated(message="Use getMidnightCalendar()")
    public static /* synthetic */ void getCalendar$annotations() {
    }

    @NotNull
    public static final Calendar setMidnight(@NotNull Calendar $this$setMidnight) {
        Calendar calendar;
        Intrinsics.checkNotNullParameter((Object)$this$setMidnight, (String)"<this>");
        Calendar $this$setMidnight_u24lambda_u2d2 = calendar = $this$setMidnight;
        boolean bl = false;
        $this$setMidnight_u24lambda_u2d2.set(11, 0);
        $this$setMidnight_u24lambda_u2d2.set(12, 0);
        $this$setMidnight_u24lambda_u2d2.set(13, 0);
        $this$setMidnight_u24lambda_u2d2.set(14, 0);
        return calendar;
    }

    public static final boolean isMonthBefore(@Nullable Calendar $this$isMonthBefore, @Nullable Calendar secondCalendar) {
        Calendar calendar;
        Calendar calendar2;
        if ($this$isMonthBefore == null || secondCalendar == null) {
            return false;
        }
        Calendar $this$isMonthBefore_u24lambda_u2d3 = calendar2 = (Calendar)$this$isMonthBefore.clone();
        boolean bl = false;
        DateUtils.setMidnight($this$isMonthBefore_u24lambda_u2d3);
        $this$isMonthBefore_u24lambda_u2d3.set(5, 1);
        Calendar firstDay = calendar2;
        Calendar $this$isMonthBefore_u24lambda_u2d4 = calendar = (Calendar)secondCalendar.clone();
        boolean bl2 = false;
        DateUtils.setMidnight($this$isMonthBefore_u24lambda_u2d4);
        $this$isMonthBefore_u24lambda_u2d4.set(5, 1);
        Calendar secondDay = calendar;
        return secondDay.before(firstDay);
    }

    public static final boolean isMonthAfter(@Nullable Calendar $this$isMonthAfter, @NotNull Calendar secondCalendar) {
        Intrinsics.checkNotNullParameter((Object)secondCalendar, (String)"secondCalendar");
        return DateUtils.isMonthBefore(secondCalendar, $this$isMonthAfter);
    }

    @NotNull
    public static final String getMonthAndYearDate(@NotNull Calendar $this$getMonthAndYearDate, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$getMonthAndYearDate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = "%s  %s";
        Object[] objectArray = new Object[]{context.getResources().getStringArray(R.array.material_calendar_months_array)[$this$getMonthAndYearDate.get(2)], $this$getMonthAndYearDate.get(1)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    public static final int getMonthsToDate(@NotNull Calendar $this$getMonthsToDate, @NotNull Calendar endCalendar) {
        Intrinsics.checkNotNullParameter((Object)$this$getMonthsToDate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)endCalendar, (String)"endCalendar");
        int years = endCalendar.get(1) - $this$getMonthsToDate.get(1);
        return years * 12 + endCalendar.get(2) - $this$getMonthsToDate.get(2);
    }

    public static final boolean isBetweenMinAndMax(@NotNull Calendar $this$isBetweenMinAndMax, @NotNull CalendarProperties calendarProperties) {
        Intrinsics.checkNotNullParameter((Object)$this$isBetweenMinAndMax, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)calendarProperties, (String)"calendarProperties");
        return !(calendarProperties.getMinimumDate() != null && $this$isBetweenMinAndMax.before(calendarProperties.getMinimumDate()) || calendarProperties.getMaximumDate() != null && $this$isBetweenMinAndMax.after(calendarProperties.getMaximumDate()));
    }

    private static final long getDaysToDate(Calendar $this$getDaysToDate, Calendar endCalendar) {
        $this$getDaysToDate.set(16, 0);
        endCalendar.set(16, 0);
        return TimeUnit.MILLISECONDS.toDays(endCalendar.getTimeInMillis() - $this$getDaysToDate.getTimeInMillis()) + 1L;
    }

    public static final boolean isFullDatesRange(@NotNull List<? extends Calendar> $this$isFullDatesRange) {
        Intrinsics.checkNotNullParameter($this$isFullDatesRange, (String)"<this>");
        Iterable $this$sortedBy$iv = CollectionsKt.distinct((Iterable)$this$isFullDatesRange);
        boolean $i$f$sortedBy = false;
        List selectedDates = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Calendar it = (Calendar)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getTimeInMillis());
                it = (Calendar)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTimeInMillis()));
            }
        });
        if ($this$isFullDatesRange.isEmpty() || selectedDates.size() == 1) {
            return true;
        }
        return (long)selectedDates.size() == DateUtils.getDaysToDate((Calendar)CollectionsKt.first((List)selectedDates), (Calendar)CollectionsKt.last((List)selectedDates));
    }

    public static final boolean isToday(@NotNull Calendar $this$isToday) {
        Intrinsics.checkNotNullParameter((Object)$this$isToday, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isToday, (Object)DateUtils.getMidnightCalendar());
    }

    public static final boolean isEqual(@NotNull Calendar $this$isEqual, @NotNull Calendar calendar) {
        Intrinsics.checkNotNullParameter((Object)$this$isEqual, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        return Intrinsics.areEqual((Object)DateUtils.setMidnight($this$isEqual), (Object)DateUtils.setMidnight(calendar));
    }
}

