/*
 * Decompiled with CFR 0.152.
 */
package com.applandeo.materialcalendarview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import androidx.core.content.ContextCompat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.LongIterator;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002\u001a,\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010\u00a8\u0006\u0012"}, d2={"getCalendarsBetweenDates", "", "Ljava/util/Calendar;", "dateFrom", "Ljava/util/Date;", "dateTo", "getDatesRange", "toCalendar", "getDrawableText", "Landroid/graphics/drawable/Drawable;", "Landroid/content/Context;", "text", "", "typeface", "Landroid/graphics/Typeface;", "color", "", "size", "library_release"})
@JvmName(name="CalendarUtils")
public final class CalendarUtils {
    @NotNull
    public static final Drawable getDrawableText(@NotNull Context $this$getDrawableText, @NotNull String text, @Nullable Typeface typeface, int color, int size) {
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)$this$getDrawableText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Bitmap bitmap = Bitmap.createBitmap((int)48, (int)48, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        float scale = $this$getDrawableText.getResources().getDisplayMetrics().density;
        Paint $this$getDrawableText_u24lambda_u2d0 = paint = new Paint(1);
        boolean bl = false;
        Typeface typeface2 = typeface;
        if (typeface2 == null) {
            typeface2 = Typeface.create((Typeface)Typeface.DEFAULT, (int)1);
        }
        $this$getDrawableText_u24lambda_u2d0.setTypeface(typeface2);
        $this$getDrawableText_u24lambda_u2d0.setColor(ContextCompat.getColor((Context)$this$getDrawableText, (int)color));
        $this$getDrawableText_u24lambda_u2d0.setTextSize((float)((int)((float)size * scale)));
        Paint paint2 = paint;
        Rect bounds = new Rect();
        paint2.getTextBounds(text, 0, text.length(), bounds);
        int x = (bitmap.getWidth() - bounds.width()) / 2;
        int y = (bitmap.getHeight() + bounds.height()) / 2;
        canvas.drawText(text, (float)x, (float)y, paint2);
        return (Drawable)new BitmapDrawable($this$getDrawableText.getResources(), bitmap);
    }

    @NotNull
    public static final List<Calendar> getDatesRange(@NotNull Calendar $this$getDatesRange, @NotNull Calendar toCalendar) {
        List<Calendar> list;
        Intrinsics.checkNotNullParameter((Object)$this$getDatesRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)toCalendar, (String)"toCalendar");
        if (toCalendar.before($this$getDatesRange)) {
            Date date = toCalendar.getTime();
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"toCalendar.time");
            Date date2 = $this$getDatesRange.getTime();
            Intrinsics.checkNotNullExpressionValue((Object)date2, (String)"this.time");
            list = CalendarUtils.getCalendarsBetweenDates(date, date2);
        } else {
            Date date = $this$getDatesRange.getTime();
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"this.time");
            Date date3 = toCalendar.getTime();
            Intrinsics.checkNotNullExpressionValue((Object)date3, (String)"toCalendar.time");
            list = CalendarUtils.getCalendarsBetweenDates(date, date3);
        }
        return list;
    }

    private static final List<Calendar> getCalendarsBetweenDates(Date dateFrom, Date dateTo) {
        Calendar calendar;
        List calendars = new ArrayList();
        Calendar $this$getCalendarsBetweenDates_u24lambda_u2d1 = calendar = Calendar.getInstance();
        boolean bl = false;
        $this$getCalendarsBetweenDates_u24lambda_u2d1.setTime(dateFrom);
        $this$getCalendarsBetweenDates_u24lambda_u2d1.set(16, 0);
        Calendar calendarFrom = calendar;
        Calendar $this$getCalendarsBetweenDates_u24lambda_u2d2 = $this$getCalendarsBetweenDates_u24lambda_u2d1 = Calendar.getInstance();
        boolean bl2 = false;
        $this$getCalendarsBetweenDates_u24lambda_u2d2.setTime(dateTo);
        $this$getCalendarsBetweenDates_u24lambda_u2d2.set(16, 0);
        Calendar calendarTo = $this$getCalendarsBetweenDates_u24lambda_u2d1;
        long daysBetweenDates = TimeUnit.MILLISECONDS.toDays(calendarTo.getTimeInMillis() - calendarFrom.getTimeInMillis());
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)1, (long)daysBetweenDates);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            long element$iv;
            long it = element$iv = ((LongIterator)iterator).nextLong();
            boolean bl3 = false;
            Calendar calendar2 = (Calendar)calendarFrom.clone();
            calendars.add(calendar2);
            calendar2.add(5, (int)it);
        }
        return calendars;
    }
}

