/*
 * Decompiled with CFR 0.152.
 */
package com.applandeo.materialcalendarview;

import android.content.Context;
import android.graphics.Typeface;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.AppCompatButton;
import androidx.core.content.ContextCompat;
import com.applandeo.materialcalendarview.CalendarView;
import com.applandeo.materialcalendarview.R;
import com.applandeo.materialcalendarview.listeners.OnSelectDateListener;
import com.applandeo.materialcalendarview.utils.CalendarProperties;
import com.applandeo.materialcalendarview.utils.DateUtils;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0006\u0010\u0014\u001a\u00020\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/applandeo/materialcalendarview/DatePicker;", "", "context", "Landroid/content/Context;", "calendarProperties", "Lcom/applandeo/materialcalendarview/utils/CalendarProperties;", "(Landroid/content/Context;Lcom/applandeo/materialcalendarview/utils/CalendarProperties;)V", "setDialogButtonsColors", "", "negativeButton", "Landroidx/appcompat/widget/AppCompatButton;", "todayButton", "setDialogButtonsTypeface", "view", "Landroid/view/View;", "setOkButtonState", "enabled", "", "okButton", "setTodayButtonVisibility", "show", "library_release"})
public final class DatePicker {
    @NotNull
    private final Context context;
    @NotNull
    private final CalendarProperties calendarProperties;

    public DatePicker(@NotNull Context context, @NotNull CalendarProperties calendarProperties) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)calendarProperties, (String)"calendarProperties");
        this.context = context;
        this.calendarProperties = calendarProperties;
    }

    @NotNull
    public final DatePicker show() {
        AlertDialog alertDialog;
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.date_picker_dialog, null);
        if (this.calendarProperties.getPagesColor() != 0) {
            view.setBackgroundColor(this.calendarProperties.getPagesColor());
        }
        AppCompatButton appCompatButton = (AppCompatButton)view.findViewById(R.id.todayButton);
        Intrinsics.checkNotNullExpressionValue((Object)appCompatButton, (String)"view.todayButton");
        this.setTodayButtonVisibility(appCompatButton);
        AppCompatButton appCompatButton2 = (AppCompatButton)view.findViewById(R.id.negativeButton);
        Intrinsics.checkNotNullExpressionValue((Object)appCompatButton2, (String)"view.negativeButton");
        AppCompatButton appCompatButton3 = (AppCompatButton)view.findViewById(R.id.todayButton);
        Intrinsics.checkNotNullExpressionValue((Object)appCompatButton3, (String)"view.todayButton");
        this.setDialogButtonsColors(appCompatButton2, appCompatButton3);
        boolean bl = this.calendarProperties.getCalendarType() == 1;
        AppCompatButton appCompatButton4 = (AppCompatButton)view.findViewById(R.id.positiveButton);
        Intrinsics.checkNotNullExpressionValue((Object)appCompatButton4, (String)"view.positiveButton");
        this.setOkButtonState(bl, appCompatButton4);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
        this.setDialogButtonsTypeface(view);
        this.calendarProperties.setOnSelectionAbilityListener((Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(this, view){
            final /* synthetic */ DatePicker this$0;
            final /* synthetic */ View $view;
            {
                this.this$0 = $receiver;
                this.$view = $view;
                super(1);
            }

            public final void invoke(boolean enabled) {
                AppCompatButton appCompatButton = (AppCompatButton)this.$view.findViewById(R.id.positiveButton);
                Intrinsics.checkNotNullExpressionValue((Object)appCompatButton, (String)"view.positiveButton");
                DatePicker.access$setOkButtonState(this.this$0, enabled, appCompatButton);
            }
        }));
        CalendarView calendarView = new CalendarView(this.context, null, 0, this.calendarProperties, 6, null);
        ((FrameLayout)view.findViewById(R.id.calendarContainer)).addView((View)calendarView);
        Calendar calendar = this.calendarProperties.getCalendar();
        if (calendar != null) {
            Object object;
            Calendar it = calendar;
            boolean bl2 = false;
            DatePicker datePicker = this;
            try {
                DatePicker $this$show_u24lambda_u2d1_u24lambda_u2d0 = datePicker;
                boolean bl3 = false;
                calendarView.setDate(it);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Result.box-impl((Object)object);
        }
        AlertDialog $this$show_u24lambda_u2d2 = alertDialog = new AlertDialog.Builder(this.context).create();
        boolean bl4 = false;
        $this$show_u24lambda_u2d2.setView(view);
        AlertDialog alertDialog2 = alertDialog;
        Intrinsics.checkNotNullExpressionValue((Object)alertDialog2, (String)"Builder(context).create(\u2026  setView(view)\n        }");
        AlertDialog alertDialog3 = alertDialog2;
        ((AppCompatButton)view.findViewById(R.id.negativeButton)).setOnClickListener(arg_0 -> DatePicker.show$lambda-3(alertDialog3, arg_0));
        ((AppCompatButton)view.findViewById(R.id.positiveButton)).setOnClickListener(arg_0 -> DatePicker.show$lambda-4(alertDialog3, this, calendarView, arg_0));
        ((AppCompatButton)view.findViewById(R.id.todayButton)).setOnClickListener(arg_0 -> DatePicker.show$lambda-5(calendarView, arg_0));
        alertDialog3.show();
        return this;
    }

    private final void setDialogButtonsTypeface(View view) {
        block0: {
            Typeface typeface = this.calendarProperties.getTypeface();
            if (typeface == null) break block0;
            Typeface typeface2 = typeface;
            boolean bl = false;
            ((AppCompatButton)view.findViewById(R.id.todayButton)).setTypeface(typeface2);
            ((AppCompatButton)view.findViewById(R.id.negativeButton)).setTypeface(typeface2);
            ((AppCompatButton)view.findViewById(R.id.positiveButton)).setTypeface(typeface2);
        }
    }

    private final void setDialogButtonsColors(AppCompatButton negativeButton, AppCompatButton todayButton) {
        if (this.calendarProperties.getDialogButtonsColor() != 0) {
            negativeButton.setTextColor(ContextCompat.getColor((Context)this.context, (int)this.calendarProperties.getDialogButtonsColor()));
            todayButton.setTextColor(ContextCompat.getColor((Context)this.context, (int)this.calendarProperties.getDialogButtonsColor()));
        }
    }

    private final void setOkButtonState(boolean enabled, AppCompatButton okButton) {
        okButton.setEnabled(enabled);
        if (this.calendarProperties.getDialogButtonsColor() == 0) {
            return;
        }
        int stateResource = enabled ? this.calendarProperties.getDialogButtonsColor() : R.color.disabledDialogButtonColor;
        okButton.setTextColor(ContextCompat.getColor((Context)this.context, (int)stateResource));
    }

    private final void setTodayButtonVisibility(AppCompatButton todayButton) {
        block1: {
            Calendar calendar = this.calendarProperties.getMaximumDate();
            if (calendar == null) break block1;
            Calendar it = calendar;
            boolean bl = false;
            if (DateUtils.isMonthBefore(it, DateUtils.getMidnightCalendar()) || DateUtils.isMonthAfter(it, DateUtils.getMidnightCalendar())) {
                todayButton.setVisibility(8);
            }
        }
    }

    private static final void show$lambda-3(AlertDialog $alertDialog, View it) {
        Intrinsics.checkNotNullParameter((Object)$alertDialog, (String)"$alertDialog");
        $alertDialog.cancel();
    }

    private static final void show$lambda-4(AlertDialog $alertDialog, DatePicker this$0, CalendarView $calendarView, View it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$alertDialog, (String)"$alertDialog");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)$calendarView), (String)"$calendarView");
            $alertDialog.cancel();
            OnSelectDateListener onSelectDateListener = this$0.calendarProperties.getOnSelectDateListener();
            if (onSelectDateListener == null) break block0;
            onSelectDateListener.onSelect($calendarView.getSelectedDates());
        }
    }

    private static final void show$lambda-5(CalendarView $calendarView, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$calendarView), (String)"$calendarView");
        $calendarView.showCurrentMonthPage();
    }

    public static final /* synthetic */ void access$setOkButtonState(DatePicker $this, boolean enabled, AppCompatButton okButton) {
        $this.setOkButtonState(enabled, okButton);
    }
}

