/*
 * Decompiled with CFR 0.152.
 */
package com.applandeo.materialcalendarview.adapters;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.applandeo.materialcalendarview.CalendarDay;
import com.applandeo.materialcalendarview.EventDay;
import com.applandeo.materialcalendarview.R;
import com.applandeo.materialcalendarview.adapters.CalendarPageAdapter;
import com.applandeo.materialcalendarview.exceptions.InvalidCustomLayoutException;
import com.applandeo.materialcalendarview.utils.CalendarProperties;
import com.applandeo.materialcalendarview.utils.DayColorsUtils;
import com.applandeo.materialcalendarview.utils.EventDayUtilsKt;
import com.applandeo.materialcalendarview.utils.ImageUtils;
import com.applandeo.materialcalendarview.utils.SelectedDay;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u0019H\u0002J\f\u0010\u001c\u001a\u00020\u001b*\u00020\u0019H\u0002J\f\u0010\u001d\u001a\u00020\u001b*\u00020\u0019H\u0002J\f\u0010\u001e\u001a\u00020\u001b*\u00020\u0019H\u0002J\u0014\u0010\u001f\u001a\u00020\u0015*\u00020 2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/applandeo/materialcalendarview/adapters/CalendarDayAdapter;", "Landroid/widget/ArrayAdapter;", "Ljava/util/Date;", "context", "Landroid/content/Context;", "calendarPageAdapter", "Lcom/applandeo/materialcalendarview/adapters/CalendarPageAdapter;", "calendarProperties", "Lcom/applandeo/materialcalendarview/utils/CalendarProperties;", "dates", "", "pageMonth", "", "(Landroid/content/Context;Lcom/applandeo/materialcalendarview/adapters/CalendarPageAdapter;Lcom/applandeo/materialcalendarview/utils/CalendarProperties;Ljava/util/List;I)V", "getView", "Landroid/view/View;", "position", "view", "parent", "Landroid/view/ViewGroup;", "setLabelColors", "", "dayLabel", "Landroid/widget/TextView;", "day", "Ljava/util/Calendar;", "isActiveDay", "", "isCurrentMonthDay", "isEventDayWithLabelColor", "isSelectedDay", "loadIcon", "Landroid/widget/ImageView;", "library_release"})
public final class CalendarDayAdapter
extends ArrayAdapter<Date> {
    @NotNull
    private final CalendarPageAdapter calendarPageAdapter;
    @NotNull
    private final CalendarProperties calendarProperties;
    private final int pageMonth;

    public CalendarDayAdapter(@NotNull Context context, @NotNull CalendarPageAdapter calendarPageAdapter, @NotNull CalendarProperties calendarProperties, @NotNull List<Date> dates, int pageMonth) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)calendarPageAdapter), (String)"calendarPageAdapter");
        Intrinsics.checkNotNullParameter((Object)calendarProperties, (String)"calendarProperties");
        Intrinsics.checkNotNullParameter(dates, (String)"dates");
        super(context, calendarProperties.getItemLayoutResource(), dates);
        this.calendarPageAdapter = calendarPageAdapter;
        this.calendarProperties = calendarProperties;
        this.pageMonth = pageMonth < 0 ? 11 : pageMonth;
    }

    @SuppressLint(value={"ViewHolder"})
    @NotNull
    public View getView(int position, @Nullable View view, @NotNull ViewGroup parent) {
        GregorianCalendar gregorianCalendar;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        View view2 = view;
        if (view2 == null) {
            view2 = LayoutInflater.from((Context)this.getContext()).inflate(this.calendarProperties.getItemLayoutResource(), parent, false);
        }
        View dayView = view2;
        GregorianCalendar $this$getView_u24lambda_u2d0 = gregorianCalendar = new GregorianCalendar();
        boolean bl = false;
        $this$getView_u24lambda_u2d0.setTime((Date)this.getItem(position));
        GregorianCalendar day = gregorianCalendar;
        ImageView imageView = (ImageView)dayView.findViewById(R.id.dayIcon);
        if (imageView != null) {
            this.loadIcon(imageView, day);
        }
        TextView textView = (TextView)dayView.findViewById(R.id.dayLabel);
        if (textView == null) {
            throw InvalidCustomLayoutException.INSTANCE;
        }
        TextView dayLabel = textView;
        this.setLabelColors(dayLabel, day);
        dayLabel.setTypeface(this.calendarProperties.getTypeface());
        dayLabel.setText((CharSequence)String.valueOf(day.get(5)));
        Intrinsics.checkNotNullExpressionValue((Object)dayView, (String)"dayView");
        return dayView;
    }

    /*
     * WARNING - void declaration
     */
    private final void setLabelColors(TextView dayLabel, Calendar day) {
        if (!this.isCurrentMonthDay(day) && !this.calendarProperties.getSelectionBetweenMonthsEnabled()) {
            DayColorsUtils.setDayColors$default(dayLabel, this.calendarProperties.getAnotherMonthsDaysLabelsColor(), null, 0, 6, null);
        } else if (this.isSelectedDay(day)) {
            Object v0;
            block13: {
                void $this$firstOrNull$iv;
                Iterable iterable = this.calendarPageAdapter.getSelectedDays();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SelectedDay selectedDay = (SelectedDay)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)selectedDay.getCalendar(), (Object)day)) continue;
                    v0 = element$iv;
                    break block13;
                }
                v0 = null;
            }
            SelectedDay selectedDay = v0;
            if (selectedDay != null) {
                SelectedDay selectedDay2 = selectedDay;
                boolean bl = false;
                selectedDay2.setView((View)dayLabel);
            }
            DayColorsUtils.setSelectedDayColors(dayLabel, day, this.calendarProperties);
        } else if (!this.isCurrentMonthDay(day) && this.calendarProperties.getSelectionBetweenMonthsEnabled()) {
            if (!this.calendarPageAdapter.getSelectedDays().contains(new SelectedDay(day, null, 2, null))) {
                DayColorsUtils.setDayColors$default(dayLabel, this.calendarProperties.getAnotherMonthsDaysLabelsColor(), null, 0, 6, null);
            }
        } else if (!this.isActiveDay(day)) {
            DayColorsUtils.setDayColors$default(dayLabel, this.calendarProperties.getDisabledDaysLabelsColor(), null, 0, 6, null);
        } else if (this.isEventDayWithLabelColor(day)) {
            DayColorsUtils.setCurrentMonthDayColors(day, dayLabel, this.calendarProperties);
        } else {
            DayColorsUtils.setCurrentMonthDayColors(day, dayLabel, this.calendarProperties);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSelectedDay(Calendar $this$isSelectedDay) {
        if (this.calendarProperties.getCalendarType() == 0) return false;
        if (!this.calendarPageAdapter.getSelectedDays().contains(new SelectedDay($this$isSelectedDay, null, 2, null))) return false;
        if (this.calendarProperties.getSelectionBetweenMonthsEnabled()) return true;
        if ($this$isSelectedDay.get(2) != this.pageMonth) return false;
        return true;
    }

    private final boolean isEventDayWithLabelColor(Calendar $this$isEventDayWithLabelColor) {
        return EventDayUtilsKt.isEventDayWithLabelColor($this$isEventDayWithLabelColor, this.calendarProperties);
    }

    private final boolean isCurrentMonthDay(Calendar $this$isCurrentMonthDay) {
        return !($this$isCurrentMonthDay.get(2) != this.pageMonth || this.calendarProperties.getMinimumDate() != null && $this$isCurrentMonthDay.before(this.calendarProperties.getMinimumDate()) || this.calendarProperties.getMaximumDate() != null && $this$isCurrentMonthDay.after(this.calendarProperties.getMaximumDate()));
    }

    private final boolean isActiveDay(Calendar $this$isActiveDay) {
        return !this.calendarProperties.getDisabledDays().contains($this$isActiveDay);
    }

    private final void loadIcon(ImageView $this$loadIcon, Calendar day) {
        block11: {
            Object v1;
            block10: {
                Object v0;
                Object it;
                Iterable $this$firstOrNull$iv;
                block9: {
                    if (!this.calendarProperties.getEventsEnabled()) {
                        $this$loadIcon.setVisibility(8);
                        return;
                    }
                    $this$firstOrNull$iv = this.calendarProperties.getCalendarDays();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (CalendarDay)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)((CalendarDay)it).getCalendar(), (Object)day)) continue;
                        v0 = element$iv;
                        break block9;
                    }
                    v0 = null;
                }
                CalendarDay calendarDay = v0;
                if (calendarDay != null) {
                    CalendarDay calendarDay2 = calendarDay;
                    boolean bl = false;
                    Integer imageResource = calendarDay2.getImageResource();
                    if (imageResource != null) {
                        $this$loadIcon.setImageResource(imageResource.intValue());
                    } else {
                        Drawable imageDrawable = calendarDay2.getImageDrawable();
                        if (imageDrawable != null) {
                            $this$loadIcon.setImageDrawable(imageDrawable);
                        }
                    }
                    if (!this.isCurrentMonthDay(day) || !this.isActiveDay(day)) {
                        $this$loadIcon.setAlpha(0.12f);
                    }
                }
                $this$firstOrNull$iv = this.calendarProperties.getEventDays();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (EventDay)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)((EventDay)it).getCalendar(), (Object)day)) continue;
                    v1 = element$iv;
                    break block10;
                }
                v1 = null;
            }
            EventDay eventDay = v1;
            if (eventDay == null) break block11;
            EventDay eventDay2 = eventDay;
            boolean bl = false;
            ImageUtils.loadImage($this$loadIcon, eventDay2.getImageDrawable$library_release());
            if (!this.isCurrentMonthDay(day) || !this.isActiveDay(day)) {
                $this$loadIcon.setAlpha(0.12f);
            }
        }
    }
}

