/*
 * Decompiled with CFR 0.152.
 */
package com.applandeo.materialcalendarview.adapters;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import androidx.viewpager.widget.PagerAdapter;
import com.applandeo.materialcalendarview.CalendarDay;
import com.applandeo.materialcalendarview.R;
import com.applandeo.materialcalendarview.adapters.CalendarDayAdapter;
import com.applandeo.materialcalendarview.extensions.CalendarGridView;
import com.applandeo.materialcalendarview.listeners.DayRowClickListener;
import com.applandeo.materialcalendarview.listeners.DayRowLongClickListener;
import com.applandeo.materialcalendarview.utils.CalendarProperties;
import com.applandeo.materialcalendarview.utils.SelectedDay;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\fJ \u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\nH\u0016J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\u0016H\u0002J\u0018\u0010#\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\nH\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010(\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\nH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006)"}, d2={"Lcom/applandeo/materialcalendarview/adapters/CalendarPageAdapter;", "Landroidx/viewpager/widget/PagerAdapter;", "context", "Landroid/content/Context;", "calendarProperties", "Lcom/applandeo/materialcalendarview/utils/CalendarProperties;", "(Landroid/content/Context;Lcom/applandeo/materialcalendarview/utils/CalendarProperties;)V", "calendarGridView", "Lcom/applandeo/materialcalendarview/extensions/CalendarGridView;", "pageMonth", "", "selectedDay", "Lcom/applandeo/materialcalendarview/utils/SelectedDay;", "getSelectedDay", "()Lcom/applandeo/materialcalendarview/utils/SelectedDay;", "setSelectedDay", "(Lcom/applandeo/materialcalendarview/utils/SelectedDay;)V", "selectedDays", "", "getSelectedDays", "()Ljava/util/List;", "addSelectedDay", "", "destroyItem", "container", "Landroid/view/ViewGroup;", "position", "any", "", "getCount", "getItemPosition", "getPageDaysProperties", "calendar", "Ljava/util/Calendar;", "informDatePicker", "instantiateItem", "isViewFromObject", "", "view", "Landroid/view/View;", "loadMonth", "library_release"})
public final class CalendarPageAdapter
extends PagerAdapter {
    @NotNull
    private final Context context;
    @NotNull
    private final CalendarProperties calendarProperties;
    private CalendarGridView calendarGridView;
    private int pageMonth;

    public CalendarPageAdapter(@NotNull Context context, @NotNull CalendarProperties calendarProperties) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)calendarProperties, (String)"calendarProperties");
        this.context = context;
        this.calendarProperties = calendarProperties;
        this.informDatePicker();
    }

    @NotNull
    public final List<SelectedDay> getSelectedDays() {
        return this.calendarProperties.getSelectedDays();
    }

    @Nullable
    public final SelectedDay getSelectedDay() {
        return (SelectedDay)CollectionsKt.firstOrNull(this.calendarProperties.getSelectedDays());
    }

    public final void setSelectedDay(@Nullable SelectedDay selectedDay) {
        SelectedDay selectedDay2 = selectedDay;
        if (selectedDay2 != null) {
            SelectedDay it = selectedDay2;
            boolean bl = false;
            this.calendarProperties.setSelectedDay(selectedDay);
        }
        this.informDatePicker();
    }

    public int getCount() {
        return 2401;
    }

    public int getItemPosition(@NotNull Object any) {
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        return -2;
    }

    public boolean isViewFromObject(@NotNull View view, @NotNull Object any) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        return view == any;
    }

    @NotNull
    public Object instantiateItem(@NotNull ViewGroup container, int position) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        View view = View.inflate((Context)this.context, (int)R.layout.calendar_view_grid, null);
        if (view == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.applandeo.materialcalendarview.extensions.CalendarGridView");
        }
        this.calendarGridView = (CalendarGridView)view;
        this.loadMonth(position);
        CalendarGridView calendarGridView = this.calendarGridView;
        if (calendarGridView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarGridView");
            calendarGridView = null;
        }
        calendarGridView.setOnItemClickListener(new DayRowClickListener(this, this.calendarProperties, this.pageMonth));
        CalendarGridView calendarGridView2 = this.calendarGridView;
        if (calendarGridView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarGridView");
            calendarGridView2 = null;
        }
        calendarGridView2.setOnItemLongClickListener(new DayRowLongClickListener(this.calendarProperties));
        CalendarGridView calendarGridView3 = this.calendarGridView;
        if (calendarGridView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarGridView");
            calendarGridView3 = null;
        }
        container.addView((View)calendarGridView3);
        CalendarGridView calendarGridView4 = this.calendarGridView;
        if (calendarGridView4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarGridView");
            calendarGridView4 = null;
        }
        return calendarGridView4;
    }

    public final void addSelectedDay(@NotNull SelectedDay selectedDay) {
        Intrinsics.checkNotNullParameter((Object)selectedDay, (String)"selectedDay");
        if (!this.calendarProperties.getSelectedDays().contains(selectedDay)) {
            this.calendarProperties.getSelectedDays().add(selectedDay);
            this.informDatePicker();
            return;
        }
        this.calendarProperties.getSelectedDays().remove(selectedDay);
        this.informDatePicker();
    }

    private final void informDatePicker() {
        block0: {
            Function1<Boolean, Unit> function1 = this.calendarProperties.getOnSelectionAbilityListener();
            if (function1 == null) break block0;
            function1.invoke((Object)(this.calendarProperties.getSelectedDays().size() > 0 ? 1 : 0));
        }
    }

    private final void loadMonth(int position) {
        Calendar calendar;
        List days = new ArrayList();
        Calendar $this$loadMonth_u24lambda_u2d1 = calendar = (Calendar)this.calendarProperties.getFirstPageCalendarDate().clone();
        boolean bl = false;
        $this$loadMonth_u24lambda_u2d1.add(2, position);
        $this$loadMonth_u24lambda_u2d1.set(5, 1);
        Calendar calendar2 = calendar;
        this.getPageDaysProperties(calendar2);
        int dayOfWeek = calendar2.get(7);
        int firstDayOfWeek = this.calendarProperties.getFirstDayOfWeek();
        int monthBeginningCell = (dayOfWeek < firstDayOfWeek ? 7 : 0) + dayOfWeek - firstDayOfWeek;
        calendar2.add(5, -monthBeginningCell);
        while (days.size() < 42) {
            Date date = calendar2.getTime();
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"calendar.time");
            days.add(date);
            calendar2.add(5, 1);
        }
        this.pageMonth = calendar2.get(2) - 1;
        CalendarDayAdapter calendarDayAdapter = new CalendarDayAdapter(this.context, this, this.calendarProperties, days, this.pageMonth);
        this.informDatePicker();
        CalendarGridView calendarGridView = this.calendarGridView;
        if (calendarGridView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"calendarGridView");
            calendarGridView = null;
        }
        calendarGridView.setAdapter((ListAdapter)calendarDayAdapter);
    }

    private final void getPageDaysProperties(Calendar calendar) {
        List pageCalendarDays;
        Function1<Calendar, List<CalendarDay>> function1 = this.calendarProperties.getOnPagePrepareListener();
        List list = pageCalendarDays = function1 != null ? (List)function1.invoke((Object)calendar) : null;
        if (pageCalendarDays != null) {
            List diff = CollectionsKt.distinct((Iterable)CollectionsKt.minus((Iterable)pageCalendarDays, (Iterable)this.calendarProperties.getCalendarDays()));
            this.calendarProperties.getCalendarDays().addAll(diff);
        }
    }

    public void destroyItem(@NotNull ViewGroup container, int position, @NotNull Object any) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        container.removeView((View)any);
    }
}

