/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.annotation;

import com.privatefasterxml.jackson.annotation.JacksonAnnotation;
import com.privatefasterxml.jackson.annotation.JacksonAnnotationValue;
import com.privatefasterxml.jackson.annotation.OptBoolean;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@JacksonAnnotation
public @interface JacksonInject {
    public String value() default "";

    public OptBoolean useInput() default OptBoolean.DEFAULT;

    public static class Value
    implements JacksonAnnotationValue<JacksonInject>,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected static final Value EMPTY = new Value(null, null);
        protected final Object _id;
        protected final Boolean _useInput;

        public Value(Object object, Boolean bl) {
            this._id = object;
            this._useInput = bl;
        }

        public static Value empty() {
            return EMPTY;
        }

        public static Value construct(Object object, Boolean bl) {
            if ("".equals(object)) {
                object = null;
            }
            if (Value._empty(object, bl)) {
                return EMPTY;
            }
            return new Value(object, bl);
        }

        public static Value from(JacksonInject jacksonInject) {
            if (jacksonInject == null) {
                return EMPTY;
            }
            return Value.construct(jacksonInject.value(), jacksonInject.useInput().asBoolean());
        }

        public static Value forId(Object object) {
            return Value.construct(object, null);
        }

        private static boolean _empty(Object object, Boolean bl) {
            return object == null && bl == null;
        }

        @Override
        public Class<JacksonInject> valueFor() {
            return JacksonInject.class;
        }

        public Value withId(Object object) {
            if (object == null ? this._id == null : object.equals(this._id)) {
                return this;
            }
            return new Value(object, this._useInput);
        }

        public Value withUseInput(Boolean bl) {
            if (bl == null ? this._useInput == null : bl.equals(this._useInput)) {
                return this;
            }
            return new Value(this._id, bl);
        }

        public Object getId() {
            return this._id;
        }

        public Boolean getUseInput() {
            return this._useInput;
        }

        public boolean hasId() {
            return this._id != null;
        }

        public boolean willUseInput(boolean bl) {
            Serializable serializable = ((Value)serializable)._useInput;
            if (serializable != null) {
                bl = (Boolean)serializable;
            }
            return bl;
        }

        public String toString() {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this._id;
            objectArray[1] = this._useInput;
            return String.format("JacksonInject.Value(id=%s,useInput=%s)", objectArray2);
        }

        public int hashCode() {
            int n2 = 1;
            Object object = ((Value)this)._id;
            if (object != null) {
                n2 = object.hashCode() + n2;
            }
            if ((this = ((Value)this)._useInput) != null) {
                n2 = ((Boolean)this).hashCode() + n2;
            }
            return n2;
        }

        public boolean equals(Object object) {
            if (object == object2) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (object.getClass() == object2.getClass()) {
                object = (Value)object;
                if (OptBoolean.equals(((Value)object2)._useInput, ((Value)object)._useInput)) {
                    Object object2 = ((Value)object2)._id;
                    if (object2 == null) {
                        return ((Value)object)._id == null;
                    }
                    return object2.equals(((Value)object)._id);
                }
            }
            return false;
        }
    }
}

