/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.annotation;

import com.privatefasterxml.jackson.annotation.JacksonAnnotation;
import com.privatefasterxml.jackson.annotation.JacksonAnnotationValue;
import com.privatefasterxml.jackson.annotation.OptBoolean;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Locale;
import java.util.TimeZone;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@JacksonAnnotation
public @interface JsonFormat {
    public static final String DEFAULT_LOCALE = "##default";
    public static final String DEFAULT_TIMEZONE = "##default";

    public String pattern() default "";

    public Shape shape() default Shape.ANY;

    public String locale() default "##default";

    public String timezone() default "##default";

    public OptBoolean lenient() default OptBoolean.DEFAULT;

    public Feature[] with() default {};

    public Feature[] without() default {};

    public static class Value
    implements JacksonAnnotationValue<JsonFormat>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final Value EMPTY = new Value();
        private final String _pattern;
        private final Shape _shape;
        private final Locale _locale;
        private final String _timezoneStr;
        private final Boolean _lenient;
        private final Features _features;
        private transient TimeZone _timezone;

        public Value() {
            Value value = features;
            Features features = Features.empty();
            value("", Shape.ANY, "", "", features, null);
        }

        public Value(JsonFormat jsonFormat) {
            Value value = object;
            JsonFormat jsonFormat2 = jsonFormat;
            Object object = jsonFormat2.pattern();
            Shape shape = jsonFormat2.shape();
            String string = jsonFormat2.locale();
            String string2 = jsonFormat2.timezone();
            Features features = Features.construct(jsonFormat2);
            Object object2 = object;
            object = jsonFormat.lenient().asBoolean();
            value((String)object2, shape, string, string2, features, (Boolean)object);
        }

        public Value(String string, Shape shape, String string2, String string3, Features features, Boolean bl) {
            Locale locale;
            if (string2 != null && string2.length() != 0 && !"##default".equals(string2)) {
                Locale locale2;
                locale = locale2;
                locale2 = new Locale(string2);
            } else {
                locale = null;
            }
            if (string3 == null || string3.length() == 0 || "##default".equals(string3)) {
                string3 = null;
            }
            this(string, shape, locale, string3, null, features, bl);
        }

        public Value(String string, Shape shape, Locale locale, TimeZone timeZone, Features features, Boolean bl) {
            if (string == null) {
                string = "";
            }
            this._pattern = string;
            if (shape == null) {
                shape = Shape.ANY;
            }
            Value value = this;
            value._shape = shape;
            value._locale = locale;
            value._timezone = timeZone;
            value._timezoneStr = null;
            if (features == null) {
                features = Features.empty();
            }
            Value value2 = this;
            value2._features = features;
            value2._lenient = bl;
        }

        public Value(String string, Shape shape, Locale locale, String string2, TimeZone timeZone, Features features, Boolean bl) {
            if (string == null) {
                string = "";
            }
            this._pattern = string;
            if (shape == null) {
                shape = Shape.ANY;
            }
            Value value = this;
            value._shape = shape;
            value._locale = locale;
            value._timezone = timeZone;
            value._timezoneStr = string2;
            if (features == null) {
                features = Features.empty();
            }
            Value value2 = this;
            value2._features = features;
            value2._lenient = bl;
        }

        @Deprecated
        public Value(String string, Shape shape, Locale locale, String string2, TimeZone timeZone, Features features) {
            this(string, shape, locale, string2, timeZone, features, null);
        }

        @Deprecated
        public Value(String string, Shape shape, String string2, String string3, Features features) {
            this(string, shape, string2, string3, features, null);
        }

        @Deprecated
        public Value(String string, Shape shape, Locale locale, TimeZone timeZone, Features features) {
            this(string, shape, locale, timeZone, features, null);
        }

        public static final Value empty() {
            return EMPTY;
        }

        public static Value merge(Value value, Value value2) {
            if (value != null) {
                value2 = value.withOverrides(value2);
            }
            return value2;
        }

        public static Value mergeAll(Value ... valueArray) {
            Value value = null;
            for (Value value2 : valueArray) {
                if (value2 == null) continue;
                if (value != null) {
                    value2 = value.withOverrides(value2);
                }
                value = value2;
            }
            return value;
        }

        public static final Value from(JsonFormat object) {
            if (object == null) {
                object = EMPTY;
            } else {
                Value value;
                Value value2 = value;
                value = new Value((JsonFormat)object);
                object = value2;
            }
            return object;
        }

        public static Value forPattern(String string) {
            Features features = Features.empty();
            return new Value(string, null, null, null, null, features, null);
        }

        public static Value forShape(Shape shape) {
            Features features = Features.empty();
            return new Value("", shape, null, null, null, features, null);
        }

        public static Value forLeniency(boolean bl) {
            Features features = Features.empty();
            Boolean bl2 = bl;
            return new Value("", null, null, null, null, features, bl2);
        }

        private static <T> boolean _equal(T t2, T t3) {
            if (t2 == null) {
                return t3 == null;
            }
            if (t3 == null) {
                return false;
            }
            return t2.equals(t3);
        }

        public final Value withOverrides(Value value) {
            Object object;
            if (value != null && value != (object = EMPTY) && value != serializable) {
                Serializable serializable;
                String string;
                Features features;
                Locale locale;
                Shape shape;
                if (serializable == object) {
                    return value;
                }
                object = value._pattern;
                if (object == null || ((String)object).isEmpty()) {
                    object = serializable._pattern;
                }
                if ((shape = value._shape) == Shape.ANY) {
                    shape = serializable._shape;
                }
                if ((locale = value._locale) == null) {
                    locale = serializable._locale;
                }
                features = (features = serializable._features) == null ? value._features : features.withOverrides(value._features);
                Boolean bl = value._lenient;
                if (bl == null) {
                    bl = serializable._lenient;
                }
                if ((string = value._timezoneStr) != null && !string.isEmpty()) {
                    serializable = value._timezone;
                } else {
                    Value value2 = serializable;
                    string = value2._timezoneStr;
                    serializable = value2._timezone;
                }
                return new Value((String)object, shape, locale, string, (TimeZone)serializable, features, bl);
            }
            return serializable;
        }

        public Value withPattern(String string) {
            Value value = object;
            Object object = value._shape;
            Locale locale = value._locale;
            String string2 = value._timezoneStr;
            TimeZone timeZone = value._timezone;
            Features features = value._features;
            Boolean bl = value._lenient;
            return new Value(string, (Shape)((Object)object), locale, string2, timeZone, features, bl);
        }

        public Value withShape(Shape shape) {
            if (shape == ((Value)((Object)string))._shape) {
                return string;
            }
            Value value = string;
            String string = value._pattern;
            Locale locale = value._locale;
            String string2 = value._timezoneStr;
            TimeZone timeZone = value._timezone;
            Features features = value._features;
            Boolean bl = value._lenient;
            return new Value(string, shape, locale, string2, timeZone, features, bl);
        }

        public Value withLocale(Locale locale) {
            Value value = string;
            String string = value._pattern;
            Shape shape = value._shape;
            String string2 = value._timezoneStr;
            TimeZone timeZone = value._timezone;
            Features features = value._features;
            Boolean bl = value._lenient;
            return new Value(string, shape, locale, string2, timeZone, features, bl);
        }

        public Value withTimeZone(TimeZone timeZone) {
            Value value = string;
            String string = value._pattern;
            Shape shape = value._shape;
            Locale locale = value._locale;
            Features features = value._features;
            Boolean bl = value._lenient;
            return new Value(string, shape, locale, null, timeZone, features, bl);
        }

        public Value withLenient(Boolean bl) {
            if (bl == ((Value)((Object)string))._lenient) {
                return string;
            }
            Value value = string;
            String string = value._pattern;
            Shape shape = value._shape;
            Locale locale = value._locale;
            String string2 = value._timezoneStr;
            TimeZone timeZone = value._timezone;
            Features features = value._features;
            return new Value(string, shape, locale, string2, timeZone, features, bl);
        }

        public Value withFeature(Feature object) {
            if ((object = ((Value)object2)._features.with(new Feature[]{object})) != ((Value)object2)._features) {
                Value value;
                Value value2 = value;
                Value value3 = object2;
                Object object2 = value3._pattern;
                Shape shape = value3._shape;
                Locale locale = value3._locale;
                String string = value3._timezoneStr;
                TimeZone timeZone = value3._timezone;
                Boolean bl = value3._lenient;
                value = new Value((String)object2, shape, locale, string, timeZone, (Features)object, bl);
                object2 = value2;
            }
            return object2;
        }

        public Value withoutFeature(Feature object) {
            if ((object = ((Value)object2)._features.without(new Feature[]{object})) != ((Value)object2)._features) {
                Value value;
                Value value2 = value;
                Value value3 = object2;
                Object object2 = value3._pattern;
                Shape shape = value3._shape;
                Locale locale = value3._locale;
                String string = value3._timezoneStr;
                TimeZone timeZone = value3._timezone;
                Boolean bl = value3._lenient;
                value = new Value((String)object2, shape, locale, string, timeZone, (Features)object, bl);
                object2 = value2;
            }
            return object2;
        }

        @Override
        public Class<JsonFormat> valueFor() {
            return JsonFormat.class;
        }

        public String getPattern() {
            return this._pattern;
        }

        public Shape getShape() {
            return this._shape;
        }

        public Locale getLocale() {
            return this._locale;
        }

        public Boolean getLenient() {
            return this._lenient;
        }

        public boolean isLenient() {
            return Boolean.TRUE.equals(this._lenient);
        }

        public String timeZoneAsString() {
            TimeZone timeZone = this._timezone;
            if (timeZone != null) {
                return timeZone.getID();
            }
            return this._timezoneStr;
        }

        public TimeZone getTimeZone() {
            Object object = this._timezone;
            if (object == null) {
                object = this._timezoneStr;
                if (object == null) {
                    return null;
                }
                object = TimeZone.getTimeZone((String)object);
                this._timezone = object;
            }
            return object;
        }

        public boolean hasShape() {
            return this._shape != Shape.ANY;
        }

        public boolean hasPattern() {
            String string = ((Value)((Object)string))._pattern;
            return string != null && string.length() > 0;
        }

        public boolean hasLocale() {
            return this._locale != null;
        }

        public boolean hasTimeZone() {
            return ((Value)this)._timezone != null || (this = ((Value)this)._timezoneStr) != null && !((String)this).isEmpty();
        }

        public boolean hasLenient() {
            return this._lenient != null;
        }

        public Boolean getFeature(Feature feature) {
            return this._features.get(feature);
        }

        public Features getFeatures() {
            return this._features;
        }

        public String toString() {
            Object[] objectArray = new Object[6];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this._pattern;
            objectArray2[1] = this._shape;
            objectArray2[2] = this._lenient;
            objectArray2[3] = this._locale;
            objectArray2[4] = this._timezoneStr;
            objectArray[5] = this._features;
            return String.format("JsonFormat.Value(pattern=%s,shape=%s,lenient=%s,locale=%s,timezone=%s,features=%s)", objectArray2);
        }

        public int hashCode() {
            String string = this._timezoneStr;
            int n2 = string == null ? 1 : string.hashCode();
            Object object = this._pattern;
            if (object != null) {
                n2 ^= ((String)object).hashCode();
            }
            Value value = this;
            n2 = ((Object)((Object)value._shape)).hashCode() + n2;
            object = value._lenient;
            if (object != null) {
                n2 ^= ((Boolean)object).hashCode();
            }
            if ((object = this._locale) != null) {
                n2 = ((Locale)object).hashCode() + n2;
            }
            return n2 ^ this._features.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            object = (Value)object;
            if (this._shape == ((Value)object)._shape && this._features.equals(((Value)object)._features)) {
                return Value._equal(this._lenient, ((Value)object)._lenient) && Value._equal(this._timezoneStr, ((Value)object)._timezoneStr) && Value._equal(this._pattern, ((Value)object)._pattern) && Value._equal(this._timezone, ((Value)object)._timezone) && Value._equal(this._locale, ((Value)object)._locale);
            }
            return false;
        }
    }

    public static class Features {
        private static final Features EMPTY = new Features(0, 0);
        private final int _enabled;
        private final int _disabled;

        private Features(int n2, int n3) {
            this._enabled = n2;
            this._disabled = n3;
        }

        public static Features empty() {
            return EMPTY;
        }

        public static Features construct(JsonFormat jsonFormat) {
            return Features.construct(jsonFormat.with(), jsonFormat.without());
        }

        public static Features construct(Feature[] featureArray, Feature[] featureArray2) {
            int n2;
            int n3 = 0;
            int n4 = featureArray.length;
            for (n2 = 0; n2 < n4; ++n2) {
                n3 |= 1 << featureArray[n2].ordinal();
            }
            int n5 = 0;
            n4 = featureArray2.length;
            for (n2 = 0; n2 < n4; ++n2) {
                n5 |= 1 << featureArray2[n2].ordinal();
            }
            return new Features(n3, n5);
        }

        public Features withOverrides(Features features) {
            if (features == null) {
                return this;
            }
            int n2 = features._disabled;
            int n3 = features._enabled;
            if (n2 == 0 && n3 == 0) {
                return this;
            }
            int n4 = this._enabled;
            if (n4 == 0 && this._disabled == 0) {
                return features;
            }
            int n5 = n4 & ~n2 | n3;
            int n6 = n4;
            n4 = this._disabled;
            n2 = n4 & ~n3 | n2;
            if (n5 == n6 && n2 == n4) {
                return this;
            }
            return new Features(n5, n2);
        }

        public Features with(Feature ... object) {
            int n2 = object2._enabled;
            int n3 = ((Feature[])object).length;
            for (int i2 = 0; i2 < n3; ++i2) {
                n2 |= 1 << object[i2].ordinal();
            }
            if (n2 != object2._enabled) {
                Features features;
                object = features;
                features = new Features(n2, object2._disabled);
                Object object2 = object;
            }
            return object2;
        }

        public Features without(Feature ... object) {
            int n2 = object2._disabled;
            int n3 = ((Feature[])object).length;
            for (int i2 = 0; i2 < n3; ++i2) {
                n2 |= 1 << object[i2].ordinal();
            }
            if (n2 != object2._disabled) {
                Features features;
                object = features;
                features = new Features(object2._enabled, n2);
                Object object2 = object;
            }
            return object2;
        }

        public Boolean get(Feature feature) {
            int n2 = 1 << feature.ordinal();
            if ((this._disabled & n2) != 0) {
                return Boolean.FALSE;
            }
            if ((this._enabled & n2) != 0) {
                return Boolean.TRUE;
            }
            return null;
        }

        public String toString() {
            if (this == EMPTY) {
                return "EMPTY";
            }
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this._enabled;
            objectArray[1] = this._disabled;
            return String.format("(enabled=0x%x,disabled=0x%x)", objectArray2);
        }

        public int hashCode() {
            return this._disabled + this._enabled;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            object = (Features)object;
            return ((Features)object)._enabled == this._enabled && ((Features)object)._disabled == this._disabled;
        }
    }

    public static enum Feature {
        ACCEPT_SINGLE_VALUE_AS_ARRAY,
        ACCEPT_CASE_INSENSITIVE_PROPERTIES,
        ACCEPT_CASE_INSENSITIVE_VALUES,
        WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS,
        WRITE_DATES_WITH_ZONE_ID,
        WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED,
        WRITE_SORTED_MAP_ENTRIES,
        ADJUST_DATES_TO_CONTEXT_TIME_ZONE;

    }

    public static enum Shape {
        ANY,
        NATURAL,
        SCALAR,
        ARRAY,
        OBJECT,
        NUMBER,
        NUMBER_FLOAT,
        NUMBER_INT,
        STRING,
        BOOLEAN,
        BINARY;


        public boolean isNumeric() {
            return this == NUMBER || this == NUMBER_INT || this == NUMBER_FLOAT;
        }

        public boolean isStructured() {
            return this == OBJECT || this == ARRAY;
        }
    }
}

