/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.annotation;

import com.privatefasterxml.jackson.annotation.JacksonAnnotation;
import com.privatefasterxml.jackson.annotation.JacksonAnnotationValue;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.TYPE, ElementType.METHOD, ElementType.CONSTRUCTOR, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@JacksonAnnotation
public @interface JsonIgnoreProperties {
    public String[] value() default {};

    public boolean ignoreUnknown() default false;

    public boolean allowGetters() default false;

    public boolean allowSetters() default false;

    public static class Value
    implements JacksonAnnotationValue<JsonIgnoreProperties>,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected static final Value EMPTY = new Value(Collections.emptySet(), false, false, false, true);
        protected final Set<String> _ignored;
        protected final boolean _ignoreUnknown;
        protected final boolean _allowGetters;
        protected final boolean _allowSetters;
        protected final boolean _merge;

        public Value(Set<String> set, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this._ignored = set == null ? Collections.emptySet() : set;
            Value value = this;
            value._ignoreUnknown = bl;
            value._allowGetters = bl2;
            value._allowSetters = bl3;
            value._merge = bl4;
        }

        public static Value from(JsonIgnoreProperties jsonIgnoreProperties) {
            if (jsonIgnoreProperties == null) {
                return EMPTY;
            }
            JsonIgnoreProperties jsonIgnoreProperties2 = jsonIgnoreProperties;
            boolean bl = jsonIgnoreProperties2.ignoreUnknown();
            boolean bl2 = jsonIgnoreProperties2.allowGetters();
            boolean bl3 = jsonIgnoreProperties2.allowSetters();
            return Value.construct(Value._asSet(jsonIgnoreProperties.value()), bl, bl2, bl3, false);
        }

        public static Value construct(Set<String> set, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            if (Value._empty(set, bl, bl2, bl3, bl4)) {
                return EMPTY;
            }
            return new Value(set, bl, bl2, bl3, bl4);
        }

        public static Value empty() {
            return EMPTY;
        }

        public static Value merge(Value value, Value value2) {
            if (value != null) {
                value2 = value.withOverrides(value2);
            }
            return value2;
        }

        public static Value mergeAll(Value ... valueArray) {
            Value value = null;
            for (Value value2 : valueArray) {
                if (value2 == null) continue;
                if (value != null) {
                    value2 = value.withOverrides(value2);
                }
                value = value2;
            }
            return value;
        }

        public static Value forIgnoredProperties(Set<String> set) {
            return EMPTY.withIgnored(set);
        }

        public static Value forIgnoredProperties(String ... stringArray) {
            if (stringArray.length == 0) {
                return EMPTY;
            }
            return EMPTY.withIgnored(Value._asSet(stringArray));
        }

        public static Value forIgnoreUnknown(boolean bl) {
            return bl ? EMPTY.withIgnoreUnknown() : EMPTY.withoutIgnoreUnknown();
        }

        private static boolean _equals(Value value, Value value2) {
            return value._ignoreUnknown == value2._ignoreUnknown && value._merge == value2._merge && value._allowGetters == value2._allowGetters && value._allowSetters == value2._allowSetters && value._ignored.equals(value2._ignored);
        }

        private static Set<String> _asSet(String[] stringArray) {
            if (stringArray != null && stringArray.length != 0) {
                HashSet<String> hashSet;
                HashSet<String> hashSet2 = hashSet;
                hashSet = new HashSet<String>(stringArray.length);
                int n2 = stringArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    hashSet2.add(stringArray[i2]);
                }
                return hashSet2;
            }
            return Collections.emptySet();
        }

        private static Set<String> _merge(Set<String> set, Set<String> set2) {
            HashSet<String> hashSet;
            if (set.isEmpty()) {
                return set2;
            }
            if (set2.isEmpty()) {
                return set;
            }
            HashSet<String> hashSet2 = hashSet;
            int n2 = set.size();
            hashSet2(set2.size() + n2);
            hashSet2.addAll(set);
            hashSet.addAll(set2);
            return hashSet;
        }

        private static boolean _empty(Set<String> set, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            Value value = EMPTY;
            if (bl == value._ignoreUnknown && bl2 == value._allowGetters && bl3 == value._allowSetters && bl4 == value._merge) {
                return set == null || set.size() == 0;
            }
            return false;
        }

        public Value withOverrides(Value value) {
            if (value != null && value != EMPTY) {
                if (!value._merge) {
                    return value;
                }
                if (Value._equals(this, value)) {
                    return this;
                }
                Value value2 = this;
                Set<String> set = Value._merge(value2._ignored, value._ignored);
                boolean bl = value2._ignoreUnknown || value._ignoreUnknown;
                boolean bl2 = this._allowGetters || value._allowGetters;
                boolean bl3 = this._allowSetters || value._allowSetters;
                return Value.construct(set, bl, bl2, bl3, true);
            }
            return this;
        }

        public Value withIgnored(Set<String> set) {
            Value value = this;
            boolean bl = value._ignoreUnknown;
            boolean bl2 = value._allowGetters;
            boolean bl3 = value._allowSetters;
            boolean bl4 = value._merge;
            return Value.construct(set, bl, bl2, bl3, bl4);
        }

        public Value withIgnored(String ... stringArray) {
            Value value = this;
            boolean bl = value._ignoreUnknown;
            boolean bl2 = value._allowGetters;
            boolean bl3 = value._allowSetters;
            boolean bl4 = value._merge;
            return Value.construct(Value._asSet(stringArray), bl, bl2, bl3, bl4);
        }

        public Value withoutIgnored() {
            Value value = this;
            boolean bl = value._ignoreUnknown;
            boolean bl2 = value._allowGetters;
            boolean bl3 = value._allowSetters;
            boolean bl4 = value._merge;
            return Value.construct(null, bl, bl2, bl3, bl4);
        }

        public Value withIgnoreUnknown() {
            if (!value2._ignoreUnknown) {
                Value value = value2;
                boolean bl = value._allowGetters;
                boolean bl2 = value._allowSetters;
                boolean bl3 = value._merge;
                Value value2 = Value.construct(value2._ignored, true, bl, bl2, bl3);
            }
            return value2;
        }

        public Value withoutIgnoreUnknown() {
            if (value2._ignoreUnknown) {
                Value value = value2;
                boolean bl = value._allowGetters;
                boolean bl2 = value._allowSetters;
                boolean bl3 = value._merge;
                Value value2 = Value.construct(value2._ignored, false, bl, bl2, bl3);
            }
            return value2;
        }

        public Value withAllowGetters() {
            if (!value2._allowGetters) {
                Value value = value2;
                boolean bl = value._ignoreUnknown;
                boolean bl2 = value._allowSetters;
                boolean bl3 = value._merge;
                Value value2 = Value.construct(value2._ignored, bl, true, bl2, bl3);
            }
            return value2;
        }

        public Value withoutAllowGetters() {
            if (value2._allowGetters) {
                Value value = value2;
                boolean bl = value._ignoreUnknown;
                boolean bl2 = value._allowSetters;
                boolean bl3 = value._merge;
                Value value2 = Value.construct(value2._ignored, bl, false, bl2, bl3);
            }
            return value2;
        }

        public Value withAllowSetters() {
            if (!value2._allowSetters) {
                Value value = value2;
                boolean bl = value._ignoreUnknown;
                boolean bl2 = value._allowGetters;
                boolean bl3 = value._merge;
                Value value2 = Value.construct(value2._ignored, bl, bl2, true, bl3);
            }
            return value2;
        }

        public Value withoutAllowSetters() {
            if (value2._allowSetters) {
                Value value = value2;
                boolean bl = value._ignoreUnknown;
                boolean bl2 = value._allowGetters;
                boolean bl3 = value._merge;
                Value value2 = Value.construct(value2._ignored, bl, bl2, false, bl3);
            }
            return value2;
        }

        public Value withMerge() {
            if (!value2._merge) {
                Value value = value2;
                boolean bl = value._ignoreUnknown;
                boolean bl2 = value._allowGetters;
                boolean bl3 = value._allowSetters;
                Value value2 = Value.construct(value2._ignored, bl, bl2, bl3, true);
            }
            return value2;
        }

        public Value withoutMerge() {
            if (value2._merge) {
                Value value = value2;
                boolean bl = value._ignoreUnknown;
                boolean bl2 = value._allowGetters;
                boolean bl3 = value._allowSetters;
                Value value2 = Value.construct(value2._ignored, bl, bl2, bl3, false);
            }
            return value2;
        }

        @Override
        public Class<JsonIgnoreProperties> valueFor() {
            return JsonIgnoreProperties.class;
        }

        public Object readResolve() {
            Value value = this;
            boolean bl = value._ignoreUnknown;
            boolean bl2 = value._allowGetters;
            boolean bl3 = value._allowSetters;
            boolean bl4 = value._merge;
            if (Value._empty(this._ignored, bl, bl2, bl3, bl4)) {
                return EMPTY;
            }
            return this;
        }

        public Set<String> getIgnored() {
            return this._ignored;
        }

        public Set<String> findIgnoredForSerialization() {
            if (this._allowGetters) {
                return Collections.emptySet();
            }
            return this._ignored;
        }

        public Set<String> findIgnoredForDeserialization() {
            if (this._allowSetters) {
                return Collections.emptySet();
            }
            return this._ignored;
        }

        public boolean getIgnoreUnknown() {
            return this._ignoreUnknown;
        }

        public boolean getAllowGetters() {
            return this._allowGetters;
        }

        public boolean getAllowSetters() {
            return this._allowSetters;
        }

        public boolean getMerge() {
            return this._merge;
        }

        public String toString() {
            Object[] objectArray = new Object[5];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this._ignored;
            objectArray2[1] = this._ignoreUnknown;
            objectArray2[2] = this._allowGetters;
            objectArray2[3] = this._allowSetters;
            objectArray[4] = this._merge;
            return String.format("JsonIgnoreProperties.Value(ignored=%s,ignoreUnknown=%s,allowGetters=%s,allowSetters=%s,merge=%s)", objectArray2);
        }

        public int hashCode() {
            Value value = this;
            int n2 = value._ignored.size();
            int n3 = value._ignoreUnknown ? 1 : -3;
            n2 += n3;
            n3 = this._allowGetters ? 3 : -7;
            n2 += n3;
            n3 = this._allowSetters ? 7 : -11;
            int n4 = n2 + n3;
            n2 = this._merge ? 11 : -13;
            return n4 + n2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            return object.getClass() == this.getClass() && Value._equals(this, (Value)object);
        }
    }
}

