/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.annotation;

import com.privatefasterxml.jackson.annotation.JacksonAnnotation;
import com.privatefasterxml.jackson.annotation.JacksonAnnotationValue;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.TYPE, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@JacksonAnnotation
public @interface JsonInclude {
    public Include value() default Include.ALWAYS;

    public Include content() default Include.ALWAYS;

    public Class<?> valueFilter() default Void.class;

    public Class<?> contentFilter() default Void.class;

    public static class Value
    implements JacksonAnnotationValue<JsonInclude>,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected static final Value EMPTY;
        protected final Include _valueInclusion;
        protected final Include _contentInclusion;
        protected final Class<?> _valueFilter;
        protected final Class<?> _contentFilter;

        public Value(JsonInclude object) {
            Value value = object2;
            JsonInclude jsonInclude = object;
            Object object2 = jsonInclude.value();
            object = jsonInclude.content();
            Class<?> clazz = jsonInclude.valueFilter();
            Class<?> clazz2 = jsonInclude.contentFilter();
            value((Include)((Object)object2), (Include)((Object)object), clazz, clazz2);
        }

        public Value(Include include, Include include2, Class<?> clazz, Class<?> clazz2) {
            if (include == null) {
                include = Include.USE_DEFAULTS;
            }
            this._valueInclusion = include;
            if (include2 == null) {
                include2 = Include.USE_DEFAULTS;
            }
            this._contentInclusion = include2;
            if (clazz == Void.class) {
                clazz = null;
            }
            this._valueFilter = clazz;
            if (clazz2 == Void.class) {
                clazz2 = null;
            }
            this._contentFilter = clazz2;
        }

        public static Value empty() {
            return EMPTY;
        }

        public static Value merge(Value value, Value value2) {
            if (value != null) {
                value2 = value.withOverrides(value2);
            }
            return value2;
        }

        public static Value mergeAll(Value ... valueArray) {
            Value value = null;
            for (Value value2 : valueArray) {
                if (value2 == null) continue;
                if (value != null) {
                    value2 = value.withOverrides(value2);
                }
                value = value2;
            }
            return value;
        }

        public static Value construct(Include include, Include include2) {
            Include include3 = Include.USE_DEFAULTS;
            if (include != include3 && include != null || include2 != include3 && include2 != null) {
                return new Value(include, include2, null, null);
            }
            return EMPTY;
        }

        public static Value construct(Include include, Include include2, Class<?> clazz, Class<?> clazz2) {
            Include include3;
            if (clazz == Void.class) {
                clazz = null;
            }
            if (clazz2 == Void.class) {
                clazz2 = null;
            }
            if (!(include != (include3 = Include.USE_DEFAULTS) && include != null || include2 != include3 && include2 != null || clazz != null || clazz2 != null)) {
                return EMPTY;
            }
            return new Value(include, include2, clazz, clazz2);
        }

        public static Value from(JsonInclude object) {
            if (object == null) {
                return EMPTY;
            }
            Include include = object.value();
            Include include2 = object.content();
            Object object2 = Include.USE_DEFAULTS;
            if (include == object2 && include2 == object2) {
                return EMPTY;
            }
            object2 = object.valueFilter();
            if (object2 == Void.class) {
                object2 = null;
            }
            if ((object = object.contentFilter()) == Void.class) {
                object = null;
            }
            return new Value(include, include2, (Class<?>)object2, (Class<?>)object);
        }

        static {
            Include include = Include.USE_DEFAULTS;
            EMPTY = new Value(include, include, null, null);
        }

        public Object readResolve() {
            Include include = Include.USE_DEFAULTS;
            if (this._valueInclusion == include && this._contentInclusion == include && this._valueFilter == null && this._contentFilter == null) {
                return EMPTY;
            }
            return this;
        }

        public Value withOverrides(Value object) {
            if (object != null && object != EMPTY) {
                Include include = object._valueInclusion;
                Value value = object;
                object = value._contentInclusion;
                Class<?> clazz = value._valueFilter;
                Class<?> clazz2 = value._contentFilter;
                Include include2 = this._valueInclusion;
                boolean bl = include != include2 && include != Include.USE_DEFAULTS;
                Include include3 = this._contentInclusion;
                boolean bl2 = object != include3 && object != Include.USE_DEFAULTS;
                Class<?> clazz3 = this._valueFilter;
                boolean bl3 = clazz != clazz3 || clazz2 != clazz3;
                if (bl) {
                    if (bl2) {
                        return new Value(include, (Include)((Object)object), clazz, clazz2);
                    }
                    return new Value(include, include3, clazz, clazz2);
                }
                if (bl2) {
                    return new Value(include2, (Include)((Object)object), clazz, clazz2);
                }
                if (bl3) {
                    return new Value(include2, include3, clazz, clazz2);
                }
                return this;
            }
            return this;
        }

        public Value withValueInclusion(Include include) {
            if (include != object._valueInclusion) {
                Value value;
                Value value2 = value;
                Value value3 = object;
                Object object = value3._contentInclusion;
                Class<?> clazz = value3._valueFilter;
                Class<?> clazz2 = value3._contentFilter;
                value = new Value(include, (Include)((Object)object), clazz, clazz2);
                object = value2;
            }
            return object;
        }

        public Value withValueFilter(Class<?> clazz) {
            Object object;
            if (clazz != null && clazz != Void.class) {
                object = Include.CUSTOM;
            } else {
                object = Include.USE_DEFAULTS;
                clazz = null;
            }
            Include include = object;
            Value value = object2;
            Object object2 = value._contentInclusion;
            object = value._contentFilter;
            return Value.construct(include, (Include)((Object)object2), clazz, object);
        }

        public Value withContentFilter(Class<?> clazz) {
            Include include;
            if (clazz != null && clazz != Void.class) {
                include = Include.CUSTOM;
            } else {
                include = Include.USE_DEFAULTS;
                clazz = null;
            }
            return Value.construct(this._valueInclusion, include, this._valueFilter, clazz);
        }

        public Value withContentInclusion(Include include) {
            if (include != object._contentInclusion) {
                Value value;
                Value value2 = value;
                Value value3 = object;
                Object object = value3._valueInclusion;
                Class<?> clazz = value3._valueFilter;
                Class<?> clazz2 = value3._contentFilter;
                value = new Value((Include)((Object)object), include, clazz, clazz2);
                object = value2;
            }
            return object;
        }

        @Override
        public Class<JsonInclude> valueFor() {
            return JsonInclude.class;
        }

        public Include getValueInclusion() {
            return this._valueInclusion;
        }

        public Include getContentInclusion() {
            return this._contentInclusion;
        }

        public Class<?> getValueFilter() {
            return this._valueFilter;
        }

        public Class<?> getContentFilter() {
            return this._contentFilter;
        }

        public String toString() {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            new StringBuilder(80).append("JsonInclude.Value(value=").append((Object)this._valueInclusion).append(",content=").append((Object)this._contentInclusion);
            if (this._valueFilter != null) {
                stringBuilder2.append(",valueFilter=").append(this._valueFilter.getName()).append(".class");
            }
            if (this._contentFilter != null) {
                stringBuilder2.append(",contentFilter=").append(this._contentFilter.getName()).append(".class");
            }
            return stringBuilder2.append(')').toString();
        }

        public int hashCode() {
            Value value = this;
            int n2 = ((Object)((Object)value._valueInclusion)).hashCode() << 2;
            return ((Object)((Object)value._contentInclusion)).hashCode() + n2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            object = (Value)object;
            return ((Value)object)._valueInclusion == this._valueInclusion && ((Value)object)._contentInclusion == this._contentInclusion && ((Value)object)._valueFilter == this._valueFilter && ((Value)object)._contentFilter == this._contentFilter;
        }
    }

    public static enum Include {
        ALWAYS,
        NON_NULL,
        NON_ABSENT,
        NON_EMPTY,
        NON_DEFAULT,
        CUSTOM,
        USE_DEFAULTS;

    }
}

