/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.annotation;

import com.privatefasterxml.jackson.annotation.JacksonAnnotation;
import com.privatefasterxml.jackson.annotation.JacksonAnnotationValue;
import com.privatefasterxml.jackson.annotation.Nulls;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@JacksonAnnotation
public @interface JsonSetter {
    public String value() default "";

    public Nulls nulls() default Nulls.DEFAULT;

    public Nulls contentNulls() default Nulls.DEFAULT;

    public static class Value
    implements JacksonAnnotationValue<JsonSetter>,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected static final Value EMPTY;
        private final Nulls _nulls;
        private final Nulls _contentNulls;

        public Value(Nulls nulls, Nulls nulls2) {
            this._nulls = nulls;
            this._contentNulls = nulls2;
        }

        public static Value from(JsonSetter jsonSetter) {
            if (jsonSetter == null) {
                return EMPTY;
            }
            return Value.construct(jsonSetter.nulls(), jsonSetter.contentNulls());
        }

        public static Value construct(Nulls nulls, Nulls nulls2) {
            if (nulls == null) {
                nulls = Nulls.DEFAULT;
            }
            if (nulls2 == null) {
                nulls2 = Nulls.DEFAULT;
            }
            if (Value._empty(nulls, nulls2)) {
                return EMPTY;
            }
            return new Value(nulls, nulls2);
        }

        public static Value empty() {
            return EMPTY;
        }

        public static Value merge(Value value, Value value2) {
            if (value != null) {
                value2 = value.withOverrides(value2);
            }
            return value2;
        }

        public static Value forValueNulls(Nulls nulls) {
            return Value.construct(nulls, Nulls.DEFAULT);
        }

        public static Value forValueNulls(Nulls nulls, Nulls nulls2) {
            return Value.construct(nulls, nulls2);
        }

        public static Value forContentNulls(Nulls nulls) {
            return Value.construct(Nulls.DEFAULT, nulls);
        }

        private static boolean _empty(Nulls nulls, Nulls nulls2) {
            return nulls == (nulls = Nulls.DEFAULT) && nulls2 == nulls;
        }

        static {
            Nulls nulls = Nulls.DEFAULT;
            EMPTY = new Value(nulls, nulls);
        }

        @Override
        public Class<JsonSetter> valueFor() {
            return JsonSetter.class;
        }

        public Object readResolve() {
            if (Value._empty(this._nulls, this._contentNulls)) {
                return EMPTY;
            }
            return this;
        }

        public Value withOverrides(Value object) {
            if (object != null && object != EMPTY) {
                Nulls nulls = object._nulls;
                object = object._contentNulls;
                Nulls nulls2 = Nulls.DEFAULT;
                if (nulls == nulls2) {
                    nulls = this._nulls;
                }
                if (object == nulls2) {
                    object = this._contentNulls;
                }
                if (nulls == this._nulls && object == this._contentNulls) {
                    return this;
                }
                return Value.construct(nulls, (Nulls)((Object)object));
            }
            return this;
        }

        public Value withValueNulls(Nulls nulls) {
            if (nulls == null) {
                nulls = Nulls.DEFAULT;
            }
            if (nulls == this._nulls) {
                return this;
            }
            return Value.construct(nulls, this._contentNulls);
        }

        public Value withValueNulls(Nulls nulls, Nulls nulls2) {
            if (nulls == null) {
                nulls = Nulls.DEFAULT;
            }
            if (nulls2 == null) {
                nulls2 = Nulls.DEFAULT;
            }
            if (nulls == this._nulls && nulls2 == this._contentNulls) {
                return this;
            }
            return Value.construct(nulls, nulls2);
        }

        public Value withContentNulls(Nulls nulls) {
            if (nulls == null) {
                nulls = Nulls.DEFAULT;
            }
            if (nulls == this._contentNulls) {
                return this;
            }
            return Value.construct(this._nulls, nulls);
        }

        public Nulls getValueNulls() {
            return this._nulls;
        }

        public Nulls getContentNulls() {
            return this._contentNulls;
        }

        public Nulls nonDefaultValueNulls() {
            Object object = object._nulls;
            if (object == Nulls.DEFAULT) {
                object = null;
            }
            return object;
        }

        public Nulls nonDefaultContentNulls() {
            Object object = object._contentNulls;
            if (object == Nulls.DEFAULT) {
                object = null;
            }
            return object;
        }

        public String toString() {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this._nulls;
            objectArray[1] = this._contentNulls;
            return String.format("JsonSetter.Value(valueNulls=%s,contentNulls=%s)", objectArray2);
        }

        public int hashCode() {
            return this._nulls.ordinal() + (this._contentNulls.ordinal() << 2);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (object.getClass() == this.getClass()) {
                object = (Value)object;
                return ((Value)object)._nulls == this._nulls && ((Value)object)._contentNulls == this._contentNulls;
            }
            return false;
        }
    }
}

