/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.annotation;

import com.privatefasterxml.jackson.annotation.ObjectIdGenerator;
import com.privatefasterxml.jackson.annotation.b;
import java.io.Serializable;
import java.util.UUID;

public class ObjectIdGenerators {

    public static final class StringIdGenerator
    extends b {
        private static final long serialVersionUID = 1L;

        public StringIdGenerator() {
            this(Object.class);
        }

        private StringIdGenerator(Class<?> clazz) {
            super(Object.class);
        }

        public ObjectIdGenerator<String> forScope(Class<?> clazz) {
            return this;
        }

        public ObjectIdGenerator<String> newForSerialization(Object object) {
            return this;
        }

        @Override
        public String generateId(Object object) {
            return UUID.randomUUID().toString();
        }

        @Override
        public ObjectIdGenerator.IdKey key(Object object) {
            if (object == null) {
                return null;
            }
            return new ObjectIdGenerator.IdKey(StringIdGenerator.class, null, object);
        }

        @Override
        public boolean canUseFor(ObjectIdGenerator<?> objectIdGenerator) {
            return objectIdGenerator instanceof StringIdGenerator;
        }
    }

    public static final class UUIDGenerator
    extends b {
        private static final long serialVersionUID = 1L;

        public UUIDGenerator() {
            this(Object.class);
        }

        private UUIDGenerator(Class<?> clazz) {
            super(Object.class);
        }

        public ObjectIdGenerator<UUID> forScope(Class<?> clazz) {
            return this;
        }

        public ObjectIdGenerator<UUID> newForSerialization(Object object) {
            return this;
        }

        @Override
        public UUID generateId(Object object) {
            return UUID.randomUUID();
        }

        @Override
        public ObjectIdGenerator.IdKey key(Object object) {
            if (object == null) {
                return null;
            }
            return new ObjectIdGenerator.IdKey(UUIDGenerator.class, null, object);
        }

        @Override
        public boolean canUseFor(ObjectIdGenerator<?> objectIdGenerator) {
            return objectIdGenerator.getClass() == UUIDGenerator.class;
        }
    }

    public static final class IntSequenceGenerator
    extends b {
        private static final long serialVersionUID = 1L;
        protected transient int _nextValue;

        public IntSequenceGenerator() {
            this(Object.class, -1);
        }

        public IntSequenceGenerator(Class<?> clazz, int n2) {
            super(clazz);
            this._nextValue = n2;
        }

        public int initialValue() {
            return 1;
        }

        public ObjectIdGenerator<Integer> forScope(Class<?> clazz) {
            if (intSequenceGenerator3._scope != clazz) {
                IntSequenceGenerator intSequenceGenerator;
                IntSequenceGenerator intSequenceGenerator2 = intSequenceGenerator;
                intSequenceGenerator = new IntSequenceGenerator(clazz, intSequenceGenerator3._nextValue);
                IntSequenceGenerator intSequenceGenerator3 = intSequenceGenerator2;
            }
            return intSequenceGenerator3;
        }

        public ObjectIdGenerator<Integer> newForSerialization(Object object) {
            IntSequenceGenerator intSequenceGenerator = serializable;
            Serializable serializable = intSequenceGenerator._scope;
            return new IntSequenceGenerator((Class<?>)serializable, intSequenceGenerator.initialValue());
        }

        @Override
        public ObjectIdGenerator.IdKey key(Object object) {
            if (object == null) {
                return null;
            }
            return new ObjectIdGenerator.IdKey(IntSequenceGenerator.class, this._scope, object);
        }

        @Override
        public Integer generateId(Object object) {
            if (object == null) {
                return null;
            }
            int n2 = this._nextValue;
            this._nextValue = n2 + 1;
            return n2;
        }
    }

    public static abstract class PropertyGenerator
    extends b {
        private static final long serialVersionUID = 1L;

        public PropertyGenerator(Class<?> clazz) {
            super(clazz);
        }
    }

    public static abstract class None
    extends ObjectIdGenerator<Object> {
    }
}

