/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core;

import com.privatefasterxml.jackson.core.Base64Variants;
import com.privatefasterxml.jackson.core.util.ByteArrayBuilder;
import java.io.Serializable;
import java.util.Arrays;

public final class Base64Variant
implements Serializable {
    private static final int INT_SPACE = 32;
    private static final long serialVersionUID = 1L;
    protected static final char PADDING_CHAR_NONE = '\u0000';
    public static final int BASE64_VALUE_INVALID = -1;
    public static final int BASE64_VALUE_PADDING = -2;
    private final transient int[] _asciiToBase64;
    private final transient char[] _base64ToAsciiC;
    private final transient byte[] _base64ToAsciiB;
    final String _name;
    private final char _paddingChar;
    private final int _maxLineLength;
    private final boolean _writePadding;
    private final PaddingReadBehaviour _paddingReadBehaviour;

    public Base64Variant(String object, String string, boolean bl, char c2, int n2) {
        String string2 = object;
        int[] nArray = new int[128];
        object = nArray;
        this._asciiToBase64 = nArray;
        char[] cArray = new char[64];
        this._base64ToAsciiC = cArray;
        this._base64ToAsciiB = new byte[64];
        this._name = string2;
        this._writePadding = bl;
        this._paddingChar = c2;
        this._maxLineLength = n2;
        int n3 = string.length();
        if (n3 == 64) {
            string.getChars(0, n3, cArray, 0);
            Arrays.fill((int[])object, -1);
            int n4 = 0;
            while (n4 < n3) {
                Base64Variant base64Variant = this;
                char c3 = base64Variant._base64ToAsciiC[n4];
                base64Variant._base64ToAsciiB[n4] = (byte)c3;
                base64Variant._asciiToBase64[c3] = n4++;
            }
            if (bl) {
                this._asciiToBase64[c2] = -2;
            }
            PaddingReadBehaviour paddingReadBehaviour = bl ? PaddingReadBehaviour.PADDING_REQUIRED : PaddingReadBehaviour.PADDING_FORBIDDEN;
            this._paddingReadBehaviour = paddingReadBehaviour;
            return;
        }
        throw new IllegalArgumentException("Base64Alphabet length must be exactly 64 (was " + n3 + ")");
    }

    public Base64Variant(Base64Variant base64Variant, String string, int n2) {
        Base64Variant base64Variant2 = base64Variant;
        boolean bl = base64Variant2._writePadding;
        char c2 = base64Variant2._paddingChar;
        this(base64Variant, string, bl, c2, n2);
    }

    public Base64Variant(Base64Variant base64Variant, String string, boolean bl, char c2, int n2) {
        Base64Variant base64Variant2 = object;
        Object object = base64Variant._paddingReadBehaviour;
        base64Variant2(base64Variant, string, bl, c2, (PaddingReadBehaviour)((Object)object), n2);
    }

    private Base64Variant(Base64Variant object, String string, boolean bl, char c2, PaddingReadBehaviour paddingReadBehaviour, int n2) {
        Base64Variant base64Variant = object2;
        Base64Variant base64Variant2 = object;
        int[] nArray = new int[128];
        Object object2 = nArray;
        v3._asciiToBase64 = nArray;
        char[] cArray = new char[64];
        object = cArray;
        v3._base64ToAsciiC = cArray;
        byte[] byArray = new byte[64];
        v3._base64ToAsciiB = byArray;
        v3._name = string;
        int n3 = base64Variant2._base64ToAsciiB.length;
        System.arraycopy(base64Variant2._base64ToAsciiB, 0, byArray, 0, n3);
        n3 = base64Variant2._base64ToAsciiC.length;
        System.arraycopy(base64Variant2._base64ToAsciiC, 0, object, 0, n3);
        int n4 = base64Variant2._asciiToBase64.length;
        System.arraycopy(base64Variant2._asciiToBase64, 0, object2, 0, n4);
        base64Variant._writePadding = bl;
        base64Variant._paddingChar = c2;
        base64Variant._maxLineLength = n2;
        base64Variant._paddingReadBehaviour = paddingReadBehaviour;
    }

    private Base64Variant(Base64Variant base64Variant, PaddingReadBehaviour paddingReadBehaviour) {
        Base64Variant base64Variant2 = string;
        Base64Variant base64Variant3 = base64Variant;
        String string = base64Variant3._name;
        boolean bl = base64Variant3._writePadding;
        char c2 = base64Variant3._paddingChar;
        int n2 = base64Variant3._maxLineLength;
        base64Variant2(base64Variant, string, bl, c2, paddingReadBehaviour, n2);
    }

    public Base64Variant withPaddingAllowed() {
        return this.withReadPadding(PaddingReadBehaviour.PADDING_ALLOWED);
    }

    public Base64Variant withPaddingRequired() {
        return this.withReadPadding(PaddingReadBehaviour.PADDING_REQUIRED);
    }

    public Base64Variant withPaddingForbidden() {
        return this.withReadPadding(PaddingReadBehaviour.PADDING_FORBIDDEN);
    }

    public Base64Variant withReadPadding(PaddingReadBehaviour paddingReadBehaviour) {
        if (paddingReadBehaviour != base64Variant3._paddingReadBehaviour) {
            Base64Variant base64Variant;
            Base64Variant base64Variant2 = base64Variant;
            base64Variant = new Base64Variant(base64Variant3, paddingReadBehaviour);
            Base64Variant base64Variant3 = base64Variant2;
        }
        return base64Variant3;
    }

    public Base64Variant withWritePadding(boolean bl) {
        if (bl != base64Variant4._writePadding) {
            Base64Variant base64Variant;
            Base64Variant base64Variant2 = base64Variant;
            Base64Variant base64Variant3 = base64Variant4;
            String string = base64Variant3._name;
            char c2 = base64Variant3._paddingChar;
            int n2 = base64Variant3._maxLineLength;
            base64Variant = new Base64Variant(base64Variant4, string, bl, c2, n2);
            Base64Variant base64Variant4 = base64Variant2;
        }
        return base64Variant4;
    }

    public Object readResolve() {
        Base64Variant base64Variant = string;
        Base64Variant base64Variant2 = Base64Variants.valueOf(base64Variant._name);
        char c2 = base64Variant._writePadding;
        char c3 = base64Variant2._writePadding;
        if (c2 == c3 && ((Base64Variant)((Object)string))._paddingChar == base64Variant2._paddingChar && ((Base64Variant)((Object)string))._paddingReadBehaviour == base64Variant2._paddingReadBehaviour && ((Base64Variant)((Object)string))._maxLineLength == base64Variant2._maxLineLength && c2 == c3) {
            return base64Variant2;
        }
        Base64Variant base64Variant3 = string;
        String string = base64Variant3._name;
        c3 = base64Variant3._paddingChar;
        PaddingReadBehaviour paddingReadBehaviour = base64Variant3._paddingReadBehaviour;
        int n2 = base64Variant3._maxLineLength;
        return new Base64Variant(base64Variant2, string, c2 != '\u0000', c3, paddingReadBehaviour, n2);
    }

    public String getName() {
        return this._name;
    }

    public boolean usesPadding() {
        return this._writePadding;
    }

    public boolean requiresPaddingOnRead() {
        return this._paddingReadBehaviour == PaddingReadBehaviour.PADDING_REQUIRED;
    }

    public boolean acceptsPaddingOnRead() {
        return this._paddingReadBehaviour != PaddingReadBehaviour.PADDING_FORBIDDEN;
    }

    public boolean usesPaddingChar(char c2) {
        return c2 == this._paddingChar;
    }

    public boolean usesPaddingChar(int n2) {
        return n2 == this._paddingChar;
    }

    public PaddingReadBehaviour paddingReadBehaviour() {
        return this._paddingReadBehaviour;
    }

    public char getPaddingChar() {
        return this._paddingChar;
    }

    public byte getPaddingByte() {
        return (byte)this._paddingChar;
    }

    public int getMaxLineLength() {
        return this._maxLineLength;
    }

    public int decodeBase64Char(char c2) {
        return c2 <= '\u007f' ? this._asciiToBase64[c2] : -1;
    }

    public int decodeBase64Char(int n2) {
        return n2 <= 127 ? this._asciiToBase64[n2] : -1;
    }

    public int decodeBase64Byte(byte by) {
        if (by < 0) {
            return -1;
        }
        return this._asciiToBase64[by];
    }

    public char encodeBase64BitsAsChar(int n2) {
        return this._base64ToAsciiC[n2];
    }

    public int encodeBase64Chunk(int n2, char[] cArray, int n3) {
        int n4 = n3;
        int n5 = n3 + 1;
        char[] cArray2 = this._base64ToAsciiC;
        int n6 = n5;
        cArray[n3] = cArray2[n2 >> 18 & 0x3F];
        n5 = n3 + 2;
        cArray[n6] = cArray2[n2 >> 12 & 0x3F];
        cArray[n5] = this._base64ToAsciiC[n2 >> 6 & 0x3F];
        cArray[n3 += 3] = cArray2[n2 & 0x3F];
        return n4 + 4;
    }

    public void encodeBase64Chunk(StringBuilder stringBuilder, int n2) {
        stringBuilder.append(this._base64ToAsciiC[n2 >> 18 & 0x3F]);
        stringBuilder.append(this._base64ToAsciiC[n2 >> 12 & 0x3F]);
        stringBuilder.append(this._base64ToAsciiC[n2 >> 6 & 0x3F]);
        stringBuilder.append(this._base64ToAsciiC[n2 & 0x3F]);
    }

    public int encodeBase64Partial(int n2, int n3, char[] cArray, int n4) {
        int n5 = n4 + 1;
        char[] cArray2 = this._base64ToAsciiC;
        int n6 = n5;
        cArray[n4] = cArray2[n2 >> 18 & 0x3F];
        n5 = n4 + 2;
        cArray[n6] = cArray2[n2 >> 12 & 0x3F];
        if (this.usesPadding()) {
            int n7 = n3;
            n3 = n4 + 3;
            n2 = n7 == 2 ? this._base64ToAsciiC[n2 >> 6 & 0x3F] : (int)this._paddingChar;
            cArray[n5] = n2;
            n5 = n4 + 4;
            cArray[n3] = this._paddingChar;
        } else if (n3 == 2) {
            int n8 = n5;
            n5 = n4 + 3;
            cArray[n8] = this._base64ToAsciiC[n2 >> 6 & 0x3F];
        }
        return n5;
    }

    public void encodeBase64Partial(StringBuilder stringBuilder, int n2, int n3) {
        stringBuilder.append(this._base64ToAsciiC[n2 >> 18 & 0x3F]);
        stringBuilder.append(this._base64ToAsciiC[n2 >> 12 & 0x3F]);
        if (this.usesPadding()) {
            n2 = n3 == 2 ? this._base64ToAsciiC[n2 >> 6 & 0x3F] : (int)this._paddingChar;
            stringBuilder.append((char)n2);
            stringBuilder.append(this._paddingChar);
        } else if (n3 == 2) {
            stringBuilder.append(this._base64ToAsciiC[n2 >> 6 & 0x3F]);
        }
    }

    public byte encodeBase64BitsAsByte(int n2) {
        return this._base64ToAsciiB[n2];
    }

    public int encodeBase64Chunk(int n2, byte[] byArray, int n3) {
        int n4 = n3;
        int n5 = n3 + 1;
        byte[] byArray2 = this._base64ToAsciiB;
        int n6 = n5;
        byArray[n3] = byArray2[n2 >> 18 & 0x3F];
        n5 = n3 + 2;
        byArray[n6] = byArray2[n2 >> 12 & 0x3F];
        byArray[n5] = this._base64ToAsciiB[n2 >> 6 & 0x3F];
        byArray[n3 += 3] = byArray2[n2 & 0x3F];
        return n4 + 4;
    }

    public int encodeBase64Partial(int n2, int n3, byte[] byArray, int n4) {
        int n5 = n4 + 1;
        byte[] byArray2 = this._base64ToAsciiB;
        int n6 = n5;
        byArray[n4] = byArray2[n2 >> 18 & 0x3F];
        n5 = n4 + 2;
        byArray[n6] = byArray2[n2 >> 12 & 0x3F];
        if (this.usesPadding()) {
            int n7 = n3;
            n3 = (byte)this._paddingChar;
            int n8 = n4 + 3;
            int n9 = n7 == 2 ? this._base64ToAsciiB[n2 >> 6 & 0x3F] : n3;
            byArray[n5] = n9;
            n5 = n4 + 4;
            byArray[n8] = n3;
        } else if (n3 == 2) {
            int n10 = n5;
            n5 = n4 + 3;
            byArray[n10] = this._base64ToAsciiB[n2 >> 6 & 0x3F];
        }
        return n5;
    }

    public String encode(byte[] byArray) {
        return this.encode(byArray, false);
    }

    public String encode(byte[] byArray, boolean bl) {
        int n2;
        StringBuilder stringBuilder;
        int n3 = byArray.length;
        StringBuilder stringBuilder2 = stringBuilder;
        int n4 = n3;
        stringBuilder = new StringBuilder(n4 + (n4 >> 2) + (n3 >> 3));
        if (bl) {
            stringBuilder2.append('\"');
        }
        int n5 = this.getMaxLineLength() >> 2;
        int n6 = n3 - 3;
        for (n2 = 0; n2 <= n6; n2 += 3) {
            int n7;
            int n8 = n2;
            int n9 = n7 = n8 + 1;
            n7 = n2 + 2;
            this.encodeBase64Chunk(stringBuilder2, (byArray[n8] << 8 | byArray[n9] & 0xFF) << 8 | byArray[n7] & 0xFF);
            if ((n5 += -1) > 0) continue;
            StringBuilder stringBuilder3 = stringBuilder2;
            stringBuilder3.append('\\');
            stringBuilder3.append('n');
            n5 = this.getMaxLineLength() >> 2;
        }
        if ((n3 -= n2) > 0) {
            int n10 = n2;
            n5 = n10 + 1;
            n2 = byArray[n10] << 16;
            if (n3 == 2) {
                n2 |= (byArray[n5] & 0xFF) << 8;
            }
            this.encodeBase64Partial(stringBuilder2, n2, n3);
        }
        if (bl) {
            stringBuilder2.append('\"');
        }
        return stringBuilder2.toString();
    }

    public String encode(byte[] byArray, boolean bl, String string) {
        int n2;
        StringBuilder stringBuilder;
        int n3 = byArray.length;
        StringBuilder stringBuilder2 = stringBuilder;
        int n4 = n3;
        stringBuilder = new StringBuilder(n4 + (n4 >> 2) + (n3 >> 3));
        if (bl) {
            stringBuilder2.append('\"');
        }
        int n5 = this.getMaxLineLength() >> 2;
        int n6 = n3 - 3;
        for (n2 = 0; n2 <= n6; n2 += 3) {
            int n7;
            int n8 = n2;
            int n9 = n7 = n8 + 1;
            n7 = n2 + 2;
            this.encodeBase64Chunk(stringBuilder2, (byArray[n8] << 8 | byArray[n9] & 0xFF) << 8 | byArray[n7] & 0xFF);
            if ((n5 += -1) > 0) continue;
            stringBuilder2.append(string);
            n5 = this.getMaxLineLength() >> 2;
        }
        int n10 = n3 - n2;
        if (n10 > 0) {
            int n11 = n2;
            n3 = n11 + 1;
            n5 = byArray[n11] << 16;
            if (n10 == 2) {
                n5 |= (byArray[n3] & 0xFF) << 8;
            }
            this.encodeBase64Partial(stringBuilder2, n5, n10);
        }
        if (bl) {
            stringBuilder2.append('\"');
        }
        return stringBuilder2.toString();
    }

    public byte[] decode(String string) {
        ByteArrayBuilder byteArrayBuilder;
        Base64Variant base64Variant = byteArrayBuilder2;
        ByteArrayBuilder byteArrayBuilder2 = byteArrayBuilder;
        byteArrayBuilder = new ByteArrayBuilder();
        base64Variant.decode(string, byteArrayBuilder2);
        return byteArrayBuilder2.toByteArray();
    }

    public void decode(String string, ByteArrayBuilder byteArrayBuilder) {
        int n2 = 0;
        int n3 = string.length();
        while (true) {
            int n4;
            block16: {
                int n5;
                char c2;
                block19: {
                    block20: {
                        block15: {
                            int n6;
                            block17: {
                                block18: {
                                    if (n2 >= n3) break block15;
                                    n4 = n2 + 1;
                                    c2 = string.charAt(n2);
                                    if (c2 <= ' ') break block16;
                                    n5 = this.decodeBase64Char(c2);
                                    if (n5 < 0) {
                                        this._reportInvalidBase64(c2, 0, null);
                                    }
                                    if (n4 >= n3) {
                                        this._reportBase64EOF();
                                    }
                                    c2 = n2 + 2;
                                    n6 = this.decodeBase64Char((char)(n4 = (int)string.charAt(n4)));
                                    if (n6 < 0) {
                                        this._reportInvalidBase64((char)n4, 1, null);
                                    }
                                    n4 = n5 << 6 | n6;
                                    if (c2 < n3) break block17;
                                    if (this.requiresPaddingOnRead()) break block18;
                                    byteArrayBuilder.append(n4 >> 4);
                                    break block15;
                                }
                                this._reportBase64EOF();
                            }
                            n5 = n2 + 3;
                            n6 = this.decodeBase64Char(c2 = (char)string.charAt(c2));
                            if (n6 < 0) {
                                if (n6 != -2) {
                                    this._reportInvalidBase64(c2, 2, null);
                                }
                                if (!this.acceptsPaddingOnRead()) {
                                    this._reportBase64UnexpectedPadding();
                                }
                                if (n5 >= n3) {
                                    this._reportBase64EOF();
                                }
                                n2 += 4;
                                c2 = string.charAt(n5);
                                if (!this.usesPaddingChar(c2)) {
                                    String string2 = "expected padding character '" + this.getPaddingChar() + "'";
                                    this._reportInvalidBase64(c2, 3, string2);
                                }
                                byteArrayBuilder.append(n4 >> 4);
                                continue;
                            }
                            n4 = n4 << 6 | n6;
                            if (n5 < n3) break block19;
                            if (this.requiresPaddingOnRead()) break block20;
                            byteArrayBuilder.appendTwoBytes(n4 >> 2);
                        }
                        return;
                    }
                    this._reportBase64EOF();
                }
                n2 += 4;
                c2 = string.charAt(n5);
                if ((n5 = this.decodeBase64Char(c2)) < 0) {
                    if (n5 != -2) {
                        this._reportInvalidBase64(c2, 3, null);
                    }
                    if (!this.acceptsPaddingOnRead()) {
                        this._reportBase64UnexpectedPadding();
                    }
                    byteArrayBuilder.appendTwoBytes(n4 >> 2);
                    continue;
                }
                byteArrayBuilder.appendThreeBytes(n4 << 6 | n5);
                continue;
            }
            n2 = n4;
        }
    }

    public String toString() {
        return this._name;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == Base64Variant.class) {
            object = (Base64Variant)object;
            return ((Base64Variant)object)._paddingChar == this._paddingChar && ((Base64Variant)object)._maxLineLength == this._maxLineLength && ((Base64Variant)object)._writePadding == this._writePadding && ((Base64Variant)object)._paddingReadBehaviour == this._paddingReadBehaviour && this._name.equals(((Base64Variant)object)._name);
        }
        return false;
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public void _reportInvalidBase64(char c2, int n2, String string) {
        Object object = c2 <= ' ' ? "Illegal white space character (code 0x" + Integer.toHexString(c2) + ") as character #" + (n2 + 1) + " of 4-char base64 unit: can only used between units" : (((Base64Variant)object).usesPaddingChar(c2) ? "Unexpected padding character ('" + ((Base64Variant)object).getPaddingChar() + "') as character #" + (n2 + 1) + " of 4-char base64 unit: padding only legal as 3rd or 4th character" : (Character.isDefined(c2) && !Character.isISOControl(c2) ? "Illegal character '" + c2 + "' (code 0x" + Integer.toHexString(c2) + ") in base64 content" : "Illegal character (code 0x" + Integer.toHexString(c2) + ") in base64 content"));
        if (string != null) {
            object = (String)object + ": " + string;
        }
        throw new IllegalArgumentException((String)object);
    }

    public void _reportBase64EOF() {
        throw new IllegalArgumentException(this.missingPaddingMessage());
    }

    public void _reportBase64UnexpectedPadding() {
        throw new IllegalArgumentException(this.unexpectedPaddingMessage());
    }

    public String unexpectedPaddingMessage() {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = this.getName();
        return String.format("Unexpected end of base64-encoded String: base64 variant '%s' expects no padding at the end while decoding. This Base64Variant might have been incorrectly configured", objectArray2);
    }

    public String missingPaddingMessage() {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.getName();
        objectArray[1] = Character.valueOf(this.getPaddingChar());
        return String.format("Unexpected end of base64-encoded String: base64 variant '%s' expects padding (one or more '%c' characters) at the end. This Base64Variant might have been incorrectly configured", objectArray2);
    }

    public static enum PaddingReadBehaviour {
        PADDING_FORBIDDEN,
        PADDING_REQUIRED,
        PADDING_ALLOWED;

    }
}

