/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core;

import com.privatefasterxml.jackson.core.Base64Variant;
import java.io.Serializable;

public final class Base64Variants {
    static final String STD_BASE64_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    public static final Base64Variant MIME;
    public static final Base64Variant MIME_NO_LINEFEEDS;
    public static final Base64Variant PEM;
    public static final Base64Variant MODIFIED_FOR_URL;

    public static Base64Variant getDefaultVariant() {
        return MIME_NO_LINEFEEDS;
    }

    public static Base64Variant valueOf(String string) {
        Base64Variant base64Variant = MIME;
        if (base64Variant._name.equals(string)) {
            return base64Variant;
        }
        base64Variant = MIME_NO_LINEFEEDS;
        if (base64Variant._name.equals(string)) {
            return base64Variant;
        }
        base64Variant = PEM;
        if (base64Variant._name.equals(string)) {
            return base64Variant;
        }
        base64Variant = MODIFIED_FOR_URL;
        if (base64Variant._name.equals(string)) {
            return base64Variant;
        }
        string = string == null ? "<null>" : "'" + string + "'";
        throw new IllegalArgumentException("No Base64Variant with name " + string);
    }

    static {
        StringBuilder stringBuilder;
        Base64Variant base64Variant;
        Serializable serializable = base64Variant;
        MIME = new Base64Variant("MIME", STD_BASE64_ALPHABET, true, '=', 76);
        MIME_NO_LINEFEEDS = new Base64Variant((Base64Variant)serializable, "MIME-NO-LINEFEEDS", Integer.MAX_VALUE);
        PEM = new Base64Variant((Base64Variant)serializable, "PEM", true, '=', 64);
        serializable = stringBuilder;
        ((StringBuilder)serializable).setCharAt(new StringBuilder(STD_BASE64_ALPHABET).indexOf("+"), '-');
        ((StringBuilder)serializable).setCharAt(((StringBuilder)serializable).indexOf("/"), '_');
        MODIFIED_FOR_URL = new Base64Variant("MODIFIED-FOR-URL", ((StringBuilder)serializable).toString(), false, '\u0000', Integer.MAX_VALUE);
    }
}

