/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core;

import com.privatefasterxml.jackson.core.FormatFeature;
import com.privatefasterxml.jackson.core.FormatSchema;
import com.privatefasterxml.jackson.core.JsonEncoding;
import com.privatefasterxml.jackson.core.JsonFactoryBuilder;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.ObjectCodec;
import com.privatefasterxml.jackson.core.SerializableString;
import com.privatefasterxml.jackson.core.StreamReadFeature;
import com.privatefasterxml.jackson.core.StreamWriteFeature;
import com.privatefasterxml.jackson.core.TSFBuilder;
import com.privatefasterxml.jackson.core.TokenStreamFactory;
import com.privatefasterxml.jackson.core.Version;
import com.privatefasterxml.jackson.core.Versioned;
import com.privatefasterxml.jackson.core.format.InputAccessor;
import com.privatefasterxml.jackson.core.format.MatchStrength;
import com.privatefasterxml.jackson.core.io.CharacterEscapes;
import com.privatefasterxml.jackson.core.io.ContentReference;
import com.privatefasterxml.jackson.core.io.IOContext;
import com.privatefasterxml.jackson.core.io.InputDecorator;
import com.privatefasterxml.jackson.core.io.OutputDecorator;
import com.privatefasterxml.jackson.core.io.SerializedString;
import com.privatefasterxml.jackson.core.io.UTF8Writer;
import com.privatefasterxml.jackson.core.json.ByteSourceJsonBootstrapper;
import com.privatefasterxml.jackson.core.json.ReaderBasedJsonParser;
import com.privatefasterxml.jackson.core.json.UTF8DataInputJsonParser;
import com.privatefasterxml.jackson.core.json.UTF8JsonGenerator;
import com.privatefasterxml.jackson.core.json.WriterBasedJsonGenerator;
import com.privatefasterxml.jackson.core.json.async.NonBlockingByteBufferJsonParser;
import com.privatefasterxml.jackson.core.json.async.NonBlockingJsonParser;
import com.privatefasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import com.privatefasterxml.jackson.core.sym.CharsToNameCanonicalizer;
import com.privatefasterxml.jackson.core.util.BufferRecycler;
import com.privatefasterxml.jackson.core.util.BufferRecyclers;
import com.privatefasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.privatefasterxml.jackson.core.util.JacksonFeature;
import java.io.CharArrayReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;

public class JsonFactory
extends TokenStreamFactory
implements Versioned,
Serializable {
    private static final long serialVersionUID = 2L;
    public static final String FORMAT_NAME_JSON = "JSON";
    protected static final int DEFAULT_FACTORY_FEATURE_FLAGS = Feature.collectDefaults();
    protected static final int DEFAULT_PARSER_FEATURE_FLAGS = JsonParser.Feature.collectDefaults();
    protected static final int DEFAULT_GENERATOR_FEATURE_FLAGS = JsonGenerator.Feature.collectDefaults();
    public static final SerializableString DEFAULT_ROOT_VALUE_SEPARATOR = DefaultPrettyPrinter.DEFAULT_ROOT_VALUE_SEPARATOR;
    public static final char DEFAULT_QUOTE_CHAR = '\"';
    protected final transient CharsToNameCanonicalizer _rootCharSymbols;
    protected final transient ByteQuadsCanonicalizer _byteSymbolCanonicalizer;
    protected int _factoryFeatures;
    protected int _parserFeatures;
    protected int _generatorFeatures;
    protected ObjectCodec _objectCodec;
    protected CharacterEscapes _characterEscapes;
    protected InputDecorator _inputDecorator;
    protected OutputDecorator _outputDecorator;
    protected SerializableString _rootValueSeparator;
    protected int _maximumNonEscapedChar;
    protected final char _quoteChar;

    public JsonFactory() {
        this((ObjectCodec)null);
    }

    public JsonFactory(ObjectCodec objectCodec) {
        JsonFactory jsonFactory = this;
        this._rootCharSymbols = CharsToNameCanonicalizer.createRoot();
        this._byteSymbolCanonicalizer = ByteQuadsCanonicalizer.createRoot();
        this._factoryFeatures = DEFAULT_FACTORY_FEATURE_FLAGS;
        this._parserFeatures = DEFAULT_PARSER_FEATURE_FLAGS;
        this._generatorFeatures = DEFAULT_GENERATOR_FEATURE_FLAGS;
        this._rootValueSeparator = DEFAULT_ROOT_VALUE_SEPARATOR;
        jsonFactory._objectCodec = objectCodec;
        jsonFactory._quoteChar = (char)34;
    }

    public JsonFactory(JsonFactory jsonFactory, ObjectCodec objectCodec) {
        this._rootCharSymbols = CharsToNameCanonicalizer.createRoot();
        this._byteSymbolCanonicalizer = ByteQuadsCanonicalizer.createRoot();
        this._factoryFeatures = DEFAULT_FACTORY_FEATURE_FLAGS;
        this._parserFeatures = DEFAULT_PARSER_FEATURE_FLAGS;
        this._generatorFeatures = DEFAULT_GENERATOR_FEATURE_FLAGS;
        this._rootValueSeparator = DEFAULT_ROOT_VALUE_SEPARATOR;
        this._objectCodec = objectCodec;
        this._factoryFeatures = jsonFactory._factoryFeatures;
        this._parserFeatures = jsonFactory._parserFeatures;
        this._generatorFeatures = jsonFactory._generatorFeatures;
        this._inputDecorator = jsonFactory._inputDecorator;
        this._outputDecorator = jsonFactory._outputDecorator;
        this._characterEscapes = jsonFactory._characterEscapes;
        this._rootValueSeparator = jsonFactory._rootValueSeparator;
        this._maximumNonEscapedChar = jsonFactory._maximumNonEscapedChar;
        this._quoteChar = jsonFactory._quoteChar;
    }

    public JsonFactory(JsonFactoryBuilder jsonFactoryBuilder) {
        this._rootCharSymbols = CharsToNameCanonicalizer.createRoot();
        this._byteSymbolCanonicalizer = ByteQuadsCanonicalizer.createRoot();
        this._factoryFeatures = DEFAULT_FACTORY_FEATURE_FLAGS;
        this._parserFeatures = DEFAULT_PARSER_FEATURE_FLAGS;
        this._generatorFeatures = DEFAULT_GENERATOR_FEATURE_FLAGS;
        this._rootValueSeparator = DEFAULT_ROOT_VALUE_SEPARATOR;
        this._objectCodec = null;
        this._factoryFeatures = jsonFactoryBuilder._factoryFeatures;
        this._parserFeatures = jsonFactoryBuilder._streamReadFeatures;
        this._generatorFeatures = jsonFactoryBuilder._streamWriteFeatures;
        this._inputDecorator = jsonFactoryBuilder._inputDecorator;
        this._outputDecorator = jsonFactoryBuilder._outputDecorator;
        this._characterEscapes = jsonFactoryBuilder._characterEscapes;
        this._rootValueSeparator = jsonFactoryBuilder._rootValueSeparator;
        this._maximumNonEscapedChar = jsonFactoryBuilder._maximumNonEscapedChar;
        this._quoteChar = jsonFactoryBuilder._quoteChar;
    }

    public JsonFactory(TSFBuilder<?, ?> tSFBuilder, boolean bl) {
        JsonFactory jsonFactory = this;
        this._rootCharSymbols = CharsToNameCanonicalizer.createRoot();
        this._byteSymbolCanonicalizer = ByteQuadsCanonicalizer.createRoot();
        this._factoryFeatures = DEFAULT_FACTORY_FEATURE_FLAGS;
        this._parserFeatures = DEFAULT_PARSER_FEATURE_FLAGS;
        this._generatorFeatures = DEFAULT_GENERATOR_FEATURE_FLAGS;
        this._rootValueSeparator = DEFAULT_ROOT_VALUE_SEPARATOR;
        this._objectCodec = null;
        this._factoryFeatures = tSFBuilder._factoryFeatures;
        this._parserFeatures = tSFBuilder._streamReadFeatures;
        this._generatorFeatures = tSFBuilder._streamWriteFeatures;
        this._inputDecorator = tSFBuilder._inputDecorator;
        jsonFactory._outputDecorator = tSFBuilder._outputDecorator;
        jsonFactory._characterEscapes = null;
        jsonFactory._rootValueSeparator = null;
        jsonFactory._maximumNonEscapedChar = 0;
        jsonFactory._quoteChar = (char)34;
    }

    public static TSFBuilder<?, ?> builder() {
        return new JsonFactoryBuilder();
    }

    private final void _requireJSONFactory(String string) {
        if (this._isJSONFactory()) {
            return;
        }
        throw new UnsupportedOperationException(String.format(string, this.getFormatName()));
    }

    private final boolean _isJSONFactory() {
        return this.getFormatName() == FORMAT_NAME_JSON;
    }

    public TSFBuilder<?, ?> rebuild() {
        this._requireJSONFactory("Factory implementation for format (%s) MUST override `rebuild()` method");
        return new JsonFactoryBuilder(this);
    }

    public JsonFactory copy() {
        this._checkInvalidCopy(JsonFactory.class);
        return new JsonFactory(this, null);
    }

    public void _checkInvalidCopy(Class<?> clazz) {
        if (this.getClass() == clazz) {
            return;
        }
        throw new IllegalStateException("Failed copy(): " + this.getClass().getName() + " (version: " + this.version() + ") does not override copy(); it has to");
    }

    public Object readResolve() {
        return new JsonFactory(this, this._objectCodec);
    }

    @Override
    public boolean requiresPropertyOrdering() {
        return false;
    }

    @Override
    public boolean canHandleBinaryNatively() {
        return false;
    }

    public boolean canUseCharArrays() {
        return true;
    }

    @Override
    public boolean canParseAsync() {
        return this._isJSONFactory();
    }

    @Override
    public Class<? extends FormatFeature> getFormatReadFeatureType() {
        return null;
    }

    @Override
    public Class<? extends FormatFeature> getFormatWriteFeatureType() {
        return null;
    }

    @Override
    public boolean canUseSchema(FormatSchema formatSchema) {
        if (formatSchema == null) {
            return false;
        }
        return (this = ((JsonFactory)this).getFormatName()) != null && ((String)this).equals(formatSchema.getSchemaType());
    }

    @Override
    public String getFormatName() {
        if (this.getClass() == JsonFactory.class) {
            return FORMAT_NAME_JSON;
        }
        return null;
    }

    public MatchStrength hasFormat(InputAccessor inputAccessor) {
        if (this.getClass() == JsonFactory.class) {
            return this.hasJSONFormat(inputAccessor);
        }
        return null;
    }

    public boolean requiresCustomCodec() {
        return false;
    }

    public MatchStrength hasJSONFormat(InputAccessor inputAccessor) {
        return ByteSourceJsonBootstrapper.hasJSONFormat(inputAccessor);
    }

    @Override
    public Version version() {
        return new Version(2, 14, 1, "applitools", "com.privatefasterxml", "artifact identification not set");
    }

    @Deprecated
    public final JsonFactory configure(Feature feature, boolean bl) {
        return bl ? this.enable(feature) : this.disable(feature);
    }

    @Deprecated
    public JsonFactory enable(Feature feature) {
        JsonFactory jsonFactory = this;
        jsonFactory._factoryFeatures |= feature.getMask();
        return jsonFactory;
    }

    @Deprecated
    public JsonFactory disable(Feature feature) {
        JsonFactory jsonFactory = this;
        jsonFactory._factoryFeatures &= ~feature.getMask();
        return jsonFactory;
    }

    public final boolean isEnabled(Feature feature) {
        return (this._factoryFeatures & feature.getMask()) != 0;
    }

    @Override
    public final int getParserFeatures() {
        return this._parserFeatures;
    }

    @Override
    public final int getGeneratorFeatures() {
        return this._generatorFeatures;
    }

    @Override
    public int getFormatParserFeatures() {
        return 0;
    }

    @Override
    public int getFormatGeneratorFeatures() {
        return 0;
    }

    public final JsonFactory configure(JsonParser.Feature feature, boolean bl) {
        return bl ? this.enable(feature) : this.disable(feature);
    }

    public JsonFactory enable(JsonParser.Feature feature) {
        JsonFactory jsonFactory = this;
        jsonFactory._parserFeatures |= feature.getMask();
        return jsonFactory;
    }

    public JsonFactory disable(JsonParser.Feature feature) {
        JsonFactory jsonFactory = this;
        jsonFactory._parserFeatures &= ~feature.getMask();
        return jsonFactory;
    }

    @Override
    public final boolean isEnabled(JsonParser.Feature feature) {
        return (this._parserFeatures & feature.getMask()) != 0;
    }

    public final boolean isEnabled(StreamReadFeature streamReadFeature) {
        return (this._parserFeatures & streamReadFeature.mappedFeature().getMask()) != 0;
    }

    public InputDecorator getInputDecorator() {
        return this._inputDecorator;
    }

    @Deprecated
    public JsonFactory setInputDecorator(InputDecorator inputDecorator) {
        this._inputDecorator = inputDecorator;
        return this;
    }

    public final JsonFactory configure(JsonGenerator.Feature feature, boolean bl) {
        return bl ? this.enable(feature) : this.disable(feature);
    }

    public JsonFactory enable(JsonGenerator.Feature feature) {
        JsonFactory jsonFactory = this;
        jsonFactory._generatorFeatures |= feature.getMask();
        return jsonFactory;
    }

    public JsonFactory disable(JsonGenerator.Feature feature) {
        JsonFactory jsonFactory = this;
        jsonFactory._generatorFeatures &= ~feature.getMask();
        return jsonFactory;
    }

    @Override
    public final boolean isEnabled(JsonGenerator.Feature feature) {
        return (this._generatorFeatures & feature.getMask()) != 0;
    }

    public final boolean isEnabled(StreamWriteFeature streamWriteFeature) {
        return (this._generatorFeatures & streamWriteFeature.mappedFeature().getMask()) != 0;
    }

    public CharacterEscapes getCharacterEscapes() {
        return this._characterEscapes;
    }

    public JsonFactory setCharacterEscapes(CharacterEscapes characterEscapes) {
        this._characterEscapes = characterEscapes;
        return this;
    }

    public OutputDecorator getOutputDecorator() {
        return this._outputDecorator;
    }

    @Deprecated
    public JsonFactory setOutputDecorator(OutputDecorator outputDecorator) {
        this._outputDecorator = outputDecorator;
        return this;
    }

    public JsonFactory setRootValueSeparator(String object) {
        if (object == null) {
            object = null;
        } else {
            SerializedString serializedString;
            SerializedString serializedString2 = serializedString;
            serializedString = new SerializedString((String)object);
            object = serializedString2;
        }
        this._rootValueSeparator = object;
        return this;
    }

    public String getRootValueSeparator() {
        SerializableString serializableString = ((JsonFactory)((Object)serializableString))._rootValueSeparator;
        return serializableString == null ? null : serializableString.getValue();
    }

    public JsonFactory setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
        return this;
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public JsonParser createParser(File file) {
        JsonFactory jsonFactory = iOContext;
        JsonFactory jsonFactory2 = iOContext;
        IOContext iOContext = jsonFactory2._createContext(jsonFactory2._createContentReference(file), true);
        return jsonFactory._createParser(jsonFactory._decorate(jsonFactory._fileInputStream(file), iOContext), iOContext);
    }

    @Override
    public JsonParser createParser(URL uRL) {
        JsonFactory jsonFactory = iOContext;
        JsonFactory jsonFactory2 = iOContext;
        IOContext iOContext = jsonFactory2._createContext(jsonFactory2._createContentReference(uRL), true);
        return jsonFactory._createParser(jsonFactory._decorate(jsonFactory._optimizedStreamFromURL(uRL), iOContext), iOContext);
    }

    @Override
    public JsonParser createParser(InputStream inputStream) {
        JsonFactory jsonFactory = iOContext;
        JsonFactory jsonFactory2 = iOContext;
        IOContext iOContext = jsonFactory2._createContext(jsonFactory2._createContentReference(inputStream), false);
        return jsonFactory._createParser(jsonFactory._decorate(inputStream, iOContext), iOContext);
    }

    @Override
    public JsonParser createParser(Reader reader) {
        JsonFactory jsonFactory = iOContext;
        JsonFactory jsonFactory2 = iOContext;
        IOContext iOContext = jsonFactory2._createContext(jsonFactory2._createContentReference(reader), false);
        return jsonFactory._createParser(jsonFactory._decorate(reader, iOContext), iOContext);
    }

    @Override
    public JsonParser createParser(byte[] byArray) {
        int n2;
        InputStream inputStream;
        JsonFactory jsonFactory = this;
        IOContext iOContext = jsonFactory._createContext(jsonFactory._createContentReference(byArray), true);
        InputDecorator inputDecorator = jsonFactory._inputDecorator;
        if (inputDecorator != null && (inputStream = inputDecorator.decorate(iOContext, byArray, 0, n2 = byArray.length)) != null) {
            return this._createParser(inputStream, iOContext);
        }
        return this._createParser(byArray, 0, byArray.length, iOContext);
    }

    @Override
    public JsonParser createParser(byte[] byArray, int n2, int n3) {
        JsonFactory jsonFactory = this;
        this._checkRangeBoundsForByteArray(byArray, n2, n3);
        IOContext iOContext = jsonFactory._createContext(jsonFactory._createContentReference(byArray, n2, n3), true);
        Object object = jsonFactory._inputDecorator;
        if (object != null && (object = ((InputDecorator)object).decorate(iOContext, byArray, n2, n3)) != null) {
            return this._createParser((InputStream)object, iOContext);
        }
        return this._createParser(byArray, n2, n3, iOContext);
    }

    @Override
    public JsonParser createParser(String object) {
        int n2 = ((String)object).length();
        if (((JsonFactory)((Object)iOContext))._inputDecorator == null && n2 <= 32768 && ((JsonFactory)((Object)iOContext)).canUseCharArrays()) {
            JsonFactory jsonFactory = iOContext;
            String string = object;
            JsonFactory jsonFactory2 = iOContext;
            IOContext iOContext = jsonFactory2._createContext(jsonFactory2._createContentReference(object), true);
            object = iOContext.allocTokenBuffer(n2);
            string.getChars(0, n2, (char[])object, 0);
            return jsonFactory._createParser((char[])object, 0, n2, iOContext, true);
        }
        return ((JsonFactory)((Object)iOContext)).createParser(new StringReader((String)object));
    }

    @Override
    public JsonParser createParser(char[] cArray) {
        return this.createParser(cArray, 0, cArray.length);
    }

    @Override
    public JsonParser createParser(char[] cArray, int n2, int n3) {
        JsonFactory jsonFactory = iOContext;
        jsonFactory._checkRangeBoundsForCharArray(cArray, n2, n3);
        if (jsonFactory._inputDecorator != null) {
            return ((JsonFactory)((Object)iOContext)).createParser(new CharArrayReader(cArray, n2, n3));
        }
        JsonFactory jsonFactory2 = iOContext;
        JsonFactory jsonFactory3 = iOContext;
        IOContext iOContext = jsonFactory3._createContext(jsonFactory3._createContentReference(cArray, n2, n3), true);
        return jsonFactory2._createParser(cArray, n2, n3, iOContext, false);
    }

    @Override
    public JsonParser createParser(DataInput dataInput) {
        JsonFactory jsonFactory = iOContext;
        JsonFactory jsonFactory2 = iOContext;
        IOContext iOContext = jsonFactory2._createContext(jsonFactory2._createContentReference(dataInput), false);
        return jsonFactory._createParser(jsonFactory._decorate(dataInput, iOContext), iOContext);
    }

    @Override
    public JsonParser createNonBlockingByteArrayParser() {
        JsonFactory jsonFactory = this;
        jsonFactory._requireJSONFactory("Non-blocking source not (yet?) supported for this format (%s)");
        IOContext iOContext = jsonFactory._createNonBlockingContext(null);
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = jsonFactory._byteSymbolCanonicalizer.makeChild(this._factoryFeatures);
        return new NonBlockingJsonParser(iOContext, this._parserFeatures, byteQuadsCanonicalizer);
    }

    @Override
    public JsonParser createNonBlockingByteBufferParser() {
        JsonFactory jsonFactory = this;
        jsonFactory._requireJSONFactory("Non-blocking source not (yet?) supported for this format (%s)");
        IOContext iOContext = jsonFactory._createNonBlockingContext(null);
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = jsonFactory._byteSymbolCanonicalizer.makeChild(this._factoryFeatures);
        return new NonBlockingByteBufferJsonParser(iOContext, this._parserFeatures, byteQuadsCanonicalizer);
    }

    @Override
    public JsonGenerator createGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) {
        JsonFactory jsonFactory = this;
        IOContext iOContext = jsonFactory._createContext(jsonFactory._createContentReference(outputStream), false);
        iOContext.setEncoding(jsonEncoding);
        if (jsonEncoding == JsonEncoding.UTF8) {
            JsonFactory jsonFactory2 = this;
            return jsonFactory2._createUTF8Generator(jsonFactory2._decorate(outputStream, iOContext), iOContext);
        }
        JsonFactory jsonFactory3 = this;
        return jsonFactory3._createGenerator(jsonFactory3._decorate(jsonFactory3._createWriter(outputStream, jsonEncoding, iOContext), iOContext), iOContext);
    }

    @Override
    public JsonGenerator createGenerator(OutputStream outputStream) {
        return this.createGenerator(outputStream, JsonEncoding.UTF8);
    }

    @Override
    public JsonGenerator createGenerator(Writer writer) {
        JsonFactory jsonFactory = iOContext;
        JsonFactory jsonFactory2 = iOContext;
        IOContext iOContext = jsonFactory2._createContext(jsonFactory2._createContentReference(writer), false);
        return jsonFactory._createGenerator(jsonFactory._decorate(writer, iOContext), iOContext);
    }

    @Override
    public JsonGenerator createGenerator(File object, JsonEncoding jsonEncoding) {
        JsonFactory jsonFactory = this;
        object = jsonFactory._fileOutputStream((File)object);
        IOContext iOContext = jsonFactory._createContext(jsonFactory._createContentReference(object), true);
        iOContext.setEncoding(jsonEncoding);
        if (jsonEncoding == JsonEncoding.UTF8) {
            JsonFactory jsonFactory2 = this;
            return jsonFactory2._createUTF8Generator(jsonFactory2._decorate((OutputStream)object, iOContext), iOContext);
        }
        JsonFactory jsonFactory3 = this;
        return jsonFactory3._createGenerator(jsonFactory3._decorate(jsonFactory3._createWriter((OutputStream)object, jsonEncoding, iOContext), iOContext), iOContext);
    }

    @Override
    public JsonGenerator createGenerator(DataOutput dataOutput, JsonEncoding jsonEncoding) {
        JsonFactory jsonFactory = this;
        return jsonFactory.createGenerator(jsonFactory._createDataOutputWrapper(dataOutput), jsonEncoding);
    }

    @Override
    public JsonGenerator createGenerator(DataOutput dataOutput) {
        JsonFactory jsonFactory = this;
        return jsonFactory.createGenerator(jsonFactory._createDataOutputWrapper(dataOutput), JsonEncoding.UTF8);
    }

    @Deprecated
    public JsonParser createJsonParser(File file) {
        return this.createParser(file);
    }

    @Deprecated
    public JsonParser createJsonParser(URL uRL) {
        return this.createParser(uRL);
    }

    @Deprecated
    public JsonParser createJsonParser(InputStream inputStream) {
        return this.createParser(inputStream);
    }

    @Deprecated
    public JsonParser createJsonParser(Reader reader) {
        return this.createParser(reader);
    }

    @Deprecated
    public JsonParser createJsonParser(byte[] byArray) {
        return this.createParser(byArray);
    }

    @Deprecated
    public JsonParser createJsonParser(byte[] byArray, int n2, int n3) {
        return this.createParser(byArray, n2, n3);
    }

    @Deprecated
    public JsonParser createJsonParser(String string) {
        return this.createParser(string);
    }

    @Deprecated
    public JsonGenerator createJsonGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) {
        return this.createGenerator(outputStream, jsonEncoding);
    }

    @Deprecated
    public JsonGenerator createJsonGenerator(Writer writer) {
        return this.createGenerator(writer);
    }

    @Deprecated
    public JsonGenerator createJsonGenerator(OutputStream outputStream) {
        return this.createGenerator(outputStream, JsonEncoding.UTF8);
    }

    /*
     * WARNING - void declaration
     */
    public JsonParser _createParser(InputStream inputStream, IOContext iOContext) {
        void var0_4;
        ByteSourceJsonBootstrapper byteSourceJsonBootstrapper;
        Object object = byteSourceJsonBootstrapper;
        JsonFactory jsonFactory = this;
        JsonFactory jsonFactory2 = jsonFactory;
        JsonFactory jsonFactory3 = jsonFactory;
        JsonFactory jsonFactory4 = jsonFactory;
        JsonFactory jsonFactory5 = jsonFactory;
        ((ByteSourceJsonBootstrapper)object)(iOContext, inputStream);
        int n2 = jsonFactory._parserFeatures;
        object = jsonFactory3._objectCodec;
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = jsonFactory4._byteSymbolCanonicalizer;
        CharsToNameCanonicalizer charsToNameCanonicalizer = jsonFactory5._rootCharSymbols;
        int n3 = jsonFactory2._factoryFeatures;
        try {
            return byteSourceJsonBootstrapper.constructParser(n2, (ObjectCodec)object, byteQuadsCanonicalizer, charsToNameCanonicalizer, n3);
        }
        catch (RuntimeException runtimeException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (iOContext.isResourceManaged()) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                var0_4.addSuppressed(exception);
            }
        }
        throw var0_4;
    }

    public JsonParser _createParser(Reader reader, IOContext iOContext) {
        JsonFactory jsonFactory = charsToNameCanonicalizer;
        int n2 = jsonFactory._parserFeatures;
        ObjectCodec objectCodec = jsonFactory._objectCodec;
        CharsToNameCanonicalizer charsToNameCanonicalizer = jsonFactory._rootCharSymbols.makeChild(((JsonFactory)((Object)charsToNameCanonicalizer))._factoryFeatures);
        return new ReaderBasedJsonParser(iOContext, n2, reader, objectCodec, charsToNameCanonicalizer);
    }

    public JsonParser _createParser(char[] cArray, int n2, int n3, IOContext object, boolean bl) {
        IOContext iOContext = object;
        int n4 = n3;
        JsonFactory jsonFactory = charsToNameCanonicalizer;
        n3 = jsonFactory._parserFeatures;
        object = jsonFactory._objectCodec;
        CharsToNameCanonicalizer charsToNameCanonicalizer = jsonFactory._rootCharSymbols.makeChild(((JsonFactory)((Object)charsToNameCanonicalizer))._factoryFeatures);
        int n5 = n2 + n4;
        return new ReaderBasedJsonParser(iOContext, n3, null, (ObjectCodec)object, charsToNameCanonicalizer, cArray, n2, n5, bl);
    }

    public JsonParser _createParser(byte[] object, int n2, int n3, IOContext iOContext) {
        ByteSourceJsonBootstrapper byteSourceJsonBootstrapper;
        ByteSourceJsonBootstrapper byteSourceJsonBootstrapper2 = byteSourceJsonBootstrapper;
        JsonFactory jsonFactory = this;
        byteSourceJsonBootstrapper2(iOContext, (byte[])object, n2, n3);
        int n4 = jsonFactory._parserFeatures;
        object = jsonFactory._objectCodec;
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = jsonFactory._byteSymbolCanonicalizer;
        CharsToNameCanonicalizer charsToNameCanonicalizer = jsonFactory._rootCharSymbols;
        int n5 = jsonFactory._factoryFeatures;
        return byteSourceJsonBootstrapper.constructParser(n4, (ObjectCodec)object, byteQuadsCanonicalizer, charsToNameCanonicalizer, n5);
    }

    public JsonParser _createParser(DataInput dataInput, IOContext object) {
        this._requireJSONFactory("InputData source not (yet?) supported for this format (%s)");
        int n2 = ByteSourceJsonBootstrapper.skipUTF8BOM(dataInput);
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this._byteSymbolCanonicalizer.makeChild(this._factoryFeatures);
        IOContext iOContext = object;
        JsonFactory jsonFactory = this;
        int n3 = jsonFactory._parserFeatures;
        object = jsonFactory._objectCodec;
        return new UTF8DataInputJsonParser(iOContext, n3, dataInput, (ObjectCodec)object, byteQuadsCanonicalizer, n2);
    }

    public JsonGenerator _createGenerator(Writer writer, IOContext iOContext) {
        CharacterEscapes characterEscapes;
        WriterBasedJsonGenerator writerBasedJsonGenerator;
        WriterBasedJsonGenerator writerBasedJsonGenerator2 = writerBasedJsonGenerator;
        JsonFactory jsonFactory = this;
        int n2 = jsonFactory._generatorFeatures;
        ObjectCodec objectCodec = jsonFactory._objectCodec;
        char c2 = jsonFactory._quoteChar;
        writerBasedJsonGenerator = new WriterBasedJsonGenerator(iOContext, n2, objectCodec, writer, c2);
        int n3 = ((JsonFactory)this)._maximumNonEscapedChar;
        if (n3 > 0) {
            writerBasedJsonGenerator2.setHighestNonEscapedChar(n3);
        }
        if ((characterEscapes = ((JsonFactory)this)._characterEscapes) != null) {
            writerBasedJsonGenerator2.setCharacterEscapes(characterEscapes);
        }
        if ((this = ((JsonFactory)this)._rootValueSeparator) != DEFAULT_ROOT_VALUE_SEPARATOR) {
            writerBasedJsonGenerator2.setRootValueSeparator((SerializableString)this);
        }
        return writerBasedJsonGenerator2;
    }

    public JsonGenerator _createUTF8Generator(OutputStream outputStream, IOContext iOContext) {
        CharacterEscapes characterEscapes;
        UTF8JsonGenerator uTF8JsonGenerator;
        UTF8JsonGenerator uTF8JsonGenerator2 = uTF8JsonGenerator;
        JsonFactory jsonFactory = this;
        int n2 = jsonFactory._generatorFeatures;
        ObjectCodec objectCodec = jsonFactory._objectCodec;
        char c2 = jsonFactory._quoteChar;
        uTF8JsonGenerator = new UTF8JsonGenerator(iOContext, n2, objectCodec, outputStream, c2);
        int n3 = ((JsonFactory)this)._maximumNonEscapedChar;
        if (n3 > 0) {
            uTF8JsonGenerator2.setHighestNonEscapedChar(n3);
        }
        if ((characterEscapes = ((JsonFactory)this)._characterEscapes) != null) {
            uTF8JsonGenerator2.setCharacterEscapes(characterEscapes);
        }
        if ((this = ((JsonFactory)this)._rootValueSeparator) != DEFAULT_ROOT_VALUE_SEPARATOR) {
            uTF8JsonGenerator2.setRootValueSeparator((SerializableString)this);
        }
        return uTF8JsonGenerator2;
    }

    public Writer _createWriter(OutputStream outputStream, JsonEncoding jsonEncoding, IOContext iOContext) {
        if (jsonEncoding == JsonEncoding.UTF8) {
            return new UTF8Writer(iOContext, outputStream);
        }
        return new OutputStreamWriter(outputStream, jsonEncoding.getJavaName());
    }

    public final InputStream _decorate(InputStream inputStream, IOContext iOContext) {
        Object object = ((JsonFactory)object)._inputDecorator;
        if (object != null && (object = ((InputDecorator)object).decorate(iOContext, inputStream)) != null) {
            return object;
        }
        return inputStream;
    }

    public final Reader _decorate(Reader reader, IOContext iOContext) {
        Object object = ((JsonFactory)object)._inputDecorator;
        if (object != null && (object = ((InputDecorator)object).decorate(iOContext, reader)) != null) {
            return object;
        }
        return reader;
    }

    public final DataInput _decorate(DataInput dataInput, IOContext iOContext) {
        Object object = ((JsonFactory)object)._inputDecorator;
        if (object != null && (object = ((InputDecorator)object).decorate(iOContext, dataInput)) != null) {
            return object;
        }
        return dataInput;
    }

    public final OutputStream _decorate(OutputStream outputStream, IOContext iOContext) {
        Object object = ((JsonFactory)object)._outputDecorator;
        if (object != null && (object = ((OutputDecorator)object).decorate(iOContext, outputStream)) != null) {
            return object;
        }
        return outputStream;
    }

    public final Writer _decorate(Writer writer, IOContext iOContext) {
        Object object = ((JsonFactory)object)._outputDecorator;
        if (object != null && (object = ((OutputDecorator)object).decorate(iOContext, writer)) != null) {
            return object;
        }
        return writer;
    }

    public BufferRecycler _getBufferRecycler() {
        if (Feature.USE_THREAD_LOCAL_FOR_BUFFER_RECYCLING.enabledIn(this._factoryFeatures)) {
            return BufferRecyclers.getBufferRecycler();
        }
        return new BufferRecycler();
    }

    public IOContext _createContext(ContentReference contentReference, boolean bl) {
        if (contentReference == null) {
            contentReference = ContentReference.unknown();
        }
        return new IOContext(this._getBufferRecycler(), contentReference, bl);
    }

    @Deprecated
    public IOContext _createContext(Object object, boolean bl) {
        JsonFactory jsonFactory = bufferRecycler;
        BufferRecycler bufferRecycler = jsonFactory._getBufferRecycler();
        return new IOContext(bufferRecycler, jsonFactory._createContentReference(object), bl);
    }

    public IOContext _createNonBlockingContext(Object object) {
        JsonFactory jsonFactory = bufferRecycler;
        BufferRecycler bufferRecycler = jsonFactory._getBufferRecycler();
        return new IOContext(bufferRecycler, jsonFactory._createContentReference(object), false);
    }

    public ContentReference _createContentReference(Object object) {
        return ContentReference.construct(this.canHandleBinaryNatively() ^ true, object);
    }

    public ContentReference _createContentReference(Object object, int n2, int n3) {
        return ContentReference.construct(this.canHandleBinaryNatively() ^ true, object, n2, n3);
    }

    public static enum Feature implements JacksonFeature
    {
        INTERN_FIELD_NAMES(true),
        CANONICALIZE_FIELD_NAMES(true),
        FAIL_ON_SYMBOL_HASH_OVERFLOW(true),
        USE_THREAD_LOCAL_FOR_BUFFER_RECYCLING(true);

        private final boolean _defaultState;

        public static int collectDefaults() {
            int n2 = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n2 |= feature.getMask();
            }
            return n2;
        }

        private Feature(boolean bl) {
            this._defaultState = bl;
        }

        @Override
        public boolean enabledByDefault() {
            return this._defaultState;
        }

        @Override
        public boolean enabledIn(int n2) {
            return (n2 & this.getMask()) != 0;
        }

        @Override
        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

