/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core;

import com.privatefasterxml.jackson.core.JsonFactory;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.SerializableString;
import com.privatefasterxml.jackson.core.TSFBuilder;
import com.privatefasterxml.jackson.core.io.CharacterEscapes;
import com.privatefasterxml.jackson.core.io.SerializedString;
import com.privatefasterxml.jackson.core.json.JsonReadFeature;
import com.privatefasterxml.jackson.core.json.JsonWriteFeature;

public class JsonFactoryBuilder
extends TSFBuilder<JsonFactory, JsonFactoryBuilder> {
    protected CharacterEscapes _characterEscapes;
    protected SerializableString _rootValueSeparator;
    protected int _maximumNonEscapedChar;
    protected char _quoteChar = (char)34;

    public JsonFactoryBuilder() {
        this._rootValueSeparator = JsonFactory.DEFAULT_ROOT_VALUE_SEPARATOR;
        this._maximumNonEscapedChar = 0;
    }

    public JsonFactoryBuilder(JsonFactory jsonFactory) {
        super(jsonFactory);
        this._characterEscapes = jsonFactory.getCharacterEscapes();
        this._rootValueSeparator = jsonFactory._rootValueSeparator;
        this._maximumNonEscapedChar = jsonFactory._maximumNonEscapedChar;
    }

    @Override
    public JsonFactoryBuilder enable(JsonReadFeature jsonReadFeature) {
        JsonFactoryBuilder jsonFactoryBuilder = this;
        jsonFactoryBuilder._legacyEnable(jsonReadFeature.mappedFeature());
        return jsonFactoryBuilder;
    }

    @Override
    public JsonFactoryBuilder enable(JsonReadFeature jsonReadFeature, JsonReadFeature ... jsonReadFeatureArray) {
        this._legacyEnable(jsonReadFeature.mappedFeature());
        this.enable(jsonReadFeature);
        int n2 = jsonReadFeatureArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this._legacyEnable(jsonReadFeatureArray[i2].mappedFeature());
        }
        return this;
    }

    @Override
    public JsonFactoryBuilder disable(JsonReadFeature jsonReadFeature) {
        JsonFactoryBuilder jsonFactoryBuilder = this;
        jsonFactoryBuilder._legacyDisable(jsonReadFeature.mappedFeature());
        return jsonFactoryBuilder;
    }

    @Override
    public JsonFactoryBuilder disable(JsonReadFeature jsonReadFeature, JsonReadFeature ... jsonReadFeatureArray) {
        this._legacyDisable(jsonReadFeature.mappedFeature());
        int n2 = jsonReadFeatureArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this._legacyEnable(jsonReadFeatureArray[i2].mappedFeature());
        }
        return this;
    }

    @Override
    public JsonFactoryBuilder configure(JsonReadFeature jsonReadFeature, boolean bl) {
        return bl ? this.enable(jsonReadFeature) : this.disable(jsonReadFeature);
    }

    @Override
    public JsonFactoryBuilder enable(JsonWriteFeature enum_) {
        if ((enum_ = ((JsonWriteFeature)enum_).mappedFeature()) != null) {
            this._legacyEnable((JsonGenerator.Feature)enum_);
        }
        return this;
    }

    @Override
    public JsonFactoryBuilder enable(JsonWriteFeature jsonWriteFeature, JsonWriteFeature ... jsonWriteFeatureArray) {
        this._legacyEnable(jsonWriteFeature.mappedFeature());
        int n2 = jsonWriteFeatureArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this._legacyEnable(jsonWriteFeatureArray[i2].mappedFeature());
        }
        return this;
    }

    @Override
    public JsonFactoryBuilder disable(JsonWriteFeature jsonWriteFeature) {
        JsonFactoryBuilder jsonFactoryBuilder = this;
        jsonFactoryBuilder._legacyDisable(jsonWriteFeature.mappedFeature());
        return jsonFactoryBuilder;
    }

    @Override
    public JsonFactoryBuilder disable(JsonWriteFeature jsonWriteFeature, JsonWriteFeature ... jsonWriteFeatureArray) {
        this._legacyDisable(jsonWriteFeature.mappedFeature());
        int n2 = jsonWriteFeatureArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this._legacyDisable(jsonWriteFeatureArray[i2].mappedFeature());
        }
        return this;
    }

    @Override
    public JsonFactoryBuilder configure(JsonWriteFeature jsonWriteFeature, boolean bl) {
        return bl ? this.enable(jsonWriteFeature) : this.disable(jsonWriteFeature);
    }

    public JsonFactoryBuilder characterEscapes(CharacterEscapes characterEscapes) {
        this._characterEscapes = characterEscapes;
        return this;
    }

    public JsonFactoryBuilder rootValueSeparator(String object) {
        if (object == null) {
            object = null;
        } else {
            SerializedString serializedString;
            SerializedString serializedString2 = serializedString;
            serializedString = new SerializedString((String)object);
            object = serializedString2;
        }
        this._rootValueSeparator = object;
        return this;
    }

    public JsonFactoryBuilder rootValueSeparator(SerializableString serializableString) {
        this._rootValueSeparator = serializableString;
        return this;
    }

    public JsonFactoryBuilder highestNonEscapedChar(int n2) {
        n2 = n2 <= 0 ? 0 : Math.max(127, n2);
        this._maximumNonEscapedChar = n2;
        return this;
    }

    public JsonFactoryBuilder quoteChar(char c2) {
        if (c2 <= '\u007f') {
            this._quoteChar = c2;
            return this;
        }
        throw new IllegalArgumentException("Can only use Unicode characters up to 0x7F as quote characters");
    }

    public CharacterEscapes characterEscapes() {
        return this._characterEscapes;
    }

    public SerializableString rootValueSeparator() {
        return this._rootValueSeparator;
    }

    public int highestNonEscapedChar() {
        return this._maximumNonEscapedChar;
    }

    public char quoteChar() {
        return this._quoteChar;
    }

    @Override
    public JsonFactory build() {
        return new JsonFactory(this);
    }
}

