/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core;

import com.privatefasterxml.jackson.core.Base64Variant;
import com.privatefasterxml.jackson.core.Base64Variants;
import com.privatefasterxml.jackson.core.FormatSchema;
import com.privatefasterxml.jackson.core.JsonGenerationException;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonStreamContext;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.ObjectCodec;
import com.privatefasterxml.jackson.core.PrettyPrinter;
import com.privatefasterxml.jackson.core.SerializableString;
import com.privatefasterxml.jackson.core.StreamWriteCapability;
import com.privatefasterxml.jackson.core.StreamWriteFeature;
import com.privatefasterxml.jackson.core.TreeNode;
import com.privatefasterxml.jackson.core.Version;
import com.privatefasterxml.jackson.core.Versioned;
import com.privatefasterxml.jackson.core.a;
import com.privatefasterxml.jackson.core.io.CharacterEscapes;
import com.privatefasterxml.jackson.core.type.WritableTypeId;
import com.privatefasterxml.jackson.core.util.JacksonFeature;
import com.privatefasterxml.jackson.core.util.JacksonFeatureSet;
import com.privatefasterxml.jackson.core.util.VersionUtil;
import java.io.Closeable;
import java.io.Flushable;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class JsonGenerator
implements Closeable,
Flushable,
Versioned {
    protected static final JacksonFeatureSet<StreamWriteCapability> DEFAULT_WRITE_CAPABILITIES = JacksonFeatureSet.fromDefaults((JacksonFeature[])StreamWriteCapability.values());
    protected static final JacksonFeatureSet<StreamWriteCapability> DEFAULT_TEXTUAL_WRITE_CAPABILITIES = DEFAULT_WRITE_CAPABILITIES.with(StreamWriteCapability.CAN_WRITE_FORMATTED_NUMBERS);
    protected static final JacksonFeatureSet<StreamWriteCapability> DEFAULT_BINARY_WRITE_CAPABILITIES = DEFAULT_WRITE_CAPABILITIES.with(StreamWriteCapability.CAN_WRITE_BINARY_NATIVELY);
    protected PrettyPrinter _cfgPrettyPrinter;

    public abstract JsonGenerator setCodec(ObjectCodec var1);

    public abstract ObjectCodec getCodec();

    @Override
    public abstract Version version();

    public abstract JsonStreamContext getOutputContext();

    public Object getOutputTarget() {
        return null;
    }

    public Object currentValue() {
        return this.getCurrentValue();
    }

    public void assignCurrentValue(Object object) {
        this.setCurrentValue(object);
    }

    public Object getCurrentValue() {
        return (this = ((JsonGenerator)this).getOutputContext()) == null ? null : ((JsonStreamContext)this).getCurrentValue();
    }

    public void setCurrentValue(Object object) {
        if ((this = ((JsonGenerator)this).getOutputContext()) != null) {
            ((JsonStreamContext)this).setCurrentValue(object);
        }
    }

    public abstract JsonGenerator enable(Feature var1);

    public abstract JsonGenerator disable(Feature var1);

    public final JsonGenerator configure(Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public abstract boolean isEnabled(Feature var1);

    public boolean isEnabled(StreamWriteFeature streamWriteFeature) {
        return this.isEnabled(streamWriteFeature.mappedFeature());
    }

    public abstract int getFeatureMask();

    @Deprecated
    public abstract JsonGenerator setFeatureMask(int var1);

    public JsonGenerator overrideStdFeatures(int n2, int n3) {
        JsonGenerator jsonGenerator = this;
        return jsonGenerator.setFeatureMask(jsonGenerator.getFeatureMask() & ~n3 | n2 & n3);
    }

    public int getFormatFeatures() {
        return 0;
    }

    public JsonGenerator overrideFormatFeatures(int n2, int n3) {
        return this;
    }

    public void setSchema(FormatSchema formatSchema) {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.getClass().getName();
        objectArray[1] = formatSchema.getSchemaType();
        throw new UnsupportedOperationException(String.format("Generator of type %s does not support schema of type '%s'", objectArray2));
    }

    public FormatSchema getSchema() {
        return null;
    }

    public JsonGenerator setPrettyPrinter(PrettyPrinter prettyPrinter) {
        this._cfgPrettyPrinter = prettyPrinter;
        return this;
    }

    public PrettyPrinter getPrettyPrinter() {
        return this._cfgPrettyPrinter;
    }

    public abstract JsonGenerator useDefaultPrettyPrinter();

    public JsonGenerator setHighestNonEscapedChar(int n2) {
        return this;
    }

    public int getHighestEscapedChar() {
        return 0;
    }

    public CharacterEscapes getCharacterEscapes() {
        return null;
    }

    public JsonGenerator setCharacterEscapes(CharacterEscapes characterEscapes) {
        return this;
    }

    public JsonGenerator setRootValueSeparator(SerializableString serializableString) {
        throw new UnsupportedOperationException();
    }

    public int getOutputBuffered() {
        return -1;
    }

    public boolean canUseSchema(FormatSchema formatSchema) {
        return false;
    }

    public boolean canWriteObjectId() {
        return false;
    }

    public boolean canWriteTypeId() {
        return false;
    }

    public boolean canWriteBinaryNatively() {
        return false;
    }

    public boolean canOmitFields() {
        return true;
    }

    public boolean canWriteFormattedNumbers() {
        return false;
    }

    public JacksonFeatureSet<StreamWriteCapability> getWriteCapabilities() {
        return DEFAULT_WRITE_CAPABILITIES;
    }

    public abstract void writeStartArray();

    @Deprecated
    public void writeStartArray(int n2) {
        this.writeStartArray();
    }

    public void writeStartArray(Object object) {
        JsonGenerator jsonGenerator = this;
        jsonGenerator.writeStartArray();
        jsonGenerator.setCurrentValue(object);
    }

    public void writeStartArray(Object object, int n2) {
        JsonGenerator jsonGenerator = this;
        jsonGenerator.writeStartArray(n2);
        jsonGenerator.setCurrentValue(object);
    }

    public abstract void writeEndArray();

    public abstract void writeStartObject();

    public void writeStartObject(Object object) {
        JsonGenerator jsonGenerator = this;
        jsonGenerator.writeStartObject();
        jsonGenerator.setCurrentValue(object);
    }

    public void writeStartObject(Object object, int n2) {
        this.writeStartObject(object);
    }

    public abstract void writeEndObject();

    public abstract void writeFieldName(String var1);

    public abstract void writeFieldName(SerializableString var1);

    public void writeFieldId(long l2) {
        this.writeFieldName(Long.toString(l2));
    }

    public void writeArray(int[] nArray, int n2, int n3) {
        if (nArray != null) {
            this._verifyOffsets(nArray.length, n2, n3);
            this.writeStartArray(nArray, n3);
            n3 = n2 + n3;
            while (n2 < n3) {
                this.writeNumber(nArray[n2]);
                ++n2;
            }
            this.writeEndArray();
            return;
        }
        throw new IllegalArgumentException("null array");
    }

    public void writeArray(long[] lArray, int n2, int n3) {
        if (lArray != null) {
            this._verifyOffsets(lArray.length, n2, n3);
            this.writeStartArray(lArray, n3);
            n3 = n2 + n3;
            while (n2 < n3) {
                this.writeNumber(lArray[n2]);
                ++n2;
            }
            this.writeEndArray();
            return;
        }
        throw new IllegalArgumentException("null array");
    }

    public void writeArray(double[] dArray, int n2, int n3) {
        if (dArray != null) {
            this._verifyOffsets(dArray.length, n2, n3);
            this.writeStartArray(dArray, n3);
            n3 = n2 + n3;
            while (n2 < n3) {
                this.writeNumber(dArray[n2]);
                ++n2;
            }
            this.writeEndArray();
            return;
        }
        throw new IllegalArgumentException("null array");
    }

    public void writeArray(String[] stringArray, int n2, int n3) {
        if (stringArray != null) {
            this._verifyOffsets(stringArray.length, n2, n3);
            this.writeStartArray(stringArray, n3);
            n3 = n2 + n3;
            while (n2 < n3) {
                this.writeString(stringArray[n2]);
                ++n2;
            }
            this.writeEndArray();
            return;
        }
        throw new IllegalArgumentException("null array");
    }

    public abstract void writeString(String var1);

    public void writeString(Reader reader, int n2) {
        this._reportUnsupportedOperation();
    }

    public abstract void writeString(char[] var1, int var2, int var3);

    public abstract void writeString(SerializableString var1);

    public abstract void writeRawUTF8String(byte[] var1, int var2, int var3);

    public abstract void writeUTF8String(byte[] var1, int var2, int var3);

    public abstract void writeRaw(String var1);

    public abstract void writeRaw(String var1, int var2, int var3);

    public abstract void writeRaw(char[] var1, int var2, int var3);

    public abstract void writeRaw(char var1);

    public void writeRaw(SerializableString serializableString) {
        this.writeRaw(serializableString.getValue());
    }

    public abstract void writeRawValue(String var1);

    public abstract void writeRawValue(String var1, int var2, int var3);

    public abstract void writeRawValue(char[] var1, int var2, int var3);

    public void writeRawValue(SerializableString serializableString) {
        this.writeRawValue(serializableString.getValue());
    }

    public abstract void writeBinary(Base64Variant var1, byte[] var2, int var3, int var4);

    public void writeBinary(byte[] byArray, int n2, int n3) {
        this.writeBinary(Base64Variants.getDefaultVariant(), byArray, n2, n3);
    }

    public void writeBinary(byte[] byArray) {
        JsonGenerator jsonGenerator = base64Variant;
        Base64Variant base64Variant = Base64Variants.getDefaultVariant();
        int n2 = byArray.length;
        jsonGenerator.writeBinary(base64Variant, byArray, 0, n2);
    }

    public int writeBinary(InputStream inputStream, int n2) {
        return this.writeBinary(Base64Variants.getDefaultVariant(), inputStream, n2);
    }

    public abstract int writeBinary(Base64Variant var1, InputStream var2, int var3);

    public void writeNumber(short s2) {
        this.writeNumber((int)s2);
    }

    public abstract void writeNumber(int var1);

    public abstract void writeNumber(long var1);

    public abstract void writeNumber(BigInteger var1);

    public abstract void writeNumber(double var1);

    public abstract void writeNumber(float var1);

    public abstract void writeNumber(BigDecimal var1);

    public abstract void writeNumber(String var1);

    public void writeNumber(char[] cArray, int n2, int n3) {
        String string;
        JsonGenerator jsonGenerator = string2;
        String string2 = string;
        string = new String(cArray, n2, n3);
        jsonGenerator.writeNumber(string2);
    }

    public abstract void writeBoolean(boolean var1);

    public abstract void writeNull();

    public void writeEmbeddedObject(Object object) {
        if (object == null) {
            this.writeNull();
            return;
        }
        if (object instanceof byte[]) {
            this.writeBinary((byte[])object);
            return;
        }
        throw new JsonGenerationException("No native support for writing embedded objects of type ".concat(object.getClass().getName()), this);
    }

    public void writeObjectId(Object object) {
        throw new JsonGenerationException("No native support for writing Object Ids", this);
    }

    public void writeObjectRef(Object object) {
        throw new JsonGenerationException("No native support for writing Object Ids", this);
    }

    public void writeTypeId(Object object) {
        throw new JsonGenerationException("No native support for writing Type Ids", this);
    }

    public WritableTypeId writeTypePrefix(WritableTypeId writableTypeId) {
        WritableTypeId writableTypeId2 = writableTypeId;
        Object object = writableTypeId2.id;
        JsonToken jsonToken = writableTypeId2.valueShape;
        if (this.canWriteTypeId()) {
            writableTypeId.wrapperWritten = false;
            this.writeTypeId(object);
        } else {
            object = object instanceof String ? (String)object : String.valueOf(object);
            writableTypeId.wrapperWritten = true;
            WritableTypeId.Inclusion inclusion = writableTypeId.include;
            if (jsonToken != JsonToken.START_OBJECT && inclusion.requiresObjectContext()) {
                writableTypeId.include = inclusion = WritableTypeId.Inclusion.WRAPPER_ARRAY;
            }
            switch (a.a[inclusion.ordinal()]) {
                default: {
                    JsonGenerator jsonGenerator = this;
                    jsonGenerator.writeStartArray();
                    jsonGenerator.writeString((String)object);
                    break;
                }
                case 4: {
                    JsonGenerator jsonGenerator = this;
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeFieldName((String)object);
                    break;
                }
                case 3: {
                    this.writeStartObject(writableTypeId.forValue);
                    this.writeStringField(writableTypeId.asProperty, (String)object);
                    return writableTypeId;
                }
                case 1: 
                case 2: 
            }
        }
        if (jsonToken == JsonToken.START_OBJECT) {
            this.writeStartObject(writableTypeId.forValue);
        } else if (jsonToken == JsonToken.START_ARRAY) {
            this.writeStartArray();
        }
        return writableTypeId;
    }

    public WritableTypeId writeTypeSuffix(WritableTypeId writableTypeId) {
        JsonToken jsonToken = writableTypeId.valueShape;
        if (jsonToken == JsonToken.START_OBJECT) {
            this.writeEndObject();
        } else if (jsonToken == JsonToken.START_ARRAY) {
            this.writeEndArray();
        }
        if (writableTypeId.wrapperWritten) {
            int n2 = a.a[writableTypeId.include.ordinal()];
            if (n2 != 1) {
                if (n2 != 2 && n2 != 3) {
                    if (n2 != 5) {
                        this.writeEndObject();
                    } else {
                        this.writeEndArray();
                    }
                }
            } else {
                Object object = writableTypeId.id;
                object = object instanceof String ? (String)object : String.valueOf(object);
                this.writeStringField(writableTypeId.asProperty, (String)object);
            }
        }
        return writableTypeId;
    }

    public void writePOJO(Object object) {
        this.writeObject(object);
    }

    public abstract void writeObject(Object var1);

    public abstract void writeTree(TreeNode var1);

    public void writeBinaryField(String string, byte[] byArray) {
        JsonGenerator jsonGenerator = this;
        jsonGenerator.writeFieldName(string);
        jsonGenerator.writeBinary(byArray);
    }

    public void writeBooleanField(String string, boolean bl) {
        JsonGenerator jsonGenerator = this;
        jsonGenerator.writeFieldName(string);
        jsonGenerator.writeBoolean(bl);
    }

    public void writeNullField(String string) {
        JsonGenerator jsonGenerator = this;
        jsonGenerator.writeFieldName(string);
        jsonGenerator.writeNull();
    }

    public void writeStringField(String string, String string2) {
        JsonGenerator jsonGenerator = this;
        jsonGenerator.writeFieldName(string);
        jsonGenerator.writeString(string2);
    }

    public void writeNumberField(String string, short s2) {
        JsonGenerator jsonGenerator = this;
        jsonGenerator.writeFieldName(string);
        jsonGenerator.writeNumber(s2);
    }

    public void writeNumberField(String string, int n2) {
        JsonGenerator jsonGenerator = this;
        jsonGenerator.writeFieldName(string);
        jsonGenerator.writeNumber(n2);
    }

    public void writeNumberField(String string, long l2) {
        JsonGenerator jsonGenerator = this;
        jsonGenerator.writeFieldName(string);
        jsonGenerator.writeNumber(l2);
    }

    public void writeNumberField(String string, BigInteger bigInteger) {
        JsonGenerator jsonGenerator = this;
        jsonGenerator.writeFieldName(string);
        jsonGenerator.writeNumber(bigInteger);
    }

    public void writeNumberField(String string, float f2) {
        JsonGenerator jsonGenerator = this;
        jsonGenerator.writeFieldName(string);
        jsonGenerator.writeNumber(f2);
    }

    public void writeNumberField(String string, double d2) {
        JsonGenerator jsonGenerator = this;
        jsonGenerator.writeFieldName(string);
        jsonGenerator.writeNumber(d2);
    }

    public void writeNumberField(String string, BigDecimal bigDecimal) {
        JsonGenerator jsonGenerator = this;
        jsonGenerator.writeFieldName(string);
        jsonGenerator.writeNumber(bigDecimal);
    }

    public void writeArrayFieldStart(String string) {
        JsonGenerator jsonGenerator = this;
        jsonGenerator.writeFieldName(string);
        jsonGenerator.writeStartArray();
    }

    public void writeObjectFieldStart(String string) {
        JsonGenerator jsonGenerator = this;
        jsonGenerator.writeFieldName(string);
        jsonGenerator.writeStartObject();
    }

    public void writePOJOField(String string, Object object) {
        this.writeObjectField(string, object);
    }

    public void writeObjectField(String string, Object object) {
        JsonGenerator jsonGenerator = this;
        jsonGenerator.writeFieldName(string);
        jsonGenerator.writeObject(object);
    }

    public void writeOmittedField(String string) {
    }

    public void copyCurrentEvent(JsonParser jsonParser) {
        Enum enum_ = jsonParser.currentToken();
        switch (enum_ == null ? -1 : ((JsonToken)enum_).id()) {
            default: {
                throw new IllegalStateException("Internal error: unknown current token, " + enum_);
            }
            case 12: {
                ((JsonGenerator)object).writeObject(jsonParser.getEmbeddedObject());
                break;
            }
            case 11: {
                ((JsonGenerator)object).writeNull();
                break;
            }
            case 10: {
                ((JsonGenerator)object).writeBoolean(false);
                break;
            }
            case 9: {
                ((JsonGenerator)object).writeBoolean(true);
                break;
            }
            case 8: {
                enum_ = jsonParser.getNumberType();
                if (enum_ == JsonParser.NumberType.BIG_DECIMAL) {
                    ((JsonGenerator)object).writeNumber(jsonParser.getDecimalValue());
                    break;
                }
                if (enum_ == JsonParser.NumberType.FLOAT) {
                    ((JsonGenerator)object).writeNumber(jsonParser.getFloatValue());
                    break;
                }
                ((JsonGenerator)object).writeNumber(jsonParser.getDoubleValue());
                break;
            }
            case 7: {
                enum_ = jsonParser.getNumberType();
                if (enum_ == JsonParser.NumberType.INT) {
                    ((JsonGenerator)object).writeNumber(jsonParser.getIntValue());
                    break;
                }
                if (enum_ == JsonParser.NumberType.BIG_INTEGER) {
                    ((JsonGenerator)object).writeNumber(jsonParser.getBigIntegerValue());
                    break;
                }
                ((JsonGenerator)object).writeNumber(jsonParser.getLongValue());
                break;
            }
            case 6: {
                if (jsonParser.hasTextCharacters()) {
                    JsonGenerator jsonGenerator = object;
                    JsonParser jsonParser2 = jsonParser;
                    Object object = jsonParser2.getTextCharacters();
                    int n2 = jsonParser2.getTextOffset();
                    int n3 = jsonParser2.getTextLength();
                    jsonGenerator.writeString((char[])object, n2, n3);
                    break;
                }
                ((JsonGenerator)object).writeString(jsonParser.getText());
                break;
            }
            case 5: {
                ((JsonGenerator)object).writeFieldName(jsonParser.getCurrentName());
                break;
            }
            case 4: {
                ((JsonGenerator)object).writeEndArray();
                break;
            }
            case 3: {
                ((JsonGenerator)object).writeStartArray();
                break;
            }
            case 2: {
                ((JsonGenerator)object).writeEndObject();
                break;
            }
            case 1: {
                ((JsonGenerator)object).writeStartObject();
                break;
            }
            case -1: {
                ((JsonGenerator)object)._reportError("No current event to copy");
            }
        }
    }

    public void copyCurrentStructure(JsonParser jsonParser) {
        JsonToken jsonToken = jsonParser.currentToken();
        int n2 = jsonToken == null ? -1 : jsonToken.id();
        if (n2 == 5) {
            this.writeFieldName(jsonParser.getCurrentName());
            JsonToken jsonToken2 = jsonParser.nextToken();
            n2 = jsonToken2 == null ? -1 : jsonToken2.id();
        }
        if (n2 != 1) {
            if (n2 != 3) {
                this.copyCurrentEvent(jsonParser);
                return;
            }
            JsonGenerator jsonGenerator = this;
            jsonGenerator.writeStartArray();
            jsonGenerator._copyCurrentContents(jsonParser);
            return;
        }
        JsonGenerator jsonGenerator = this;
        jsonGenerator.writeStartObject();
        jsonGenerator._copyCurrentContents(jsonParser);
    }

    public void _copyCurrentContents(JsonParser jsonParser) {
        Object object;
        int n2 = 1;
        block14: while ((object = jsonParser.nextToken()) != null) {
            switch (((JsonToken)((Object)object)).id()) {
                default: {
                    throw new IllegalStateException("Internal error: unknown current token, " + object);
                }
                case 12: {
                    this.writeObject(jsonParser.getEmbeddedObject());
                    continue block14;
                }
                case 11: {
                    this.writeNull();
                    continue block14;
                }
                case 10: {
                    this.writeBoolean(false);
                    continue block14;
                }
                case 9: {
                    this.writeBoolean(true);
                    continue block14;
                }
                case 8: {
                    object = jsonParser.getNumberType();
                    if (object == JsonParser.NumberType.BIG_DECIMAL) {
                        this.writeNumber(jsonParser.getDecimalValue());
                        continue block14;
                    }
                    if (object == JsonParser.NumberType.FLOAT) {
                        this.writeNumber(jsonParser.getFloatValue());
                        continue block14;
                    }
                    this.writeNumber(jsonParser.getDoubleValue());
                    continue block14;
                }
                case 7: {
                    object = jsonParser.getNumberType();
                    if (object == JsonParser.NumberType.INT) {
                        this.writeNumber(jsonParser.getIntValue());
                        continue block14;
                    }
                    if (object == JsonParser.NumberType.BIG_INTEGER) {
                        this.writeNumber(jsonParser.getBigIntegerValue());
                        continue block14;
                    }
                    this.writeNumber(jsonParser.getLongValue());
                    continue block14;
                }
                case 6: {
                    if (jsonParser.hasTextCharacters()) {
                        JsonParser jsonParser2 = jsonParser;
                        object = jsonParser2.getTextCharacters();
                        int n3 = jsonParser2.getTextOffset();
                        int n4 = jsonParser2.getTextLength();
                        this.writeString((char[])object, n3, n4);
                        continue block14;
                    }
                    this.writeString(jsonParser.getText());
                    continue block14;
                }
                case 5: {
                    this.writeFieldName(jsonParser.getCurrentName());
                    continue block14;
                }
                case 4: {
                    this.writeEndArray();
                    if ((n2 += -1) != 0) continue block14;
                    return;
                }
                case 3: {
                    this.writeStartArray();
                    ++n2;
                    continue block14;
                }
                case 2: {
                    this.writeEndObject();
                    if ((n2 += -1) != 0) continue block14;
                    return;
                }
                case 1: 
            }
            this.writeStartObject();
            ++n2;
        }
    }

    @Override
    public abstract void flush();

    public abstract boolean isClosed();

    @Override
    public abstract void close();

    public void _reportError(String string) {
        throw new JsonGenerationException(string, this);
    }

    public final void _throwInternal() {
        VersionUtil.throwInternal();
    }

    public void _reportUnsupportedOperation() {
        throw new UnsupportedOperationException("Operation not supported by generator of type ".concat(this.getClass().getName()));
    }

    public final void _verifyOffsets(int n2, int n3, int n4) {
        if (n3 >= 0 && n3 + n4 <= n2) {
            return;
        }
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = n3;
        objectArray2[1] = n4;
        objectArray[2] = n2;
        throw new IllegalArgumentException(String.format("invalid argument(s) (offset=%d, length=%d) for input array of %d element", objectArray2));
    }

    public void _writeSimpleObject(Object object) {
        if (object == null) {
            this.writeNull();
            return;
        }
        if (object instanceof String) {
            this.writeString((String)object);
            return;
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            if (number instanceof Integer) {
                this.writeNumber(number.intValue());
                return;
            }
            if (number instanceof Long) {
                this.writeNumber(number.longValue());
                return;
            }
            if (number instanceof Double) {
                this.writeNumber(number.doubleValue());
                return;
            }
            if (number instanceof Float) {
                this.writeNumber(number.floatValue());
                return;
            }
            if (number instanceof Short) {
                this.writeNumber(number.shortValue());
                return;
            }
            if (number instanceof Byte) {
                this.writeNumber(number.byteValue());
                return;
            }
            if (number instanceof BigInteger) {
                this.writeNumber((BigInteger)number);
                return;
            }
            if (number instanceof BigDecimal) {
                this.writeNumber((BigDecimal)number);
                return;
            }
            if (number instanceof AtomicInteger) {
                this.writeNumber(((AtomicInteger)number).get());
                return;
            }
            if (number instanceof AtomicLong) {
                this.writeNumber(((AtomicLong)number).get());
                return;
            }
        } else {
            if (object instanceof byte[]) {
                this.writeBinary((byte[])object);
                return;
            }
            if (object instanceof Boolean) {
                this.writeBoolean((Boolean)object);
                return;
            }
            if (object instanceof AtomicBoolean) {
                this.writeBoolean(((AtomicBoolean)object).get());
                return;
            }
        }
        throw new IllegalStateException("No ObjectCodec defined for the generator, can only serialize simple wrapper types (type passed " + object.getClass().getName() + ")");
    }

    public static enum Feature {
        AUTO_CLOSE_TARGET(true),
        AUTO_CLOSE_JSON_CONTENT(true),
        FLUSH_PASSED_TO_STREAM(true),
        QUOTE_FIELD_NAMES(true),
        QUOTE_NON_NUMERIC_NUMBERS(true),
        ESCAPE_NON_ASCII(false),
        WRITE_NUMBERS_AS_STRINGS(false),
        WRITE_BIGDECIMAL_AS_PLAIN(false),
        STRICT_DUPLICATE_DETECTION(false),
        IGNORE_UNKNOWN(false),
        USE_FAST_DOUBLE_WRITER(false),
        WRITE_HEX_UPPER_CASE(true);

        private final boolean _defaultState;
        private final int _mask;

        public static int collectDefaults() {
            int n2 = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n2 |= feature.getMask();
            }
            return n2;
        }

        private Feature(boolean bl) {
            this._defaultState = bl;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public boolean enabledIn(int n2) {
            return (n2 & this._mask) != 0;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

