/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core;

import com.privatefasterxml.jackson.core.io.ContentReference;
import java.io.Serializable;

public class JsonLocation
implements Serializable {
    private static final long serialVersionUID = 2L;
    @Deprecated
    public static final int MAX_CONTENT_SNIPPET = 500;
    public static final JsonLocation NA = new JsonLocation(ContentReference.unknown(), -1L, -1L, -1, -1);
    protected final long _totalBytes;
    protected final long _totalChars;
    protected final int _lineNr;
    protected final int _columnNr;
    protected final ContentReference _contentReference;
    protected transient String _sourceDescription;

    public JsonLocation(ContentReference contentReference, long l2, int n2, int n3) {
        this(contentReference, -1L, l2, n2, n3);
    }

    public JsonLocation(ContentReference contentReference, long l2, long l3, int n2, int n3) {
        if (contentReference == null) {
            contentReference = ContentReference.unknown();
        }
        JsonLocation jsonLocation = this;
        jsonLocation._contentReference = contentReference;
        jsonLocation._totalBytes = l2;
        jsonLocation._totalChars = l3;
        jsonLocation._lineNr = n2;
        jsonLocation._columnNr = n3;
    }

    @Deprecated
    public JsonLocation(Object object, long l2, int n2, int n3) {
        this(JsonLocation._wrap(object), l2, n2, n3);
    }

    @Deprecated
    public JsonLocation(Object object, long l2, long l3, int n2, int n3) {
        this(JsonLocation._wrap(object), l2, l3, n2, n3);
    }

    public static ContentReference _wrap(Object object) {
        if (object instanceof ContentReference) {
            return (ContentReference)object;
        }
        return ContentReference.construct(false, object);
    }

    public ContentReference contentReference() {
        return this._contentReference;
    }

    @Deprecated
    public Object getSourceRef() {
        return this._contentReference.getRawContent();
    }

    public int getLineNr() {
        return this._lineNr;
    }

    public int getColumnNr() {
        return this._columnNr;
    }

    public long getCharOffset() {
        return this._totalChars;
    }

    public long getByteOffset() {
        return this._totalBytes;
    }

    public String sourceDescription() {
        if (this._sourceDescription == null) {
            this._sourceDescription = this._contentReference.buildSourceDescription();
        }
        return this._sourceDescription;
    }

    public String offsetDescription() {
        return this.appendOffsetDescription(new StringBuilder(40)).toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public StringBuilder appendOffsetDescription(StringBuilder stringBuilder) {
        long l2;
        block10: {
            block9: {
                block8: {
                    if (!this._contentReference.hasTextualContent()) break block8;
                    stringBuilder.append("line: ");
                    int n2 = this._lineNr;
                    if (n2 >= 0) {
                        stringBuilder.append(n2);
                    } else {
                        stringBuilder.append("UNKNOWN");
                    }
                    stringBuilder.append(", column: ");
                    int n3 = this._columnNr;
                    if (n3 >= 0) {
                        stringBuilder.append(n3);
                        return stringBuilder;
                    }
                    break block9;
                }
                if (this._lineNr > 0) {
                    stringBuilder.append("line: ").append(this._lineNr);
                    if (this._columnNr <= 0) return stringBuilder;
                    stringBuilder.append(", column: ");
                    stringBuilder.append(this._columnNr);
                    return stringBuilder;
                }
                stringBuilder.append("byte offset: #");
                l2 = this._totalBytes;
                if (l2 >= 0L) break block10;
            }
            stringBuilder.append("UNKNOWN");
            return stringBuilder;
        }
        stringBuilder.append(l2);
        return stringBuilder;
    }

    public int hashCode() {
        return (((this._contentReference == null ? 1 : 2) ^ this._lineNr) + this._columnNr ^ (int)this._totalChars) + (int)this._totalBytes;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof JsonLocation)) {
            return false;
        }
        object = (JsonLocation)object;
        ContentReference contentReference = this._contentReference;
        if (contentReference == null ? ((JsonLocation)object)._contentReference != null : !contentReference.equals(((JsonLocation)object)._contentReference)) {
            return false;
        }
        return this._lineNr == ((JsonLocation)object)._lineNr && this._columnNr == ((JsonLocation)object)._columnNr && this._totalChars == ((JsonLocation)object)._totalChars && this._totalBytes == ((JsonLocation)object)._totalBytes;
    }

    public String toString() {
        JsonLocation jsonLocation = string;
        String string = jsonLocation.sourceDescription();
        return jsonLocation.appendOffsetDescription(new StringBuilder(string.length() + 40).append("[Source: ").append(string).append("; ")).append(']').toString();
    }
}

